// Host stdlib memory routines on IML

#include "xstdlib.h"
#include "immem.h"

#include "jsapi.h"

//#include "_optimize.h"

#ifdef USE_IML

// --------------------------------------------------------------------------------
// Define here to avoid including mmp in js
void movie_CharacterRemapUC(void *pCurrentThread, short *buffer, long length, int bRemapToNative);

void x_CharacterRemapUC( struct JSContext *cx, unsigned short *buffer, long length, int bRemapToNative)
{
	movie_CharacterRemapUC( JS_GetContextPrivate( cx ), (short *)buffer, length, bRemapToNative);
}

// --------------------------------------------------------------------------------
void *xmalloc(size_t nbytes)
{
	IMMEMTAG("xmalloc");
	return imMemPointerNew( nbytes );
}

// --------------------------------------------------------------------------------
// from realloc
void *xrealloc(void * ptr, size_t size)
{
	size_t 	pointerSize;
	void*  	newBlock;
	
	// hold on we need to be just like the old routine...
	if( !ptr )
	{
		IMMEMTAG("xrealloc");
		return imMemPointerNew( size );
	}
	// next test:  if the pointer is non-NULL and the size is 0 free the block and return NULL
	if( ptr && size == 0 )
	{
		imMemPointerDispose( &ptr );
		return NULL;
	}
	
	pointerSize = imMemPointerGetSize( ptr );
	IMMEMTAG("xrealloc");
	newBlock    = imMemPointerNew( size );
	
	if( newBlock )
	{
		// do minimum size calculation
		size_t bytesToCopy = size < pointerSize ? size : pointerSize;
	
		// copy the data
		imMemCopy( newBlock, ptr, bytesToCopy);
	}
	// dump old block, whether we get a new block or not.			
	imMemPointerDispose( &ptr );
	
	return newBlock;
}

// --------------------------------------------------------------------------------
void *xcalloc(size_t ssize, size_t nbytes)
{
	IMMEMTAG("xcalloc");
	return imMemPointerNew( ssize * nbytes );
}

// --------------------------------------------------------------------------------
void xfree(void * ptr)
{
	imMemPointerDispose( &ptr );
}

// From LingoCore/Include/{win/mac}/stackspc.h
#ifdef XP_WIN
#define kStackSpaceMinimum	(90000)
#else
#define kStackSpaceMinimum	(20000)
#endif

// --------------------------------------------------------------------------------
int xStackIsLow(void)
{
	return imMemStackVerify( kStackSpaceMinimum )? 0: 1;
}

#ifdef DEBUG
void xmemtag(char *f)
{
	IMMEMTAG(f);
}
#endif


#endif

// --------------------------------------------------------------------------------
// --------------------------------------------------------------------------------
