#ifndef xstdlib_h___
#define xstdlib_h___

// !!dp
// 20003.08.22 covers for memory management routines.

#define USE_IML
#ifdef USE_IML
#include <stddef.h>

void *xmalloc(size_t nbytes);
void *xrealloc(void * ptr, size_t nbytes);
void *xcalloc(size_t ssize, size_t nbytes);
void xfree(void * ptr);

int xStackIsLow(void);

// Redefine these to make compiler catch re-directed calls.
#define malloc(n) dontuse
#define realloc(p,n) dontuse
#define free(p) dontuse
#define calloc(p, n) dontuse

#ifdef DEBUG
#define XMEMTAG(x) xmemtag(x)
void xmemtag(char *f);
#else
#define XMEMTAG(x)
#endif

#define kMapCharToNative (1)
#define kMapCharToFile	(0)

struct JSContext;
void x_CharacterRemapUC( struct JSContext *cx, unsigned short *buffer, long length, int bRemapToNative);


#else

#include <stdlib.h>

#define xmalloc(n) malloc(n)
#define xrealloc(p,n) realloc(p,n)
#define xfree(p) free(p)
#define xcalloc(p, n) calloc(p, n)

#define xStackIsLow() (0)

#define movie_CharacterRemapUC( pCurrentThread, buffer, length, bRemapToNative)

#endif

#endif
