
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
        Asset( "ANIM", "anim/wulfe.zip" ),
}
local prefabs = {}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "wilson"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "wilson.png" )

	inst:AddTag("hound")
	inst:AddTag("houndfriend")
	inst:AddTag("monster")
	inst.components.hunger.max = 120
	inst.components.sanity.max = 150
	inst.components.combat.damagemultiplier = 1.3
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.1)
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.3)
	inst.components.temperature.hurtrate = (TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME) / 2
	inst.components.eater.strongstomach = true -- can eat monster meat!
	inst.components.sanity.neg_aura_mult = 0

	-- todo: Add an example special power here.

end


-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.wulfe = "The Feisty She-Wolf"
STRINGS.CHARACTER_NAMES.wulfe = "Wulfe"
STRINGS.CHARACTER_DESCRIPTIONS.wulfe = "*Fluffy friend! Hounds won't attack her unless provoked.\n*Natural Predator! Pigmen and Bunnymen both instinctually attack her."
STRINGS.CHARACTER_QUOTES.wulfe = "\"Grrrr.\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.WULFE = {}

STRINGS.CHARACTERS.WULFE.ANNOUNCE_CANFIX = "\nI fix!"
STRINGS.CHARACTERS.WULFE.ACTIONFAIL_SHAVE_AWAKEBEEFALO = "I not crazy, you know!"
STRINGS.CHARACTERS.WULFE.ACTIONFAIL_SHAVE_NOBITS = "What I shave, exactly?"
STRINGS.CHARACTERS.WULFE.ACTIONFAIL_STORE_GENERIC = "Full up."
STRINGS.CHARACTERS.WULFE.ACTIONFAIL_GENERIC = "Don't understand..."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_ADVENTUREFAIL = "*whine*"

STRINGS.CHARACTERS.WULFE.ANNOUNCE_BOOMERANG = "Ow!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_CHARLIE = "Noise?!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_CHARLIE_ATTACK = "OW! GROWL!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_COLD = "Brrr..."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_CRAFTING_FAIL = "Need more stuff."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_DUSK = "Sun get low. Need fire soon."

STRINGS.CHARACTERS.WULFE.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.WULFE.ANNOUNCE_EAT.GENERIC = "Dinnertime!!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_EAT.PAINFUL = "*whine* Stomach hurt..."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_EAT.SPOILED = "Blech, too old!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_EAT.STALE = "Need more salt. Or something."

STRINGS.CHARACTERS.WULFE.ANNOUNCE_ENTER_DARK = "Where my night vision??"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_ENTER_LIGHT = "Oh. There it is."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_FREEDOM = "Wulfe free!! ....Now what."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_HIGHRESEARCH = "I can feel brainmeats tingling."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_HUNGRY = "*whine* Neeeeed fooooood!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_HUNT_BEAST_NEARBY = "Hmm. Yumyum is close."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_HUNT_LOST_TRAIL = "But where Yumyum go??"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_INV_FULL = "Grr, no more room."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_KNOCKEDOUT = "Oww..."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_LOWRESEARCH = "Ehh... not feel very smart."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_MOSQUITOS = "Wulfe HATE itchies!!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_NODANGERSLEEP = "It better to sleep under moon."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_NODAYSLEEP = "Can't sleep, sun up..."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_NOHUNGERSLEEP = "Can't sleep... need food."
STRINGS.CHARACTERS.WULFE.ANNOUNCE_NO_TRAP = "Yip!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_PECKED = "Ow! GRRR!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_QUAKE = "AH! Groundshake!!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_RESEARCH = "Brain get bigger!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_THORNS = "Yipe!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_TORCH_OUT = "*whine* Darkness!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_TRAP_WENT_OFF = "Yipe!!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_WORMHOLE = "Blech, sticky."

-- Battle
STRINGS.CHARACTERS.WULFE.ANNOUNCE_HOUNDS = "*HOWL* Wulfe hear fluffy friend!"
STRINGS.CHARACTERS.WULFE.ANNOUNCE_DEERCLOPS = "Bad Bad BAD!!"

STRINGS.CHARACTERS.WULFE.BATTLECRY = {}
STRINGS.CHARACTERS.WULFE.BATTLECRY.GENERIC = "GRRROWWWWWLLL!"
STRINGS.CHARACTERS.WULFE.BATTLECRY.PIG = "Tasty tasty, come here!"
STRINGS.CHARACTERS.WULFE.BATTLECRY.PREY = "You taste good?"
STRINGS.CHARACTERS.WULFE.BATTLECRY.SPIDER = "Kill, kill!"
STRINGS.CHARACTERS.WULFE.BATTLECRY.SPIDER_WARRIOR = "Hissss!"
STRINGS.CHARACTERS.WULFE.BATTLECRY.HOUND = "This MY territory!"
STRINGS.CHARACTERS.WULFE.BATTLECRY.LEIF = "You not escape!"

STRINGS.CHARACTERS.WULFE.COMBAT_QUIT = {}
STRINGS.CHARACTERS.WULFE.COMBAT_QUIT.GENERIC = "Hmph. Wulfe wins."
STRINGS.CHARACTERS.WULFE.COMBAT_QUIT.PIG = "Ehh, not worth it."
STRINGS.CHARACTERS.WULFE.COMBAT_QUIT.PREY = "It escape."
STRINGS.CHARACTERS.WULFE.COMBAT_QUIT.SPIDER = "Whatever."
STRINGS.CHARACTERS.WULFE.COMBAT_QUIT.SPIDER_WARRIOR = "Whatever!"

-- Description
STRINGS.CHARACTERS.WULFE.DESCRIBE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURPER = "Any skin under fur?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ORANGEAMULET = "Go zip zip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.YELLOWSTAFF = "Shiny stick!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.YELLOWGEM = "Sun color."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ORANGEGEM = "Carrot color."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RESEARCHLAB4 = "What I make next?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ANCIENT_ALTAR = "So old. What it do?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_BANANA = "Ooo!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_BANANA_COOKED = "Yum, yum."
STRINGS.CHARACTERS.WULFE.DESCRIBE.Cave_BANANA_TREE = "Yum yum tree!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.GENERIC = "It not say."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.N = "North."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.S = "South."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.E = "East."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.W = "West."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.NE = "Northeast."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.SE = "Southeast."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.NW = "Northwest."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COMPASS.SW = "Southwest."

STRINGS.CHARACTERS.WULFE.DESCRIBE.HOUNDSTOOTH = "Not as sharp as mine!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ARMORSNURTLESHELL = "Sticky."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BAT = "Grrrr."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BATBAT = "I like this one!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BATWING = "*sniff sniff*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BATWING_COOKED = "It edible."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEDROLL_FURRY = "Fluffy! Soft!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUNNYMAN = "He smell real delicious."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWER_CAVE = "Pretty!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWER_CAVE_DOUBLE = "Pretty!."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWER_CAVE_TRIPLE = "Pretty!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.GUANO = "Bat poo."
STRINGS.CHARACTERS.WULFE.DESCRIBE.LIGHTBULB = "So bright."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MANRABBIT_TAIL = "Nice and fluffy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MUSHTREE_TALL = "Fairyland..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MUSHTREE_MEDIUM = "Fairyland..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MUSHTREE_SMALL = "Fairyland..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RABBITHOUSE = "I don't think that edible."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURTLE = "Blech."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURTLE_SHELLPIECES = "What use for?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURTLEHAT = "For hard head!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURTLEHOLE = "Ickies live inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLURTLESLIME = "Bleeeech."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SNURTLE = "Gross."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_HIDER = "Hiss!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_SPITTER = "HISS"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDERHOLE = "Like to stay far from."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_FULL = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_LOW = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_MED = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_TALL = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_TALL_FULL = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_TALL_LOW = "It rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STALAGMITE_TALL_MED = "Itrock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.POWCAKE = "Wulfe can't eat this..."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_ENTRANCE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_ENTRANCE.GENERIC = "Cave inside. Smash it!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_ENTRANCE.OPEN = "Be careful. Dark down there!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_EXIT = "I still alive!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELLPHONOGRAPH = "Yip! Yip! Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BOOMERANG = "Throwing weapon. Fun, too."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGGUARD = "Yummy but dangerous."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ABIGAIL = "Little spirit?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ADVENTURE_PORTAL = "Ohh, this look neat."
STRINGS.CHARACTERS.WULFE.DESCRIBE.AMULET = "It make Wulfe feel safe when worn."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ANIMAL_TRACK = "Follow for dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ARMORGRASS = "Better than nothing!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ARMORMARBLE = "Wulfe stylish AND protected!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ARMORWOOD = "Better safe with this!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.ASH = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.ASH.GENERIC = "All burn away."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ASH.REMAINS_EYE_BONE = "Aww, eye thing broke."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ASH.REMAINS_THINGIE = "No good anymore."

STRINGS.CHARACTERS.WULFE.DESCRIBE.AXE = "Piney wood chopper."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BABYBEEFALO = "It grow into big Beef Dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BACKPACK = "It make Wulfe's life way easier."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BACONEGGS = "Yum."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BANDAGE = "Good thing to have when hunting!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BASALT = "How to break this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEARDHAIR = "But how this happen?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEDROLL_STRAW = "Itchy bed. Need soft pelt."
-- paste here
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEE.GENERIC = "Buzz"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEE.HELD = "Yipe!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEBOX = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEBOX.FULLHONEY = "Yummm."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEBOX.GENERIC = "I made little home for buzzies."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEBOX.NOHONEY = "Have to wait."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEBOX.SOMEHONEY = "Almost, almost!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALO = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALO.FOLLOWER = "Dinner friend."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALO.GENERIC = "Beefy dinner!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALO.NAKED = "Hee, hee."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALO.SLEEPING = "Look so cozy."

STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALOHAT = "I am one with Beefy Dinners."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEFALOWOOL = "Cuddles and warmth!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEHAT = "No stinging through this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEHIVE = "Buzz, buzzz"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BEEMINE_MAXWELL = "Scary!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRIES = "Juicy!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRIES_COOKED = "Yummy!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRYBUSH = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRYBUSH.BARREN = "It need poop."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRYBUSH.GENERIC = "Berryfruit!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BERRYBUSH.PICKED = "More berryfruit soon, right?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRDCAGE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRDCAGE.GENERIC = "For featherfriend."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRDCAGE.OCCUPIED = "Chirp!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRDCAGE.SLEEPING = "Hee, hee. So cute."

STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRDTRAP = "Catch birdies with this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRD_EGG = "Bird inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BIRD_EGG_COOKED = "Food for Wulfe."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BISHOP = "Giraffe?!?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLOWDART_FIRE = "It make enemies burn!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLOWDART_SLEEP = "It make them sleepy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUEAMULET = "Chilly."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUEGEM = "Feel cold to touch."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUEPRINT = "Wulfe learn something with this!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_CAP = "Eat if feel hurt."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_CAP_COOKED = "It make feel a bit better."

STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_MUSHROOM ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_MUSHROOM.GENERIC = "Good for when Wulfe hurt."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_MUSHROOM.INGROUND = "It tired."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BLUE_MUSHROOM.PICKED = "It grow back, right?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BOARDS = "Flat wood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUGNET = "Catch bees and buzz!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUSHHAT = "I one with nature."
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUTTER = "Sun paste?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.BUTTERFLY ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUTTERFLY.GENERIC = "Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.BUTTERFLY.HELD = "Flutterbutter."

STRINGS.CHARACTERS.WULFE.DESCRIBE.BUTTERFLYWINGS = "Ooops, it broke."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.EMBERS = "Need wood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.GENERIC = "Warm."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.HIGH = "WOW! BIG!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.LOW = "Too small."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.NORMAL = "So cozy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAMPFIRE.OUT = "It gone..."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CANE = "Wulfe super snazzy!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CARROT = "Bunnyfood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CARROT_COOKED = "Better with sugar."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CAVE_FERN = "Cave plant."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHARCOAL = "*sniff sniff*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESSJUNK1 = "What this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESSJUNK2 = "What this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESSJUNK3 = "What this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESTER = "We have LOT in common."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESTER_EYEBONE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESTER_EYEBONE.GENERIC = "Where it come from?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.CHESTER_EYEBONE.WAITING = "*whine*"

STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKEDMANDRAKE = "Wulfe feel kind of bad."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKEDMEAT = "Yip!! Yip!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKEDMONSTERMEAT = "*sniff* Could smell better."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKEDSMALLMEAT = "Wish it bigger."

STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKPOT = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKPOT.COOKING_LONG = "*yawn*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKPOT.COOKING_SHORT = "Not long now."
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKPOT.DONE = "Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.COOKPOT.EMPTY = "Put cold dinner inside."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CUTGRASS = "Ugh. Wulfe hate weaving rope."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CUTREEDS = "*sniff sniff* It smell swampy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CUTSTONE = "I try to break with head once. Not work out so well."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CROW = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.CROW.GENERIC = "Come here, little featherfriend."
STRINGS.CHARACTERS.WULFE.DESCRIBE.CROW.HELD = "Wulfe like dark feathers best."

STRINGS.CHARACTERS.WULFE.DESCRIBE.CORN = "It get stuck in teeth."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DEERCLOPS_EYEBALL = "This part taste any good?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.DEPLETED_GRASS ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.DEPLETED_GRASS.GENERIC = "Waiting SO boring."

STRINGS.CHARACTERS.WULFE.DESCRIBE.DEVTOOL = "Smell like bacon."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DEVTOOL_NODEV = "Aroo?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIRTPILE = "Dinner track?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD.COLD = "Not here..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD.GENERIC = "This some kind of big science?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD.HOT = "SO EXCITED."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD.WARM = "Think something over here!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGROD.WARMER = "It closer now!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGRODBASE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGRODBASE.GENERIC = "What it do?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGRODBASE.READY = "It need key."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGRODBASE.UNLOCKED = "Go go!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.DIVININGRODSTART = "*sniff* What this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DRAGONFRUIT = "Ooo! Love this one!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DRAGONFRUIT_COOKED = "My favorite!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DRUMSTICK = "Smell good."
STRINGS.CHARACTERS.WULFE.DESCRIBE.DRUMSTICK_COOKED = "Mmm!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DDUG_BERRYBUSH = "Farming time!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DDUG_GRASS = "Farming time!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DDUG_MARSH_BUSH = "Farming time!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DDUG_SAPLING = "Farming time!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DURIAN = "Blech! Bad smell!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.DURIAN_COOKED = "How it smell WORSE now?!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EARMUFFSHAT = "Cuddlesoft."
STRINGS.CHARACTERS.WULFE.DESCRIBE.EGGPLANT = "Pretty color."
STRINGS.CHARACTERS.WULFE.DESCRIBE.EGGPLANT_COOKED = "*sniff sniff*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EYEPLANT = "Grrrrr."

STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN.BURNING = "Oh! Sorry!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN.BURNT = "It was accident, I swear."
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN.CHOPPED = "Err... maybe it grow back?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN.GENERIC = "Piney wood maker."

STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN_SPARSE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN_SPARSE.BURNING = "Oh! Sorry!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN_SPARSE.BURNT = "It was accident, I swear."
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN_SPARSE.CHOPPED = "No baby trees?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.EVERGREEN_SPARSE.GENERIC = "It kind of creepy."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FARMPLOT ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.FARMPLOT.GENERIC = "Put baby fruit inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FARMPLOTGROWING = "Go go go!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FARMPLOT.NEEDSFERTILIZER = "It need poop."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FEATHERHAT = "I Birdmaster now!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FEATHER_CROW = "Shiny dark feather."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FEATHER_ROBIN = "Shiny red feather."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FEATHER_ROBIN_WINTER = "Shiny white feather."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREFLIES ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.GENERIC = "Oh! Get net!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HELD = "Wulfe like these bugs."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREHOUND = "Woah! This guy all toasty!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.EMBERS = "Need wood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.GENERIC = "Good time to make dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.HIGH = "WOW! BIG!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.LOW = "It getting low."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.NORMAL = "Toasty warm."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FIREPIT.OUT = "Cook food here."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FIRESTAFF = "HA HAHA AHA HA NO CAN STOP WULFE NOW"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FISH = "Scaley."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FISH_COOKED = "Fishy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLINT = "Very useful rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWER = "*sniff sniff* Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWERHAT = "So many colors!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.FLOWER_EVIL = "Somehow it make my head hurt..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FOLIAGE = "Plant stuff."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FOOTBALLHAT = "I smell like dinner now."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FROG ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.DEAD = "It dead, Jim."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GENERIC = "It so angry! It make ME angry!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SLEEPING = "Food is sleeping."

STRINGS.CHARACTERS.WULFE.DESCRIBE.FROGLEGS = "It food, I guess."
STRINGS.CHARACTERS.WULFE.DESCRIBE.FROGLEGS_COOKED = "Chewy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GEARS = "What these for?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.GHOST = "It not so tough! It dead, after all!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.GOLDENAXE = "Pretty wood chopper."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GOLDENPICKAXE = "Pretty rock smasher."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GOLDENPITCHFORK = "Do I need this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.GOLDENSHOVEL = "Pretty digger."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GOLDNUGGET = "*gnaw, gnaw*"

STRINGS.CHARACTERS.WULFE.DESCRIBE.GRASS ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.GRASS.BARREN = "It need poop."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GRASS.BURNING = "Oh!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.GRASS.GENERIC = "Grass, good for tools."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GRASS.PICKED = "It mine, now."

STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_CAP = "No good, make sick. Cook first."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_CAP_COOKED = "It make Wulfe feel calm."

STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_MUSHROOM ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_MUSHROOM.GENERIC = "It good for brain."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_MUSHROOM.INGROUND = "It sleeping."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GREEN_MUSHROOM.PICKED = "It been pulled out."

STRINGS.CHARACTERS.WULFE.DESCRIBE.GUNPOWDER = "*sneeze*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HAMBAT = "Waste of food..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.HAMMER = "Smash all rocks!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HEALINGSALVE = "It sting, but it good kind of sting."

STRINGS.CHARACTERS.WULFE.DESCRIBE.HEATROCK ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.HEATROCK.COLD = "Fire rock is cold."
STRINGS.CHARACTERS.WULFE.DESCRIBE.HEATROCK.GENERIC = "Fire make hot. Good for winter."
STRINGS.CHARACTERS.WULFE.DESCRIBE.HEATROCK.HOT = "Yip! Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HEATROCK.WARM = "Not as warm now..."

STRINGS.CHARACTERS.WULFE.DESCRIBE.HOME = "Someone inside?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HOMESIGN = "What these funny scribbles?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HONEY = "Yum, yum! Goldenfood!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HONEYCOMB = "Make beehome for goldenfood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.HORN = "Beefy dinner sound!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HOUND = "It fluffy friend!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HOUNDBONE = "*whine*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.HOUNDMOUND = "Fluffy friend live here."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ICEBOX = "Brrrr."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ICEHOUND = "So cold! Need fire rock?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.INSANITYROCK ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.INSANITYROCK.ACTIVE = "*howl*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.INSANITYROCK.INACTIVE = "Aroo?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.KILLERBEE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.KILLERBEE.GENERIC = "It angry! Danger buzz."
STRINGS.CHARACTERS.WULFE.DESCRIBE.KILLERBEE.HELD = "Grrrr."

STRINGS.CHARACTERS.WULFE.DESCRIBE.KNIGHT = "Horse?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.KOALEFANT_SUMMER = "Should Wulfe hug it or eat?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.KOALEFANT_WINTER = "It cute, but make good winter pelt."
STRINGS.CHARACTERS.WULFE.DESCRIBE.KRAMPUS = "HEY NO HOW ABOUT YOU DIE NOW"
STRINGS.CHARACTERS.WULFE.DESCRIBE.KRAMPUS_SACK = "You mess with the Wulfe, you get... the Wulfe."
STRINGS.CHARACTERS.WULFE.DESCRIBE.LEIF = "Yipe! It big!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.LEIF_SPARSE = "Yipe! It big! And weird!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.LIGHTNING_ROD = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.LIGHTNING_ROD.CHARGED = "Zappy zap!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.LIGHTNING_ROD.GENERIC = "Maybe it rain soon?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.LITTLE_WALRUS = "Grrrrrr...! It make Wulfe really mad!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.LIVINGLOG = "It make Wulfe feel creeps."
STRINGS.CHARACTERS.WULFE.DESCRIBE.LOCKEDWES = "Strange man is stuck?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.LOG = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.LOG.BURNING = "Burny wood."
STRINGS.CHARACTERS.WULFE.DESCRIBE.LOG.GENERIC = "Good for gnawing on when teeth hurt."

STRINGS.CHARACTERS.WULFE.DESCRIBE.LUREPLANT = "Wulfe no trust plant beast!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.LUREPLANTBULB = "*sniff sniff*"

STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKE.DEAD = "Might as well cook, now."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKE.GENERIC = "Dance, dance, dance!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKE.PICKED = "It make lot of noise, for plant."

STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKESOUP = "Wulfe make soup!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MANDRAKE_COOKED = "Flavor bad, but it good for Wulfe."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARBLE = "Ooo. Strong white rock."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARBLEPILLAR = "Break like rock, maybe?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARBLETREE = "Not chop... Smash?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_BUSH ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_BUSH.BURNING = "Burn, sharp bush! Feel Wulfe's wrath!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_BUSH.GENERIC = "Look sharp."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_BUSH.PICKED = "Yipe!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_PLANT = "It another boring plant."

STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_TREE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_TREE.BURNING = "So much danger, all at once."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_TREE.BURNT = "It break soon."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_TREE.CHOPPED = "Hah! I show you!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MARSH_TREE.GENERIC = "Do not touch sharp tree."

STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELL = "Grrrrrr!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELLHEAD = "*sniff sniff* Nope, it not real."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELLLIGHT = "How this work?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELLLOCK = "Need key?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MAXWELLTHRONE = "Maybe it best to keep distance... *whine*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MEAT = "Wulfe LOVE meat!!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.MEATRACK ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MEATRACK.DONE = "Jerky!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MEATRACK.DRYING = "*sigh* Need wait."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MEATRACK.GENERIC = "Meat go here."

STRINGS.CHARACTERS.WULFE.DESCRIBE.MEAT_DRIED = "Chewy dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MERM = "Grrr... I hate fishy smell."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MERMHEAD = "It smell awful! Blech!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MERMHOUSE = "Heavy storm come through here?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MINERHAT = "Shiny head!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MONKEY = "Aroo?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MONKEYBARREL = "Something inside?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MONSTERLASAGNA = "Not sure if really want, but... it here."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MONSTERMEAT = "It smell strange."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MONSTERMEAT_DRIED = "Still smell strange."

STRINGS.CHARACTERS.WULFE.DESCRIBE.MOSQUITO = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MOSQUITO.GENERIC = "It give angry itchies."
STRINGS.CHARACTERS.WULFE.DESCRIBE.MOSQUITO.HELD = "So annoying!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.MOUND = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.MOUND.DUG = "Wulfe dig hole!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.MOUND.GENERIC = "Maybe treasure inside?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.NIGHTLIGHT = "Oh! Spooky."
STRINGS.CHARACTERS.WULFE.DESCRIBE.NIGHTMAREFUEL = "Is solid or liquid?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.NIGHTSWORD = "Wulfe is warrior of night!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.NITRE = "What this rock for?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ONEMANBAND = "Too much noise, and scare off dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PANDORASCHEST = "Ooo, what inside? Snack? Dinner?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PANFLUTE = "It remind Wulfe of home."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PAPYRUS = "I always rip it, somehow."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PENGUIN = "It seem kind of snooty."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PERD = "HISSSS"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PETALS = "Flower broke. Sorry, flower."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PETALS_EVIL = "It smell like nightmare."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PICKAXE = "Smash rocks."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGGYBACK = "More room for dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGHEAD = "Hope no one ever do that to me."

STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGHOUSE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGHOUSE.FULL = "Pig beast is inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGHOUSE.GENERIC = "Why THEY get super nice house?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGHOUSE.LIGHTSOUT = "Grrr! You suck, pig beast!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGKING = "...So. Much. Dinner. ...*drool*"

STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN.DEAD = "Yum, yum!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN.FOLLOWER = "HEY. Do chore for Wulfe!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN.GENERIC = "Weak but trouble when many. Taste good, too."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN.GUARD = "Maybe too much trouble..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGMAN.WEREPIG = "It fluffy but it NOT friend!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGSKIN = "Should eat or use for tool? Hard decision."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGTENT = "*sniff sniff* I hungry."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PIGTORCH = "It a pig light!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.PINECONE = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.PINECONE.GENERIC = "Baby tree, or fire food?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PINECONE.PLANTED = "I sorry I kill tree dad! Or mom."

STRINGS.CHARACTERS.WULFE.DESCRIBE.PITCHFORK = "It scoop up ground."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANTMEAT = "Is veggie or beef?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANTMEAT_COOKED = "Smell pretty good."

STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANT_NORMAL ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANT_NORMAL.GENERIC = "Wulfe hate waiting."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANT_NORMAL.GROWING = "Hurry up!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PLANT_NORMAL.READY = "*howl*"

STRINGS.CHARACTERS.WULFE.DESCRIBE.POMEGRANATE = "Tarty seed fruit!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.POMEGRANATE_COOKED = "Eat now! Eat now!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.POND = "It no look good for drinking."
STRINGS.CHARACTERS.WULFE.DESCRIBE.POOP = "Food for plant. But why plant like poop?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PUMPKIN = "Big sun fruit!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PUMPKIN_COOKED = "Yum."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PUMPKIN_LANTERN = "*howl*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.PURPLEAMULET = "Having it calm Wulfe down."
STRINGS.CHARACTERS.WULFE.DESCRIBE.PURPLEGEM = "Voices inside?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.RABBIT ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.RABBIT.GENERIC = "Cute but noisy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RABBIT.HELD = "*sniff* Probably taste okay."

STRINGS.CHARACTERS.WULFE.DESCRIBE.RABBITHOLE = "Little snackbunnies live here."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RAINOMETER = "Use to keep track of rain!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.RAZOR = "Take off the beefy hair."
STRINGS.CHARACTERS.WULFE.DESCRIBE.REDGEM = "Color of shiny fire."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_CAP = "Do not eat! It poison."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_CAP_COOKED = "Can poison hungry enemy."

STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_MUSHROOM = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_MUSHROOM.GENERIC = "Should not eat this one."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_MUSHROOM.INGROUND = "It sleepy."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RED_MUSHROOM.PICKED = "It come back later. I think."

STRINGS.CHARACTERS.WULFE.DESCRIBE.REEDS = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.REEDS.BURNING = "Oops."
STRINGS.CHARACTERS.WULFE.DESCRIBE.REEDS.GENERIC = "*chew chew chew*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.REEDS.PICKED = "All gone."

STRINGS.CHARACTERS.WULFE.DESCRIBE.RESEARCHLAB = "It make Wulfe feel smart."
STRINGS.CHARACTERS.WULFE.DESCRIBE.RESEARCHLAB2 = "How I even make this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.RESEARCHLAB3 = "It science! Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.RESURRECTIONSTATUE = "*sniff sniff*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.RESURRECTIONSTONE = "Did someone make this?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN.GENERIC = "This one color of broken dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN.HELD = "Sorry, it law of survival."

STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN_WINTER = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN_WINTER.GENERIC = "Same color as Wulfe!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBIN_WINTER.HELD = "Hello featherfriend!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK_LIGHT = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK_LIGHT.GENERIC = "Hit it with hammer!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK_LIGHT.OUT = "It better than fire!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK_LIGHT.LOW = "Have to break again soon."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK_LIGHT.NORMAL = "*yawn* Comfy."

STRINGS.CHARACTERS.WULFE.DESCRIBE.ROBOT_PUPPET = "It trapped!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCK = "Wulfe prefer techno."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROCKS = "Useful, but boring."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROOK = "WOAH!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROPE = "Such a pain to make."
STRINGS.CHARACTERS.WULFE.DESCRIBE.ROTTENEGG = "Blech, not worth eating."

STRINGS.CHARACTERS.WULFE.DESCRIBE.SANITYROCK = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SANITYROCK.ACTIVE = "I no understand this thing."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SANITYROCK.INACTIVE = "Someone mess with it?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SAPLING = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SAPLING.BURNING = "Oops!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SAPLING.GENERIC = "Baby tree."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SAPLING.PICKED = "Sorry, Wulfe need for science."

STRINGS.CHARACTERS.WULFE.DESCRIBE.SEEDS = "Baby food plant inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SEEDS_COOKED = "Crunchy!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SEWING_KIT = "Good thing I know how to use!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SHOVEL = "Dig fast with this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SILK = "It sticky, but strong."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SKELETON = "*whine* Wulfe not ready to die yet!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SKULLCHEST = "Spooks inside?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLBIRD ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLBIRD.GENERIC = "What that BIG thing on it face?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLBIRD.HUNGRY = "It want food."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLBIRD.STARVING = "It starving, need food!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLMEAT = "For snacktime!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SMALLMEAT_DRIED = "Good but get stuck in teeth."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPEAR = "Wulfe hunt dinner with this!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER.DEAD = "Hah!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER.GENERIC = "Growl..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER.SLEEPING = "It look easy to kill."

STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDERDEN = "Nasty!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDEREGGSACK = "Don't put it close to home!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDERGLAND = "Good for making heal paste."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDERQUEEN = "HISSSSS!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_WARRIOR = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_WARRIOR.DEAD = "It better this way."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_WARRIOR.GENERIC = "Wulfe want stripe pelt, too."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SPIDER_WARRIOR.SLEEPING = "Hunt while have chance?"

STRINGS.CHARACTERS.WULFE.DESCRIBE.SPOILED_FOOD = "Blech! Can't eat this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STATUEHARP = "Where it head go?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.STATUEMAXWELL = "Grrrr... He seem like bad man."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STINGER = "Careful!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.STRAWHAT = "Not Wulfe's favorite hat."
STRINGS.CHARACTERS.WULFE.DESCRIBE.STUFFEDEGGPLANT = "Yum."
STRINGS.CHARACTERS.WULFE.DESCRIBE.SUNKBOAT = "No sail with this..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TAFFY = "Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRD = "Maybe it best to keep distance."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG = "Should Wulfe love it or eat it?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_COOKED = "Looks like breakfast!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED.COLD = "Too cold. Put closer to fire."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED.GENERIC = "It come out eventually?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED.HOT = "Too hot! Move further back!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED.LONG = "It take long time to hatch. Wulfe have no patience."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDEGG_CRACKED.SHORT = "It hatch soon!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDNEST ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDNEST.GENERIC = "Hmm, could be breakfast."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TALLBIRDNEST.PICKED = "No breakfast there."

STRINGS.CHARACTERS.WULFE.DESCRIBE.TEENBIRD ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.TEENBIRD.GENERIC = "It still friend, for now..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TEENBIRD.HUNGRY = "It want dinner."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TEENBIRD.STARVING = "I think it want eat ME!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEBASE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEBASE.SVALID = "It look ready."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEBASE.SGEMS = "Need more purple shiny."

STRINGS.CHARACTERS.WULFE.DESCRIBE.GEMSOCKET = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.GEMSOCKET.VALID = "It good to go."
STRINGS.CHARACTERS.WULFE.DESCRIBE.GEMSOCKET.GEMS = "It need more shiny."

STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BASE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BASE.ACTIVE = "This safe? Not so sure."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BASE.GENERIC = "It smell like another world in there."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BASE.LOCKED = "It need something, first."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BASE.PARTIAL = "It not have enough thing on it."

STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_BOX = "Never see anything like this!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_CRANK = "What this for?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_POTATO = "*gnaw* !! *whine*"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELEPORTATO_RING = "Maybe use as fancy belt?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TELESTAFF = "It can't possibly go wrong!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENT = "Wulfe have no need for thing like this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLE = "What the rest of it look like?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLESPIKE = "Better than spear!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLESPOTS = "Put on head as hat, maybe?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLE_PILLAR = "Oh!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLE_PILLAR_ARM = "Slippery."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TENTACLE_GARDEN = "It not safe here."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TOPHAT = "Is Wulfe rich, yet?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TORCH = "Feel safer with this."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRAP = "Too small for Beef Dinners."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRAP_TEETH = "Hee, hee. They never see it coming."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRAP_TEETH_MAXWELL = "Danger!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TREASURECHEST = "What inside?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TREASURECHEST_TRAP = "Yip!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_1 = "Broken, can't play."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_10 = "My teeth much sharper."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_11 = "It say it Wulfe's long lost cousin. Neat!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_12 = "It too tough to eat, so..."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_2 = "What?! It not do anything!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_3 = "*gnaw, gnaw* ...No, still can't break."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_4 = "Hello? I Wulfe. What your name?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_5 = "This fall from sky?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_6 = "Never see rope like this before."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_7 = "Playtime!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_8 = "What this for? Leaky boat?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRINKET_9 = "Candy? *chew, chew* ...*spit* No."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRUNKVEST_SUMMER = "So fashionable."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRUNKVEST_WINTER = "Winter no match for Wulfe, now."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRUNK_COOKED = "Really eat this?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRUNK_SUMMER = "Light trunk."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TRUNK_WINTER = "Heavy trunk."
STRINGS.CHARACTERS.WULFE.DESCRIBE.TWIGS = "Broken baby trees."
STRINGS.CHARACTERS.WULFE.DESCRIBE.UMBRELLA = "It smell like pig."
STRINGS.CHARACTERS.WULFE.DESCRIBE.UNIMPLEMENTED = "I no understand this!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WASPHIVE = "Uh oh."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WETGOOP = "Blech."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_STONE = "I outsmart you someday, pig!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_STONE_ITEM = "I outsmart you someday, pig!!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_RUINS = "Hmm. It broke."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_RUINS_ITEM = "Hmm. It broke."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_HAY = "Pig think this make him safe?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_HAY_ITEM = "Pig think this make him safe?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_WOOD = "A bit harder to get pig beast inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALL_WOOD_ITEM = "A bit harder to get pig beast inside."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUS = "I better hunter than YOU!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUS_TUSK = "It very hard. Make good tool."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUSHAT = "Like very much!"

STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUS_CAMP = {}
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUS_CAMP.EMPTY = "*sniff sniff* They long gone."
STRINGS.CHARACTERS.WULFE.DESCRIBE.WALRUS_CAMP.GENERIC = "Why everyone have better home than Wulfe??"

STRINGS.CHARACTERS.WULFE.DESCRIBE.WINTERHAT = "Fluffy snuggly!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WINTEROMETER = "Must be prepared when winter come."

STRINGS.CHARACTERS.WULFE.DESCRIBE.WORMHOLE ={}
STRINGS.CHARACTERS.WULFE.DESCRIBE.WORMHOLE.GENERIC = "It alive or what?"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WORMHOLE.OPEN = "Ack! Teeth look sharp!"
STRINGS.CHARACTERS.WULFE.DESCRIBE.WORMHOLE_LIMITED = "It must be old."


--endpaste



STRINGS.CHARACTERS.WULFE.DESCRIBE_GENERIC = "Not sure WHAT this is."
STRINGS.CHARACTERS.WULFE.DESCRIBE_TOODARK = "Nighteyes not open yet! Need light!"


return MakePlayerCharacter("wulfe", prefabs, assets, fn)
