-- _Q_ -- Ice Fling Range Check 1.1

PrefabFiles = 
{
	"range",
}


--GLOBAL.setmetatable(env,{__index = function (t,k)return GLOBAL.rawget(GLOBAL,k)end,})

if GetModConfigData("Range Check Time") == "short" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 10
end

if GetModConfigData("Range Check Time") == "default" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 30
end

if GetModConfigData("Range Check Time") == "long" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 60
end

if GetModConfigData("Range Check Time") == "longer" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 240
end

if GetModConfigData("Range Check Time") == "longest" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 480
end

if GetModConfigData("Range Check Time") == "always" then
	GLOBAL.TUNING.RANGE_CHECK_TIME = 1
end

function IceFlingOnRemove(inst)
	local pos = GLOBAL.Point(inst.Transform:GetWorldPosition())
	local range_indicators = GLOBAL.TheSim:FindEntities(pos.x,pos.y,pos.z, 2, {"range_indicator"})
	for i,v in ipairs(range_indicators) do
		if v:IsValid() then
			v:Remove()
		end
	end
end

function getstatus_mod(inst, viewer)
	
	if inst.prefab == "firesuppressor" then
		GLOBAL.TUNING.RANGE_CHECK_PRAFAB = "firesuppressor"
	elseif inst.prefab == "lightning_rod" then
		GLOBAL.TUNING.RANGE_CHECK_PRAFAB = "lightning_rod"
	elseif inst.prefab == "basefan" then
		GLOBAL.TUNING.RANGE_CHECK_PRAFAB = "basefan"
	elseif inst.prefab == "sprinkler" then
		GLOBAL.TUNING.RANGE_CHECK_PRAFAB = "sprinkler"
	else 
		GLOBAL.TUNING.RANGE_CHECK_PRAFAB = "range_invalid"
	end 

	local pos = Point(inst.Transform:GetWorldPosition())
	local range_indicators = TheSim:FindEntities(pos.x,pos.y,pos.z, 2, {"range_indicator"} )

	if #range_indicators < 1 then
	local range = GLOBAL.SpawnPrefab("range_indicator")
	range.Transform:SetPosition(pos.x, pos.y, pos.z)
	end
end

function IceFlingPostInit(inst)
	if inst and inst.components.inspectable then
		inst.components.inspectable.getstatus = getstatus_mod
	end
	inst:ListenForEvent("onremove", IceFlingOnRemove)
end

AddPrefabPostInit("firesuppressor", IceFlingPostInit)
AddPrefabPostInit("lightning_rod", IceFlingPostInit)
AddPrefabPostInit("basefan", IceFlingPostInit)
AddPrefabPostInit("sprinkler", IceFlingPostInit)
