-- Backpack Mod -tehMug(wump)
-- Moderately Friendly Update

-------------------------------------------------------------------------------
Assets =
{
	Asset("ATLAS", "images/newslots.xml"),

}

function backpackpostinit(inst)
	--print "backpack prefabs mod running"	
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.BACK
end

function krampussackpostinit(inst)
	--print "krampus_sack prefabs mod running"	
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.BACK
end

function piggybackpostinit(inst)
	--print "piggyback prefabs mod running"	
	inst.components.equippable.equipslot = GLOBAL.EQUIPSLOTS.BACK
end

function inventorypostinit(component,inst)
	--print "inventory component mod running!"
	
	inst.components.inventory.numequipslots = 4
end

function gamepostinit()
	--print "Add new icon! thanks for using Personal Backpack Slot Mod V7"
end


AddComponentPostInit("inventory", inventorypostinit)

AddPrefabPostInit("backpack", backpackpostinit)
AddPrefabPostInit("krampus_sack", krampussackpostinit)
AddPrefabPostInit("piggyback", piggybackpostinit)

AddSimPostInit(gamepostinit)


table.insert(GLOBAL.EQUIPSLOTS, "BACK")
GLOBAL.EQUIPSLOTS.BACK = "back"

--//we are going to hotwire the PlayerHud:SetMainCharacter function to fix up the inventory widget to use our new stuff
--big thanks to @Kevin:
AddClassPostConstruct("screens/playerhud", function(self) 
    local oldfn = self.SetMainCharacter
    function self:SetMainCharacter(maincharacter)
        
        --//call the old version of the function
        oldfn(self, maincharacter)
        
        --//new equip slot adding API!
        self.controls.inv:AddEquipSlot(GLOBAL.EQUIPSLOTS.BACK, "images/newslots.xml", "back.tex")
        --self.controls.inv:AddEquipSlot(GLOBAL.EQUIPSLOTS.NECK, "images/newslots.xml", "neck.tex")
        
        --//make the background fit the new images
        self.controls.inv.bg:SetScale(1,1,1)

        --//open the backpack in its new location
        local bp = maincharacter.components.inventory:GetEquippedItem(GLOBAL.EQUIPSLOTS.BACK)
        if bp and bp.components.container then
            bp.components.container:Close()
            bp.components.container:Open(maincharacter)
        end
    end
end)
