_G = GLOBAL

local TUNING = _G.TUNING

local function GetReduction(owner)
	if not owner then owner = _G.GetPlayer() end 
	local health = owner.components.health.currenthealth
	local absorption = 1 - 0.025 * 2 ^ (health / 50)--
	absorption = math.clamp(absorption, TUNING.ARMORGRASS_ABSORPTION, 0.975)
	absorption = absorption + 0.005 - absorption % 0.001
	return absorption
end 

local function ontakefuelfn(inst)
	_G.GetPlayer().SoundEmitter:PlaySound"dontstarve_DLC003/common/crafted/vortex_armour/add_fuel"
	local armor = inst.components.armor
	
	local condition = armor.condition
	local percent = armor:GetPercent()
	local value = 150--percent * 50 + 100
	local new_condition = math.clamp(condition + value, 0, armor.maxcondition)
	armor:SetCondition(new_condition)
end

AddPrefabPostInit("armor_sanity", function(inst)
	local function healthdelta()
		inst.components.armor.absorb_percent = GetReduction()
	end
	inst:ListenForEvent("healthdelta", healthdelta, _G.GetPlayer())
	inst:DoTaskInTime(0, healthdelta)
	
	inst:AddComponent"fueled"
    inst.components.fueled.accepting = true
    inst.components.fueled.fueltype = "NIGHTMARE"
    inst.components.fueled:InitializeFuelLevel(4 * TUNING.LARGE_FUEL)
	inst.components.fueled.ontakefuelfn = ontakefuelfn
end)

TUNING.ARMOR_SANITY = 900