local _G = GLOBAL

local DONT_RAMP_UP = {
	"spiderqueen", 
	"leif"
}

local kills = {}

_G.TUNING.RAMP_UP_PERCENT = 0.5

AddPrefabPostInit("world", function(inst)
	local OnLoad, OnSave = inst.OnLoad, inst.OnSave
	
	inst.OnLoad = function(inst, data)
		if data and data.boss_kills_count then kills = data.boss_kills_count end 
		if OnLoad then return OnLoad(inst, data) end 
	end
	
	inst.OnSave = function(inst, data)
		data.boss_kills_count = kills  
		if OnSave then return OnSave(inst, data) end 
	end
end)

AddPrefabPostInitAny(function(inst)
	if not inst:HasTag"epic" then return end 
	for _, tag in pairs(DONT_RAMP_UP) do 
		if inst:HasTag(tag) then return end 
	end 
	
	if kills[inst.prefab] and inst.components.health then 
		local maxhealth = inst.components.health.maxhealth
		maxhealth = maxhealth * (1 + _G.TUNING.RAMP_UP_PERCENT * kills[inst.prefab])
		inst.components.health:SetMaxHealth(maxhealth)
	end -- fortunately the ds health component doesn't save max health 
	
	inst:ListenForEvent("death", function()
		if not kills[inst.prefab] then kills[inst.prefab] = 0 end 
		kills[inst.prefab] = kills[inst.prefab] + 1 
	end)
end) 

_G.debug_ramp_up = function(damagemulti)
	print("debug ramp up")
	if damagemulti then _G.GetPlayer().components.combat:AddDamageModifier("debug_ramp_up", 9) end 
	for k, v in pairs(kills) do print(k, v) end 
end
