local assets = {
    Asset("ANIM", "anim/whitestaff.zip"),
    Asset("ANIM", "anim/swap_whitestaff.zip"),
 
    Asset("ATLAS", "images/inventoryimages/whitestaff.xml"),
    Asset("IMAGE", "images/inventoryimages/whitestaff.tex"),
}

local function test(staff, caster, target, pos)
	return true 
--[[
	local Map = GetWorld() and GetWorld().Map
	if not Map or not pos or TheCamera.interior then return end 
	local tile = Map:GetTileAtPoint(pos.x, pos.y, pos.z)
	return tile == GROUND.IMPASSABLE
]]
end

local function GetNewTile(x, y, z)
	return GetWorld():HasTag"shipwrecked" and GROUND.BEACH
		or GROUND.DIRT
end 

local function rebuild(x, y, z)
	local Map = GetWorld().Map
	local X, Y = Map:GetTileCoordsAtPoint(x, y, z)
	local tile = Map:GetTileAtPoint(x, y, z)
	local newtile = GetNewTile(x, y, z)
	
--	print("rebuilding: x, y, z, X, Y, tile, newtile", x, y, z, X, Y, tile, newtile)
	if tile ~= GROUND.IMPASSABLE then return --[[print("not impassible", x, y, z, tile) ]]end 
	
	GetWorld():DoTaskInTime(math.random(), function()
		GetPlayer().SoundEmitter:PlaySound"dontstarve/common/mushroom_down"
		
		Map:SetTile(X, Y, newtile)
		Map:RebuildLayer(tile, X, Y)
		Map:RebuildLayer(newtile, X, Y)
		
		local minimap = TheSim:FindFirstEntityWithTag"minimap"
		if minimap then 
			minimap.MiniMap:RebuildLayer(tile, X, Y)
			minimap.MiniMap:RebuildLayer(newtile, X, Y)
		end 	
	end)
end 

local function finalize()
--	print("finalizing")
	GetPlayer().components.autosaver:DoSave()
	GetPlayer().components.health:SetInvincible(true)
--	SetPause(true)
	TheFrontEnd:Fade(false, 10, function()
		Settings.save_slot = SaveGameIndex.saveslot
		SetPause(true)
		StartNextInstance({
			reset_action = RESET_ACTION.LOAD_SLOT, 
			save_slot = SaveGameIndex:GetCurrentSaveSlot()
		}, true)
		SetPause(false)
	end)
end

local function spell(staff, target, pos)
	local Map = GetWorld().Map
	if not Map or not pos then return finalize() end 
	
	print("spell", staff, target, pos.x, pos.y, pos.z)
	local X, Z, d = pos.x, pos.z, TUNING.MOSESSTAFF_WIDTH
	
	for x = X - d * 2, X + d * 2, 4 do 
		for z = Z - d * 2, Z + d * 2, 4 do 
			rebuild(x, 0, z)
		end 
	end 
		
	local caster = staff.components.inventoryitem.owner 
	if caster and caster.components.sanity then 
		caster.components.sanity:DoDelta(TUNING.MOSESSTAFF_SANITY_COST)
	end  
	if staff.components.finiteuses then staff.components.finiteuses:Use() end 
end 

local function moses_staff(sim)
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddSoundEmitter()
	MakeInventoryPhysics(inst)
	-- not floatable 
	
	local anim = inst.entity:AddAnimState()
	anim:SetBank"whitestaff"
	anim:SetBuild"whitestaff"
	anim:PlayAnimation"idle"
	
	inst:AddComponent"inspectable"
	
	inst:AddComponent"inventoryitem"
	inst.components.inventoryitem.imagename = "whitestaff"
	inst.components.inventoryitem.atlasname = "images/inventoryimages/whitestaff.xml"

	inst:AddComponent"equippable"
	
	inst.components.equippable:SetOnEquip(function(inst, owner)
		owner.AnimState:OverrideSymbol("swap_object", "swap_whitestaff", "swap_whitestaff")
		owner.AnimState:Show"ARM_carry"
		owner.AnimState:Hide"ARM_normal"
	end)
	
	inst.components.equippable:SetOnUnequip(function(inst, owner)
		owner.AnimState:Hide"ARM_carry"
		owner.AnimState:Show"ARM_normal"
	end)
	
	inst:AddComponent"finiteuses"
	inst.components.finiteuses:SetMaxUses(TUNING.MOSESSTAFF_USES)
	inst.components.finiteuses:SetUses(TUNING.MOSESSTAFF_USES)
	inst.components.finiteuses:SetOnFinished(function(inst)
		inst.SoundEmitter:PlaySound"dontstarve/common/gem_shatter"
		inst:Remove()
	end)
	
	inst:AddComponent"spellcaster"
	inst.components.spellcaster:SetSpellTestFn(test)
	inst.components.spellcaster:SetSpellFn(spell)
	inst.components.spellcaster.canuseonpoint = true
	inst.components.spellcaster.canusefrominventory = true 
	
	return inst 
end

return Prefab("common/inventory/moses_staff", moses_staff, assets, {})