﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Text;
using System.Threading;
using System.Windows.Forms;

namespace AutoOff
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        bool status = false;

        /// <summary>
        /// 秒
        /// </summary>
        private int s = 0;
        /// <summary>
        /// 分钟
        /// </summary>
        private int m = 0;
        /// <summary>
        /// 小时
        /// </summary>
        private int h = 0;
        private void btnStart_Click(object sender, EventArgs e)
        {
            if (!status)
            {
                lbStatus.Text = "已启动";
                status = true;
                IsInInternet();
                //定时器有效，计时开始
                timer1.Enabled = true;
                timerShutDown.Enabled = true;

            }
        }

        private void btnEnd_Click(object sender, EventArgs e)
        {
            if (status)
            {
                lbStatus.Text = "未启动";
                lbS.Text = "0";
                lbM.Text = "0";
                lbH.Text = "0";
                status = false;
                timer1.Enabled = false;
                timerShutDown.Enabled = false;
                timerCountDown.Enabled = false;
                iscountdown = false;
                lbCountDownTitle.Visible = false;
                lbCountDown.Text = "999";
                lbCountDown.Visible = false;
            }
        }

        private void Form1_SizeChanged(object sender, EventArgs e)
        {
            this.ShowInTaskbar = false; //不显示在系统任务栏
            notifyIcon1.Visible = true; //托盘图标可见
        }

        private void notifyIcon1_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            if (this.WindowState == FormWindowState.Minimized)
            {
                this.ShowInTaskbar = true; //显示在系统任务栏
                this.WindowState = FormWindowState.Normal; //还原窗体
                notifyIcon1.Visible = false; //托盘图标隐藏
            }
        }

        //是否联网
        private bool IsInInternet()
        {
            bool isinternet = true;

            System.Int32 dwFlag = new int();
            if (!TestInternet.InternetGetConnectedState(ref dwFlag, 0))
            {
                label3.Text = "未连网!";
                isinternet = false;
            }
            else if ((dwFlag & TestInternet.INTERNET_CONNECTION_MODEM) != 0)
            {
                label3.Text = "采用调治解调器上网。";
            }
            else if ((dwFlag & TestInternet.INTERNET_CONNECTION_LAN) != 0)
            {
                label3.Text = "采用网卡上网。";
            }

            return isinternet;
        }

        //运行时间
        private void timer1_Tick(object sender, EventArgs e)
        {
            if (s < 59)
            {
                s++;
            }
            else if (m < 59)
            {
                s = 0;
                m++;
            }
            else
            {
                h++;
            }
            lbS.Text = s.ToString();
            lbM.Text = m.ToString();
            lbH.Text = h.ToString();
        }

        /// <summary>
        /// 关机倒计时
        /// </summary>
        int ss = 100;

        /// <summary>
        /// 是否开始倒计时
        /// </summary>
        bool iscountdown = false;
        //检测联网
        private void timerShutDown_Tick(object sender, EventArgs e)
        {
            if (!IsInInternet())
            {
                if (!iscountdown)
                {
                    lbCountDownTitle.Visible = true;
                    lbCountDown.Visible = true;
                    if (numericUpDown1.Value != 0)
                    {
                        lbCountDown.Text = (numericUpDown1.Value * 60).ToString();
                        ss = (int)numericUpDown1.Value * 60;
                    }
                    timerCountDown.Enabled = true;
                    iscountdown = true;
                }
            }
            else
            {
                timerCountDown.Enabled = false;
                lbCountDownTitle.Visible = false;
                lbCountDown.Text = "999";
                lbCountDown.Visible = false;
                iscountdown = false;
            }
        }

        private void timerCountDown_Tick(object sender, EventArgs e)
        {
            ss--;
            lbCountDown.Text = ss.ToString();
            if (ss == 0)
            {
                Process myProcess = new Process(); 
                myProcess.StartInfo.FileName = "cmd.exe"; 
                myProcess.StartInfo.UseShellExecute = false; 
                myProcess.StartInfo.RedirectStandardInput = true;
                myProcess.StartInfo.RedirectStandardOutput = true; 
                myProcess.StartInfo.RedirectStandardError = true; 
                myProcess.StartInfo.CreateNoWindow = true; 
                myProcess.Start(); 
                myProcess.StandardInput.WriteLine("shutdown -s -f -t 0");
                //MessageBox.Show("关机");
                timerCountDown.Enabled = false;
                iscountdown = false;
            }
        }
    }
}
