/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools;

import com.fantasticsource.mctools.PathedParticle;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class PathedParticleManager {
    protected static final ResourceLocation PARTICLE_TEXTURES = new ResourceLocation("textures/particle/particles.png");
    protected static final Profiler profiler = Minecraft.func_71410_x().field_71424_I;
    protected static final TextureManager renderer = Minecraft.func_71410_x().field_71446_o;
    protected static HashMap<Pair<GlStateManager.SourceFactor, GlStateManager.DestFactor>, ArrayList<PathedParticle>> particles = new HashMap();

    public static void add(PathedParticle particle, GlStateManager.SourceFactor sourceBlend, GlStateManager.DestFactor destBlend) {
        particles.computeIfAbsent(new Pair<GlStateManager.SourceFactor, GlStateManager.DestFactor>(sourceBlend, destBlend), o -> new ArrayList()).add(particle);
    }

    public static void update() {
        for (ArrayList<PathedParticle> list : particles.values()) {
            list.removeIf(particle -> {
                particle.func_189213_a();
                return !particle.func_187113_k();
            });
        }
        particles.values().removeIf(ArrayList::isEmpty);
    }

    public static void render(Entity entityIn, float partialTick) {
        if (particles.size() == 0) {
            return;
        }
        float f1 = MathHelper.func_76134_b((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76126_a((float)(entityIn.field_70177_z * ((float)Math.PI / 180)));
        float f3 = -f2 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f4 = f1 * MathHelper.func_76126_a((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76134_b((float)(entityIn.field_70125_A * ((float)Math.PI / 180)));
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179147_l();
        renderer.func_110577_a(PARTICLE_TEXTURES);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        for (Map.Entry<Pair<GlStateManager.SourceFactor, GlStateManager.DestFactor>, ArrayList<PathedParticle>> entry : particles.entrySet()) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)entry.getKey().getKey(), (GlStateManager.DestFactor)entry.getKey().getValue());
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
            for (PathedParticle particle : entry.getValue()) {
                particle.func_180434_a(bufferbuilder, entityIn, partialTick, f1, f5, f2, f3, f4);
            }
            tessellator.func_78381_a();
        }
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179084_k();
        GlStateManager.func_179132_a((boolean)true);
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (!Minecraft.func_71410_x().func_147113_T()) {
            profiler.func_76320_a("FLib: Pathed Particles Update");
            PathedParticleManager.update();
            profiler.func_76319_b();
        }
    }

    @SubscribeEvent
    public static void renderLast(RenderWorldLastEvent event) {
        profiler.func_76320_a("FLib: Pathed Particles Render");
        PathedParticleManager.render(Minecraft.func_71410_x().func_175606_aa(), event.getPartialTicks());
        profiler.func_76319_b();
    }

    static {
        MinecraftForge.EVENT_BUS.register(PathedParticleManager.class);
    }
}

