/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.betterattributes;

import com.fantasticsource.mctools.GlobalInventory;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.betterattributes.BetterAttribute;
import com.fantasticsource.mctools.component.NBTSerializableComponent;
import com.fantasticsource.mctools.event.InventoryChangedEvent;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.component.CDouble;
import com.fantasticsource.tools.component.CInt;
import com.fantasticsource.tools.component.CStringUTF8;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import io.netty.buffer.ByteBuf;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class BetterAttributeMod
extends NBTSerializableComponent {
    public static final int OPERATION_ADD_AMOUNT = 0;
    public static final int OPERATION_ADD_OLD_TIER_TIMES_AMOUNT = 1;
    public static final int OPERATION_MULT = 2;
    public String name = "";
    public String betterAttributeName = "";
    public String parentAttributeName = "";
    public int priority = 0;
    public int operation = 0;
    public double amount = 0.0;

    public BetterAttributeMod() {
    }

    public BetterAttributeMod(String name, BetterAttribute attribute, double amount) {
        this(name, attribute, 0, amount);
    }

    public BetterAttributeMod(String name, BetterAttribute attribute, int operation, double amount) {
        this(name, attribute, 0, operation, amount);
    }

    public BetterAttributeMod(String name, BetterAttribute attribute, int priority, int operation, double amount) {
        this(name, attribute.name, priority, operation, amount);
    }

    public BetterAttributeMod(String name, String betterAttributeName, double amount) {
        this(name, betterAttributeName, 0, amount);
    }

    public BetterAttributeMod(String name, String betterAttributeName, int operation, double amount) {
        this(name, betterAttributeName, 0, operation, amount);
    }

    public BetterAttributeMod(String name, String betterAttributeName, int priority, int operation, double amount) {
        this.name = name;
        this.betterAttributeName = betterAttributeName;
        this.priority = priority;
        this.operation = operation;
        this.amount = amount;
    }

    public String toString() {
        BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(this.betterAttributeName);
        boolean good = attribute == null || attribute.isGood;
        switch (this.operation) {
            case 0: 
            case 1: {
                if (!(this.amount < 0.0)) break;
                good = !good;
                break;
            }
            case 2: {
                if (!(this.amount < 1.0)) break;
                good = !good;
            }
        }
        String result = "" + (good ? TextFormatting.GREEN : TextFormatting.RED);
        switch (this.operation) {
            case 0: 
            case 1: {
                if (!(this.amount >= 0.0)) break;
                result = result + "+" + Tools.formatNicely(this.amount);
                break;
            }
            case 2: {
                result = result + Tools.formatNicely(this.amount) + "x";
            }
        }
        result = result + TextFormatting.GRAY + " " + I18n.func_74838_a((String)("attribute.name." + this.betterAttributeName));
        return result;
    }

    @Override
    public BetterAttributeMod write(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.betterAttributeName);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.parentAttributeName);
        buf.writeInt(this.priority);
        buf.writeInt(this.operation);
        buf.writeDouble(this.amount);
        return this;
    }

    @Override
    public BetterAttributeMod read(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.betterAttributeName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.parentAttributeName = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.priority = buf.readInt();
        this.operation = buf.readInt();
        this.amount = buf.readDouble();
        return this;
    }

    @Override
    public BetterAttributeMod save(OutputStream stream) {
        new CStringUTF8().set(this.name).save(stream).set(this.betterAttributeName).save(stream).set(this.parentAttributeName).save(stream);
        new CInt().set(this.priority).save(stream).set(this.operation).save(stream);
        new CDouble().set(this.amount).save(stream);
        return this;
    }

    @Override
    public BetterAttributeMod load(InputStream stream) {
        CStringUTF8 cs = new CStringUTF8();
        CInt ci = new CInt();
        this.name = cs.load((InputStream)stream).value;
        this.betterAttributeName = cs.load((InputStream)stream).value;
        this.parentAttributeName = cs.load((InputStream)stream).value;
        this.priority = ci.load((InputStream)stream).value;
        this.operation = ci.load((InputStream)stream).value;
        this.amount = new CDouble().load((InputStream)stream).value;
        return this;
    }

    public NBTBase serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("name", this.name);
        compound.func_74778_a("betterAttributeName", this.betterAttributeName);
        compound.func_74778_a("parentAttributeName", this.parentAttributeName);
        compound.func_74768_a("priority", this.priority);
        compound.func_74768_a("operation", this.operation);
        compound.func_74780_a("amount", this.amount);
        return compound;
    }

    public void deserializeNBT(NBTBase nbt) {
        NBTTagCompound compound = (NBTTagCompound)nbt;
        this.name = compound.func_74779_i("name");
        this.betterAttributeName = compound.func_74779_i("betterAttributeName");
        this.parentAttributeName = compound.func_74779_i("parentAttributeName");
        this.priority = compound.func_74762_e("priority");
        this.operation = compound.func_74762_e("operation");
        this.amount = compound.func_74769_h("amount");
    }

    @SubscribeEvent
    public static void inventoryChanged(InventoryChangedEvent event) {
        Entity entity = event.getEntity();
        for (BetterAttribute attribute : BetterAttribute.BETTER_ATTRIBUTES.values()) {
            attribute.calculateTotal(entity);
        }
    }

    @SubscribeEvent
    public static void betterAttributeCalc(BetterAttribute.BetterAttributeCalcEvent event) {
        String attributeName = event.attribute.name;
        Entity entity = event.entity;
        for (BetterAttributeMod parentMod : event.attribute.parentMods) {
            BetterAttributeMod.applyMod(entity, event.functions, parentMod);
        }
        ArrayList<NBTTagCompound> compounds = new ArrayList<NBTTagCompound>();
        compounds.add(entity.getEntityData());
        for (ItemStack stack : GlobalInventory.getValidEquippedItems(entity)) {
            if (!stack.func_77942_o()) continue;
            compounds.add(stack.func_77978_p());
        }
        for (NBTTagCompound compound : compounds) {
            if ((compound = MCTools.getSubCompoundIfExists(compound, "fantasticlib", "betterAttributeMods", attributeName)) == null) continue;
            for (String key : compound.func_150296_c()) {
                BetterAttributeMod mod = new BetterAttributeMod();
                mod.deserializeNBT((NBTBase)compound.func_74775_l(key));
                BetterAttributeMod.applyMod(entity, event.functions, mod);
            }
        }
    }

    protected static void applyMod(Entity entity, ExplicitPriorityQueue<Predicate<double[]>> functions, BetterAttributeMod mod) {
        functions.add(d -> {
            BetterAttribute parent = BetterAttribute.BETTER_ATTRIBUTES.get(mod.parentAttributeName);
            switch (mod.operation) {
                case 0: {
                    d[0] = d[0] + (parent != null ? parent.getTotalAmount(entity) * mod.amount : mod.amount);
                    break;
                }
                case 1: {
                    d[0] = d[0] + d[1] * (parent != null ? parent.getTotalAmount(entity) * mod.amount : mod.amount);
                    break;
                }
                case 2: {
                    d[0] = d[0] * (parent != null ? parent.getTotalAmount(entity) * mod.amount : mod.amount);
                }
            }
            return true;
        }, mod.priority);
    }

    public static void addMods(Entity entity, BetterAttributeMod ... mods) {
        NBTTagCompound compound = MCTools.getOrGenerateSubCompound(entity.getEntityData(), "fantasticlib", "betterAttributeMods");
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (BetterAttributeMod mod : mods) {
            MCTools.getOrGenerateSubCompound(compound, mod.betterAttributeName).func_74782_a(mod.name, mod.serializeNBT());
            attributesToRecalc.add(mod.betterAttributeName);
        }
        for (String attributeName : attributesToRecalc) {
            BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
            if (attribute == null) continue;
            attribute.calculateTotal(entity);
        }
    }

    public static void addMods(Entity entity, ItemStack stack, BetterAttributeMod ... mods) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = MCTools.getOrGenerateSubCompound(stack.func_77978_p(), "fantasticlib", "betterAttributeMods");
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (BetterAttributeMod mod : mods) {
            MCTools.getOrGenerateSubCompound(compound, mod.betterAttributeName).func_74782_a(mod.name, mod.serializeNBT());
            attributesToRecalc.add(mod.betterAttributeName);
        }
        if (entity != null) {
            for (String attributeName : attributesToRecalc) {
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
                if (attribute == null) continue;
                attribute.calculateTotal(entity);
            }
        }
    }

    public static void removeMods(Entity entity, BetterAttributeMod ... mods) {
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (BetterAttributeMod mod : mods) {
            NBTTagCompound compound2 = MCTools.getSubCompoundIfExists(compound, mod.betterAttributeName);
            if (compound2 == null || !compound2.func_74764_b(mod.name)) continue;
            compound2.func_82580_o(mod.name);
            attributesToRecalc.add(mod.betterAttributeName);
        }
        for (String attributeName : attributesToRecalc) {
            BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
            if (attribute == null) continue;
            attribute.calculateTotal(entity);
        }
    }

    public static void removeModsWithName(Entity entity, String modName) {
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            if (!compound2.func_74764_b(modName)) continue;
            compound2.func_82580_o(modName);
            attributesToRecalc.add(attributeName);
        }
        for (String attributeName : attributesToRecalc) {
            BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
            if (attribute == null) continue;
            attribute.calculateTotal(entity);
        }
    }

    public static void removeModsWithNameContaining(Entity entity, String partialModName, boolean ignored) {
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            for (String foundModName : compound2.func_150296_c().toArray(new String[0])) {
                if (!foundModName.contains(partialModName)) continue;
                compound2.func_82580_o(foundModName);
                attributesToRecalc.add(attributeName);
            }
        }
        for (String attributeName : attributesToRecalc) {
            BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
            if (attribute == null) continue;
            attribute.calculateTotal(entity);
        }
    }

    public static void removeModsIf(Entity entity, Predicate<BetterAttributeMod> condition) {
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(entity.getEntityData(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            BetterAttributeMod mod = new BetterAttributeMod();
            for (String key2 : compound2.func_150296_c().toArray(new String[0])) {
                mod.deserializeNBT((NBTBase)compound2.func_74775_l(key2));
                if (!condition.test(mod)) continue;
                compound2.func_82580_o(key2);
                attributesToRecalc.add(attributeName);
            }
        }
        for (String attributeName : attributesToRecalc) {
            BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
            if (attribute == null) continue;
            attribute.calculateTotal(entity);
        }
    }

    public static void removeMods(Entity entity, ItemStack stack, BetterAttributeMod ... mods) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(stack.func_77978_p(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (BetterAttributeMod mod : mods) {
            NBTTagCompound compound2 = MCTools.getSubCompoundIfExists(compound, mod.betterAttributeName);
            if (compound2 == null || !compound2.func_74764_b(mod.name)) continue;
            compound2.func_82580_o(mod.name);
            attributesToRecalc.add(mod.betterAttributeName);
        }
        if (entity != null) {
            for (String attributeName : attributesToRecalc) {
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
                if (attribute == null) continue;
                attribute.calculateTotal(entity);
            }
        }
    }

    public static void removeModsWithName(Entity entity, ItemStack stack, String modName) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(stack.func_77978_p(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            if (!compound2.func_74764_b(modName)) continue;
            compound2.func_82580_o(modName);
            attributesToRecalc.add(attributeName);
        }
        if (entity != null) {
            for (String attributeName : attributesToRecalc) {
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
                if (attribute == null) continue;
                attribute.calculateTotal(entity);
            }
        }
    }

    public static void removeModsWithNameContaining(Entity entity, ItemStack stack, String partialModName, boolean ignored) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(stack.func_77978_p(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            for (String foundModName : compound2.func_150296_c().toArray(new String[0])) {
                if (!foundModName.contains(partialModName)) continue;
                compound2.func_82580_o(foundModName);
                attributesToRecalc.add(attributeName);
            }
        }
        if (entity != null) {
            for (String attributeName : attributesToRecalc) {
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
                if (attribute == null) continue;
                attribute.calculateTotal(entity);
            }
        }
    }

    public static void removeModsIf(Entity entity, ItemStack stack, Predicate<BetterAttributeMod> condition) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound compound = MCTools.getSubCompoundIfExists(stack.func_77978_p(), "fantasticlib", "betterAttributeMods");
        if (compound == null) {
            return;
        }
        HashSet<String> attributesToRecalc = new HashSet<String>();
        for (String attributeName : compound.func_150296_c()) {
            NBTTagCompound compound2 = compound.func_74775_l(attributeName);
            BetterAttributeMod mod = new BetterAttributeMod();
            for (String key2 : compound2.func_150296_c().toArray(new String[0])) {
                mod.deserializeNBT((NBTBase)compound2.func_74775_l(key2));
                if (!condition.test(mod)) continue;
                compound2.func_82580_o(key2);
                attributesToRecalc.add(attributeName);
            }
        }
        if (entity != null) {
            for (String attributeName : attributesToRecalc) {
                BetterAttribute attribute = BetterAttribute.BETTER_ATTRIBUTES.get(attributeName);
                if (attribute == null) continue;
                attribute.calculateTotal(entity);
            }
        }
    }
}

