/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.text;

import com.fantasticsource.mctools.MonoASCIIFontRenderer;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.mctools.gui.GUILeftClickEvent;
import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.Namespace;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.mctools.gui.element.text.CodeInput;
import com.fantasticsource.mctools.gui.element.text.GUIMultilineTextInput;
import com.fantasticsource.mctools.gui.element.text.GUIText;
import com.fantasticsource.mctools.gui.element.text.filter.TextFilter;
import com.fantasticsource.mctools.gui.element.view.GUIPanZoomView;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public class GUITextInput
extends GUIText {
    protected String namespace = null;
    protected static final Color T_RED = Color.RED.copy().setAF(0.4f);
    protected int cursorPosition;
    protected int selectorPosition = -1;
    protected long cursorTime;
    public TextFilter filter;
    protected long lastClickTime;
    protected int clicks = 1;
    protected int lastAbsMouseX;

    public GUITextInput(GUIScreen screen, String text, TextFilter filter) {
        this(screen, text, filter, (Color)Color.WHITE, 1.0);
    }

    public GUITextInput(GUIScreen screen, String text, TextFilter filter, double scale) {
        this(screen, text, filter, (Color)Color.WHITE, scale);
    }

    public GUITextInput(GUIScreen screen, String text, TextFilter filter, Color activeColor) {
        this(screen, text, filter, activeColor, 1.0);
    }

    public GUITextInput(GUIScreen screen, String text, TextFilter filter, Color activeColor, double scale) {
        super(screen, text, GUIScreen.getIdleColor(activeColor), GUIScreen.getHoverColor(activeColor), activeColor, scale);
        this.filter = filter;
        this.cursorPosition = text.length();
    }

    public GUITextInput(GUIScreen screen, double x, double y, String text, TextFilter filter) {
        this(screen, x, y, text, filter, (Color)Color.WHITE, 1.0);
    }

    public GUITextInput(GUIScreen screen, double x, double y, String text, TextFilter filter, double scale) {
        this(screen, x, y, text, filter, (Color)Color.WHITE, scale);
    }

    public GUITextInput(GUIScreen screen, double x, double y, String text, TextFilter filter, Color activeColor) {
        this(screen, x, y, text, filter, activeColor, 1.0);
    }

    public GUITextInput(GUIScreen screen, double x, double y, String text, TextFilter filter, Color activeColor, double scale) {
        super(screen, x, y, text, GUIScreen.getIdleColor(activeColor), GUIScreen.getHoverColor(activeColor), activeColor, scale);
        this.filter = filter;
        this.cursorPosition = text.length();
    }

    public GUITextInput setNamespace(String namespace) {
        if (this.namespace != null) {
            this.screen.namespaces.get((Object)this.namespace).inputs.remove(this);
        }
        this.namespace = namespace;
        this.screen.namespaces.computeIfAbsent((String)namespace, (Function<String, Namespace>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setNamespace$0(java.lang.String ), (Ljava/lang/String;)Lcom/fantasticsource/mctools/gui/Namespace;)()).inputs.add(this);
        return this;
    }

    protected boolean hasSelectedText() {
        return this.selectorPosition != -1 && this.selectorPosition != this.cursorPosition;
    }

    protected int charType(char c) {
        if (Character.isWhitespace(c)) {
            return 0;
        }
        if (Character.isLetterOrDigit(c) || c == '_') {
            return 1;
        }
        return -1;
    }

    protected boolean isWhitespace() {
        for (char c : this.text.toCharArray()) {
            if (c == ' ') continue;
            return false;
        }
        return true;
    }

    protected int nonWhitespaceStart() {
        int i = 0;
        for (char c : this.text.toCharArray()) {
            if (c != ' ') break;
            ++i;
        }
        return i;
    }

    protected int nonWhitespaceEnd() {
        int i;
        char[] chars = this.text.toCharArray();
        for (i = chars.length; i > 0 && chars[i - 1] == ' '; --i) {
        }
        return i;
    }

    protected int tabs() {
        if (!(this.parent instanceof CodeInput)) {
            return 0;
        }
        int tabbing = 0;
        for (int index = 0; index < this.parent.size(); ++index) {
            GUITextInput element = (GUITextInput)this.parent.get(index);
            if (element == this) {
                return Tools.max(0, tabbing);
            }
            for (char c : element.text.toCharArray()) {
                if (c == '{') {
                    ++tabbing;
                    continue;
                }
                if (c != '}') continue;
                --tabbing;
            }
        }
        throw new IllegalStateException("This should be impossible");
    }

    protected void deselectAll() {
        if (this.parent instanceof CodeInput) {
            ((CodeInput)this.parent).selectionStartY = -1;
            for (GUIElement element : this.parent.children) {
                ((GUITextInput)element).selectorPosition = -1;
            }
        } else {
            this.selectorPosition = -1;
        }
    }

    protected void singleLineHome() {
        int startPos;
        int n = startPos = this.isWhitespace() ? Tools.min(this.text.length(), this.tabs()) : this.nonWhitespaceStart();
        if (this.cursorPosition == startPos) {
            startPos = 0;
        }
        if (GUIScreen.func_146272_n()) {
            if (this.selectorPosition == -1 && this.cursorPosition != startPos) {
                this.selectorPosition = this.cursorPosition;
            }
        } else {
            this.deselectAll();
        }
        this.cursorPosition = startPos;
        if (this.parent instanceof CodeInput) {
            ((CodeInput)this.parent).cursorX = this.cursorPosition;
        }
    }

    protected void singleLineEnd() {
        int endPos;
        int n = endPos = this.isWhitespace() ? Tools.min(this.text.length(), this.tabs()) : this.nonWhitespaceEnd();
        if (this.cursorPosition == endPos) {
            endPos = this.text.length();
        }
        if (GUIScreen.func_146272_n()) {
            if (this.selectorPosition == -1 && this.cursorPosition != endPos) {
                this.selectorPosition = this.cursorPosition;
            }
        } else {
            this.deselectAll();
        }
        this.cursorPosition = endPos;
        if (this.parent instanceof CodeInput) {
            ((CodeInput)this.parent).cursorX = this.cursorPosition;
        }
    }

    public boolean valid() {
        if (this.filter == null || !this.filter.acceptable(this.text)) {
            return false;
        }
        if (this.namespace != null) {
            return !this.screen.namespaces.get(this.namespace).containsIgnoreObject(this.getText(), this);
        }
        return true;
    }

    protected GUITextInput multilineDelete() {
        if (!(this.parent instanceof CodeInput) || ((CodeInput)this.parent).selectionStartY == -1 || ((CodeInput)this.parent).selectionStartY == this.parent.indexOf(this)) {
            return null;
        }
        CodeInput code = (CodeInput)this.parent;
        int index = this.parent.indexOf(this);
        int firstY = Tools.min(index, code.selectionStartY);
        int lastY = Tools.max(index, code.selectionStartY);
        GUITextInput element = (GUITextInput)code.get(lastY);
        String s = element.text.substring(Tools.max(element.cursorPosition, element.selectorPosition));
        element = (GUITextInput)code.get(firstY);
        int nextCursorPos = element.selectorPosition == -1 ? element.cursorPosition : Tools.min(element.selectorPosition, element.cursorPosition);
        element.setText(element.text.substring(0, nextCursorPos) + s);
        this.setActive(false);
        for (int i = lastY - firstY; i > 0; --i) {
            code.remove(firstY + 1);
        }
        element.setActive(true);
        element.selectorPosition = -1;
        element.cursorPosition = nextCursorPos;
        code.cursorX = nextCursorPos;
        code.selectionStartY = -1;
        return element;
    }

    protected GUITextInput activeLine() {
        if (this.parent instanceof CodeInput) {
            for (GUIElement element : this.parent.children) {
                if (!element.isActive()) continue;
                return (GUITextInput)element;
            }
        }
        return this.isActive() ? this : null;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        GUITextInput element;
        int i;
        CodeInput code;
        super.keyTyped(typedChar, keyCode);
        if (!this.active) {
            return;
        }
        String oldText = this.text;
        CodeInput codeInput = code = this.parent instanceof CodeInput ? (CodeInput)this.parent : null;
        if (keyCode == 28) {
            if (this instanceof GUIMultilineTextInput) {
                int min;
                GUITextInput element2 = this.multilineDelete();
                if (element2 == null) {
                    element2 = this;
                }
                if ((min = Tools.min(element2.cursorPosition, element2.selectorPosition)) == -1) {
                    min = element2.cursorPosition;
                }
                String before = element2.text.substring(0, min);
                String after = element2.text.substring(Tools.max(element2.cursorPosition, element2.selectorPosition));
                element2.setText(before + "\n" + after);
                this.deselectAll();
                element2.cursorPosition = min + 1;
            } else if (code != null) {
                GUITextInput element3 = this.multilineDelete();
                if (element3 == null) {
                    element3 = this;
                }
                int min = element3.selectorPosition == -1 ? element3.cursorPosition : Tools.min(element3.cursorPosition, element3.selectorPosition);
                String before = element3.text.substring(0, min);
                String after = element3.text.substring(Tools.max(element3.cursorPosition, element3.selectorPosition));
                element3.setText(before);
                this.deselectAll();
                element3.cursorPosition = min;
                element3.setActive(false);
                int tabs = element3.tabs();
                for (char c : before.toCharArray()) {
                    if (c == '{') {
                        ++tabs;
                        continue;
                    }
                    if (c != '}') continue;
                    --tabs;
                }
                String afterTrimmed = after.trim();
                if (afterTrimmed.length() <= 0 || afterTrimmed.charAt(0) == '}') {
                    // empty if block
                }
                tabs = Tools.max(0, --tabs);
                StringBuilder tabbing = new StringBuilder();
                for (i = tabs; i > 0; --i) {
                    tabbing.append(" ");
                }
                element3 = (GUITextInput)code.add(code.indexOf(element3) + 1, tabbing + afterTrimmed);
                element3.setActive(true);
                element3.cursorPosition = tabs;
                code.cursorX = tabs;
            }
        } else if (keyCode == 199) {
            if (this instanceof GUIMultilineTextInput) {
                if (GUIScreen.func_146272_n()) {
                    if (this.selectorPosition == -1) {
                        this.selectorPosition = this.cursorPosition;
                    }
                } else {
                    this.selectorPosition = -1;
                }
                if (GUIScreen.func_146271_m()) {
                    this.cursorPosition = 0;
                } else {
                    int position = 0;
                    for (String fullLine : this.fullLines) {
                        if ((position += fullLine.length()) < this.cursorPosition) continue;
                        this.cursorPosition = position - fullLine.length();
                        if (fullLine.length() > 0 && fullLine.charAt(0) == '\n') {
                            ++this.cursorPosition;
                        }
                        break;
                    }
                }
            } else {
                int index = this.parent.indexOf(this);
                if (code != null && index != 0 && GUIScreen.func_146271_m()) {
                    GUITextInput first = (GUITextInput)code.get(0);
                    if (GUIScreen.func_146272_n()) {
                        if (code.selectionStartY == -1) {
                            code.selectionStartY = index;
                        }
                        for (int i2 = 0; i2 < this.parent.size(); ++i2) {
                            GUITextInput element4 = (GUITextInput)this.parent.get(i2);
                            if (i2 > code.selectionStartY) {
                                element4.selectorPosition = -1;
                                continue;
                            }
                            if (i2 < code.selectionStartY) {
                                element4.selectorPosition = element4.text.length();
                                element4.cursorPosition = 0;
                                continue;
                            }
                            if (element4.selectorPosition == -1) {
                                element4.selectorPosition = element4.cursorPosition;
                            }
                            element4.cursorPosition = 0;
                        }
                    } else {
                        this.deselectAll();
                        first.cursorPosition = 0;
                    }
                    this.setActive(false);
                    first.setActive(true);
                    code.cursorX = first.cursorPosition;
                } else {
                    this.singleLineHome();
                }
            }
        } else if (keyCode == 207) {
            if (this instanceof GUIMultilineTextInput) {
                if (GUIScreen.func_146272_n()) {
                    if (this.selectorPosition == -1) {
                        this.selectorPosition = this.cursorPosition;
                    }
                } else {
                    this.selectorPosition = -1;
                }
                if (GUIScreen.func_146271_m()) {
                    this.cursorPosition = this.text.length();
                } else {
                    int position = 0;
                    for (int i3 = 0; i3 < this.fullLines.size(); ++i3) {
                        String fullLine = (String)this.fullLines.get(i3);
                        if ((position += fullLine.length()) < this.cursorPosition) continue;
                        this.cursorPosition = this.cursorPosition == position && this.cursorPosition < this.text.length() && this.text.charAt(this.cursorPosition) != '\n' ? (this.cursorPosition += ((String)this.fullLines.get(i3 + 1)).length()) : position;
                        break;
                    }
                }
            } else {
                int index = this.parent.indexOf(this);
                if (code != null && index != this.parent.size() - 1 && GUIScreen.func_146271_m()) {
                    GUITextInput last = (GUITextInput)code.get(code.size() - 1);
                    if (GUIScreen.func_146272_n()) {
                        if (code.selectionStartY == -1) {
                            code.selectionStartY = index;
                        }
                        for (int i4 = 0; i4 < this.parent.size(); ++i4) {
                            GUITextInput element5 = (GUITextInput)this.parent.get(i4);
                            if (i4 < code.selectionStartY) {
                                element5.selectorPosition = -1;
                                continue;
                            }
                            if (i4 > code.selectionStartY) {
                                element5.selectorPosition = 0;
                                element5.cursorPosition = element5.text.length();
                                continue;
                            }
                            if (element5.selectorPosition == -1) {
                                element5.selectorPosition = element5.cursorPosition;
                            }
                            element5.cursorPosition = element5.text.length();
                        }
                    } else {
                        this.deselectAll();
                        last.cursorPosition = last.text.length();
                    }
                    this.setActive(false);
                    last.setActive(true);
                    code.cursorX = last.cursorPosition;
                } else {
                    this.singleLineEnd();
                }
            }
        } else if (GUIScreen.func_146271_m() && keyCode == 30) {
            if (code != null) {
                GUITextInput last = (GUITextInput)code.get(code.size() - 1);
                for (GUIElement e : code.children) {
                    GUITextInput element6 = (GUITextInput)e;
                    if (element6.text.length() <= 0) continue;
                    element6.selectorPosition = 0;
                    element6.cursorPosition = element6.text.length();
                }
                this.setActive(false);
                last.setActive(true);
                code.selectionStartY = 0;
                code.cursorX = last.cursorPosition;
            } else if (this.text.length() > 0) {
                this.selectorPosition = 0;
                this.cursorPosition = this.text.length();
            }
        } else if (GUIScreen.func_146271_m() && keyCode == 45) {
            StringBuilder s = new StringBuilder();
            if (code != null && ((CodeInput)this.parent).selectionStartY != -1 && ((CodeInput)this.parent).selectionStartY != this.parent.indexOf(this)) {
                int startY = Tools.min(code.indexOf(this), code.selectionStartY);
                int endY = Tools.max(code.indexOf(this), code.selectionStartY);
                GUITextInput element7 = (GUITextInput)code.get(startY);
                s.append(element7.text.substring(element7.selectorPosition == -1 ? element7.cursorPosition : Tools.min(element7.cursorPosition, element7.selectorPosition)));
                for (int i5 = startY + 1; i5 < endY; ++i5) {
                    s.append("\n").append(((GUITextInput)code.get((int)i5)).text);
                }
                element7 = (GUITextInput)code.get(endY);
                s.append("\n").append(element7.text, 0, Tools.max(element7.cursorPosition, element7.selectorPosition));
                this.multilineDelete();
            } else if (this.hasSelectedText()) {
                int min = Tools.min(this.selectorPosition, this.cursorPosition);
                s.append(this.text, min, Tools.max(this.cursorPosition, this.selectorPosition));
                this.text = this.text.substring(0, min) + this.text.substring(Tools.max(this.selectorPosition, this.cursorPosition));
                this.deselectAll();
                this.cursorPosition = min;
                if (code != null) {
                    ((CodeInput)this.parent).cursorX = this.cursorPosition;
                }
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s.toString().replaceAll("\n", "\r\n")), null);
        } else if (GUIScreen.func_146271_m() && keyCode == 46) {
            StringBuilder s = new StringBuilder();
            if (code != null && ((CodeInput)this.parent).selectionStartY != -1 && ((CodeInput)this.parent).selectionStartY != this.parent.indexOf(this)) {
                int startY = Tools.min(code.indexOf(this), code.selectionStartY);
                int endY = Tools.max(code.indexOf(this), code.selectionStartY);
                GUITextInput element8 = (GUITextInput)code.get(startY);
                s.append(element8.text.substring(element8.selectorPosition == -1 ? element8.cursorPosition : Tools.min(element8.cursorPosition, element8.selectorPosition)));
                for (int i6 = startY + 1; i6 < endY; ++i6) {
                    s.append("\n").append(((GUITextInput)code.get((int)i6)).text);
                }
                element8 = (GUITextInput)code.get(endY);
                s.append("\n").append(element8.text, 0, Tools.max(element8.cursorPosition, element8.selectorPosition));
            } else if (this.hasSelectedText()) {
                s = new StringBuilder(this.text.substring(Tools.min(this.cursorPosition, this.selectorPosition), Tools.max(this.cursorPosition, this.selectorPosition)));
            }
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(s.toString().replaceAll("\n", "\r\n")), null);
        } else if (GUIScreen.func_146271_m() && keyCode == 47) {
            String before;
            int min;
            String clipboard = GUIScreen.func_146277_j().replaceAll("\r", "");
            String[] tokens = Tools.fixedSplit(clipboard, "\n");
            GUITextInput element9 = this.multilineDelete();
            if (element9 == null) {
                element9 = this;
            }
            if (code != null && tokens.length > 1) {
                min = element9.selectorPosition == -1 ? element9.cursorPosition : Tools.min(element9.cursorPosition, element9.selectorPosition);
                before = element9.text.substring(0, min);
                String after = element9.text.substring(Tools.max(element9.cursorPosition, element9.selectorPosition));
                element9.setText(before + tokens[0]);
                element9.setActive(false);
                int index = code.indexOf(element9) + 1;
                for (i = 1; i < tokens.length - 1; ++i) {
                    code.add(index++, tokens[i]);
                }
                before = tokens[tokens.length - 1];
                element9 = (GUITextInput)code.add(index, before + after);
                this.deselectAll();
                element9.setActive(true);
                code.cursorX = element9.cursorPosition = before.length();
                code.selectionStartY = -1;
            } else {
                min = Tools.min(element9.cursorPosition, element9.selectorPosition);
                if (min == -1) {
                    min = element9.cursorPosition;
                }
                before = element9.text.substring(0, min) + clipboard;
                element9.setText(before + element9.text.substring(Tools.max(element9.cursorPosition, element9.selectorPosition)));
                this.deselectAll();
                element9.cursorPosition = before.length();
            }
        } else if (typedChar >= ' ' && typedChar <= '~') {
            int min;
            GUITextInput element10 = this.multilineDelete();
            if (element10 == null) {
                element10 = this;
            }
            if ((min = Tools.min(element10.cursorPosition, element10.selectorPosition)) == -1) {
                min = element10.cursorPosition;
            }
            String before = element10.text.substring(0, min);
            String after = element10.text.substring(Tools.max(element10.cursorPosition, element10.selectorPosition));
            if (code != null && typedChar == '}' && element10.isWhitespace()) {
                StringBuilder s = new StringBuilder();
                for (int i7 = this.tabs() - 1; i7 > 0; --i7) {
                    s.append(" ");
                }
                element10.setText(s.toString() + '}');
                this.deselectAll();
                element10.cursorPosition = element10.text.length();
            } else {
                element10.setText(before + typedChar + after);
                this.deselectAll();
                element10.cursorPosition = min + 1;
            }
            if (code != null) {
                code.cursorX = element10.cursorPosition;
                code.selectionStartY = -1;
            }
        } else if (keyCode == 14) {
            if (this.multilineDelete() == null) {
                int index;
                if (this.hasSelectedText()) {
                    int min = Tools.min(this.selectorPosition, this.cursorPosition);
                    this.text = this.text.substring(0, min) + this.text.substring(Tools.max(this.selectorPosition, this.cursorPosition));
                    this.deselectAll();
                    this.cursorPosition = min;
                } else if (this.cursorPosition > 0) {
                    this.text = this.text.substring(0, this.cursorPosition - 1) + this.text.substring(this.cursorPosition);
                    --this.cursorPosition;
                } else if (code != null && (index = this.parent.indexOf(this)) != 0) {
                    GUITextInput other = (GUITextInput)this.parent.get(index - 1);
                    this.text = other.text + this.text;
                    this.cursorPosition = other.text.length();
                    this.parent.remove(index - 1);
                }
                if (code != null) {
                    code.cursorX = this.cursorPosition;
                    code.selectionStartY = -1;
                }
            }
        } else if (keyCode == 211) {
            if (this.multilineDelete() == null) {
                int index;
                if (this.hasSelectedText()) {
                    int min = Tools.min(this.selectorPosition, this.cursorPosition);
                    this.text = this.text.substring(0, min) + this.text.substring(Tools.max(this.selectorPosition, this.cursorPosition));
                    this.deselectAll();
                    this.cursorPosition = min;
                } else if (this.cursorPosition < this.text.length()) {
                    this.text = this.text.substring(0, this.cursorPosition) + this.text.substring(this.cursorPosition + 1);
                } else if (code != null && (index = this.parent.indexOf(this)) != this.parent.size() - 1) {
                    this.text = this.text + ((GUITextInput)this.parent.get((int)(index + 1))).text;
                    this.parent.remove(index + 1);
                }
                if (code != null) {
                    code.cursorX = this.cursorPosition;
                    code.selectionStartY = -1;
                }
            }
        } else if (keyCode == 203) {
            if (GUIScreen.func_146272_n()) {
                if (this.selectorPosition == -1 && this.cursorPosition > 0) {
                    this.selectorPosition = this.cursorPosition;
                }
            } else {
                this.deselectAll();
            }
            if (this.cursorPosition > 0) {
                int type = this.charType(this.text.charAt(this.cursorPosition - 1));
                --this.cursorPosition;
                if (type != -1 && GUIScreen.func_146271_m()) {
                    while (this.cursorPosition > 0 && this.charType(this.text.charAt(this.cursorPosition - 1)) == type) {
                        --this.cursorPosition;
                    }
                }
                if (code != null) {
                    ((CodeInput)this.parent).cursorX = this.cursorPosition;
                }
            } else if (code != null) {
                int index = code.indexOf(this);
                if (index != 0) {
                    GUITextInput other = (GUITextInput)code.get(index - 1);
                    if (GUIScreen.func_146272_n() && code.selectionStartY == -1) {
                        code.selectionStartY = index;
                        other.selectorPosition = -1;
                    }
                    this.setActive(false);
                    other.setActive(true);
                    code.cursorX = other.cursorPosition = other.text.length();
                } else {
                    code.cursorX = this.cursorPosition;
                }
            }
        } else if (keyCode == 205) {
            if (GUIScreen.func_146272_n()) {
                if (this.selectorPosition == -1 && this.cursorPosition < this.text.length()) {
                    this.selectorPosition = this.cursorPosition;
                }
            } else {
                this.deselectAll();
            }
            if (this.cursorPosition < this.text.length()) {
                int type = this.charType(this.text.charAt(this.cursorPosition));
                ++this.cursorPosition;
                if (type != -1 && GUIScreen.func_146271_m()) {
                    while (this.cursorPosition < this.text.length() && this.charType(this.text.charAt(this.cursorPosition)) == type) {
                        ++this.cursorPosition;
                    }
                }
                if (code != null) {
                    ((CodeInput)this.parent).cursorX = this.cursorPosition;
                }
            } else if (code != null) {
                int index = code.indexOf(this);
                if (index != this.parent.size() - 1) {
                    GUITextInput other = (GUITextInput)code.get(index + 1);
                    if (GUIScreen.func_146272_n() && code.selectionStartY == -1) {
                        code.selectionStartY = index;
                        other.selectorPosition = -1;
                    }
                    this.setActive(false);
                    other.setActive(true);
                    code.cursorX = other.cursorPosition = 0;
                } else {
                    code.cursorX = this.cursorPosition;
                }
            }
        } else if (keyCode == 200) {
            if (this instanceof GUIMultilineTextInput) {
                if (GUIScreen.func_146272_n()) {
                    if (this.selectorPosition == -1) {
                        this.selectorPosition = this.cursorPosition;
                    }
                } else {
                    this.selectorPosition = -1;
                }
                int lineIndex = 0;
                int pos = 0;
                String partialLine = "";
                for (String fullLine : this.fullLines) {
                    if ((pos += fullLine.length()) >= this.cursorPosition) {
                        partialLine = fullLine.substring(0, this.cursorPosition - (pos - fullLine.length()));
                        break;
                    }
                    ++lineIndex;
                }
                this.cursorPosition = lineIndex == 0 ? 0 : this.findCursorPosition(this.absoluteX() + (double)GUIScreen.FONT_RENDERER.func_78256_a(partialLine.replaceAll("\n", "")) * this.scale / (double)this.screen.field_146294_l, lineIndex - 1);
            } else if (code != null && this.parent.indexOf(this) > 0) {
                int index = code.indexOf(this);
                GUITextInput other = (GUITextInput)code.get(index - 1);
                if (GUIScreen.func_146272_n()) {
                    if (code.selectionStartY == -1) {
                        code.selectionStartY = index;
                    }
                    if (code.selectionStartY > index) {
                        this.selectorPosition = this.text.length();
                        this.cursorPosition = 0;
                        other.selectorPosition = other.text.length();
                    } else if (code.selectionStartY < index) {
                        this.selectorPosition = -1;
                    } else {
                        if (this.selectorPosition == -1) {
                            this.selectorPosition = this.cursorPosition;
                        }
                        this.cursorPosition = 0;
                        other.selectorPosition = other.text.length();
                    }
                } else {
                    this.deselectAll();
                }
                this.setActive(false);
                other.setActive(true);
                other.cursorPosition = Tools.min(other.text.length(), code.cursorX);
            } else {
                this.singleLineHome();
            }
        } else if (keyCode == 208) {
            if (this instanceof GUIMultilineTextInput) {
                if (GUIScreen.func_146272_n()) {
                    if (this.selectorPosition == -1) {
                        this.selectorPosition = this.cursorPosition;
                    }
                } else {
                    this.selectorPosition = -1;
                }
                int lineIndex = 0;
                int pos = 0;
                String partialLine = "";
                for (String fullLine : this.fullLines) {
                    if ((pos += fullLine.length()) >= this.cursorPosition) {
                        partialLine = fullLine.substring(0, this.cursorPosition - (pos - fullLine.length()));
                        break;
                    }
                    ++lineIndex;
                }
                this.cursorPosition = lineIndex == this.fullLines.size() - 1 ? this.text.length() : this.findCursorPosition(this.absoluteX() + (double)GUIScreen.FONT_RENDERER.func_78256_a(partialLine.replaceAll("\n", "")) * this.scale / (double)this.screen.field_146294_l, lineIndex + 1);
            } else if (code != null && this.parent.indexOf(this) != this.parent.size() - 1) {
                int index = code.indexOf(this);
                GUITextInput other = (GUITextInput)code.get(index + 1);
                if (GUIScreen.func_146272_n()) {
                    if (code.selectionStartY == -1) {
                        code.selectionStartY = index;
                    }
                    if (code.selectionStartY < index) {
                        this.selectorPosition = 0;
                        this.cursorPosition = this.text.length();
                        other.selectorPosition = 0;
                    } else if (code.selectionStartY > index) {
                        this.selectorPosition = -1;
                    } else {
                        if (this.selectorPosition == -1) {
                            this.selectorPosition = this.cursorPosition;
                        }
                        this.cursorPosition = this.text.length();
                        other.selectorPosition = 0;
                    }
                } else {
                    this.deselectAll();
                }
                this.setActive(false);
                other.setActive(true);
                other.cursorPosition = Tools.min(other.text.length(), code.cursorX);
            } else {
                this.singleLineEnd();
            }
        }
        if (code != null && (element = this.activeLine()) != null) {
            if (element.y < code.top) {
                code.progress = element.y / (code.internalHeight - 1.0);
            }
            if (element.y + element.height > code.bottom) {
                code.progress = (element.y + element.height - 1.0) / (code.internalHeight - 1.0);
            }
        }
        this.cursorTime = System.currentTimeMillis();
        this.screen.root.recalc(0);
        if (!this.text.equals(oldText)) {
            for (Runnable action : this.onEditActions) {
                action.run();
            }
        }
    }

    @Override
    public GUITextInput recalc(int subIndexChanged) {
        this.text = this.text.replaceAll("\r", "");
        this.lines.clear();
        this.fullLines.clear();
        if (this.parent instanceof CodeInput) {
            this.lines.add(this.text);
            this.fullLines.add(this.text);
            this.width = (double)MonoASCIIFontRenderer.getStringWidth(this.text) * this.scale / (double)this.screen.field_146294_l;
            this.height = (double)(MonoASCIIFontRenderer.LINE_HEIGHT + 2) * this.scale / (double)this.screen.field_146295_m;
        } else {
            StringBuilder previous = new StringBuilder();
            String[] words = Tools.preservedSplit(this.text, "[\n]|[ ]+", true);
            double parentW = this.parent == null ? 1.0 : this.parent.absoluteWidth();
            StringBuilder line = new StringBuilder();
            StringBuilder fullLine = new StringBuilder();
            int index = 0;
            double maxLineW = 1.0 / (double)this.screen.field_146294_l;
            double lineW = 1.0 / (double)this.screen.field_146294_l;
            while (index < words.length) {
                String word;
                if ((word = words[index++]).equals("")) continue;
                if (word.equals("\n")) {
                    this.lines.add(line.toString());
                    this.fullLines.add(fullLine.toString());
                    line = new StringBuilder();
                    fullLine = new StringBuilder("\n");
                    maxLineW = 1.0;
                    lineW = 1.0 / (double)this.screen.field_146294_l;
                } else {
                    double wordW = (double)Render.getPartialStringWidth(previous.toString().replaceAll("\n", ""), word.replaceAll("\n", "")) * this.scale / (double)this.screen.field_146294_l;
                    if (lineW + wordW > parentW) {
                        if (word.trim().equals("")) {
                            fullLine.append(word);
                            continue;
                        }
                        if (line.length() == 0) {
                            line.append(word);
                            fullLine.append(word);
                            lineW += wordW;
                        } else {
                            this.lines.add(line.toString());
                            this.fullLines.add(fullLine.toString());
                            line = new StringBuilder(word);
                            fullLine = new StringBuilder(word);
                            maxLineW = parentW;
                            lineW = (double)(Render.getPartialStringWidth(previous.toString().replaceAll("\n", ""), word.replaceAll("\n", "")) + 1) * this.scale / (double)this.screen.field_146294_l;
                        }
                    } else {
                        line.append(word);
                        fullLine.append(word);
                        lineW += wordW;
                    }
                }
                previous.append(word);
            }
            if (line.length() > 0) {
                this.lines.add(line.toString());
                maxLineW = Tools.max(maxLineW, lineW);
            }
            if (fullLine.length() > 0) {
                this.fullLines.add(fullLine.toString());
            }
            this.width = maxLineW;
            this.height = this instanceof GUIMultilineTextInput && this.text.length() > 0 && this.text.charAt(this.text.length() - 1) == '\n' ? (double)(Tools.max(1, this.fullLines.size()) * GUIScreen.FONT_RENDERER.field_78288_b - 1) * this.scale / (double)this.screen.field_146295_m : (double)(Tools.max(1, this.lines.size()) * GUIScreen.FONT_RENDERER.field_78288_b - 1) * this.scale / (double)this.screen.field_146295_m;
        }
        if (this.parent != null) {
            this.width /= this.parent.absoluteWidth();
            this.height /= this.parent.absoluteHeight();
        }
        this.width += 1.0 * this.width / (double)this.screen.field_146294_l;
        this.recalcAndRepositionSubElements(0);
        if (this.parent instanceof CodeInput) {
            this.width = Tools.max(this.width, 2.0 / (double)this.parent.absolutePxWidth());
        }
        this.postRecalc();
        return this;
    }

    @Override
    public boolean isWithin(double x, double y) {
        if (this.parent instanceof CodeInput) {
            double yy = this.absoluteY();
            return yy <= y && y < yy + this.absoluteHeight();
        }
        return super.isWithin(x, y);
    }

    @Override
    public boolean mousePressed(int button) {
        boolean result = false;
        if (button == 0 && this.isMouseWithin()) {
            result = true;
            this.setActive(true);
            long time = System.currentTimeMillis();
            int absMouseX = (int)(GUIScreen.mouseX * (double)this.screen.field_146294_l);
            this.clicks = time - this.lastClickTime <= 250L && Math.abs(this.lastAbsMouseX - absMouseX) < 3 ? ++this.clicks : 1;
            this.lastClickTime = time;
            if (this.clicks == 1) {
                this.lastAbsMouseX = absMouseX;
                if (GUIScreen.func_146272_n()) {
                    if (this.selectorPosition == -1) {
                        this.selectorPosition = this.cursorPosition;
                    }
                } else {
                    this.deselectAll();
                }
                this.cursorPosition = this.findCursorPosition(this.mouseX(), this.mouseY());
                if (this.parent instanceof CodeInput && ((CodeInput)this.parent).selectionStartY == -1) {
                    ((CodeInput)this.parent).selectionStartY = this.parent.indexOf(this);
                }
            } else if (this.clicks == 2) {
                this.deselectAll();
                this.selectorPosition = this.cursorPosition = this.findCursorPosition(this.mouseX(), this.mouseY());
                char[] chars = this.text.toCharArray();
                int type = this.charType(chars[this.cursorPosition == 0 ? 0 : this.cursorPosition - 1]);
                while (this.cursorPosition < chars.length && this.charType(chars[this.cursorPosition]) == type) {
                    ++this.cursorPosition;
                }
                while (this.selectorPosition > 0 && this.charType(chars[this.selectorPosition - 1]) == type) {
                    --this.selectorPosition;
                }
                if (this.selectorPosition == this.cursorPosition) {
                    this.selectorPosition = -1;
                }
            } else {
                this.deselectAll();
                this.cursorPosition = this.text.length();
                this.selectorPosition = 0;
            }
            this.cursorTime = System.currentTimeMillis();
            if (this.parent instanceof CodeInput) {
                ((CodeInput)this.parent).cursorX = this.cursorPosition;
            }
        } else {
            this.setActive(false);
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            result |= child.mousePressed(button);
        }
        return result;
    }

    @Override
    public boolean mouseReleased(int button) {
        boolean result;
        boolean bl = result = button == 0 && this.active && this.isMouseWithin();
        if (result && !MinecraftForge.EVENT_BUS.post((Event)new GUILeftClickEvent(this.screen, this))) {
            this.click();
        }
        for (GUIElement child : (ArrayList)this.children.clone()) {
            child.mouseReleased(button);
        }
        return result;
    }

    @Override
    public void mouseDrag(int button) {
        if (button == 0 && (this.parent instanceof CodeInput && this.isMouseWithin() || !(this.parent instanceof CodeInput) && this.active)) {
            if (this.parent instanceof CodeInput && ((CodeInput)this.parent).selectionStartY != -1 && ((CodeInput)this.parent).selectionStartY != this.parent.indexOf(this)) {
                CodeInput code = (CodeInput)this.parent;
                int index = code.indexOf(this);
                if (code.selectionStartY < index) {
                    int i;
                    GUITextInput element = (GUITextInput)code.get(code.selectionStartY);
                    if (element.selectorPosition == -1) {
                        element.selectorPosition = element.cursorPosition;
                    }
                    element.cursorPosition = element.text.length();
                    for (i = code.selectionStartY + 1; i < index; ++i) {
                        element = (GUITextInput)code.get(i);
                        element.selectorPosition = 0;
                        element.cursorPosition = element.text.length();
                    }
                    this.selectorPosition = 0;
                    for (i = 0; i < code.selectionStartY; ++i) {
                        ((GUITextInput)code.get((int)i)).selectorPosition = -1;
                    }
                    for (i = index + 1; i < code.size(); ++i) {
                        ((GUITextInput)code.get((int)i)).selectorPosition = -1;
                    }
                } else {
                    int i;
                    GUITextInput element = (GUITextInput)code.get(code.selectionStartY);
                    if (element.selectorPosition == -1) {
                        element.selectorPosition = element.cursorPosition;
                    }
                    element.cursorPosition = 0;
                    for (i = code.selectionStartY - 1; i > index; --i) {
                        element = (GUITextInput)code.get(i);
                        element.selectorPosition = element.text.length();
                        element.cursorPosition = 0;
                    }
                    this.selectorPosition = this.text.length();
                    for (i = 0; i < index; ++i) {
                        ((GUITextInput)code.get((int)i)).selectorPosition = -1;
                    }
                    for (i = code.selectionStartY + 1; i < code.size(); ++i) {
                        ((GUITextInput)code.get((int)i)).selectorPosition = -1;
                    }
                }
                this.cursorPosition = this.findCursorPosition(this.mouseX(), this.mouseY());
            } else {
                if (this.selectorPosition == -1) {
                    this.selectorPosition = this.cursorPosition;
                }
                this.cursorPosition = this.findCursorPosition(this.mouseX(), this.mouseY());
                if (this.selectorPosition == this.cursorPosition) {
                    this.selectorPosition = -1;
                }
                int sp = this.selectorPosition;
                int cp = this.cursorPosition;
                this.deselectAll();
                this.selectorPosition = sp;
                this.cursorPosition = cp;
                if (this.parent instanceof CodeInput) {
                    CodeInput code = (CodeInput)this.parent;
                    code.selectionStartY = code.indexOf(this);
                    code.cursorX = this.cursorPosition;
                }
            }
            GUITextInput activeLine = this.activeLine();
            if (activeLine != null) {
                ((GUIElement)activeLine).setActive(false);
            }
            this.setActive(true);
        }
        this.cursorTime = System.currentTimeMillis();
        super.mouseDrag(button);
    }

    @Override
    public void draw() {
        Color c;
        int mcColor;
        GlStateManager.func_179090_x();
        double adjustedScale = this.scale * (double)new ScaledResolution(Minecraft.func_71410_x()).func_78325_e();
        if (this.parent instanceof GUIPanZoomView) {
            adjustedScale *= ((GUIPanZoomView)this.parent).getZoom();
        }
        if (!this.valid()) {
            GlStateManager.func_179131_c((float)T_RED.rf(), (float)T_RED.gf(), (float)T_RED.bf(), (float)T_RED.af());
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)1.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187437_J();
        } else if (this.active) {
            GlStateManager.func_179131_c((float)Color.GRAY.rf(), (float)Color.GRAY.gf(), (float)Color.GRAY.bf(), (float)0.2f);
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)1.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_187437_J();
        }
        if (this.text.length() > 0 && ((mcColor = (c = this.active ? this.activeColor : (this.isMouseWithin() ? this.hoverColor : this.color)).color() >>> 8 | c.a() << 24) & 0xFC000000) != 0) {
            GlStateManager.func_179098_w();
            GlStateManager.func_179094_E();
            GlStateManager.func_179139_a((double)(adjustedScale / (double)this.absolutePxWidth()), (double)(adjustedScale / (double)this.absolutePxHeight()), (double)1.0);
            if (this.parent instanceof CodeInput) {
                MonoASCIIFontRenderer.draw(this.text, 0.0, 0.0, c, Color.BLACK);
            } else {
                GUIScreen.FONT_RENDERER.func_175065_a(this.text, 1.0f, 0.0f, mcColor, false);
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179090_x();
        }
        if (this.active || this.parent instanceof CodeInput) {
            float cursorX;
            float f = cursorX = this.parent instanceof CodeInput ? (float)MonoASCIIFontRenderer.getStringWidth(this.text.substring(0, this.cursorPosition)) : (float)GUIScreen.FONT_RENDERER.func_78256_a(this.text.substring(0, this.cursorPosition).replaceAll("\n", "")) + 0.5f;
            float selectorX = this.selectorPosition == -1 ? cursorX : (float)(this.parent instanceof CodeInput ? MonoASCIIFontRenderer.getStringWidth(this.text.substring(0, this.selectorPosition)) : GUIScreen.FONT_RENDERER.func_78256_a(this.text.substring(0, this.selectorPosition).replaceAll("\n", ""))) + 0.5f;
            cursorX = Tools.max(cursorX, 1.0f / (float)this.absolutePxWidth() + 0.5f);
            cursorX = (float)((double)cursorX * (adjustedScale / (double)this.absolutePxWidth()));
            selectorX = (float)((double)selectorX * (adjustedScale / (double)this.absolutePxWidth()));
            if (this.selectorPosition != -1 && cursorX != selectorX) {
                float min = Tools.min(cursorX, selectorX);
                float max = Tools.max(cursorX, selectorX);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                GlStateManager.func_187447_r((int)7);
                GlStateManager.func_187435_e((float)min, (float)0.0f, (float)0.0f);
                GlStateManager.func_187435_e((float)min, (float)1.0f, (float)0.0f);
                GlStateManager.func_187435_e((float)max, (float)1.0f, (float)0.0f);
                GlStateManager.func_187435_e((float)max, (float)0.0f, (float)0.0f);
                GlStateManager.func_187437_J();
            }
            if (this.active && (System.currentTimeMillis() - this.cursorTime) % 1000L < 500L) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_187447_r((int)1);
                GlStateManager.func_187435_e((float)cursorX, (float)0.0f, (float)0.0f);
                GlStateManager.func_187435_e((float)cursorX, (float)1.0f, (float)0.0f);
                GlStateManager.func_187437_J();
            }
        }
        this.drawChildren();
    }

    @Override
    public void setActive(boolean active) {
        if (active && !this.active) {
            this.cursorTime = System.currentTimeMillis();
        }
        super.setActive(active);
    }

    protected int findCursorPosition(double absX, double absY) {
        return this.findCursorPosition(absX, (int)((absY - this.absoluteY()) / this.absoluteHeight() * (double)this.fullLines.size()));
    }

    protected int findCursorPosition(double absX, int lineIndex) {
        String line;
        int result = 0;
        if (this instanceof GUIMultilineTextInput) {
            if (lineIndex >= this.lines.size()) {
                return this.text.length();
            }
            line = (String)this.lines.get(lineIndex);
            String fullLine = (String)this.fullLines.get(lineIndex);
            if (fullLine.length() > 0 && fullLine.charAt(0) == '\n') {
                ++result;
            }
            for (int i = 0; i < lineIndex; ++i) {
                result += ((String)this.fullLines.get(i)).length();
            }
        } else {
            line = this.text;
        }
        double xDif = absX - this.absoluteX();
        for (char c : line.toCharArray()) {
            double lastDif = xDif;
            if ((xDif -= (double)(this.parent instanceof CodeInput ? MonoASCIIFontRenderer.CHAR_WIDTH + 2 : GUIScreen.FONT_RENDERER.func_78263_a(c)) * this.scale / (double)this.screen.field_146294_l) <= 0.0) {
                if (!(Math.abs(xDif) < lastDif)) break;
                ++result;
                break;
            }
            ++result;
        }
        return result;
    }

    @Override
    public String toString() {
        return this.valid() ? this.filter.transformInput(this.text) : "(INVALID INPUT)";
    }

    private static /* synthetic */ Namespace lambda$setNamespace$0(String o) {
        return new Namespace();
    }
}

