/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.mctools.gui.element.textured;

import com.fantasticsource.mctools.gui.GUIScreen;
import com.fantasticsource.mctools.gui.element.GUIElement;
import com.fantasticsource.tools.datastructures.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public class GUIStretchedImage
extends GUIElement {
    protected ResourceLocation texture;
    protected double u;
    protected double v;
    protected double uw;
    protected double vh;
    protected Color color;
    protected boolean ignoreMCGUIScale = false;

    public GUIStretchedImage(GUIScreen screen, double width, double height, ResourceLocation texture) {
        this(screen, width, height, texture, Color.WHITE);
    }

    public GUIStretchedImage(GUIScreen screen, double width, double height, ResourceLocation texture, Color color) {
        this(screen, width, height, texture, color, 0.0, 0.0, 1.0, 1.0);
    }

    public GUIStretchedImage(GUIScreen screen, double width, double height, ResourceLocation texture, double u, double v, double uw, double vh) {
        this(screen, width, height, texture, Color.WHITE, u, v, uw, vh);
    }

    public GUIStretchedImage(GUIScreen screen, double width, double height, ResourceLocation texture, Color color, double u, double v, double uw, double vh) {
        super(screen, width, height);
        this.texture = texture;
        this.color = color;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
    }

    public GUIStretchedImage(GUIScreen screen, ResourceLocation texture) {
        this(screen, texture, Color.WHITE);
    }

    public GUIStretchedImage(GUIScreen screen, ResourceLocation texture, Color color) {
        this(screen, 0.0, 0.0, 1.0, 1.0, texture, color);
    }

    public GUIStretchedImage(GUIScreen screen, double x, double y, double width, double height, ResourceLocation texture) {
        this(screen, x, y, width, height, texture, Color.WHITE);
    }

    public GUIStretchedImage(GUIScreen screen, double x, double y, double width, double height, ResourceLocation texture, Color color) {
        this(screen, x, y, width, height, texture, color, 0.0, 0.0, 1.0, 1.0);
    }

    public GUIStretchedImage(GUIScreen screen, double x, double y, double width, double height, ResourceLocation texture, double u, double v, double uw, double vh) {
        this(screen, x, y, width, height, texture, Color.WHITE, u, v, uw, vh);
    }

    public GUIStretchedImage(GUIScreen screen, double x, double y, double width, double height, ResourceLocation texture, Color color, double u, double v, double uw, double vh) {
        super(screen, x, y, width, height);
        this.texture = texture;
        this.color = color;
        this.u = u;
        this.v = v;
        this.uw = uw;
        this.vh = vh;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color.copy();
    }

    @Override
    public void draw() {
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)this.color.rf(), (float)this.color.gf(), (float)this.color.bf(), (float)this.color.af());
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.texture);
        double u2 = this.u + this.uw;
        double v2 = this.v + this.vh;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder builder = tessellator.func_178180_c();
        builder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        builder.func_181662_b(1.0, 0.0, 0.0).func_187315_a(u2, this.v).func_181675_d();
        builder.func_181662_b(0.0, 0.0, 0.0).func_187315_a(this.u, this.v).func_181675_d();
        builder.func_181662_b(0.0, 1.0, 0.0).func_187315_a(this.u, v2).func_181675_d();
        builder.func_181662_b(1.0, 1.0, 0.0).func_187315_a(u2, v2).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawChildren();
    }
}

