/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.tools.component;

import com.fantasticsource.tools.component.Component;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CFloat
extends Component {
    public float value;

    public CFloat set(float value) {
        this.value = value;
        return this;
    }

    @Override
    public CFloat write(ByteBuf buf) {
        buf.writeFloat(this.value);
        return this;
    }

    @Override
    public CFloat read(ByteBuf buf) {
        this.value = buf.readFloat();
        return this;
    }

    @Override
    public CFloat save(OutputStream stream) {
        try {
            int i = Float.floatToRawIntBits(this.value);
            stream.write(new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i});
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public CFloat load(InputStream stream) {
        try {
            byte[] bytes = new byte[4];
            if (stream.read(bytes) < 4) {
                throw new IOException("Reached end of file while reading!");
            }
            this.value = Float.intBitsToFloat((bytes[0] & 0xFF) << 24 | (bytes[1] & 0xFF) << 16 | (bytes[2] & 0xFF) << 8 | bytes[3] & 0xFF);
            return this;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

