/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth;

import com.fantasticsource.dynamicstealth.Commands;
import com.fantasticsource.dynamicstealth.client.HUD;
import com.fantasticsource.dynamicstealth.client.RenderAlterer;
import com.fantasticsource.dynamicstealth.client.TooltipAlterer;
import com.fantasticsource.dynamicstealth.common.BlocksAndItems;
import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.common.Network;
import com.fantasticsource.dynamicstealth.common.potions.Potions;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatCNPC;
import com.fantasticsource.dynamicstealth.compat.CompatDissolution;
import com.fantasticsource.dynamicstealth.compat.CompatEBWizardry;
import com.fantasticsource.dynamicstealth.compat.CompatNeat;
import com.fantasticsource.dynamicstealth.compat.CompatRoughMobs;
import com.fantasticsource.dynamicstealth.config.ConfigHandler;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.Attributes;
import com.fantasticsource.dynamicstealth.server.CombatTracker;
import com.fantasticsource.dynamicstealth.server.EntityLookHelperEdit;
import com.fantasticsource.dynamicstealth.server.GlobalDefaultsAndData;
import com.fantasticsource.dynamicstealth.server.HUDData;
import com.fantasticsource.dynamicstealth.server.HelperSystem;
import com.fantasticsource.dynamicstealth.server.ai.AIDynamicStealth;
import com.fantasticsource.dynamicstealth.server.ai.EntityAIData;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIAttackMeleeEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIAttackRangedBowEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIAttackRangedEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIBearAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIBearAttackPlayerEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIBearHurtByTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AICreeperSwellEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIDefendVillageEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIEntityLookIdleEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIFindEntityNearestEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIFindEntityNearestPlayerEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIFireballAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIFollowOwnerEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIFollowOwnerFlyingEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIGuardianAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIHurtByTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIJohnnyAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AILlamaDefendEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AILlamaHurtByTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AINearestAttackableTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIOcelotAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIOwnerHurtByTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIOwnerHurtTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIParrotFollowEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIPigmanHurtByAggressorEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIPigmanTargetAggressorEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIShulkerAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIShulkerAttackNearestEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIShulkerDefenseAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AISlimeFaceRandomEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AISpiderAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AISpiderTargetEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AITargetNonTamedEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIVexChargeAttackEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIWanderAvoidWaterEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIWanderAvoidWaterFlyingEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIWanderEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIWatchClosestEdit;
import com.fantasticsource.dynamicstealth.server.ai.edited.AIZombieAttackEdit;
import com.fantasticsource.dynamicstealth.server.entitytracker.EntityTrackerEdit;
import com.fantasticsource.dynamicstealth.server.event.EventData;
import com.fantasticsource.dynamicstealth.server.event.attacks.AssassinationEvent;
import com.fantasticsource.dynamicstealth.server.event.attacks.AttackData;
import com.fantasticsource.dynamicstealth.server.event.attacks.StealthAttackEvent;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.dynamicstealth.server.senses.EntitySensesEdit;
import com.fantasticsource.dynamicstealth.server.senses.EntityTouchData;
import com.fantasticsource.dynamicstealth.server.senses.HidingData;
import com.fantasticsource.dynamicstealth.server.senses.hearing.Communication;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import java.io.File;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIAttackRangedBow;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIDefendVillage;
import net.minecraft.entity.ai.EntityAIFindEntityNearest;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOcelotAttack;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.ai.EntityAIZombieAttack;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.monster.EntityShulker;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.monster.EntityVindicator;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;

@Mod(modid="dynamicstealth", name="Dynamic Stealth", version="1.12.2.114", dependencies="required-after:fantasticlib@[1.12.2.044zo,)", acceptedMinecraftVersions="[1.12.2]")
public class DynamicStealth {
    public static final String MODID = "dynamicstealth";
    public static final String NAME = "Dynamic Stealth";
    public static final String VERSION = "1.12.2.114";
    public static final String CONFIG_VERSION = "1.12.2.095";
    public static final TrigLookupTable TRIG_TABLE = new TrigLookupTable(1024);
    private static EntityLivingBase victimThreatTarget = null;

    public DynamicStealth() {
        Attributes.init();
        MinecraftForge.EVENT_BUS.register(ServerTickTimer.class);
        MinecraftForge.EVENT_BUS.register(DynamicStealth.class);
        MinecraftForge.EVENT_BUS.register(Network.class);
        MinecraftForge.EVENT_BUS.register(Potions.class);
        MinecraftForge.EVENT_BUS.register(Compat.class);
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(HUD.class);
            MinecraftForge.EVENT_BUS.register(ClientData.class);
            MinecraftForge.EVENT_BUS.register(RenderAlterer.class);
        }
    }

    @SubscribeEvent
    public static void saveConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            ConfigManager.sync((String)MODID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void postConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            DynamicStealth.update();
        } else if (event.getModID().equals("neat")) {
            CompatNeat.config = new Configuration(new File(Loader.instance().getConfigDir(), "neat.cfg"));
            CompatNeat.heightAboveMob = CompatNeat.config.get("general", "Height Above Mob", 0.6).getDouble();
        }
    }

    public static void update() {
        PlayerList playerList;
        if (DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeMode != 3) {
            ClientData.prevStealthDisplayed = Tools.min((float[])new float[]{ClientData.prevStealthDisplayed, 100.0f});
            ClientData.prevStealthFrameIndex = Tools.min((int[])new int[]{ClientData.prevStealthFrameIndex, 49});
        }
        Compat.NAUGHTY.clear();
        Compat.NICE.clear();
        GlobalDefaultsAndData.update();
        AttackData.update();
        HUDData.update();
        EntityAIData.update();
        EntityTouchData.update();
        EntitySightData.update();
        EntityThreatData.update();
        EventData.update();
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && (playerList = server.func_184103_al()) != null) {
            for (EntityPlayerMP player : playerList.func_181057_v()) {
                Network.WRAPPER.sendTo((IMessage)new Network.ClientInitPacket(player), player);
            }
        }
    }

    @SubscribeEvent
    public static void despawn(LivingSpawnEvent.AllowDespawn event) {
        EntityLivingBase livingBase = event.getEntityLiving();
        Event.Result result = event.getResult();
        if (livingBase instanceof EntityLiving && result != Event.Result.DENY && result != Event.Result.DEFAULT) {
            Threat.remove(livingBase);
        }
    }

    @SubscribeEvent
    public static void chunkUnload(ChunkEvent.Unload event) {
        ClassInheritanceMultiMap[] sets;
        Chunk chunk = event.getChunk();
        for (ClassInheritanceMultiMap set : sets = chunk.func_177429_s()) {
            for (Entity entity : set) {
                if (!(entity instanceof EntityLiving)) continue;
                Threat.remove((EntityLivingBase)((EntityLiving)entity));
            }
        }
    }

    @SubscribeEvent
    public static void worldUnload(WorldEvent.Unload event) {
        for (Entity entity : event.getWorld().field_72996_f) {
            if (!(entity instanceof EntityLiving)) continue;
            Threat.remove((EntityLivingBase)((EntityLiving)entity));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void worldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world instanceof WorldServer && DynamicStealthConfig.serverSettings.senses.usePlayerSenses) {
            WorldServer worldServer = (WorldServer)world;
            worldServer.field_73062_L = new EntityTrackerEdit(worldServer);
        }
    }

    @SubscribeEvent
    public static void playerLogon(PlayerEvent.PlayerLoggedInEvent event) {
        HidingData.load(event.player);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void serverTickHighest(TickEvent.ServerTickEvent event) {
        Profiler profiler = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b;
        profiler.func_76320_a("DStealth - ServerTick");
        profiler.func_76320_a("CombatTracker.update()");
        CombatTracker.update(event);
        profiler.func_76318_c("Threat.update()");
        Threat.update(event);
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        Profiler profiler = FMLCommonHandler.instance().getMinecraftServerInstance().field_71304_b;
        profiler.func_76320_a("DStealth - ServerTick");
        profiler.func_76320_a("Sight.update()");
        Sight.update(event);
        profiler.func_76318_c("Communication.update()");
        Communication.update(event);
        profiler.func_76319_b();
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase livingBase = event.getEntityLiving();
        World world = livingBase.field_70170_p;
        if (!world.field_72995_K && livingBase.func_70089_S()) {
            int type;
            int n = livingBase instanceof EntityPlayerMP ? 1 : (type = livingBase instanceof EntityLiving ? 2 : 0);
            if (type != 0 && DynamicStealthConfig.serverSettings.senses.touch.touchEnabled && EntityTouchData.canFeelTouch((Entity)livingBase)) {
                block4: for (Entity felt : world.func_72839_b((Entity)livingBase, livingBase.func_174813_aQ())) {
                    int feltType = felt instanceof EntityPlayerMP ? 1 : (felt instanceof EntityLiving ? 2 : 0);
                    if (feltType == 0 || !felt.func_70089_S()) continue;
                    if (DynamicStealthConfig.serverSettings.senses.touch.touchReveals) {
                        if (type == 2 || !(livingBase instanceof FakePlayer)) {
                            livingBase.func_184589_d(MobEffects.field_76441_p);
                        }
                        if (feltType == 2 || !(felt instanceof FakePlayer)) {
                            ((EntityLivingBase)felt).func_184589_d(MobEffects.field_76441_p);
                        }
                    }
                    if (felt instanceof EntityBat || MCTools.isRidingOrRiddenBy((Entity)livingBase, (Entity)felt)) continue;
                    switch (type) {
                        case 1: {
                            break;
                        }
                        case 2: {
                            EntityLiving feelerLiving = (EntityLiving)livingBase;
                            EntityLivingBase target = feelerLiving.func_70638_az();
                            if (target != null && feelerLiving.field_70723_bA.func_75522_a((Entity)target)) break;
                            AIDynamicStealth ai = AIDynamicStealth.getStealthAI(feelerLiving);
                            if (ai != null) {
                                if (ai.isFleeing()) break;
                                DynamicStealth.makeLivingLookTowardEntity(feelerLiving, felt);
                                PathNavigate navigate = feelerLiving.func_70661_as();
                                if (navigate.func_75505_d() == ai.path) {
                                    navigate.func_75499_g();
                                }
                                if (ai.getMode() == 0) continue block4;
                                ai.restart(feelerLiving.func_180425_c());
                                break;
                            }
                            DynamicStealth.makeLivingLookTowardEntity(feelerLiving, felt);
                        }
                    }
                }
            }
            if (type == 2) {
                CombatTracker.pathReachesThreatTarget((EntityLiving)livingBase);
            }
        }
    }

    @SubscribeEvent
    public static void kamikazeDeath(ExplosionEvent event) {
        Explosion explosion = event.getExplosion();
        EntityLivingBase exploder = explosion.func_94613_c();
        if (exploder instanceof EntityCreeper) {
            exploder.func_70106_y();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityDeathPre(LivingDeathEvent event) {
        boolean isMelee;
        EntityLivingBase victim = event.getEntityLiving();
        DamageSource dmgSource = event.getSource();
        Entity source = dmgSource.func_76346_g();
        Entity immediate = dmgSource.func_76364_f();
        boolean bl = isMelee = source != null && source == immediate;
        if (source == null) {
            source = dmgSource.func_76364_f();
        }
        Threat.set(victim, null, 0.0f);
        if (source instanceof EntityLivingBase) {
            EntityLivingBase killer = (EntityLivingBase)source;
            boolean wasSeen = false;
            for (Entity entity : victim.field_70170_p.field_72996_f) {
                AIDynamicStealth stealthAI;
                void var11_11;
                EntityLivingBase witness;
                if (!(entity instanceof EntityLivingBase) || GlobalDefaultsAndData.isFullBypass((Entity)(witness = (EntityLivingBase)entity)) || !witness.func_70089_S()) continue;
                if (Threat.getTarget(witness) == victim) {
                    if (!Sight.canSee(witness, (Entity)victim, true)) continue;
                    if (MCTools.isOwned((Entity)witness)) {
                        Threat.set(witness, null, 0.0f);
                    } else {
                        Threat.clearTarget(witness);
                    }
                    Communication.notifyDead(witness, victim);
                    continue;
                }
                if (!HelperSystem.isAlly(witness, victim) || !Sight.canSee(witness, (Entity)victim, false)) continue;
                if (Sight.canSee(witness, source, true)) {
                    wasSeen = true;
                    BlockPos blockPos = killer.func_180425_c();
                } else {
                    BlockPos blockPos = victim.func_180425_c();
                }
                Threat.apply(witness, killer, DynamicStealthConfig.serverSettings.threat.allyKilledThreat, Threat.THREAT_TYPE.GEN_ALLY_KILLED, wasSeen);
                Communication.warn(witness, killer, (BlockPos)var11_11, wasSeen);
                if (!(witness instanceof EntityLiving) || (stealthAI = AIDynamicStealth.getStealthAI((EntityLiving)witness)) == null) continue;
                stealthAI.fleeIfYouShould(0.0f);
                if (!stealthAI.isFleeing()) continue;
                stealthAI.lastKnownPosition = var11_11;
            }
            if (!(wasSeen || EntityThreatData.isPassive((Entity)victim) || GlobalDefaultsAndData.isFullBypass((Entity)killer) || Sight.canSee(victim, source, true) || victimThreatTarget == source || CompatEBWizardry.mindControllerIs(victim, killer) || killer instanceof FakePlayer || MinecraftForge.EVENT_BUS.post((Event)new AssassinationEvent(killer, victim)))) {
                WeaponEntry weaponEntry = AttackData.getWeaponEntry(isMelee ? killer.func_184614_ca() : null, 2, false);
                for (PotionEffect potionEffect : weaponEntry.attackerEffects) {
                    killer.func_70690_d(new PotionEffect(potionEffect));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void entityDeathPost(LivingDropsEvent event) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)event.getEntityLiving())) {
            return;
        }
        event.getEntityLiving().func_70674_bp();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void entityAttackedPre(LivingHurtEvent event) {
        boolean isMelee;
        EntityLivingBase victim = event.getEntityLiving();
        victimThreatTarget = Threat.getTarget(victim);
        DamageSource dmgSource = event.getSource();
        Entity source = dmgSource.func_76346_g();
        Entity immediate = dmgSource.func_76364_f();
        boolean bl = isMelee = source != null && source == immediate;
        if (source == null) {
            source = immediate;
        }
        boolean isBlocked = AttackData.isBlocked(victim, dmgSource);
        if (source instanceof EntityLivingBase) {
            EntityLivingBase attacker = (EntityLivingBase)source;
            if (isMelee) {
                if (isBlocked) {
                    if (DynamicStealthConfig.serverSettings.interactions.attackBlocked.removeInvisibilityOnHit) {
                        if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                            attacker.func_184589_d(MobEffects.field_76441_p);
                        }
                        if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                            victim.func_184589_d(MobEffects.field_76441_p);
                        }
                    }
                    if (DynamicStealthConfig.serverSettings.interactions.attackBlocked.removeBlindnessOnHit) {
                        if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                            attacker.func_184589_d(MobEffects.field_76440_q);
                        }
                        if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                            victim.func_184589_d(MobEffects.field_76440_q);
                        }
                    }
                } else {
                    if (DynamicStealthConfig.serverSettings.interactions.attack.removeInvisibilityOnHit) {
                        if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                            attacker.func_184589_d(MobEffects.field_76441_p);
                        }
                        if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                            victim.func_184589_d(MobEffects.field_76441_p);
                        }
                    }
                    if (DynamicStealthConfig.serverSettings.interactions.attack.removeBlindnessOnHit) {
                        if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                            attacker.func_184589_d(MobEffects.field_76440_q);
                        }
                        if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                            victim.func_184589_d(MobEffects.field_76440_q);
                        }
                    }
                }
            } else if (isBlocked) {
                if (DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked.removeInvisibilityOnHit) {
                    if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                        attacker.func_184589_d(MobEffects.field_76441_p);
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        victim.func_184589_d(MobEffects.field_76441_p);
                    }
                }
                if (DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked.removeBlindnessOnHit) {
                    if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                        attacker.func_184589_d(MobEffects.field_76440_q);
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        victim.func_184589_d(MobEffects.field_76440_q);
                    }
                }
            } else {
                if (DynamicStealthConfig.serverSettings.interactions.rangedAttack.removeInvisibilityOnHit) {
                    if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                        attacker.func_184589_d(MobEffects.field_76441_p);
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        victim.func_184589_d(MobEffects.field_76441_p);
                    }
                }
                if (DynamicStealthConfig.serverSettings.interactions.rangedAttack.removeBlindnessOnHit) {
                    if (!(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                        attacker.func_184589_d(MobEffects.field_76440_q);
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        victim.func_184589_d(MobEffects.field_76440_q);
                    }
                }
            }
            if (isMelee && attacker.func_70089_S() && !(attacker instanceof FakePlayer) && !GlobalDefaultsAndData.isFullBypass((Entity)attacker)) {
                if (Sight.canSee(victim, (Entity)attacker, true)) {
                    ItemStack itemStack = attacker.func_184614_ca();
                    WeaponEntry weaponEntry = AttackData.getWeaponEntry(itemStack, 0, isBlocked);
                    if (weaponEntry.armorPenetration) {
                        dmgSource.func_76348_h();
                    }
                    event.setAmount((float)((double)event.getAmount() * weaponEntry.damageMultiplier));
                    for (PotionEffect potionEffect : weaponEntry.attackerEffects) {
                        attacker.func_70690_d(new PotionEffect(potionEffect));
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        for (PotionEffect potionEffect : weaponEntry.victimEffects) {
                            victim.func_70690_d(new PotionEffect(potionEffect));
                        }
                    }
                    if (!(!weaponEntry.consumeItem || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d || itemStack.func_77973_b().equals(Items.field_190931_a))) {
                        itemStack.func_190917_f(-1);
                    }
                } else if (!MinecraftForge.EVENT_BUS.post((Event)new StealthAttackEvent(victim, dmgSource, event.getAmount()))) {
                    ItemStack itemStack = attacker.func_184614_ca();
                    WeaponEntry weaponEntry = AttackData.getWeaponEntry(itemStack, 1, isBlocked);
                    if (weaponEntry.armorPenetration) {
                        dmgSource.func_76348_h();
                    }
                    event.setAmount((float)((double)event.getAmount() * weaponEntry.damageMultiplier));
                    for (PotionEffect potionEffect : weaponEntry.attackerEffects) {
                        attacker.func_70690_d(new PotionEffect(potionEffect));
                    }
                    if (!GlobalDefaultsAndData.isFullBypass((Entity)victim)) {
                        for (PotionEffect potionEffect : weaponEntry.victimEffects) {
                            victim.func_70690_d(new PotionEffect(potionEffect));
                        }
                    }
                    if (!(!weaponEntry.consumeItem || attacker instanceof EntityPlayer && ((EntityPlayer)attacker).field_71075_bZ.field_75098_d || itemStack.func_77973_b().equals(Items.field_190931_a))) {
                        itemStack.func_190917_f(-1);
                    }
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void entityAttackedPost(LivingHurtEvent event) {
        if (event.isCanceled() && event.getResult() == Event.Result.DENY) {
            return;
        }
        EntityLivingBase targetBase = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        Entity source = damageSource.func_76346_g();
        if (source == null) {
            source = damageSource.func_76364_f();
        }
        if (targetBase instanceof EntityLiving && !GlobalDefaultsAndData.isFullBypass((Entity)targetBase)) {
            EntityLiving victim = (EntityLiving)targetBase;
            if (source instanceof EntityLivingBase) {
                EntityLivingBase attacker = (EntityLivingBase)source;
                DynamicStealth.makeLivingLookTowardEntity(victim, (Entity)attacker);
                boolean canSee = Sight.canSee((EntityLivingBase)victim, (Entity)attacker, true, false, false);
                BlockPos perceivedPos = attacker.func_180425_c();
                if (!canSee) {
                    int distance = (int)victim.func_70032_d((Entity)attacker);
                    MCTools.randomPos((BlockPos)perceivedPos, (int)Tools.min((int[])new int[]{distance >> 1, 7}), (int)Tools.min((int[])new int[]{distance >> 2, 4}));
                }
                Communication.warn((EntityLivingBase)victim, attacker, perceivedPos, canSee);
                Communication.warn(attacker, (EntityLivingBase)victim, victim.func_180425_c(), true);
                AIDynamicStealth stealthAI = AIDynamicStealth.getStealthAI(victim);
                boolean hasAI = stealthAI != null;
                Threat.ThreatData threatData = Threat.get((EntityLivingBase)victim);
                EntityLivingBase threatTarget = threatData.target;
                if (hasAI && (stealthAI.isFleeing() || stealthAI.getMode() == -2)) {
                    if (DynamicStealthConfig.serverSettings.ai.flee.increaseOnDamage) {
                        Threat.apply((EntityLivingBase)victim, attacker, event.getAmount(), Threat.THREAT_TYPE.GEN_ATTACKED_DURING_FLEE, canSee, damageSource);
                    }
                    Compat.clearAttackTargetAndCancelBadTasks(victim);
                    stealthAI.restart(perceivedPos);
                } else {
                    Threat.apply((EntityLivingBase)victim, attacker, event.getAmount(), Threat.THREAT_TYPE.GEN_ATTACKED, canSee, damageSource);
                    if (threatTarget == null) {
                        Compat.clearAttackTargetAndCancelBadTasks(victim);
                    } else {
                        victim.func_70624_b(threatTarget);
                    }
                    if (hasAI) {
                        stealthAI.restart(perceivedPos);
                    }
                }
                if (hasAI) {
                    if (event.isCanceled()) {
                        stealthAI.fleeIfYouShould(0.0f);
                    } else {
                        stealthAI.fleeIfYouShould(-event.getAmount());
                    }
                }
            }
        }
        if (source instanceof EntityLiving) {
            EntityLiving livingSource = (EntityLiving)source;
            Threat.apply((EntityLivingBase)livingSource, targetBase, event.getAmount(), Threat.THREAT_TYPE.GEN_DAMAGE_DEALT, livingSource.field_70723_bA.func_75522_a((Entity)targetBase), damageSource);
        }
    }

    public static void makeLivingLookTowardEntity(EntityLiving living, Entity target) {
        float fYaw;
        if (GlobalDefaultsAndData.isFullBypass((Entity)living)) {
            return;
        }
        if (Compat.testdummy && living.getClass().getName().equals("boni.dummy.EntityDummy")) {
            return;
        }
        Vec3d pos1 = living.func_174791_d().func_178787_e(new Vec3d(0.0, (double)living.func_70047_e(), 0.0));
        Vec3d pos2 = target.func_174791_d().func_178787_e(new Vec3d(0.0, (double)target.field_70131_O * 0.5, 0.0));
        living.field_70177_z = fYaw = (float)MCTools.getYawDeg((Vec3d)pos1, (Vec3d)pos2, (TrigLookupTable)TRIG_TABLE);
        living.field_70759_as = fYaw;
        living.field_70125_A = (float)MCTools.getPitchDeg((Vec3d)pos1, (Vec3d)pos2, (TrigLookupTable)TRIG_TABLE);
        if (living instanceof EntitySlime) {
            living.field_70177_z = fYaw;
            for (EntityAITasks.EntityAITaskEntry task : ((EntitySlime)living).field_70714_bg.field_75782_a) {
                if (!(task.field_75733_a instanceof AISlimeFaceRandomEdit)) continue;
                ((AISlimeFaceRandomEdit)task.field_75733_a).setDirection(fYaw, true);
                break;
            }
        }
        living.field_70749_g.func_75651_a(target, 180.0f, 180.0f);
    }

    @SubscribeEvent
    public static void entityConstructing(EntityEvent.EntityConstructing event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase) {
            Attributes.addAttributes((EntityLivingBase)entity);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void entityJoin(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(!(entity instanceof EntityLiving) || GlobalDefaultsAndData.isFullBypass(entity) || Compat.customnpcs && NpcAPI.Instance().getIEntity(entity) instanceof ICustomNpc)) {
            DynamicStealth.livingJoinWorld((EntityLiving)entity);
        }
    }

    public static void livingJoinWorld(EntityLiving living) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)living)) {
            return;
        }
        try {
            living.field_70749_g = new EntityLookHelperEdit(living);
            if (!living.field_70170_p.field_72995_K) {
                living.field_70723_bA = new EntitySensesEdit(living);
                if (living instanceof AbstractSkeleton) {
                    AbstractSkeleton abstractSkeleton = (AbstractSkeleton)living;
                    abstractSkeleton.field_85037_d = new AIAttackRangedBowEdit(abstractSkeleton.field_85037_d);
                    abstractSkeleton.field_85038_e = new AIAttackMeleeEdit(abstractSkeleton.field_85038_e);
                }
                DynamicStealth.replaceTasks(living.field_70714_bg, living);
                DynamicStealth.replaceTasks(living.field_70715_bh, living);
                DynamicStealth.addTasks(living.field_70715_bh, living.field_70714_bg, living);
            } else {
                RenderAlterer.replaceLayers((EntityLivingBase)living);
            }
        }
        catch (Exception e) {
            MCTools.crash((Exception)e, (int)137, (boolean)false);
        }
    }

    private static void replaceTasks(EntityAITasks tasks, EntityLiving living) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)living)) {
            return;
        }
        Set taskSet = tasks.field_75782_a;
        EntityAITasks.EntityAITaskEntry[] taskArray = new EntityAITasks.EntityAITaskEntry[taskSet.size()];
        taskSet.toArray(taskArray);
        for (EntityAITasks.EntityAITaskEntry task : taskArray) {
            Class<?> actionClass = task.field_75733_a.getClass();
            String actionClassName = actionClass.getName();
            if (actionClass == EntityAILookIdle.class) {
                DynamicStealth.replaceTask(tasks, task, new AIEntityLookIdleEdit(living));
                continue;
            }
            if (actionClass == EntityAIWander.class) {
                AIWanderEdit wanderEdit = new AIWanderEdit((EntityCreature)living, (EntityAIWander)task.field_75733_a);
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)wanderEdit);
                if (!(living instanceof EntityGuardian)) continue;
                ((EntityGuardian)living).field_175481_bq = wanderEdit;
                continue;
            }
            if (actionClass == EntityAIWanderAvoidWater.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIWanderAvoidWaterEdit((EntityCreature)living, (EntityAIWanderAvoidWater)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIWanderAvoidWaterFlying.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIWanderAvoidWaterFlyingEdit((EntityCreature)living, (EntityAIWanderAvoidWaterFlying)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIWatchClosest.class) {
                DynamicStealth.replaceTask(tasks, task, new AIWatchClosestEdit((EntityAIWatchClosest)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIWatchClosest2.class) {
                DynamicStealth.replaceTask(tasks, task, new AIWatchClosestEdit((EntityAIWatchClosest)task.field_75733_a, true));
                continue;
            }
            if (actionClass == EntityAIAttackMelee.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIAttackMeleeEdit((EntityAIAttackMelee)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityRabbit.AIEvilAttack.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIAttackMeleeEdit((EntityAIAttackMelee)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityPolarBear.AIMeleeAttack.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIBearAttackEdit((EntityAIAttackMelee)task.field_75733_a));
                continue;
            }
            if (actionClass == EntitySpider.AISpiderAttack.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AISpiderAttackEdit((EntityAIAttackMelee)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIZombieAttack.class) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIZombieAttackEdit((EntityAIAttackMelee)((EntityAIZombieAttack)task.field_75733_a)));
                continue;
            }
            if (actionClass == EntityAINearestAttackableTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AINearestAttackableTargetEdit((EntityAINearestAttackableTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityPolarBear.AIAttackPlayer.class) {
                DynamicStealth.replaceTask(tasks, task, new AIBearAttackPlayerEdit((EntityAINearestAttackableTarget<EntityPlayer>)((EntityAINearestAttackableTarget)task.field_75733_a)));
                continue;
            }
            if (actionClass == EntitySpider.AISpiderTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AISpiderTargetEdit((EntityAINearestAttackableTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityLlama.AIDefendTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AILlamaDefendEdit((EntityAINearestAttackableTarget<EntityWolf>)((EntityAINearestAttackableTarget)task.field_75733_a)));
                continue;
            }
            if (actionClass == EntityVindicator.AIJohnnyAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIJohnnyAttackEdit((EntityAINearestAttackableTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityPigZombie.AITargetAggressor.class) {
                DynamicStealth.replaceTask(tasks, task, new AIPigmanTargetAggressorEdit((EntityAINearestAttackableTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityShulker.AIAttackNearest.class) {
                DynamicStealth.replaceTask(tasks, task, new AIShulkerAttackNearestEdit((EntityAINearestAttackableTarget<EntityPlayer>)((EntityAINearestAttackableTarget)task.field_75733_a)));
                continue;
            }
            if (actionClass == EntityShulker.AIDefenseAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIShulkerDefenseAttackEdit((EntityAINearestAttackableTarget<EntityLivingBase>)((EntityAINearestAttackableTarget)task.field_75733_a)));
                continue;
            }
            if (actionClass == EntityAIHurtByTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AIHurtByTargetEdit((EntityAIHurtByTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityPigZombie.AIHurtByAggressor.class) {
                DynamicStealth.replaceTask(tasks, task, new AIPigmanHurtByAggressorEdit((EntityAIHurtByTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityLlama.AIHurtByTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AILlamaHurtByTargetEdit((EntityAIHurtByTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityPolarBear.AIHurtByTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AIBearHurtByTargetEdit((EntityAIHurtByTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIAttackRanged.class) {
                DynamicStealth.replaceTask(tasks, task, new AIAttackRangedEdit((EntityAIAttackRanged)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIAttackRangedBow.class) {
                DynamicStealth.replaceTask(tasks, task, new AIAttackRangedBowEdit((EntityAIAttackRangedBow)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIFindEntityNearestPlayer.class) {
                DynamicStealth.replaceTask(tasks, task, new AIFindEntityNearestPlayerEdit((EntityAIFindEntityNearestPlayer)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIFindEntityNearest.class) {
                DynamicStealth.replaceTask(tasks, task, new AIFindEntityNearestEdit((EntityAIFindEntityNearest)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAITargetNonTamed.class) {
                DynamicStealth.replaceTask(tasks, task, new AITargetNonTamedEdit((EntityAITargetNonTamed)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIFollow.class) {
                DynamicStealth.replaceTask(tasks, task, new AIParrotFollowEdit((EntityAIFollow)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIDefendVillage.class) {
                DynamicStealth.replaceTask(tasks, task, new AIDefendVillageEdit((EntityAIDefendVillage)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIOwnerHurtByTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AIOwnerHurtByTargetEdit((EntityAIOwnerHurtByTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIOwnerHurtTarget.class) {
                DynamicStealth.replaceTask(tasks, task, new AIOwnerHurtTargetEdit((EntityAIOwnerHurtTarget)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAICreeperSwell.class) {
                DynamicStealth.replaceTask(tasks, task, new AICreeperSwellEdit((EntityCreeper)living));
                continue;
            }
            if (actionClass == EntitySlime.AISlimeFaceRandom.class) {
                DynamicStealth.replaceTask(tasks, task, new AISlimeFaceRandomEdit((EntitySlime)living));
                continue;
            }
            if (actionClass == EntityAIOcelotAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIOcelotAttackEdit(living));
                continue;
            }
            if (actionClass == EntityGuardian.AIGuardianAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIGuardianAttackEdit((EntityGuardian)living));
                continue;
            }
            if (actionClass == EntityBlaze.AIFireballAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIFireballAttackEdit((EntityBlaze)living));
                continue;
            }
            if (actionClass == EntityVex.AIChargeAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIVexChargeAttackEdit((EntityVex)living));
                continue;
            }
            if (actionClass == EntityShulker.AIAttack.class) {
                DynamicStealth.replaceTask(tasks, task, new AIShulkerAttackEdit((EntityShulker)living));
                continue;
            }
            if (actionClass == EntityAIFollowOwner.class) {
                DynamicStealth.replaceTask(tasks, task, new AIFollowOwnerEdit((EntityTameable)living, (EntityAIFollowOwner)task.field_75733_a));
                continue;
            }
            if (actionClass == EntityAIFollowOwnerFlying.class) {
                DynamicStealth.replaceTask(tasks, task, new AIFollowOwnerFlyingEdit((EntityTameable)living, (EntityAIFollowOwner)task.field_75733_a));
                continue;
            }
            if (actionClassName.equals("net.minecraft.entity.monster.AbstractSkeleton$1")) {
                DynamicStealth.replaceTask(tasks, task, (EntityAIBase)new AIAttackMeleeEdit((EntityAIAttackMelee)task.field_75733_a));
                continue;
            }
            if (actionClassName.equals("com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest")) {
                DynamicStealth.replaceTask(tasks, task, new AIWatchClosestEdit(living, EntityLivingBase.class, 0.02f));
                continue;
            }
            if (actionClassName.equals("com.lycanitesmobs.core.entity.ai.EntityAILookIdle")) {
                DynamicStealth.replaceTask(tasks, task, new AIEntityLookIdleEdit(living));
                continue;
            }
            if (actionClassName.contains("de.lellson.roughmobs") && actionClassName.contains("RoughAIWeaponSwitch")) {
                DynamicStealth.replaceTask(tasks, task, new CompatRoughMobs.RoughAIWeaponSwitchEdit(living, 12.0));
                continue;
            }
            if (!Compat.customnpcs) continue;
            if (actionClassName.equals("noppes.npcs.ai.target.EntityAIClearTarget")) {
                tasks.func_85156_a(task.field_75733_a);
                continue;
            }
            if (!actionClassName.equals("noppes.npcs.ai.EntityAIWatchClosest")) continue;
            DynamicStealth.replaceTask(tasks, task, new AIWatchClosestEdit(living, (Class)ReflectionTool.get((Class)ReflectionTool.getClassByName((String)"noppes.npcs.ai.EntityAIWatchClosest"), (String)"watchedClass", (Object)task.field_75733_a), 0.002f));
        }
    }

    private static void replaceTask(EntityAITasks tasks, EntityAITasks.EntityAITaskEntry oldTask, EntityAIBase newTask) {
        tasks.func_75776_a(oldTask.field_75731_b, newTask);
        tasks.func_85156_a(oldTask.field_75733_a);
    }

    private static void addTasks(EntityAITasks targetTasks, EntityAITasks tasks, EntityLiving living) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)living)) {
            return;
        }
        if (!EntityThreatData.bypassesThreat((Entity)living)) {
            tasks.func_75776_a(-7777777, (EntityAIBase)AIDynamicStealth.getInstance(living));
        }
    }

    @Mod.EventHandler
    public static void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new Commands());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws Exception {
        ConfigHandler.update();
        MinecraftForge.EVENT_BUS.register(BlocksAndItems.class);
        Network.init();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            // empty if block
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        BlocksAndItems.registerRecipes(event);
        if (Loader.isModLoaded((String)"neat")) {
            Compat.neat = true;
        }
        if (Loader.isModLoaded((String)"testdummy")) {
            Compat.testdummy = true;
        }
        if (Loader.isModLoaded((String)"statues")) {
            Compat.statues = true;
        }
        if (Loader.isModLoaded((String)"iceandfire")) {
            Compat.iceandfire = true;
        }
        if (Loader.isModLoaded((String)"conarm")) {
            Compat.conarm = true;
        }
        if (Loader.isModLoaded((String)"dissolution")) {
            Compat.dissolution = true;
            MinecraftForge.EVENT_BUS.register(CompatDissolution.class);
        }
        if (Loader.isModLoaded((String)"customnpcs")) {
            Compat.customnpcs = true;
            MinecraftForge.EVENT_BUS.register(CompatCNPC.class);
        }
        if (Loader.isModLoaded((String)"bibliocraft")) {
            try {
                Compat.bibliocraftArmorStandEntity = Class.forName("jds.bibliocraft.entity.AbtractSteve");
            }
            catch (ClassNotFoundException e) {
                System.err.println(TextFormatting.RED + "Bibliocraft is loaded, but could not find jds.bibliocraft.entity.AbtractSteve");
            }
        }
        CompatEBWizardry.mindTrickPotion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation("ebwizardry", "mind_trick"));
        CompatEBWizardry.mindControlPotion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation("ebwizardry", "mind_control"));
        DynamicStealth.update();
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register(TooltipAlterer.class);
        }
    }

    static {
        ConfigHandler.init();
    }
}

