/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.client;

import com.fantasticsource.dynamicstealth.DynamicStealth;
import com.fantasticsource.dynamicstealth.client.event.RenderLightGaugeEvent;
import com.fantasticsource.dynamicstealth.client.event.RenderOPHUDEvent;
import com.fantasticsource.dynamicstealth.client.event.RenderStealthGaugeEvent;
import com.fantasticsource.dynamicstealth.client.event.RenderTargetingHUDEvent;
import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatNeat;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.mctools.ClientTickTimer;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.OutlinedFontRenderer;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.tools.ReflectionTool;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.datastructures.Color;
import com.fantasticsource.tools.datastructures.Pair;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class HUD {
    private static final ResourceLocation BASIC_GAUGE_TEXTURE = new ResourceLocation("dynamicstealth", "image/basicgauge.png");
    private static final int BASIC_GAUGE_SIZE = 32;
    private static final double BASIC_GAUGE_UV_HALF_PIXEL = 0.015625;
    private static final double BASIC_GAUGE_UV_SUBTEX_SIZE = 0.46875;
    private static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("dynamicstealth", "image/arrow.png");
    private static final float ARROW_WIDTH = 152.0f;
    private static final float ARROW_HEIGHT = 87.0f;
    private static final float ARROW_UV_HALF_PIXEL_W = 0.0032894737f;
    private static final float ARROW_UV_HALF_PIXEL_H = 0.0057471264f;
    private static final float ARROW_ORIGIN_X = 151.0f;
    private static final float ARROW_ORIGIN_Y = 43.0f;
    private static final float ARROW_LEFT = 151.0f;
    private static final float ARROW_RIGHT = 1.0f;
    private static final float ARROW_ABOVE = 43.0f;
    private static final float ARROW_BELOW = 44.0f;
    private static final float ARROW_CENTER_ORIGIN_X = 45.0f;
    private static final float ARROW_CENTER_LEFT = 45.0f;
    private static final float ARROW_CENTER_RIGHT = 107.0f;
    private static final ResourceLocation STEALTH_GAUGE_TEXTURE = new ResourceLocation("dynamicstealth", "image/stealthgauge.png");
    private static final int STEALTH_GAUGE_SIZE = 128;
    private static final float STEALTH_GAUGE_UV_HALF_PIXEL = 0.00390625f;
    private static final ResourceLocation STEALTH_GAUGE_TEXTURE_2 = new ResourceLocation("dynamicstealth", "image/stealthgauge2.png");
    private static final float STEALTH_GAUGE_2_UV_HALF_PIXEL_W = 3.90625E-4f;
    private static final float STEALTH_GAUGE_2_UV_HALF_PIXEL_H = 7.8125E-4f;
    private static final float STEALTH_GAUGE_2_UV_W = 0.1f;
    private static final float STEALTH_GAUGE_2_UV_H = 0.2f;
    private static final ResourceLocation STEALTH_GAUGE_TEXTURE_3 = new ResourceLocation("dynamicstealth", "image/stealthgauge3.png");
    private static final float STEALTH_GAUGE_3_UV_HALF_PIXEL_W = 3.90625E-4f;
    private static final float STEALTH_GAUGE_3_UV_HALF_PIXEL_H = 5.5803574E-4f;
    private static final float STEALTH_GAUGE_3_UV_W = 0.1f;
    private static final float STEALTH_GAUGE_3_UV_H = 0.14285715f;
    private static final ResourceLocation STEALTH_GAUGE_RIM_TEXTURE = new ResourceLocation("dynamicstealth", "image/stealthgaugerim.png");
    private static final int STEALTH_GAUGE_RIM_SIZE = 256;
    private static final float STEALTH_GAUGE_RIM_UV_HALF_PIXEL = 0.001953125f;
    private static final ResourceLocation CRYSTAL_TEXTURE = new ResourceLocation("dynamicstealth", "image/crystal.png");
    private static final float CRYSTAL_WIDTH = 63.0f;
    private static final float CRYSTAL_HEIGHT = 25.0f;
    private static final float CRYSTAL_UV_HALF_PIXEL_W = 0.007936508f;
    private static final float CRYSTAL_UV_HALF_PIXEL_H = 0.02f;
    private static final float CRYSTAL_ORIGIN_X = 0.0f;
    private static final float CRYSTAL_ORIGIN_Y = 12.0f;
    private static final float CRYSTAL_LEFT = 0.0f;
    private static final float CRYSTAL_RIGHT = 63.0f;
    private static final float CRYSTAL_ABOVE = 12.0f;
    private static final float CRYSTAL_BELOW = 13.0f;
    private static final ResourceLocation HP_BACKGROUND_TEXTURE = new ResourceLocation("dynamicstealth", "image/hpbackground.png");
    private static final float HP_BACKGROUND_WIDTH = 142.0f;
    private static final float HP_BACKGROUND_HEIGHT = 18.0f;
    private static final ResourceLocation HP_FILL_TEXTURE = new ResourceLocation("dynamicstealth", "image/hpfill.png");
    private static final float HP_FILL_WIDTH = 140.0f;
    private static final float HP_FILL_HEIGHT = 16.0f;
    private static final DecimalFormat ONE_DECIMAL = new DecimalFormat("0.0");
    private static final DecimalFormat NO_DECIMAL = new DecimalFormat("0");
    private static TextureManager textureManager = Minecraft.func_71410_x().field_71446_o;
    private static float prevPartialTickExtended = 0.0f;
    private static final Class OPTIFINE_SHADERS_CLASS = ReflectionTool.getClassByName((String)"net.optifine.shaders.Shaders");
    private static final Field SHADERS_CONFIG_RENDER_RES_MUL_FIELD = OPTIFINE_SHADERS_CLASS == null ? null : ReflectionTool.getField((Class)OPTIFINE_SHADERS_CLASS, (String[])new String[]{"configRenderResMul"});

    public static void draw(RenderGameOverlayEvent.Pre event, Minecraft mc) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179132_a((boolean)false);
        HUD.drawHUD(event, mc);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179126_j();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientData.targetData = null;
            ClientData.targetPriority = 2.147483647E9;
            for (ClientData.OnPointData data : ClientData.opMap.values()) {
                HUD.makeTargetIfBetter(data);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void drawHUD(Render.RenderHUDEvent event) {
        HUD.draw(event.getParentEvent(), Minecraft.func_71410_x());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void replaceCursor(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS || DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeMode != 3) {
            return;
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderStealthGaugeEvent(event))) {
            HUD.drawStealthGauge(Minecraft.func_71410_x(), 3, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void entityRender(RenderLivingEvent.Post event) {
        if (!event.getRenderer().func_177068_d().field_178639_r) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            EntityLivingBase livingBase = event.getEntity();
            if (livingBase != null && !MCTools.isRidingOrRiddenBy((Entity)Minecraft.func_71410_x().field_71439_g, (Entity)livingBase)) {
                int id = livingBase.func_145782_y();
                ClientData.OnPointData data = ClientData.opMap.get(id);
                if (data == null && ClientData.targetData != null && ClientData.targetData.searcherID == id) {
                    data = ClientData.targetData;
                }
                if (data != null && HUD.onPointFilter(data.color)) {
                    HUD.drawOPHUD(event, livingBase, data);
                }
            }
        }
    }

    private static boolean onPointFilter(int color) {
        if (color == 0x555555) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.bypass;
        }
        if (color == 52224) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.idlePassive;
        }
        if (color == 0x4444FF) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.idleNonPassive;
        }
        if (color == 0xFF8800) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.alert;
        }
        if (color == 0xFF0000) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.attackingYou;
        }
        if (color == 0xFFFF00) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.attackingOther;
        }
        if (color == 0xFF55FF) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.fleeingNonPassive;
        }
        if (color == 0xAA00AA) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.fleeingPassive;
        }
        if (color == 0x55FF55) {
            return DynamicStealthConfig.clientSettings.hudSettings.ophudFilter.dazed;
        }
        return false;
    }

    private static void drawOPHUD(RenderLivingEvent.Post event, EntityLivingBase livingBase, ClientData.OnPointData data) {
        RenderManager renderManager = event.getRenderer().func_177068_d();
        double x = event.getX();
        double y = event.getY();
        double z = event.getZ();
        float viewerYaw = renderManager.field_78735_i;
        float viewerPitch = renderManager.field_78732_j;
        int color = data.color;
        Color c = new Color(color, true);
        int r = c.r();
        int g = c.g();
        int b = c.b();
        boolean depth = DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.depth;
        double scale = DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.scale * 0.025;
        double halfSize2D = 8.0;
        double hOff2D = DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.horizontalOffset2D;
        double vOff2D = Compat.neat ? DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalOffset2D - 11.0 : DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalOffset2D - 22.0;
        GlStateManager.func_179140_f();
        if (depth) {
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
        } else {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179098_w();
        textureManager.func_110577_a(BASIC_GAUGE_TEXTURE);
        MinecraftForge.EVENT_BUS.post((Event)new RenderOPHUDEvent.Untransformed(event, data));
        GlStateManager.func_179094_E();
        if (Compat.neat) {
            GlStateManager.func_179137_b((double)x, (double)(y + (double)livingBase.field_70131_O * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalPercent + DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalOffset - 0.5 + CompatNeat.heightAboveMob), (double)z);
            GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(renderManager.field_78733_k.field_74320_O == 2 ? -viewerPitch : viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)livingBase.field_70130_N * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.horizontalPercent), (double)0.0, (double)0.0);
            GlStateManager.func_179139_a((double)(-scale), (double)(-scale), (double)scale);
        } else if (Compat.customnpcs && livingBase.getClass().getName().equals("noppes.npcs.entity.EntityCustomNpc")) {
            double cnpcScale = (double)livingBase.field_70131_O / 1.8;
            GlStateManager.func_179137_b((double)x, (double)(y + (double)livingBase.field_70131_O * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalPercent + DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalOffset - 0.5 - 0.108 * cnpcScale), (double)z);
            GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(renderManager.field_78733_k.field_74320_O == 2 ? -viewerPitch : viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)livingBase.field_70130_N * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.horizontalPercent), (double)0.0, (double)0.0);
            GlStateManager.func_179139_a((double)(-(scale *= cnpcScale)), (double)(-scale), (double)scale);
            vOff2D -= 56.0;
        } else {
            GlStateManager.func_179137_b((double)x, (double)(y + (double)livingBase.field_70131_O * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalPercent - (DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.accountForSneak && livingBase.func_70093_af() ? 0.25 : 0.0) + DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.verticalOffset), (double)z);
            GlStateManager.func_179114_b((float)(-viewerYaw), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(renderManager.field_78733_k.field_74320_O == 2 ? -viewerPitch : viewerPitch), (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)((double)livingBase.field_70130_N * DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.horizontalPercent), (double)0.0, (double)0.0);
            GlStateManager.func_179139_a((double)(-scale), (double)(-scale), (double)scale);
        }
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderOPHUDEvent.Transformed(event, data))) {
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181711_k);
            double left = -halfSize2D + hOff2D;
            double right = halfSize2D + hOff2D;
            double top = -halfSize2D + vOff2D;
            double bottom = halfSize2D + vOff2D;
            if (!ClientData.canHaveThreat(color)) {
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.015625, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.015625, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(0.484375, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(0.484375, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
            } else {
                double amount = (double)data.percent / 100.0;
                double level = bottom - halfSize2D * 2.0 * amount;
                double uvLevel = 0.484375 - 0.46875 * amount;
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.015625, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, level, 0.0).func_187315_a(0.015625, uvLevel).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, level, 0.0).func_187315_a(0.484375, uvLevel).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(0.484375, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, level, 0.0).func_187315_a(0.015625, uvLevel).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.015625, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(0.484375, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, level, 0.0).func_187315_a(0.484375, uvLevel).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
            }
            if (color == 0xFF0000 || color == 0xFF8800 || color == 0x555555) {
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.015625, 0.515625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.015625, 0.984375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(0.484375, 0.984375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(0.484375, 0.515625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
            } else {
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.515625, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.515625, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(0.984375, 0.484375).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(0.984375, 0.015625).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
            }
            tessellator.func_78381_a();
            if (!Compat.neat && DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.hpGauge) {
                Color color2;
                top = bottom + 4.0;
                bottom = top + 18.0;
                right = 71.0;
                left = -right;
                GlStateManager.func_179132_a((boolean)false);
                textureManager.func_110577_a(HP_BACKGROUND_TEXTURE);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.0, 1.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(1.0, 1.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(1.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(255, 255, 255, 255).func_181675_d();
                tessellator.func_78381_a();
                double ratio = Tools.min((float[])new float[]{Tools.max((float[])new float[]{livingBase.func_110143_aJ() / livingBase.func_110138_aP(), 0.0f}), 1.0f});
                if (livingBase.func_190530_aW()) {
                    color2 = Color.PURPLE.copy().setVF(0.7f);
                } else {
                    g = (int)(255.0 * ratio);
                    r = 255 - g;
                    b = 0;
                    color2 = new Color(r, g, b).setVF((float)(0.3 + 0.5 * (0.5 - Math.abs(0.5 - ratio))));
                }
                r = color2.r();
                g = color2.g();
                b = color2.b();
                double halfWDif = -1.0;
                double halfHDif = -1.0;
                double left2 = left - halfWDif;
                double right2 = right + halfWDif;
                double top2 = top - halfHDif;
                double bottom2 = bottom + halfHDif;
                double separation = left2 + (right2 - left2) * ratio;
                textureManager.func_110577_a(HP_FILL_TEXTURE);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181711_k);
                bufferbuilder.func_181662_b(left2, top2, 0.0).func_187315_a(0.0, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(left2, bottom2, 0.0).func_187315_a(0.0, 1.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(separation, bottom2, 0.0).func_187315_a(ratio, 1.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                bufferbuilder.func_181662_b(separation, top2, 0.0).func_187315_a(ratio, 0.0).func_187314_a(0xF000F0, 0xF000F0).func_181669_b(r, g, b, 255).func_181675_d();
                tessellator.func_78381_a();
                if (DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.hpGaugePercent || DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.hpGaugeCurrentAndMax) {
                    String text;
                    float spacing = (float)((bottom - top) / 2.0 - (double)(OutlinedFontRenderer.LINE_HEIGHT / 2) + 0.5);
                    if (DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.hpGaugeCurrentAndMax) {
                        text = ONE_DECIMAL.format(livingBase.func_110143_aJ());
                        OutlinedFontRenderer.draw((String)text, (float)((float)(left + 3.0 + (double)spacing)), (float)((float)(top + (double)spacing)), (Color)Color.WHITE, (Color)Color.BLACK);
                        text = ONE_DECIMAL.format(livingBase.func_110138_aP());
                        OutlinedFontRenderer.draw((String)text, (float)((float)(right - 3.0 - (double)spacing - (double)OutlinedFontRenderer.getStringWidth((String)text))), (float)((float)(top + (double)spacing)), (Color)Color.WHITE, (Color)Color.BLACK);
                    }
                    if (DynamicStealthConfig.clientSettings.hudSettings.ophudStyle.hpGaugePercent) {
                        text = NO_DECIMAL.format(100.0f * livingBase.func_110143_aJ() / livingBase.func_110138_aP()) + "%";
                        OutlinedFontRenderer.draw((String)text, (float)((float)(left + (right - left) / 2.0 - (double)OutlinedFontRenderer.getStringWidth((String)text)) / 2.0f), (float)((float)(top + (double)spacing)), (Color)Color.WHITE, (Color)Color.BLACK);
                    }
                }
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                textureManager.func_110577_a(HP_BACKGROUND_TEXTURE);
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                bufferbuilder.func_181662_b(left, top, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
                bufferbuilder.func_181662_b(left, bottom, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
                bufferbuilder.func_181662_b(right, bottom, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
                bufferbuilder.func_181662_b(right, top, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            }
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179084_k();
        if (!depth) {
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179145_e();
    }

    private static void makeTargetIfBetter(ClientData.OnPointData data) {
        int color = data.color;
        if (color == 0x555555 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.bypass) {
            return;
        }
        if (color == 52224 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.idlePassive) {
            return;
        }
        if (color == 0x4444FF && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.idleNonPassive) {
            return;
        }
        if (color == 0xFF8800 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.alert) {
            return;
        }
        if (color == 0xFF0000 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.attackingYou) {
            return;
        }
        if (color == 0xFFFF00 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.attackingOther) {
            return;
        }
        if (color == 0xFF55FF && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.fleeingNonPassive) {
            return;
        }
        if (color == 0xAA00AA && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.fleeingPassive) {
            return;
        }
        if (color == 0x55FF55 && !DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.dazed) {
            return;
        }
        int maxDist = DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.maxDist;
        int maxAngle = DynamicStealthConfig.clientSettings.hudSettings.targetingFilter.maxAngle;
        if (maxDist <= 0 || maxAngle < 0) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        World world = player.field_70170_p;
        if (world == null) {
            return;
        }
        Entity entity = world.func_73045_a(data.searcherID);
        if (entity == null) {
            return;
        }
        double distSquared = player.func_70068_e(entity);
        if (distSquared > Math.pow(maxDist, 2.0)) {
            return;
        }
        double angleDif = Vec3d.func_189986_a((float)player.field_70125_A, (float)player.field_70759_as).func_72432_b().func_72430_b(new Vec3d(entity.field_70165_t - player.field_70165_t, entity.field_70163_u + (double)entity.field_70131_O * 0.5 - (player.field_70163_u + (double)player.eyeHeight), entity.field_70161_v - player.field_70161_v).func_72432_b());
        if (angleDif < -1.0) {
            angleDif = -1.0;
        } else if (angleDif > 1.0) {
            angleDif = 1.0;
        }
        angleDif = Tools.radtodeg((double)DynamicStealth.TRIG_TABLE.arccos(angleDif));
        if (angleDif > (double)maxAngle) {
            return;
        }
        double priority = Math.pow(angleDif, 4.0) * distSquared;
        if (priority < ClientData.targetPriority) {
            ClientData.targetData = data;
            ClientData.targetPriority = priority;
        }
    }

    private static void drawArrow(float x, float y, float angleDeg, float scale) {
        HUD.drawArrow(x, y, angleDeg, scale, false);
    }

    private static void drawArrow(float x, float y, float angleDeg, float scale, boolean fromCenter) {
        float r;
        float l;
        GlStateManager.func_179098_w();
        textureManager.func_110577_a(ARROW_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)angleDeg, (float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        if (fromCenter) {
            l = -45.0f;
            r = 107.0f;
        } else {
            l = -151.0f;
            r = 1.0f;
        }
        GlStateManager.func_187447_r((int)7);
        GlStateManager.func_187426_b((float)0.0032894737f, (float)0.0057471264f);
        GlStateManager.func_187435_e((float)l, (float)-43.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.0032894737f, (float)0.99425286f);
        GlStateManager.func_187435_e((float)l, (float)44.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.99671054f, (float)0.99425286f);
        GlStateManager.func_187435_e((float)r, (float)44.0f, (float)0.0f);
        GlStateManager.func_187426_b((float)0.99671054f, (float)0.0057471264f);
        GlStateManager.func_187435_e((float)r, (float)-43.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179121_F();
    }

    private static void drawCrystals(float x, float y, float scale, float ... anglesDeg) {
        textureManager.func_110577_a(CRYSTAL_TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        for (float angleDeg : anglesDeg) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)angleDeg, (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187426_b((float)0.007936508f, (float)0.02f);
            GlStateManager.func_187435_e((float)-0.0f, (float)-12.0f, (float)0.0f);
            GlStateManager.func_187426_b((float)0.007936508f, (float)0.98f);
            GlStateManager.func_187435_e((float)-0.0f, (float)13.0f, (float)0.0f);
            GlStateManager.func_187426_b((float)0.99206346f, (float)0.98f);
            GlStateManager.func_187435_e((float)63.0f, (float)13.0f, (float)0.0f);
            GlStateManager.func_187426_b((float)0.99206346f, (float)0.02f);
            GlStateManager.func_187435_e((float)63.0f, (float)-12.0f, (float)0.0f);
            GlStateManager.func_187437_J();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private static void drawReticle(float x, float y) {
        int spacing = DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.reticleSpacing;
        float scale = (float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.reticleSize / Tools.max((float[])new float[]{152.0f, 87.0f});
        HUD.drawArrow(x - (float)spacing, y + (float)spacing, 45.0f, scale);
        HUD.drawArrow(x + (float)spacing, y + (float)spacing, 135.0f, scale);
        HUD.drawArrow(x - (float)spacing, y - (float)spacing, -45.0f, scale);
        HUD.drawArrow(x + (float)spacing, y - (float)spacing, -135.0f, scale);
    }

    private static void drawLightGauge(Minecraft mc) {
        int i;
        if (!DynamicStealthConfig.clientSettings.hudSettings.lightGauge.showLightGauge) {
            return;
        }
        float alpha = (float)DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeAlpha;
        if (alpha <= 0.0f) {
            return;
        }
        float scale = (float)(DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeSize >> 1) / Tools.max((float[])new float[]{63.0f, 25.0f});
        float maxOffset = Tools.max((float[])new float[]{0.0f, 63.0f, 12.0f, 13.0f});
        ScaledResolution sr = new ScaledResolution(mc);
        double x = (double)(maxOffset * scale) + (double)((float)sr.func_78326_a() - maxOffset * 2.0f * scale) * DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeX;
        double y = (double)(maxOffset * scale) + (double)((float)sr.func_78328_b() - maxOffset * 2.0f * scale) * DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeY;
        int light = ClientData.lightLevel;
        Color c = new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeColorFull, 16), true);
        GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)alpha);
        int iLight = light * 24;
        for (i = 0; i < iLight; i += 24) {
            HUD.drawCrystals((float)x, (float)y, scale, i + 90);
        }
        c = new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.lightGauge.lightGaugeColorEmpty, 16), true);
        GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)alpha);
        while (i < 360) {
            HUD.drawCrystals((float)x, (float)y, scale, i + 90);
            i += 24;
        }
    }

    private static void drawStealthGauge(Minecraft mc, int mode, RenderGameOverlayEvent.Pre event) {
        if (mode == 0) {
            return;
        }
        float alpha = (float)DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeAlpha;
        if (alpha <= 0.0f) {
            return;
        }
        if (ClientData.stealthLevel == -128) {
            return;
        }
        float partialTick = mc.func_184121_ak();
        float partialTickExtended = (float)ClientTickTimer.currentTick() + partialTick;
        float partialTickDelta = partialTickExtended - prevPartialTickExtended;
        prevPartialTickExtended = partialTickExtended;
        GlStateManager.func_179094_E();
        ScaledResolution sr = new ScaledResolution(mc);
        int halfSize = DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeSize / 2;
        double x = (double)halfSize + (double)(sr.func_78326_a() - halfSize * 2) * DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeX;
        double y = (double)halfSize + (double)(sr.func_78328_b() - halfSize * 2) * DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeY;
        GlStateManager.func_179137_b((double)x, (double)y, (double)0.0);
        Color c = new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeColor, 16), true);
        if (mode == 1) {
            float stealth = partialTick * (float)(ClientData.stealthLevel - ClientData.prevStealthLevel) + (float)ClientData.prevStealthLevel;
            float theta = 0.9f * stealth;
            GlStateManager.func_179114_b((float)theta, (float)0.0f, (float)0.0f, (float)1.0f);
            textureManager.func_110577_a(STEALTH_GAUGE_TEXTURE);
            GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)alpha);
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187426_b((float)0.00390625f, (float)0.00390625f);
            GlStateManager.func_187435_e((float)(-halfSize), (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187426_b((float)0.00390625f, (float)0.99609375f);
            GlStateManager.func_187435_e((float)(-halfSize), (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)0.99609375f, (float)0.99609375f);
            GlStateManager.func_187435_e((float)halfSize, (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)0.99609375f, (float)0.00390625f);
            GlStateManager.func_187435_e((float)halfSize, (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187437_J();
            GlStateManager.func_179114_b((float)(-theta), (float)0.0f, (float)0.0f, (float)1.0f);
            textureManager.func_110577_a(STEALTH_GAUGE_RIM_TEXTURE);
            c = new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeRimColor, 16), true);
            GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)1.0f);
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187426_b((float)0.001953125f, (float)0.001953125f);
            GlStateManager.func_187435_e((float)(-halfSize), (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187426_b((float)0.001953125f, (float)0.9980469f);
            GlStateManager.func_187435_e((float)(-halfSize), (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)0.9980469f, (float)0.9980469f);
            GlStateManager.func_187435_e((float)halfSize, (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)0.9980469f, (float)0.001953125f);
            GlStateManager.func_187435_e((float)halfSize, (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187437_J();
            HUD.drawArrow(0.0f, -halfSize, -90.0f, 0.06f, true);
        } else if (mode == 2) {
            textureManager.func_110577_a(STEALTH_GAUGE_TEXTURE_2);
            float dif = (float)ClientData.stealthLevel - ClientData.prevStealthDisplayed;
            int direction = dif > 0.0f ? 1 : -1;
            float absLimitedDif = Math.min(partialTickDelta * (float)DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeSpeed, Math.abs(dif));
            float displayedStealth = ClientData.prevStealthDisplayed + absLimitedDif * (float)direction;
            int index = Tools.min((int[])new int[]{(int)(100.0f - displayedStealth) >> 2, 49});
            GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)alpha);
            int gridX = index % 10;
            int gridY = index / 10;
            float uvleft = (float)gridX * 0.1f + 3.90625E-4f;
            float uvright = (float)(gridX + 1) * 0.1f - 3.90625E-4f;
            float uvtop = (float)gridY * 0.2f + 7.8125E-4f;
            float uvbottom = (float)(gridY + 1) * 0.2f - 7.8125E-4f;
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187426_b((float)uvleft, (float)uvtop);
            GlStateManager.func_187435_e((float)(-halfSize), (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187426_b((float)uvleft, (float)uvbottom);
            GlStateManager.func_187435_e((float)(-halfSize), (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)uvright, (float)uvbottom);
            GlStateManager.func_187435_e((float)halfSize, (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)uvright, (float)uvtop);
            GlStateManager.func_187435_e((float)halfSize, (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187437_J();
            ClientData.prevStealthFrameIndex = index;
            ClientData.prevStealthDisplayed = displayedStealth;
        } else if (mode == 3) {
            event.setCanceled(true);
            textureManager.func_110577_a(STEALTH_GAUGE_TEXTURE_3);
            float dif = (float)ClientData.stealthLevel - ClientData.prevStealthDisplayed;
            if (ClientData.stealthLevel == 100) {
                if (ClientData.fullStealthTime >= DynamicStealthConfig.clientSettings.hudSettings.mainStyle.cursorReversionDelay) {
                    dif += 80.0f;
                } else {
                    ++ClientData.fullStealthTime;
                }
            } else {
                ClientData.fullStealthTime = 0;
            }
            int direction = dif > 0.0f ? 1 : -1;
            float absLimitedDif = Math.min(partialTickDelta * (float)DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeSpeed, Math.abs(dif));
            float displayedStealth = ClientData.prevStealthDisplayed + absLimitedDif * (float)direction;
            int index = Tools.min((int[])new int[]{(int)(180.0f - displayedStealth) >> 2, 69});
            GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)alpha);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            GlStateManager.func_179147_l();
            int gridX = index % 10;
            int gridY = index / 10;
            float uvleft = (float)gridX * 0.1f + 3.90625E-4f;
            float uvright = (float)(gridX + 1) * 0.1f - 3.90625E-4f;
            float uvtop = (float)gridY * 0.14285715f + 5.5803574E-4f;
            float uvbottom = (float)(gridY + 1) * 0.14285715f - 5.5803574E-4f;
            GlStateManager.func_187447_r((int)7);
            GlStateManager.func_187426_b((float)uvleft, (float)uvtop);
            GlStateManager.func_187435_e((float)(-halfSize), (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187426_b((float)uvleft, (float)uvbottom);
            GlStateManager.func_187435_e((float)(-halfSize), (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)uvright, (float)uvbottom);
            GlStateManager.func_187435_e((float)halfSize, (float)halfSize, (float)0.0f);
            GlStateManager.func_187426_b((float)uvright, (float)uvtop);
            GlStateManager.func_187435_e((float)halfSize, (float)(-halfSize), (float)0.0f);
            GlStateManager.func_187437_J();
            ClientData.prevStealthFrameIndex = index;
            ClientData.prevStealthDisplayed = displayedStealth;
        }
        GlStateManager.func_179121_F();
    }

    private static void drawHUD(RenderGameOverlayEvent.Pre event, Minecraft mc) {
        Entity entity;
        if (ClientData.targetData != null && (entity = mc.field_71439_g.field_70170_p.func_73045_a(ClientData.targetData.searcherID)) != null) {
            HUD.drawTargetingHUD(event, entity, mc.field_71466_p);
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179098_w();
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderLightGaugeEvent(event))) {
            HUD.drawLightGauge(mc);
        }
        if (DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeMode != 3 && !MinecraftForge.EVENT_BUS.post((Event)new RenderStealthGaugeEvent(event))) {
            HUD.drawStealthGauge(mc, DynamicStealthConfig.clientSettings.hudSettings.mainStyle.stealthGaugeMode, null);
        }
    }

    public static void drawTargetingHUD(RenderGameOverlayEvent.Pre event, Entity entity, FontRenderer fontRenderer) {
        block36: {
            try {
                boolean toRight;
                float originDrawY;
                Pair pos = Render.getEntityXYInWindow((Entity)entity, (double)0.0, (double)((double)entity.field_70131_O * 0.5), (double)0.0);
                if (pos == null) {
                    return;
                }
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                float originX = ((Float)pos.getKey()).floatValue();
                float originY = ((Float)pos.getValue()).floatValue();
                int portW = Render.getStoredViewportWidth();
                int portH = Render.getStoredViewportHeight();
                if (SHADERS_CONFIG_RENDER_RES_MUL_FIELD != null) {
                    float optifineScalar = ((Float)ReflectionTool.get((Field)SHADERS_CONFIG_RENDER_RES_MUL_FIELD, null)).floatValue();
                    originX /= optifineScalar;
                    originY /= optifineScalar;
                    portW = (int)((float)portW / optifineScalar);
                    portH = (int)((float)portH / optifineScalar);
                }
                boolean offScreen = false;
                float boundX = originX;
                float boundY = originY;
                if (boundX < 1.0f) {
                    boundX = 1.0f;
                    offScreen = true;
                } else if (boundX > (float)(portW - 1)) {
                    boundX = portW - 1;
                    offScreen = true;
                }
                if (boundY < 1.0f) {
                    boundY = 1.0f;
                    offScreen = true;
                } else if (boundY > (float)(portH - 1)) {
                    boundY = portH - 1;
                    offScreen = true;
                }
                ScaledResolution sr = new ScaledResolution(Minecraft.func_71410_x());
                if (offScreen) {
                    double halfPortW = (double)portW * 0.5;
                    double halfPortH = (double)portH * 0.5;
                    double angleRad = DynamicStealth.TRIG_TABLE.arctanFullcircle(halfPortW, halfPortH, (double)originX, (double)originY);
                    double dist = (double)Tools.min((int[])new int[]{portW, portH}) * 0.4;
                    double originDrawX = (halfPortW + dist * DynamicStealth.TRIG_TABLE.cos(angleRad)) / (double)sr.func_78325_e();
                    double originDrawY2 = (halfPortH - dist * DynamicStealth.TRIG_TABLE.sin(angleRad)) / (double)sr.func_78325_e();
                    if (!MinecraftForge.EVENT_BUS.post((Event)new RenderTargetingHUDEvent.Offscreen(event, boundX / (float)sr.func_78325_e(), boundY / (float)sr.func_78325_e(), originDrawX, originDrawY2, angleRad, ClientData.targetData))) {
                        Color c = DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.stateColoredArrow ? new Color(ClientData.targetData.color, true) : new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.defaultArrowColor, 16), true);
                        GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)((float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.arrowAlpha));
                        HUD.drawArrow((float)originDrawX, (float)originDrawY2, (float)Tools.radtodeg((double)angleRad), (float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.arrowSize / Tools.max((float[])new float[]{152.0f, 87.0f}));
                    }
                    break block36;
                }
                float originDrawX = boundX / (float)sr.func_78325_e();
                if (MinecraftForge.EVENT_BUS.post((Event)new RenderTargetingHUDEvent.Onscreen(event, originDrawX, originDrawY = boundY / (float)sr.func_78325_e(), ClientData.targetData))) break block36;
                int color = ClientData.targetData.color;
                Color c = DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.stateColoredReticle ? new Color(color, true) : new Color(Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.defaultReticleColor, 16), true);
                GlStateManager.func_179131_c((float)c.rf(), (float)c.gf(), (float)c.bf(), (float)((float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.reticleAlpha));
                HUD.drawReticle(originDrawX, originDrawY);
                int targetID = ClientData.targetData.targetID;
                Entity target = targetID == -1 || targetID == -2 ? null : entity.field_70170_p.func_73045_a(targetID);
                float padding = 1.0f;
                ArrayList<String> elements = new ArrayList<String>();
                if (ClientData.allowTargetingName && DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.components.name) {
                    elements.add(entity.func_70005_c_());
                }
                if (ClientData.allowTargetingHP && DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.components.hp && entity instanceof EntityLivingBase) {
                    EntityLivingBase livingBase = (EntityLivingBase)entity;
                    float hp = livingBase.func_110143_aJ();
                    float max = livingBase.func_110138_aP();
                    elements.add(I18n.func_74837_a((String)"dynamicstealth.hud.hp", (Object[])new Object[]{ONE_DECIMAL.format(hp), ONE_DECIMAL.format(max), (int)(hp / max * 100.0f)}));
                }
                if (DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.components.action) {
                    String action;
                    switch (color) {
                        case 0x55FF55: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.dazed", (Object[])new Object[0]);
                            break;
                        }
                        case 0xAA00AA: 
                        case 0xFF55FF: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.fleeFrom", (Object[])new Object[]{target == null ? I18n.func_74837_a((String)"dynamicstealth.hud.unknown", (Object[])new Object[0]) : target.func_70005_c_()});
                            break;
                        }
                        case 0xFF8800: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.search", (Object[])new Object[0]);
                            break;
                        }
                        case 52224: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.idlePassive", (Object[])new Object[0]);
                            break;
                        }
                        case 0x4444FF: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.idleNonPassive", (Object[])new Object[0]);
                            break;
                        }
                        case 0x555555: {
                            if (target != null) {
                                action = I18n.func_74837_a((String)"dynamicstealth.hud.targeting", (Object[])new Object[]{target.func_70005_c_()});
                                break;
                            }
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.unknown", (Object[])new Object[0]);
                            break;
                        }
                        default: {
                            action = I18n.func_74837_a((String)"dynamicstealth.hud.targeting", (Object[])new Object[]{target == null ? I18n.func_74837_a((String)"dynamicstealth.hud.unknown", (Object[])new Object[0]) : target.func_70005_c_()});
                        }
                    }
                    elements.add(I18n.func_74837_a((String)"dynamicstealth.hud.action", (Object[])new Object[]{action}));
                }
                if (ClientData.allowTargetingThreat && DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.components.threat) {
                    if (color == 0x555555) {
                        elements.add(I18n.func_74837_a((String)"dynamicstealth.hud.threatNotApplicable", (Object[])new Object[0]));
                    } else if (ClientData.targetData.percent > 0) {
                        elements.add(I18n.func_74837_a((String)"dynamicstealth.hud.threat", (Object[])new Object[]{ClientData.targetData.percent}));
                    }
                }
                if (ClientData.allowTargetingDistance && DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.components.distance) {
                    elements.add(I18n.func_74837_a((String)"dynamicstealth.hud.distance", (Object[])new Object[]{ONE_DECIMAL.format(entity.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g))}));
                }
                float width = 0.0f;
                for (String string : elements) {
                    width = Tools.max((float[])new float[]{width, fontRenderer.func_78256_a(string)});
                }
                float height = (float)(fontRenderer.field_78288_b * elements.size()) + padding * (float)(elements.size() - 1);
                float textScale = (float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.textScale;
                float offX = 20.0f;
                float alpha = (float)DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.textAlpha;
                if (!DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.stateColoredText) {
                    color = Integer.parseInt(DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.defaultTextColor, 16);
                }
                color |= (int)(255.0f * alpha) << 24;
                GlStateManager.func_179090_x();
                boolean bl = toRight = originX < (float)(portW >> 1);
                if (!toRight) {
                    offX = -offX;
                }
                float drawX = originX / (float)sr.func_78325_e() + offX;
                float drawY = originY / (float)sr.func_78325_e();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)drawX, (float)drawY, (float)0.0f);
                GlStateManager.func_179152_a((float)textScale, (float)textScale, (float)1.0f);
                GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)alpha);
                if (toRight) {
                    GlStateManager.func_187447_r((int)7);
                    GlStateManager.func_187435_e((float)(-padding), (float)(-height / 2.0f - padding), (float)0.0f);
                    GlStateManager.func_187435_e((float)(-padding), (float)(height / 2.0f + padding - 1.0f), (float)0.0f);
                    GlStateManager.func_187435_e((float)(width + padding - 1.0f), (float)(height / 2.0f + padding - 1.0f), (float)0.0f);
                    GlStateManager.func_187435_e((float)(width + padding - 1.0f), (float)(-height / 2.0f - padding), (float)0.0f);
                    GlStateManager.func_187437_J();
                    GlStateManager.func_179098_w();
                    for (int i = 0; i < elements.size(); ++i) {
                        fontRenderer.func_175065_a((String)elements.get(i), 0.0f, -height / 2.0f + height * (float)i / (float)elements.size(), color, false);
                    }
                } else {
                    GlStateManager.func_187447_r((int)7);
                    GlStateManager.func_187435_e((float)(-width - padding), (float)(-height / 2.0f - padding), (float)0.0f);
                    GlStateManager.func_187435_e((float)(-width - padding), (float)(height / 2.0f + padding - 1.0f), (float)0.0f);
                    GlStateManager.func_187435_e((float)(padding - 1.0f), (float)(height / 2.0f + padding - 1.0f), (float)0.0f);
                    GlStateManager.func_187435_e((float)(padding - 1.0f), (float)(-height / 2.0f - padding), (float)0.0f);
                    GlStateManager.func_187437_J();
                    GlStateManager.func_179098_w();
                    for (int i = 0; i < elements.size(); ++i) {
                        fontRenderer.func_175065_a((String)elements.get(i), -width, -height / 2.0f + height * (float)i / (float)elements.size(), color, false);
                    }
                }
                GlStateManager.func_179121_F();
            }
            catch (IllegalAccessException e) {
                MCTools.crash((Exception)e, (int)155, (boolean)false);
            }
        }
    }
}

