/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.client;

import com.fantasticsource.dynamicstealth.client.layeredits.LayerEndermanEyesEdit;
import com.fantasticsource.dynamicstealth.client.layeredits.LayerSpiderEyesEdit;
import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatIceAndFire;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.entity.layers.LayerEndermanEyes;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.layers.LayerSpiderEyes;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderAlterer {
    private static HashSet<ScorePlayerTeam> colorTeams = new HashSet();
    private static Scoreboard scoreboard;
    private static HashSet<EntityLivingBase> glowCache;
    private static LinkedHashMap<EntityLivingBase, Team> teamCache;
    private static boolean ready;

    @SubscribeEvent
    public static void init(EntityJoinWorldEvent event) {
        if (!ready && event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            scoreboard = Minecraft.func_71410_x().field_71441_e.func_96441_U();
            ScorePlayerTeam team = scoreboard.func_96527_f("dark green");
            team.func_96666_b(TextFormatting.DARK_GREEN.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("green");
            team.func_96666_b(TextFormatting.GREEN.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("blue");
            team.func_96666_b(TextFormatting.BLUE.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("yellow");
            team.func_96666_b(TextFormatting.YELLOW.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("orange");
            team.func_96666_b(TextFormatting.GOLD.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("red");
            team.func_96666_b(TextFormatting.RED.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("black");
            team.func_96666_b(TextFormatting.BLACK.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("pink");
            team.func_96666_b(TextFormatting.LIGHT_PURPLE.toString());
            colorTeams.add(team);
            team = scoreboard.func_96527_f("purple");
            team.func_96666_b(TextFormatting.DARK_PURPLE.toString());
            colorTeams.add(team);
            ready = true;
        }
    }

    @SubscribeEvent
    public static void reset(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        ready = false;
    }

    private static String getTeam(int color) {
        switch (color) {
            case 0x55FF55: {
                return "green";
            }
            case 52224: {
                return "dark green";
            }
            case 0x4444FF: {
                return "blue";
            }
            case 0xFFFF00: {
                return "yellow";
            }
            case 0xFF8800: {
                return "orange";
            }
            case 0xFF0000: {
                return "red";
            }
            case 0x555555: {
                return "black";
            }
            case 0xFF55FF: {
                return "pink";
            }
            case 0xAA00AA: {
                return "purple";
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void tick(TickEvent.WorldTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            for (EntityLivingBase livingBase : (HashSet)glowCache.clone()) {
                livingBase.func_184195_f(false);
                glowCache.remove(livingBase);
            }
            for (Object object : teamCache.entrySet().toArray()) {
                Map.Entry entry = (Map.Entry)object;
                EntityLivingBase livingBase = (EntityLivingBase)entry.getKey();
                Team team = ((EntityLivingBase)entry.getKey()).func_96124_cp();
                if (team != null) {
                    scoreboard.func_151392_a(livingBase.func_110124_au().toString(), team.func_96661_b());
                }
                teamCache.remove(livingBase);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=true)
    public static void preRender(RenderLivingEvent.Pre event) {
        if (ready) {
            EntityLivingBase livingBase = event.getEntity();
            if (livingBase.getClass() == Compat.bibliocraftArmorStandEntity) {
                return;
            }
            if (Compat.statues && livingBase.getClass().getName().contains("party.lemons.statue")) {
                return;
            }
            if (glowCache.contains(livingBase)) {
                glowCache.remove(livingBase);
                livingBase.func_184195_f(false);
            }
            if (!event.isCanceled()) {
                ClientData.OnPointData data;
                if (Compat.iceandfire && CompatIceAndFire.isPetrified((Entity)livingBase)) {
                    return;
                }
                livingBase.func_82142_c(false);
                if (DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.glow && DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.stateColoredGlow && (data = ClientData.targetData) != null && data.searcherID == livingBase.func_145782_y()) {
                    Team team = livingBase.func_96124_cp();
                    if (team != null) {
                        teamCache.put(livingBase, team);
                    }
                    scoreboard.func_151392_a(livingBase.func_110124_au().toString(), RenderAlterer.getTeam(data.color));
                }
                if (ClientData.usePlayerSenses && livingBase != Minecraft.func_71410_x().field_71439_g) {
                    int id = livingBase.func_145782_y();
                    double min = DynamicStealthConfig.clientSettings.entityFading.mobOpacityMin;
                    double visibility = ClientData.visibilityMap.containsKey(id) ? (double)ClientData.visibilityMap.get(id).floatValue() : (ClientData.previousVisibilityMap1.containsKey(id) ? (double)ClientData.previousVisibilityMap1.get(id).floatValue() : (ClientData.previousVisibilityMap2.containsKey(id) ? (double)ClientData.previousVisibilityMap2.get(id).floatValue() : 1.0));
                    double maxOpacityAt = DynamicStealthConfig.clientSettings.entityFading.fullOpacityAt;
                    if (visibility != 0.0) {
                        visibility = maxOpacityAt == 0.0 ? 1.0 : (visibility /= maxOpacityAt);
                    }
                    GlStateManager.func_179147_l();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    GlStateManager.func_179089_o();
                    GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
                    GlStateManager.Color c = GlStateManager.field_179170_t;
                    c.field_179192_d *= (float)(min + (1.0 - min) * visibility);
                    GL11.glColor4f((float)c.field_179195_a, (float)c.field_179193_b, (float)c.field_179194_c, (float)c.field_179192_d);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void postRender(RenderLivingEvent.Post event) {
        if (ready) {
            EntityLivingBase livingBase = event.getEntity();
            if (Compat.statues && livingBase.getClass().getName().contains("party.lemons.statue")) {
                return;
            }
            Team team = livingBase.func_96124_cp();
            if (colorTeams.contains(team)) {
                scoreboard.func_96512_b(livingBase.func_189512_bd(), (ScorePlayerTeam)team);
                if (teamCache.containsKey(livingBase)) {
                    scoreboard.func_151392_a(livingBase.func_189512_bd(), teamCache.get(livingBase).func_96661_b());
                }
                livingBase.func_184195_f(false);
            }
            if (Compat.iceandfire && CompatIceAndFire.isPetrified((Entity)livingBase)) {
                return;
            }
            if (!event.isCanceled()) {
                ClientData.OnPointData data = ClientData.targetData;
                if (DynamicStealthConfig.clientSettings.hudSettings.targetingStyle.glow && data != null && data.searcherID == livingBase.func_145782_y()) {
                    RenderAlterer.setTempGlow(event);
                } else if (ClientData.soulSight && !livingBase.func_184202_aL()) {
                    RenderAlterer.setTempGlow(event);
                }
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
        }
    }

    private static void setTempGlow(RenderLivingEvent.Post event) {
        EntityLivingBase entity = event.getEntity();
        entity.func_184195_f(true);
        glowCache.add(entity);
    }

    public static void replaceLayers(EntityLivingBase livingBase) {
        Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingBase);
        if (render instanceof RenderLivingBase) {
            List list = ((RenderLivingBase)render).field_177097_h;
            for (LayerRenderer layer : list.toArray(new LayerRenderer[0])) {
                if (layer instanceof LayerSpiderEyes) {
                    list.remove(layer);
                    list.add(new LayerSpiderEyesEdit((RenderSpider)render));
                    continue;
                }
                if (!(layer instanceof LayerEndermanEyes)) continue;
                list.remove(layer);
                list.add(new LayerEndermanEyesEdit((RenderEnderman)render));
            }
        }
    }

    static {
        glowCache = new HashSet();
        teamCache = new LinkedHashMap();
        ready = false;
    }
}

