/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.client;

import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class TooltipAlterer {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void tooltips(ItemTooltipEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || !DynamicStealthConfig.clientSettings.tooltips.alterTooltips) {
            return;
        }
        String attackDamageString = I18n.func_74837_a((String)"attribute.name.generic.attackDamage", (Object[])new Object[0]);
        ItemStack stack = event.getItemStack();
        WeaponEntry normal = ClientData.getWeaponEntry(stack, 0, false);
        WeaponEntry stealth = ClientData.getWeaponEntry(stack, 1, false);
        WeaponEntry blockedNormal = ClientData.getWeaponEntry(stack, 0, true);
        WeaponEntry blockedStealth = ClientData.getWeaponEntry(stack, 1, true);
        WeaponEntry assassination = ClientData.getWeaponEntry(stack, 2, false);
        List tooltip = event.getToolTip();
        double vanillaDamage = MCTools.getAttribute((EntityLivingBase)player, (IAttribute)SharedMonsterAttributes.field_111264_e);
        for (int i = 0; i < tooltip.size(); ++i) {
            String line = (String)tooltip.get(i);
            if (!line.contains(attackDamageString)) continue;
            try {
                vanillaDamage = Double.parseDouble(line.replace(attackDamageString, "").trim());
                tooltip.remove(i);
                break;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        tooltip.add("");
        tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.normalAttacks"));
        if (normal.consumeItem) {
            tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.consumeItem"));
        }
        if (normal.armorPenetration) {
            tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.penetratingDamage", (Object[])new Object[]{String.format("%.2f", vanillaDamage * normal.damageMultiplier)}));
        } else {
            tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.normalDamage", (Object[])new Object[]{String.format("%.2f", vanillaDamage * normal.damageMultiplier)}));
        }
        for (FantasticPotionEffect potionEffect : normal.attackerEffects) {
            tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveYouPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
        }
        for (FantasticPotionEffect potionEffect : normal.victimEffects) {
            tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveVictimPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
        }
        if (!stealth.equals(normal)) {
            tooltip.add("");
            tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.stealthAttacks"));
            if (stealth.consumeItem) {
                tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.consumeItem"));
            }
            if (stealth.armorPenetration) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.penetratingDamage", (Object[])new Object[]{String.format("%.2f", vanillaDamage * stealth.damageMultiplier)}));
            } else {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.normalDamage", (Object[])new Object[]{String.format("%.2f", vanillaDamage * stealth.damageMultiplier)}));
            }
            for (FantasticPotionEffect potionEffect : stealth.attackerEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveYouPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
            for (FantasticPotionEffect potionEffect : stealth.victimEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveVictimPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
        }
        if (!WeaponEntry.resultMatches(vanillaDamage, normal, blockedNormal)) {
            double blockedDamage = blockedNormal.armorPenetration ? vanillaDamage * blockedNormal.damageMultiplier : 0.0;
            tooltip.add("");
            tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.blockedNormalAttacks"));
            if (blockedNormal.consumeItem) {
                tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.consumeItem"));
            }
            if (blockedNormal.armorPenetration) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.penetratingDamage", (Object[])new Object[]{String.format("%.2f", blockedDamage)}));
            } else {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.normalDamage", (Object[])new Object[]{String.format("%.2f", blockedDamage)}));
            }
            for (FantasticPotionEffect potionEffect : blockedNormal.attackerEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveYouPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
            for (FantasticPotionEffect potionEffect : blockedNormal.victimEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveVictimPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
        }
        if (!WeaponEntry.resultMatches(vanillaDamage, stealth, blockedStealth)) {
            double blockedDamage = blockedStealth.armorPenetration ? vanillaDamage * blockedStealth.damageMultiplier : 0.0;
            tooltip.add("");
            tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.blockedStealthAttacks"));
            if (blockedStealth.consumeItem) {
                tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.consumeItem"));
            }
            if (blockedStealth.armorPenetration) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.penetratingDamage", (Object[])new Object[]{String.format("%.2f", blockedDamage)}));
            } else {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.normalDamage", (Object[])new Object[]{String.format("%.2f", blockedDamage)}));
            }
            for (FantasticPotionEffect potionEffect : blockedStealth.attackerEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveYouPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
            for (FantasticPotionEffect potionEffect : blockedStealth.victimEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveVictimPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
        }
        if (assassination.attackerEffects.size() > 0 && (DynamicStealthConfig.clientSettings.tooltips.alwaysShowAssassinationInfo || !assassination.equals(ClientData.assassinationDefault))) {
            tooltip.add("");
            tooltip.add(I18n.func_74838_a((String)"dynamicstealth.tooltip.assassinations"));
            for (FantasticPotionEffect potionEffect : assassination.attackerEffects) {
                tooltip.add(I18n.func_74837_a((String)"dynamicstealth.tooltip.giveYouPotion", (Object[])new Object[]{I18n.func_74837_a((String)potionEffect.func_188419_a().func_76393_a(), (Object[])new Object[0]), potionEffect.func_76458_c() + 1, Potion.func_188410_a((PotionEffect)potionEffect, (float)1.0f)}));
            }
        }
    }
}

