/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.client.event;

import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.mctools.Render;
import com.fantasticsource.tools.Tools;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;

@Cancelable
public class RenderTargetingHUDEvent
extends Event {
    private final double x;
    private final double y;
    private final ClientData.OnPointData data;
    private final RenderGameOverlayEvent.Pre parentEvent;

    private RenderTargetingHUDEvent(RenderGameOverlayEvent.Pre parentEvent, double x, double y, ClientData.OnPointData data) {
        this.parentEvent = parentEvent;
        this.x = x;
        this.y = y;
        this.data = data;
    }

    public RenderGameOverlayEvent.Pre getParentEvent() {
        return this.parentEvent;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getViewportWidth() throws IllegalAccessException {
        return Render.getStoredViewportWidth();
    }

    public int getViewportHeight() throws IllegalAccessException {
        return Render.getStoredViewportHeight();
    }

    @Nonnull
    public ClientData.OnPointData getData() {
        return this.data.clone();
    }

    @Nonnull
    public Entity getEntity() {
        return this.data.getEntity();
    }

    @Nullable
    public Entity getEntityTarget() {
        return this.data.getTarget();
    }

    public int getEntityThreatColor() {
        return this.data.color;
    }

    public int getEntityThreat() {
        return this.data.percent;
    }

    public static class Offscreen
    extends RenderTargetingHUDEvent {
        private final double angleRad;
        private final double dsX;
        private final double dsY;

        public Offscreen(RenderGameOverlayEvent.Pre parentEvent, double x, double y, double dsX, double dsY, double angleRad, ClientData.OnPointData data) {
            super(parentEvent, x, y, data);
            this.angleRad = angleRad;
            this.dsX = dsX;
            this.dsY = dsY;
        }

        public double getAngleRad() {
            return this.angleRad;
        }

        public double getAngleDeg() {
            return Tools.radtodeg((double)this.angleRad);
        }

        public double getDSX() {
            return this.dsX;
        }

        public double getDSY() {
            return this.dsY;
        }
    }

    public static class Onscreen
    extends RenderTargetingHUDEvent {
        public Onscreen(RenderGameOverlayEvent.Pre parentEvent, double x, double y, ClientData.OnPointData data) {
            super(parentEvent, x, y, data);
        }
    }
}

