/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.common;

import com.fantasticsource.dynamicstealth.compat.CompatEBWizardry;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.ai.AIDynamicStealth;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientData {
    public static final byte CID_ATTACKING_YOU = 0;
    public static final byte CID_SEARCHING = 1;
    public static final byte CID_ATTACKING_OTHER = 2;
    public static final byte CID_IDLE_NON_PASSIVE = 3;
    public static final byte CID_IDLE_PASSIVE = 4;
    public static final byte CID_FLEEING_NON_PASSIVE = 5;
    public static final byte CID_FLEEING_PASSIVE = 6;
    public static final byte CID_BYPASS = 7;
    public static final byte CID_DAZED = 8;
    public static final int COLOR_ATTACKING_YOU = 0xFF0000;
    public static final int COLOR_ATTACKING_OTHER = 0xFFFF00;
    public static final int COLOR_SEARCHING = 0xFF8800;
    public static final int COLOR_IDLE_NON_PASSIVE = 0x4444FF;
    public static final int COLOR_IDLE_PASSIVE = 52224;
    public static final int COLOR_FLEEING_N0N_PASSIVE = 0xFF55FF;
    public static final int COLOR_FLEEING_PASSIVE = 0xAA00AA;
    public static final int COLOR_BYPASS = 0x555555;
    public static final int COLOR_DAZED = 0x55FF55;
    public static int stealthLevel = -128;
    public static int prevStealthLevel = -128;
    public static int lightLevel = 0;
    public static int prevStealthFrameIndex = 0;
    public static float prevStealthDisplayed = 0.0f;
    public static int fullStealthTime = 0;
    public static boolean soulSight = false;
    public static boolean usePlayerSenses = false;
    public static boolean allowTargetingName = true;
    public static boolean allowTargetingHP = true;
    public static boolean allowTargetingThreat = true;
    public static boolean allowTargetingDistance = true;
    public static LinkedHashMap<Integer, OnPointData> opMap = new LinkedHashMap();
    public static OnPointData targetData = null;
    public static double targetPriority = 2.147483647E9;
    public static LinkedHashMap<Integer, Float> visibilityMap = new LinkedHashMap();
    public static LinkedHashMap<Integer, Float> previousVisibilityMap1 = new LinkedHashMap();
    public static LinkedHashMap<Integer, Float> previousVisibilityMap2 = new LinkedHashMap();
    public static WeaponEntry normalDefault = new WeaponEntry(null);
    public static WeaponEntry rangedDefault = new WeaponEntry(null);
    public static WeaponEntry stealthDefault = new WeaponEntry(null);
    public static WeaponEntry rangedStealthDefault = new WeaponEntry(null);
    public static WeaponEntry normalBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry rangedBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry stealthBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry rangedStealthBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry assassinationDefault = new WeaponEntry(null);
    public static WeaponEntry rangedAssassinationDefault = new WeaponEntry(null);
    public static ArrayList<WeaponEntry> normalWeaponSpecific = new ArrayList();
    public static ArrayList<WeaponEntry> stealthWeaponSpecific = new ArrayList();
    public static ArrayList<WeaponEntry> normalBlockedWeaponSpecific = new ArrayList();
    public static ArrayList<WeaponEntry> stealthBlockedWeaponSpecific = new ArrayList();
    public static ArrayList<WeaponEntry> assassinationWeaponSpecific = new ArrayList();

    @SubscribeEvent
    public static void clearClientData(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        stealthLevel = -128;
        prevStealthLevel = -128;
        prevStealthDisplayed = 0.0f;
        prevStealthFrameIndex = 0;
        soulSight = false;
        usePlayerSenses = false;
        allowTargetingName = true;
        allowTargetingHP = true;
        allowTargetingThreat = true;
        allowTargetingDistance = true;
        opMap.clear();
        targetData = null;
        targetPriority = 2.147483647E9;
        visibilityMap.clear();
        previousVisibilityMap1.clear();
        previousVisibilityMap2.clear();
    }

    public static byte getCID(int color) {
        switch (color) {
            case 0xFF0000: {
                return 0;
            }
            case 0xFF8800: {
                return 1;
            }
            case 0xFFFF00: {
                return 2;
            }
            case 0x4444FF: {
                return 3;
            }
            case 52224: {
                return 4;
            }
            case 0xFF55FF: {
                return 5;
            }
            case 0xAA00AA: {
                return 6;
            }
            case 0x555555: {
                return 7;
            }
            case 0x55FF55: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Unregistered color: " + color);
    }

    public static byte getCID(EntityPlayer player, Entity searcher, Entity target, float threatPercentage) {
        return ClientData.getCID(ClientData.getColor(player, searcher, target, threatPercentage));
    }

    public static int getColor(byte cid) {
        switch (cid) {
            case 0: {
                return 0xFF0000;
            }
            case 1: {
                return 0xFF8800;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 0x4444FF;
            }
            case 4: {
                return 52224;
            }
            case 5: {
                return 0xFF55FF;
            }
            case 6: {
                return 0xAA00AA;
            }
            case 7: {
                return 0x555555;
            }
            case 8: {
                return 0x55FF55;
            }
        }
        throw new IllegalArgumentException("Unregistered cid: " + cid);
    }

    public static int getColor(EntityPlayer player, Entity searcher, Entity target, float threatPercentage) {
        AIDynamicStealth stealthAI;
        if (EntityThreatData.bypassesThreat(searcher)) {
            return 0x555555;
        }
        if (CompatEBWizardry.mindTrickPotion != null && searcher instanceof EntityLivingBase && ((EntityLivingBase)searcher).func_70660_b(CompatEBWizardry.mindTrickPotion) != null) {
            return 0x55FF55;
        }
        AIDynamicStealth aIDynamicStealth = stealthAI = searcher instanceof EntityLiving ? AIDynamicStealth.getStealthAI((EntityLiving)searcher) : null;
        if (stealthAI != null && stealthAI.isFleeing()) {
            return DynamicStealthConfig.serverSettings.hud.recognizePassive && EntityThreatData.isPassive(searcher) ? 0xAA00AA : 0xFF55FF;
        }
        if (DynamicStealthConfig.serverSettings.hud.recognizePassive && EntityThreatData.isPassive(searcher)) {
            return 52224;
        }
        if (threatPercentage <= 0.0f) {
            return 0x4444FF;
        }
        if (target == null || searcher instanceof EntityLivingBase && !Sight.canSee((EntityLivingBase)searcher, target, true)) {
            return 0xFF8800;
        }
        if (target == player) {
            return 0xFF0000;
        }
        return 0xFFFF00;
    }

    public static boolean canHaveClientTarget(byte cid) {
        return cid != 4 && cid != 3 && cid != 1 && cid != 8;
    }

    public static boolean canHaveClientTarget(int color) {
        return color != 52224 && color != 0x4444FF && color != 0xFF8800 && color != 0x55FF55;
    }

    public static boolean canHaveThreat(byte cid) {
        return cid != 4 && cid != 3 && cid != 7 && cid != 8;
    }

    public static boolean canHaveThreat(int color) {
        return color != 52224 && color != 0x4444FF && color != 0x555555 && color != 0x55FF55;
    }

    protected static WeaponEntry getDefault(int type, boolean isMelee, boolean isBlocked) {
        if (type == 0) {
            if (isMelee) {
                if (isBlocked) {
                    return normalBlockedDefault;
                }
                return normalDefault;
            }
            if (isBlocked) {
                return rangedBlockedDefault;
            }
            return rangedDefault;
        }
        if (type == 1) {
            if (isMelee) {
                if (isBlocked) {
                    return stealthBlockedDefault;
                }
                return stealthDefault;
            }
            if (isBlocked) {
                return rangedStealthBlockedDefault;
            }
            return rangedStealthDefault;
        }
        if (type == 2) {
            if (isMelee) {
                return assassinationDefault;
            }
            return rangedAssassinationDefault;
        }
        return null;
    }

    public static WeaponEntry getWeaponEntry(ItemStack itemStack, int type, boolean isBlocked) {
        if (itemStack == null) {
            return ClientData.getDefault(type, false, isBlocked);
        }
        ArrayList<ArrayList<WeaponEntry>> priorityOrderedLists = new ArrayList<ArrayList<WeaponEntry>>();
        if (type == 2) {
            priorityOrderedLists.add(assassinationWeaponSpecific);
        } else {
            if (type == 1) {
                if (isBlocked) {
                    priorityOrderedLists.add(stealthBlockedWeaponSpecific);
                }
                priorityOrderedLists.add(stealthWeaponSpecific);
            }
            if (isBlocked) {
                priorityOrderedLists.add(normalBlockedWeaponSpecific);
            }
            priorityOrderedLists.add(normalWeaponSpecific);
        }
        for (ArrayList arrayList : priorityOrderedLists) {
            for (WeaponEntry weaponEntry : arrayList) {
                if (!weaponEntry.filter.matches(itemStack)) continue;
                return weaponEntry;
            }
        }
        return ClientData.getDefault(type, true, isBlocked);
    }

    public static class OnPointData {
        public int color;
        public int searcherID;
        public int targetID;
        public int percent;

        public OnPointData(int color, int searcherID, int targetID, int percent) {
            this.color = color;
            this.searcherID = searcherID;
            this.targetID = targetID;
            this.percent = percent;
        }

        public OnPointData clone() {
            return new OnPointData(this.color, this.searcherID, this.targetID, this.percent);
        }

        public Entity getEntity() {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(this.searcherID);
        }

        public Entity getTarget() {
            return Minecraft.func_71410_x().field_71441_e.func_73045_a(this.targetID);
        }
    }
}

