/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.common;

import com.fantasticsource.dynamicstealth.common.ClientData;
import com.fantasticsource.dynamicstealth.common.DSTools;
import com.fantasticsource.dynamicstealth.component.CWeaponEntry;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.event.attacks.AttackData;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class Network {
    public static final SimpleNetworkWrapper WRAPPER = NetworkRegistry.INSTANCE.newSimpleChannel("dynamicstealth");
    private static int discriminator = 0;
    private static HashSet<EntityPlayerMP> oldSoulSightClients = new HashSet();

    public static void init() {
        WRAPPER.registerMessage(HUDPacketHandler.class, HUDPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(ClientInitPacketHandler.class, ClientInitPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(VisibilityPacketHandler.class, VisibilityPacket.class, discriminator++, Side.CLIENT);
        WRAPPER.registerMessage(SoulSightPacketHandler.class, SoulSightPacket.class, discriminator++, Side.CLIENT);
    }

    @SubscribeEvent
    public static void sendClientData(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        Profiler profiler = server.field_71304_b;
        profiler.func_76320_a("DStealth: Send client data");
        HashSet<EntityPlayerMP> newSoulSightClients = new HashSet<EntityPlayerMP>();
        for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
            if (EntitySightData.hasSoulSight((Entity)player)) {
                if (!oldSoulSightClients.contains(player)) {
                    WRAPPER.sendTo((IMessage)new SoulSightPacket(true), player);
                }
                newSoulSightClients.add(player);
            } else if (oldSoulSightClients.contains(player)) {
                WRAPPER.sendTo((IMessage)new SoulSightPacket(false), player);
            }
            if (!MCTools.entityIsValid((Entity)player)) continue;
            if (player.func_70089_S()) {
                boolean stealthGauge;
                boolean targetElement;
                boolean opHUD;
                if (DynamicStealthConfig.serverSettings.senses.usePlayerSenses) {
                    WRAPPER.sendTo((IMessage)new VisibilityPacket(player), player);
                }
                if (MCTools.isOP((EntityPlayerMP)player)) {
                    opHUD = DynamicStealthConfig.serverSettings.hud.ophud.allowOPHUD > 0;
                    targetElement = DynamicStealthConfig.serverSettings.hud.targeting.allowTargetElement > 0;
                    stealthGauge = DynamicStealthConfig.serverSettings.hud.allowStealthGauge > 0;
                } else {
                    opHUD = DynamicStealthConfig.serverSettings.hud.ophud.allowOPHUD > 1;
                    targetElement = DynamicStealthConfig.serverSettings.hud.targeting.allowTargetElement > 1;
                    boolean bl = stealthGauge = DynamicStealthConfig.serverSettings.hud.allowStealthGauge > 1;
                }
                if (!opHUD && !stealthGauge) continue;
                player.field_70170_p.field_72984_F.func_76320_a("DStealth: Create HUDPacket");
                HUDPacket packet = new HUDPacket(player, opHUD, targetElement, !stealthGauge ? -128 : (int)(Sight.globalPlayerStealthLevel((EntityPlayer)player) * 100.0));
                player.field_70170_p.field_72984_F.func_76318_c("DStealth: Send HUDPacket");
                WRAPPER.sendTo((IMessage)packet, player);
                player.field_70170_p.field_72984_F.func_76319_b();
                continue;
            }
            player.field_70170_p.field_72984_F.func_76320_a("DStealth: Create HUDPacket");
            HUDPacket packet = new HUDPacket(player, false, false, -128);
            player.field_70170_p.field_72984_F.func_76318_c("DStealth: Send HUDPacket");
            WRAPPER.sendTo((IMessage)packet, player);
            player.field_70170_p.field_72984_F.func_76319_b();
        }
        oldSoulSightClients = newSoulSightClients;
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public static void playerLogon(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        WRAPPER.sendTo((IMessage)new ClientInitPacket(player), player);
    }

    public static class HUDPacketHandler
    implements IMessageHandler<HUDPacket, IMessage> {
        public IMessage onMessage(HUDPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.prevStealthLevel = (ClientData.stealthLevel == -128 || packet.stealthLevel == -128) && ClientData.stealthLevel != packet.stealthLevel ? packet.stealthLevel : ClientData.stealthLevel;
                    ClientData.stealthLevel = packet.stealthLevel;
                    ClientData.lightLevel = packet.lightLevel;
                    if (packet.update) {
                        ClientData.opMap.clear();
                        int target = ClientData.targetData == null ? -1 : ClientData.targetData.targetID;
                        for (ClientData.OnPointData data : packet.outputList) {
                            ClientData.opMap.put(data.searcherID, data);
                            if (data.searcherID != target) continue;
                            ClientData.targetData = data;
                        }
                    }
                });
            }
            return null;
        }
    }

    public static class HUDPacket
    implements IMessage {
        EntityPlayerMP player;
        boolean targetElement;
        boolean update;
        int stealthLevel;
        int lightLevel;
        ArrayList<Entity> inputList = new ArrayList();
        ArrayList<ClientData.OnPointData> outputList = new ArrayList();

        public HUDPacket() {
        }

        public HUDPacket(EntityPlayerMP player, boolean opHUD, boolean targetElement, int stealthLevel) {
            this.player = player;
            this.targetElement = targetElement;
            this.lightLevel = DSTools.entityLightLevel((Entity)player);
            this.stealthLevel = stealthLevel;
            BlockPos playerPos = player.func_180425_c();
            int rangeSq = DynamicStealthConfig.serverSettings.hud.ophud.opHUDRange * DynamicStealthConfig.serverSettings.hud.ophud.opHUDRange;
            int delay = DynamicStealthConfig.serverSettings.hud.ophud.opHUDDelay;
            boolean bl = this.update = opHUD && ServerTickTimer.currentTick() % (long)delay == (long)(player.func_145782_y() % delay);
            if (this.update) {
                for (Entity seen : Sight.seenEntities(player).keySet()) {
                    if (!seen.func_70089_S() || !(seen.func_174818_b(playerPos) <= (double)rangeSq)) continue;
                    this.inputList.add(seen);
                }
            }
        }

        public void toBytes(ByteBuf buf) {
            block7: {
                buf.writeByte(this.stealthLevel);
                buf.writeByte(this.lightLevel);
                buf.writeBoolean(this.update);
                if (!this.update) break block7;
                buf.writeBoolean(this.targetElement);
                buf.writeInt(this.inputList.size());
                if (this.targetElement) {
                    for (Entity seen : this.inputList) {
                        if (EntityThreatData.bypassesThreat(seen)) {
                            buf.writeByte(7);
                            buf.writeInt(seen.func_145782_y());
                            EntityLivingBase target = seen instanceof EntityLiving ? ((EntityLiving)seen).func_70638_az() : null;
                            buf.writeInt(target == null ? -1 : target.func_145782_y());
                            continue;
                        }
                        Threat.ThreatData data = Threat.get((EntityLivingBase)seen);
                        byte cid = ClientData.getCID((EntityPlayer)this.player, seen, (Entity)data.target, data.threatPercentage);
                        buf.writeByte((int)cid);
                        buf.writeInt(seen.func_145782_y());
                        if (ClientData.canHaveClientTarget(cid)) {
                            buf.writeInt(data.target == null ? -1 : data.target.func_145782_y());
                        }
                        if (!ClientData.canHaveThreat(cid)) continue;
                        buf.writeByte((int)data.threatPercentage);
                    }
                } else {
                    for (Entity seen : this.inputList) {
                        if (EntityThreatData.bypassesThreat(seen)) {
                            buf.writeByte(7);
                            buf.writeInt(seen.func_145782_y());
                            continue;
                        }
                        Threat.ThreatData data = Threat.get((EntityLivingBase)seen);
                        byte cid = ClientData.getCID((EntityPlayer)this.player, seen, (Entity)data.target, data.threatPercentage);
                        buf.writeByte((int)ClientData.getCID((EntityPlayer)this.player, seen, (Entity)data.target, data.threatPercentage));
                        buf.writeInt(seen.func_145782_y());
                        if (!ClientData.canHaveThreat(cid)) continue;
                        buf.writeByte((int)data.threatPercentage);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            block4: {
                int remaining;
                this.stealthLevel = buf.readByte();
                this.lightLevel = buf.readByte();
                this.update = buf.readBoolean();
                if (!this.update) break block4;
                this.targetElement = buf.readBoolean();
                if (this.targetElement) {
                    for (remaining = buf.readInt(); remaining > 0; --remaining) {
                        int color = ClientData.getColor(buf.readByte());
                        this.outputList.add(new ClientData.OnPointData(color, buf.readInt(), ClientData.canHaveClientTarget(color) ? buf.readInt() : -1, ClientData.canHaveThreat(color) ? buf.readByte() : (byte)0));
                    }
                } else {
                    while (remaining > 0) {
                        int color = ClientData.getColor(buf.readByte());
                        this.outputList.add(new ClientData.OnPointData(color, buf.readInt(), -2, ClientData.canHaveThreat(color) ? buf.readByte() : (byte)0));
                        --remaining;
                    }
                }
            }
        }
    }

    public static class ClientInitPacketHandler
    implements IMessageHandler<ClientInitPacket, IMessage> {
        public IMessage onMessage(ClientInitPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.soulSight = packet.soulSight;
                    ClientData.usePlayerSenses = packet.usePlayerSenses;
                    ClientData.allowTargetingName = packet.allowTargetingName;
                    ClientData.allowTargetingHP = packet.allowTargetingHP;
                    ClientData.allowTargetingThreat = packet.allowTargetingThreat;
                    ClientData.allowTargetingDistance = packet.allowTargetingDistance;
                    ClientData.normalDefault = packet.normalDefault;
                    ClientData.rangedDefault = packet.rangedDefault;
                    ClientData.stealthDefault = packet.stealthDefault;
                    ClientData.rangedStealthDefault = packet.rangedStealthDefault;
                    ClientData.normalBlockedDefault = packet.normalBlockedDefault;
                    ClientData.rangedBlockedDefault = packet.rangedBlockedDefault;
                    ClientData.stealthBlockedDefault = packet.stealthBlockedDefault;
                    ClientData.rangedStealthBlockedDefault = packet.rangedStealthBlockedDefault;
                    ClientData.assassinationDefault = packet.assassinationDefault;
                    ClientData.rangedAssassinationDefault = packet.rangedAssassinationDefault;
                    ClientData.normalWeaponSpecific = packet.normalWeaponSpecific;
                    ClientData.stealthWeaponSpecific = packet.stealthWeaponSpecific;
                    ClientData.normalBlockedWeaponSpecific = packet.normalBlockedWeaponSpecific;
                    ClientData.stealthBlockedWeaponSpecific = packet.stealthBlockedWeaponSpecific;
                    ClientData.assassinationWeaponSpecific = packet.assassinationWeaponSpecific;
                });
            }
            return null;
        }
    }

    public static class ClientInitPacket
    implements IMessage {
        public boolean soulSight;
        public boolean usePlayerSenses;
        public boolean allowTargetingName;
        public boolean allowTargetingHP;
        public boolean allowTargetingThreat;
        public boolean allowTargetingDistance;
        public WeaponEntry normalDefault;
        public WeaponEntry rangedDefault;
        public WeaponEntry stealthDefault;
        public WeaponEntry rangedStealthDefault;
        public WeaponEntry normalBlockedDefault;
        public WeaponEntry rangedBlockedDefault;
        public WeaponEntry stealthBlockedDefault;
        public WeaponEntry rangedStealthBlockedDefault;
        public WeaponEntry assassinationDefault;
        public WeaponEntry rangedAssassinationDefault;
        public ArrayList<WeaponEntry> normalWeaponSpecific = new ArrayList();
        public ArrayList<WeaponEntry> stealthWeaponSpecific = new ArrayList();
        public ArrayList<WeaponEntry> normalBlockedWeaponSpecific = new ArrayList();
        public ArrayList<WeaponEntry> stealthBlockedWeaponSpecific = new ArrayList();
        public ArrayList<WeaponEntry> assassinationWeaponSpecific = new ArrayList();

        public ClientInitPacket() {
        }

        public ClientInitPacket(EntityPlayerMP player) {
            this.soulSight = EntitySightData.hasSoulSight((Entity)player);
            if (this.soulSight) {
                oldSoulSightClients.add(player);
            }
            if (MCTools.isOP((EntityPlayerMP)player)) {
                this.allowTargetingName = DynamicStealthConfig.serverSettings.hud.targeting.allowNameElement > 0;
                this.allowTargetingHP = DynamicStealthConfig.serverSettings.hud.targeting.allowHPElement > 0;
                this.allowTargetingThreat = DynamicStealthConfig.serverSettings.hud.targeting.allowThreatElement > 0;
                this.allowTargetingDistance = DynamicStealthConfig.serverSettings.hud.targeting.allowDistanceElement > 0;
            } else {
                this.allowTargetingName = DynamicStealthConfig.serverSettings.hud.targeting.allowNameElement > 1;
                this.allowTargetingHP = DynamicStealthConfig.serverSettings.hud.targeting.allowHPElement > 1;
                this.allowTargetingThreat = DynamicStealthConfig.serverSettings.hud.targeting.allowThreatElement > 1;
                this.allowTargetingDistance = DynamicStealthConfig.serverSettings.hud.targeting.allowDistanceElement > 1;
            }
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.soulSight);
            buf.writeBoolean(DynamicStealthConfig.serverSettings.senses.usePlayerSenses);
            buf.writeBoolean(this.allowTargetingName);
            buf.writeBoolean(this.allowTargetingHP);
            buf.writeBoolean(this.allowTargetingThreat);
            buf.writeBoolean(this.allowTargetingDistance);
            CWeaponEntry cWeaponEntry = new CWeaponEntry();
            for (WeaponEntry weaponEntry : new WeaponEntry[]{AttackData.normalDefault, AttackData.rangedDefault, AttackData.stealthDefault, AttackData.rangedStealthDefault, AttackData.normalBlockedDefault, AttackData.rangedBlockedDefault, AttackData.stealthBlockedDefault, AttackData.rangedStealthBlockedDefault, AttackData.assassinationDefault, AttackData.rangedAssassinationDefault}) {
                cWeaponEntry.set(weaponEntry).write(buf);
            }
            for (ArrayList list : new ArrayList[]{AttackData.normalWeaponSpecific, AttackData.stealthWeaponSpecific, AttackData.normalBlockedWeaponSpecific, AttackData.stealthBlockedWeaponSpecific, AttackData.assassinationWeaponSpecific}) {
                buf.writeInt(list.size());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    WeaponEntry weaponEntry = (WeaponEntry)iterator.next();
                    cWeaponEntry.set(weaponEntry).write(buf);
                }
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.soulSight = buf.readBoolean();
            this.usePlayerSenses = buf.readBoolean();
            this.allowTargetingName = buf.readBoolean();
            this.allowTargetingHP = buf.readBoolean();
            this.allowTargetingThreat = buf.readBoolean();
            this.allowTargetingDistance = buf.readBoolean();
            CWeaponEntry cWeaponEntry = new CWeaponEntry();
            this.normalDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.rangedDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.stealthDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.rangedStealthDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.normalBlockedDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.rangedBlockedDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.stealthBlockedDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.rangedStealthBlockedDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.assassinationDefault = cWeaponEntry.read((ByteBuf)buf).value;
            this.rangedAssassinationDefault = cWeaponEntry.read((ByteBuf)buf).value;
            for (ArrayList list : new ArrayList[]{this.normalWeaponSpecific, this.stealthWeaponSpecific, this.normalBlockedWeaponSpecific, this.stealthBlockedWeaponSpecific, this.assassinationWeaponSpecific}) {
                list.clear();
                for (int i = buf.readInt(); i > 0; --i) {
                    list.add(cWeaponEntry.read((ByteBuf)buf).value);
                }
            }
        }
    }

    public static class SoulSightPacketHandler
    implements IMessageHandler<SoulSightPacket, IMessage> {
        public IMessage onMessage(SoulSightPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.soulSight = packet.soulSight;
                });
            }
            return null;
        }
    }

    public static class SoulSightPacket
    implements IMessage {
        boolean soulSight;

        public SoulSightPacket() {
        }

        public SoulSightPacket(boolean soulSight) {
            this.soulSight = soulSight;
        }

        public void toBytes(ByteBuf buf) {
            buf.writeBoolean(this.soulSight);
        }

        public void fromBytes(ByteBuf buf) {
            this.soulSight = buf.readBoolean();
        }
    }

    public static class VisibilityPacketHandler
    implements IMessageHandler<VisibilityPacket, IMessage> {
        public IMessage onMessage(VisibilityPacket packet, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft.func_71410_x().func_152344_a(() -> {
                    ClientData.previousVisibilityMap2 = ClientData.previousVisibilityMap1;
                    ClientData.previousVisibilityMap1 = ClientData.visibilityMap;
                    ClientData.visibilityMap = packet.visibilityMap;
                });
            }
            return null;
        }
    }

    public static class VisibilityPacket
    implements IMessage {
        LinkedHashMap<Entity, Double> inputMap;
        LinkedHashMap<Integer, Float> visibilityMap;

        public VisibilityPacket() {
        }

        public VisibilityPacket(EntityPlayerMP player) {
            this.inputMap = Sight.seenEntities(player);
        }

        public void toBytes(ByteBuf buf) {
            int i = this.inputMap.size();
            buf.writeInt(i);
            for (Map.Entry<Entity, Double> entry : this.inputMap.entrySet()) {
                buf.writeInt(entry.getKey().func_145782_y());
                buf.writeFloat((float)(1.0 - entry.getValue()));
            }
        }

        public void fromBytes(ByteBuf buf) {
            this.visibilityMap = new LinkedHashMap();
            for (int i = buf.readInt(); i > 0; --i) {
                this.visibilityMap.put(buf.readInt(), Float.valueOf(buf.readFloat()));
            }
        }
    }
}

