/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.config.client.hud;

import net.minecraftforge.common.config.Config;

public class TargetingFilterConfig {
    @Config.Name(value="020 Max Distance")
    @Config.LangKey(value="dynamicstealth.config.targetingMaxDist")
    @Config.Comment(value={"The maximum distance at which the targeting system will acquire a target"})
    public int maxDist = Integer.MAX_VALUE;
    @Config.Name(value="030 Max Angle")
    @Config.LangKey(value="dynamicstealth.config.targetingMaxAngle")
    @Config.Comment(value={"The maximum angle at which the targeting system will acquire a target", "If set to -1, targeting is disabled"})
    @Config.RangeInt(min=-1, max=180)
    public int maxAngle = 180;
    @Config.Name(value="070 Bypass")
    @Config.LangKey(value="dynamicstealth.config.targetingBypass")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an entity that bypasses the threat system"})
    public boolean bypass = true;
    @Config.Name(value="071 Idle (Passive)")
    @Config.LangKey(value="dynamicstealth.config.targetingIdlePassive")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an idle passive entity"})
    public boolean idlePassive = false;
    @Config.Name(value="072 Idle (Non-Passive)")
    @Config.LangKey(value="dynamicstealth.config.targetingIdleNonPassive")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an idle non-passive entity.  This also applies to idle passive entities if the server has passive recognition disabled"})
    public boolean idleNonPassive = true;
    @Config.Name(value="073 Attacking You")
    @Config.LangKey(value="dynamicstealth.config.targetingAtkYou")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an entity that is attacking YOU"})
    public boolean attackingYou = true;
    @Config.Name(value="074 Attacking Other")
    @Config.LangKey(value="dynamicstealth.config.targetingAtkOther")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an entity that is attacking something besides you"})
    public boolean attackingOther = true;
    @Config.Name(value="075 Searching")
    @Config.LangKey(value="dynamicstealth.config.targetingSearching")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on an entity that is actively searching for a target"})
    public boolean alert = true;
    @Config.Name(value="076 Fleeing (Passive)")
    @Config.LangKey(value="dynamicstealth.config.targetingFleePassive")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on a passive entity that is fleeing"})
    public boolean fleeingPassive = false;
    @Config.Name(value="077 Fleeing (Non-Passive)")
    @Config.LangKey(value="dynamicstealth.config.targetingFlee")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on a non-passive entity that is fleeing"})
    public boolean fleeingNonPassive = true;
    @Config.Name(value="090 Dazed")
    @Config.LangKey(value="dynamicstealth.config.targetingDazed")
    @Config.Comment(value={"If true, the targeting HUD shows when focused on a dazed entity"})
    public boolean dazed = true;
}

