/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server;

import com.fantasticsource.dynamicstealth.server.GlobalDefaultsAndData;
import com.fantasticsource.dynamicstealth.server.threat.Threat;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class CombatTracker {
    private static final int ITERATION_FREQUENCY = 72000;
    private static LinkedHashMap<EntityLivingBase, Long> successfulAttackTimes = new LinkedHashMap();
    private static LinkedHashMap<EntityLivingBase, Long> successfulPathTimes = new LinkedHashMap();
    private static LinkedHashMap<EntityLivingBase, Long> idleTimes = new LinkedHashMap();
    private static LinkedHashMap<EntityLivingBase, Long> noTargetTimes = new LinkedHashMap();

    public static void update(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            long modTick = ServerTickTimer.currentTick() % 72000L;
            if (modTick == 1000L) {
                CombatTracker.removeAllUnusedTimes(successfulAttackTimes);
            } else if (modTick == 2000L) {
                CombatTracker.removeAllUnusedTimes(successfulPathTimes);
            } else if (modTick == 3000L) {
                CombatTracker.removeAllUnusedTimes(idleTimes);
            } else if (modTick == 4000L) {
                CombatTracker.removeAllUnusedTimes(noTargetTimes);
            }
        }
    }

    private static void removeAllUnusedTimes(LinkedHashMap<EntityLivingBase, Long> map) {
        map.entrySet().removeIf(entry -> !MCTools.entityIsValid((Entity)((Entity)entry.getKey())));
    }

    public static void setSuccessfulAttackTime(EntityLivingBase livingBase) {
        CombatTracker.setSuccessfulAttackTime(livingBase, ServerTickTimer.currentTick());
    }

    public static void setSuccessfulAttackTime(EntityLivingBase livingBase, long time) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        successfulAttackTimes.put(livingBase, time);
    }

    public static long lastSuccessfulAttackTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase) || !successfulAttackTimes.containsKey(livingBase)) {
            return -1L;
        }
        return successfulAttackTimes.get(livingBase);
    }

    public static long timeSinceLastSuccessfulAttack(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return Long.MAX_VALUE;
        }
        long result = CombatTracker.lastSuccessfulAttackTime(livingBase);
        return result == -1L ? Long.MAX_VALUE : ServerTickTimer.currentTick() - result;
    }

    public static boolean pathReachesThreatTarget(EntityLiving living) {
        return CombatTracker.pathReachesThreatTarget(living, null);
    }

    public static boolean pathReachesThreatTarget(EntityLiving living, Path path) {
        block8: {
            block7: {
                if (GlobalDefaultsAndData.isFullBypass((Entity)living)) {
                    return false;
                }
                if (path == null) {
                    path = living.func_70661_as().func_75505_d();
                }
                if (path == null) {
                    return false;
                }
                EntityLivingBase target = Threat.getTarget((EntityLivingBase)living);
                if (target == null) {
                    return false;
                }
                PathPoint point = path.func_75870_c();
                if (point == null) break block7;
                BlockPos blockPos = new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c);
                if (!(target.func_180425_c().func_177951_i((Vec3i)blockPos) > 2.0)) break block8;
            }
            return false;
        }
        CombatTracker.setSuccessfulPathTime((EntityLivingBase)living);
        return true;
    }

    public static void setSuccessfulPathTime(EntityLivingBase livingBase) {
        CombatTracker.setSuccessfulPathTime(livingBase, ServerTickTimer.currentTick());
    }

    public static void setSuccessfulPathTime(EntityLivingBase livingBase, long time) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        successfulPathTimes.put(livingBase, time);
    }

    public static long lastSuccessfulPathTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase) || !successfulPathTimes.containsKey(livingBase)) {
            return -1L;
        }
        return successfulPathTimes.get(livingBase);
    }

    public static long timeSinceLastSuccessfulPath(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return Long.MAX_VALUE;
        }
        long result = CombatTracker.lastSuccessfulPathTime(livingBase);
        return result == -1L ? Long.MAX_VALUE : ServerTickTimer.currentTick() - result;
    }

    public static void setIdleTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        idleTimes.remove(livingBase);
    }

    public static void setIdleTime(EntityLivingBase livingBase, long time) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        if (time == ServerTickTimer.currentTick()) {
            idleTimes.remove(livingBase);
        } else {
            idleTimes.put(livingBase, time);
        }
    }

    public static long lastIdleTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return -1L;
        }
        if (!idleTimes.containsKey(livingBase)) {
            return -1L;
        }
        return idleTimes.get(livingBase);
    }

    public static long timeSinceLastIdle(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return 0L;
        }
        long result = CombatTracker.lastIdleTime(livingBase);
        return result == -1L ? 0L : ServerTickTimer.currentTick() - result;
    }

    public static void setNoTargetTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        noTargetTimes.remove(livingBase);
    }

    public static void setNoTargetTime(EntityLivingBase livingBase, long time) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return;
        }
        if (time == ServerTickTimer.currentTick()) {
            noTargetTimes.remove(livingBase);
        } else {
            noTargetTimes.put(livingBase, time);
        }
    }

    public static long lastNoTargetTime(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase) || !noTargetTimes.containsKey(livingBase)) {
            return -1L;
        }
        return noTargetTimes.get(livingBase);
    }

    public static long timeSinceLastNoTarget(EntityLivingBase livingBase) {
        if (GlobalDefaultsAndData.isFullBypass((Entity)livingBase)) {
            return 0L;
        }
        long result = CombatTracker.lastNoTargetTime(livingBase);
        return result == -1L ? 0L : ServerTickTimer.currentTick() - result;
    }
}

