/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.mctools.MCTools;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class EntityAIData {
    private static LinkedHashMap<Class<? extends Entity>, LinkedHashMap<String, Integer>> entityHeadTurnSpeeds;
    private static LinkedHashMap<Class<? extends Entity>, LinkedHashMap<String, Integer>> entityFleePercentages;

    public static void update() {
        entityHeadTurnSpeeds = new LinkedHashMap();
        entityFleePercentages = new LinkedHashMap();
        MCTools.populateEntityIntMap((String[])DynamicStealthConfig.serverSettings.ai.y_entityOverrides.headTurnSpeed, entityHeadTurnSpeeds);
        MCTools.populateEntityIntMap((String[])DynamicStealthConfig.serverSettings.ai.y_entityOverrides.specificFleeThresholds, entityFleePercentages);
    }

    public static int headTurnSpeed(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return 0;
        }
        return MCTools.entityMatchesIntMapOrDefault((Entity)entity, entityHeadTurnSpeeds, (int)DynamicStealthConfig.serverSettings.ai.headTurnSpeed);
    }

    public static int fleeThreshold(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return 0;
        }
        return MCTools.entityMatchesIntMapOrDefault((Entity)entity, entityFleePercentages, (int)DynamicStealthConfig.serverSettings.ai.flee.threshold);
    }
}

