/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai.edited;

import com.fantasticsource.dynamicstealth.server.ai.edited.AITargetEdit;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.MathHelper;

public class AIAttackRangedEdit
extends EntityAIBase {
    private final EntityLiving attacker;
    private final IRangedAttackMob rangedAttacker;
    private final double entityMoveSpeed;
    private final int attackIntervalMin;
    private final int attackIntervalRange;
    private final float attackRadius;
    private final float attackRadiusSquared;
    private EntityLivingBase target;
    private int timer;
    private int seeTime;
    private Path path = null;

    public AIAttackRangedEdit(EntityAIAttackRanged oldAI) {
        this.rangedAttacker = oldAI.field_82641_b;
        this.entityMoveSpeed = oldAI.field_75321_e;
        this.attackIntervalMin = oldAI.field_96561_g;
        this.attackRadius = oldAI.field_96562_i;
        this.attackIntervalRange = oldAI.field_75325_h - this.attackIntervalMin;
        this.attackRadiusSquared = this.attackRadius * this.attackRadius;
        this.attacker = (EntityLiving)this.rangedAttacker;
        this.timer = -1;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase testTarget = this.attacker.func_70638_az();
        if (AITargetEdit.isSuitableTarget(this.attacker, testTarget)) {
            this.target = testTarget;
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.timer = -1;
        if (this.path != null && this.path.equals(this.attacker.func_70661_as().func_75505_d())) {
            this.attacker.func_70661_as().func_75499_g();
        }
        this.path = null;
    }

    public void func_75246_d() {
        double distSquared = this.attacker.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
        ++this.seeTime;
        if (distSquared <= (double)this.attackRadiusSquared && this.seeTime >= 20) {
            if (this.path != null && this.path.equals(this.attacker.func_70661_as().func_75505_d())) {
                this.attacker.func_70661_as().func_75499_g();
            }
            this.path = null;
        } else {
            this.path = this.attacker.func_70661_as().func_75494_a((Entity)this.target);
            this.attacker.func_70661_as().func_75484_a(this.path, this.entityMoveSpeed);
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (--this.timer == 0) {
            float distanceFactor = MathHelper.func_76133_a((double)distSquared) / this.attackRadius;
            this.rangedAttacker.func_82196_d(this.target, MathHelper.func_76131_a((float)distanceFactor, (float)0.1f, (float)1.0f));
            this.timer = MathHelper.func_76141_d((float)((float)this.attackIntervalMin + distanceFactor * (float)this.attackIntervalRange));
        } else if (this.timer < 0) {
            float distanceFactor = MathHelper.func_76133_a((double)distSquared) / this.attackRadius;
            this.timer = MathHelper.func_76141_d((float)((float)this.attackIntervalMin + distanceFactor * (float)this.attackIntervalRange));
        }
    }
}

