/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.ai.edited;

import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import com.google.common.base.Predicate;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityLookHelper;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.pathfinding.PathNodeType;

public class AIParrotFollowEdit
extends EntityAIBase {
    private final EntityLiving searcher;
    private final Predicate<EntityLiving> followPredicate;
    private final double speedModifier;
    private final PathNavigate navigator;
    private final float stopDistance;
    private final float areaSize;
    private EntityLiving target;
    private Path path = null;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public AIParrotFollowEdit(EntityAIFollow oldAI) {
        this.searcher = oldAI.field_192372_a;
        this.speedModifier = oldAI.field_192375_d;
        this.stopDistance = oldAI.field_192378_g;
        this.areaSize = oldAI.field_192380_i;
        this.followPredicate = target -> target != null && this.searcher.getClass() != target.getClass();
        this.navigator = this.searcher.func_70661_as();
        if (!(this.navigator instanceof PathNavigateGround) && !(this.navigator instanceof PathNavigateFlying)) {
            throw new IllegalArgumentException("Unsupported mob type for FollowMobGoal");
        }
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        List list = this.searcher.field_70170_p.func_175647_a(EntityLiving.class, this.searcher.func_174813_aQ().func_186662_g((double)this.areaSize), this.followPredicate);
        if (list.isEmpty()) {
            return false;
        }
        ExplicitPriorityQueue queue = new ExplicitPriorityQueue(list.size());
        for (EntityLiving entity : list) {
            queue.add((Object)entity, entity.func_70068_e((Entity)this.searcher));
        }
        this.target = (EntityLiving)queue.poll();
        while (this.target != null && !Sight.canSee((EntityLivingBase)this.searcher, (Entity)this.target, false)) {
            this.target = (EntityLiving)queue.poll();
        }
        return this.target != null;
    }

    public boolean func_75253_b() {
        return Sight.canSee((EntityLivingBase)this.searcher, (Entity)this.target, false) && !this.navigator.func_75500_f() && this.searcher.func_70068_e((Entity)this.target) > Math.pow(this.stopDistance, 2.0);
    }

    public void func_75249_e() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.searcher.func_184643_a(PathNodeType.WATER);
        this.searcher.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    public void func_75251_c() {
        this.target = null;
        this.searcher.func_184644_a(PathNodeType.WATER, this.oldWaterCost);
        if (this.path != null && this.path.equals(this.navigator.func_75505_d())) {
            this.navigator.func_75499_g();
        }
        this.path = null;
    }

    public void func_75246_d() {
        if (this.target != null && !this.searcher.func_110167_bD()) {
            this.searcher.func_70671_ap().func_75651_a((Entity)this.target, 10.0f, (float)this.searcher.func_70646_bf());
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = 10;
                double d0 = this.searcher.field_70165_t - this.target.field_70165_t;
                double d1 = this.searcher.field_70163_u - this.target.field_70163_u;
                double d2 = this.searcher.field_70161_v - this.target.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                if (d3 > (double)(this.stopDistance * this.stopDistance)) {
                    this.path = this.navigator.func_75494_a((Entity)this.target);
                    this.navigator.func_75484_a(this.path, this.speedModifier);
                } else {
                    if (this.path != null && this.path.equals(this.navigator.func_75505_d())) {
                        this.navigator.func_75499_g();
                    }
                    EntityLookHelper entitylookhelper = this.target.func_70671_ap();
                    if (d3 <= (double)this.stopDistance || entitylookhelper.func_180423_e() == this.searcher.field_70165_t && entitylookhelper.func_180422_f() == this.searcher.field_70163_u && entitylookhelper.func_180421_g() == this.searcher.field_70161_v) {
                        double d4 = this.target.field_70165_t - this.searcher.field_70165_t;
                        double d5 = this.target.field_70161_v - this.searcher.field_70161_v;
                        this.path = this.navigator.func_75488_a(this.searcher.field_70165_t - d4, this.searcher.field_70163_u, this.searcher.field_70161_v - d5);
                        this.navigator.func_75484_a(this.path, this.speedModifier);
                    }
                }
            }
        }
    }
}

