/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.entitytracker;

import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLeashKnot;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.ai.attributes.AttributeMap;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityPainting;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityDragonFireball;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketEntity;
import net.minecraft.network.play.server.SPacketEntityEffect;
import net.minecraft.network.play.server.SPacketEntityEquipment;
import net.minecraft.network.play.server.SPacketEntityHeadLook;
import net.minecraft.network.play.server.SPacketEntityMetadata;
import net.minecraft.network.play.server.SPacketEntityProperties;
import net.minecraft.network.play.server.SPacketEntityTeleport;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.network.play.server.SPacketSetPassengers;
import net.minecraft.network.play.server.SPacketSpawnExperienceOrb;
import net.minecraft.network.play.server.SPacketSpawnMob;
import net.minecraft.network.play.server.SPacketSpawnObject;
import net.minecraft.network.play.server.SPacketSpawnPainting;
import net.minecraft.network.play.server.SPacketSpawnPlayer;
import net.minecraft.network.play.server.SPacketUseBed;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DSEntityTrackerEntry
extends EntityTrackerEntry {
    protected static final Logger LOGGER = LogManager.getLogger();
    protected final Entity entity;
    protected final boolean isLivingBase;
    protected final boolean isPlayer;
    protected final EntityLivingBase livingBase;
    protected final EntityPlayerMP player;
    protected final int field_73131_c;
    protected final boolean field_73143_t;
    protected int field_73142_u;
    protected int field_73127_g;
    protected int field_73139_h;
    protected int field_73140_i;
    protected boolean field_180234_y;
    protected boolean field_73141_v;
    protected long field_73128_d;
    protected long field_73129_e;
    protected long field_73126_f;
    protected double lastMotionX;
    protected double lastMotionY;
    protected double lastMotionZ;
    private List<Entity> passengers = Collections.emptyList();

    public DSEntityTrackerEntry(Entity entity, int maxRange, int currentRange, int updateFrequency, boolean sendVelocityUpdates) {
        super(entity, maxRange, currentRange, updateFrequency, sendVelocityUpdates);
        this.entity = entity;
        this.isLivingBase = entity instanceof EntityLivingBase;
        this.livingBase = this.isLivingBase ? (EntityLivingBase)entity : null;
        this.isPlayer = entity instanceof EntityPlayerMP;
        this.player = this.isPlayer ? (EntityPlayerMP)entity : null;
        this.field_73131_c = updateFrequency;
        this.field_73143_t = sendVelocityUpdates;
        this.field_180234_y = entity.field_70122_E;
        this.field_73128_d = EntityTracker.func_187253_a((double)entity.field_70165_t);
        this.field_73129_e = EntityTracker.func_187253_a((double)entity.field_70163_u);
        this.field_73126_f = EntityTracker.func_187253_a((double)entity.field_70161_v);
        this.field_73127_g = MathHelper.func_76141_d((float)(entity.field_70177_z * 256.0f / 360.0f));
        this.field_73139_h = MathHelper.func_76141_d((float)(entity.field_70125_A * 256.0f / 360.0f));
        this.field_73140_i = MathHelper.func_76141_d((float)(entity.func_70079_am() * 256.0f / 360.0f));
    }

    public boolean equals(Object entityTrackerEntry) {
        return entityTrackerEntry instanceof DSEntityTrackerEntry && ((DSEntityTrackerEntry)((Object)entityTrackerEntry)).entity.func_145782_y() == this.entity.func_145782_y();
    }

    public int hashCode() {
        return this.entity.func_145782_y();
    }

    public void func_73122_a(List<EntityPlayer> players) {
        List list = this.entity.func_184188_bt();
        if (!list.equals(this.passengers)) {
            this.passengers = list;
            this.func_151259_a((Packet<?>)new SPacketSetPassengers(this.entity));
        }
        if (this.field_73136_m % this.field_73131_c == 0 || this.entity.field_70160_al || this.entity.func_184212_Q().func_187223_a()) {
            if (this.entity.func_184218_aH()) {
                boolean flag3;
                int j1 = MathHelper.func_76141_d((float)(this.entity.field_70177_z * 256.0f / 360.0f));
                int l1 = MathHelper.func_76141_d((float)(this.entity.field_70125_A * 256.0f / 360.0f));
                boolean bl = flag3 = Math.abs(j1 - this.field_73127_g) >= 1 || Math.abs(l1 - this.field_73139_h) >= 1;
                if (flag3) {
                    this.func_151259_a((Packet<?>)new SPacketEntity.S16PacketEntityLook(this.entity.func_145782_y(), (byte)j1, (byte)l1, this.entity.field_70122_E));
                    this.field_73127_g = j1;
                    this.field_73139_h = l1;
                }
                this.field_73128_d = EntityTracker.func_187253_a((double)this.entity.field_70165_t);
                this.field_73129_e = EntityTracker.func_187253_a((double)this.entity.field_70163_u);
                this.field_73126_f = EntityTracker.func_187253_a((double)this.entity.field_70161_v);
                this.sendMetadata();
                this.field_73141_v = true;
            } else {
                boolean flag1;
                ++this.field_73142_u;
                long i1 = EntityTracker.func_187253_a((double)this.entity.field_70165_t);
                long i2 = EntityTracker.func_187253_a((double)this.entity.field_70163_u);
                long j2 = EntityTracker.func_187253_a((double)this.entity.field_70161_v);
                int k2 = MathHelper.func_76141_d((float)(this.entity.field_70177_z * 256.0f / 360.0f));
                int i = MathHelper.func_76141_d((float)(this.entity.field_70125_A * 256.0f / 360.0f));
                long j = i1 - this.field_73128_d;
                long k = i2 - this.field_73129_e;
                long l = j2 - this.field_73126_f;
                SPacketEntityTeleport packet1 = null;
                boolean flag = j * j + k * k + l * l >= 128L || this.field_73136_m % 60 == 0;
                boolean bl = flag1 = Math.abs(k2 - this.field_73127_g) >= 1 || Math.abs(i - this.field_73139_h) >= 1;
                if (this.field_73136_m > 0) {
                    if (j >= -32768L && j < 32768L && k >= -32768L && k < 32768L && l >= -32768L && l < 32768L && this.field_73142_u <= 400 && !this.field_73141_v && this.field_180234_y == this.entity.field_70122_E) {
                        if (!flag || !flag1) {
                            if (flag) {
                                packet1 = new SPacketEntity.S15PacketEntityRelMove(this.entity.func_145782_y(), j, k, l, this.entity.field_70122_E);
                            } else if (flag1) {
                                packet1 = new SPacketEntity.S16PacketEntityLook(this.entity.func_145782_y(), (byte)k2, (byte)i, this.entity.field_70122_E);
                            }
                        } else {
                            packet1 = new SPacketEntity.S17PacketEntityLookMove(this.entity.func_145782_y(), j, k, l, (byte)k2, (byte)i, this.entity.field_70122_E);
                        }
                    } else {
                        this.field_180234_y = this.entity.field_70122_E;
                        this.field_73142_u = 0;
                        this.func_187261_c();
                        packet1 = new SPacketEntityTeleport(this.entity);
                    }
                }
                if (this.field_73136_m > 0 && (this.field_73143_t || this.isLivingBase && this.livingBase.func_184613_cA()) && (this.lastMotionX != this.entity.field_70159_w || this.lastMotionY != this.entity.field_70181_x || this.lastMotionZ != this.entity.field_70179_y)) {
                    this.lastMotionX = this.entity.field_70159_w;
                    this.lastMotionY = this.entity.field_70181_x;
                    this.lastMotionZ = this.entity.field_70179_y;
                    this.func_151259_a((Packet<?>)new SPacketEntityVelocity(this.entity.func_145782_y(), this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y));
                }
                if (packet1 != null) {
                    this.func_151259_a((Packet<?>)packet1);
                }
                this.sendMetadata();
                if (flag) {
                    this.field_73128_d = i1;
                    this.field_73129_e = i2;
                    this.field_73126_f = j2;
                }
                if (flag1) {
                    this.field_73127_g = k2;
                    this.field_73139_h = i;
                }
                this.field_73141_v = false;
            }
            int k1 = MathHelper.func_76141_d((float)(this.entity.func_70079_am() * 256.0f / 360.0f));
            if (Math.abs(k1 - this.field_73140_i) >= 1) {
                this.func_151259_a((Packet<?>)new SPacketEntityHeadLook(this.entity, (byte)k1));
                this.field_73140_i = k1;
            }
            this.entity.field_70160_al = false;
        }
        ++this.field_73136_m;
        if (this.entity.field_70133_I) {
            this.func_151261_b((Packet<?>)new SPacketEntityVelocity(this.entity));
            this.entity.field_70133_I = false;
        }
    }

    private void sendMetadata() {
        EntityDataManager entitydatamanager = this.entity.func_184212_Q();
        if (entitydatamanager.func_187223_a()) {
            this.func_151261_b((Packet<?>)new SPacketEntityMetadata(this.entity.func_145782_y(), entitydatamanager, false));
        }
        if (this.isLivingBase) {
            AttributeMap attributemap = (AttributeMap)this.livingBase.func_110140_aT();
            Set set = attributemap.func_111161_b();
            if (!set.isEmpty()) {
                this.func_151261_b((Packet<?>)new SPacketEntityProperties(this.entity.func_145782_y(), (Collection)set));
            }
            set.clear();
        }
    }

    public void func_151259_a(Packet<?> packetIn) {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            entityplayermp.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_151261_b(Packet<?> packetIn) {
        this.func_151259_a(packetIn);
        if (this.isPlayer) {
            this.player.field_71135_a.func_147359_a(packetIn);
        }
    }

    public void func_73119_a() {
        for (EntityPlayerMP entityplayermp : this.field_73134_o) {
            this.entity.func_184203_c(entityplayermp);
            entityplayermp.func_152339_d(this.entity);
        }
    }

    public void func_73118_a(EntityPlayerMP playerMP) {
        if (this.field_73134_o.contains(playerMP)) {
            this.entity.func_184203_c(playerMP);
            playerMP.func_152339_d(this.entity);
            this.field_73134_o.remove(playerMP);
        }
    }

    public void func_73117_b(EntityPlayerMP player) {
        if (player != this.entity) {
            if (this.func_180233_c(player)) {
                if (!this.field_73134_o.contains(player)) {
                    AttributeMap attributemap;
                    Collection collection;
                    this.field_73134_o.add(player);
                    Packet<?> packet = this.createSpawnPacket();
                    player.field_71135_a.func_147359_a(packet);
                    if (!this.entity.func_184212_Q().func_187228_d()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityMetadata(this.entity.func_145782_y(), this.entity.func_184212_Q(), true));
                    }
                    if (this.isLivingBase && !(collection = (attributemap = (AttributeMap)this.livingBase.func_110140_aT()).func_111160_c()).isEmpty()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityProperties(this.entity.func_145782_y(), collection));
                    }
                    this.lastMotionX = this.entity.field_70159_w;
                    this.lastMotionY = this.entity.field_70181_x;
                    this.lastMotionZ = this.entity.field_70179_y;
                    if (!(packet instanceof SPacketSpawnMob) && (this.field_73143_t || this.isLivingBase && this.livingBase.func_184613_cA())) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(this.entity.func_145782_y(), this.entity.field_70159_w, this.entity.field_70181_x, this.entity.field_70179_y));
                    }
                    if (this.isLivingBase) {
                        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
                            ItemStack itemstack = this.livingBase.func_184582_a(entityequipmentslot);
                            if (itemstack.func_190926_b()) continue;
                            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEquipment(this.entity.func_145782_y(), entityequipmentslot, itemstack));
                        }
                    }
                    if (this.isPlayer && this.player.func_70608_bn()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketUseBed((EntityPlayer)this.player, new BlockPos(this.entity)));
                    }
                    if (this.isLivingBase) {
                        for (PotionEffect potioneffect : this.livingBase.func_70651_bq()) {
                            player.field_71135_a.func_147359_a((Packet)new SPacketEntityEffect(this.entity.func_145782_y(), potioneffect));
                        }
                    }
                    if (!this.entity.func_184188_bt().isEmpty()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.entity));
                    }
                    if (this.entity.func_184218_aH()) {
                        player.field_71135_a.func_147359_a((Packet)new SPacketSetPassengers(this.entity.func_184187_bx()));
                    }
                    this.entity.func_184178_b(player);
                    player.func_184848_d(this.entity);
                    ForgeEventFactory.onStartEntityTracking((Entity)this.entity, (EntityPlayer)player);
                }
            } else if (this.field_73134_o.contains(player)) {
                this.field_73134_o.remove(player);
                this.entity.func_184203_c(player);
                player.func_152339_d(this.entity);
                ForgeEventFactory.onStopEntityTracking((Entity)this.entity, (EntityPlayer)player);
            }
        }
    }

    public boolean func_180233_c(EntityPlayerMP playerMP) {
        return Sight.canSee((EntityLivingBase)playerMP, this.entity, true);
    }

    public void func_73125_b(List<EntityPlayer> players) {
        for (EntityPlayer player : players) {
            this.func_73117_b((EntityPlayerMP)player);
        }
    }

    private Packet<?> createSpawnPacket() {
        Packet pkt;
        if (this.entity.field_70128_L) {
            LOGGER.warn("Fetching addPacket for removed entity");
        }
        if ((pkt = FMLNetworkHandler.getEntitySpawningPacket((Entity)this.entity)) != null) {
            return pkt;
        }
        if (this.isPlayer) {
            return new SPacketSpawnPlayer((EntityPlayer)this.player);
        }
        if (this.isLivingBase && this.entity instanceof IAnimals) {
            this.field_73140_i = MathHelper.func_76141_d((float)(this.entity.func_70079_am() * 256.0f / 360.0f));
            return new SPacketSpawnMob(this.livingBase);
        }
        if (this.entity instanceof EntityArmorStand) {
            return new SPacketSpawnObject(this.entity, 78);
        }
        if (this.entity instanceof EntityPainting) {
            return new SPacketSpawnPainting((EntityPainting)this.entity);
        }
        if (this.entity instanceof EntityItem) {
            return new SPacketSpawnObject(this.entity, 2, 1);
        }
        if (this.entity instanceof EntityMinecart) {
            return new SPacketSpawnObject(this.entity, 10, ((EntityMinecart)this.entity).func_184264_v().func_184956_a());
        }
        if (this.entity instanceof EntityBoat) {
            return new SPacketSpawnObject(this.entity, 1);
        }
        if (this.entity instanceof EntityXPOrb) {
            return new SPacketSpawnExperienceOrb((EntityXPOrb)this.entity);
        }
        if (this.entity instanceof EntityFishHook) {
            EntityPlayer angler = ((EntityFishHook)this.entity).func_190619_l();
            return new SPacketSpawnObject(this.entity, 90, angler == null ? this.entity.func_145782_y() : angler.func_145782_y());
        }
        if (this.entity instanceof EntitySpectralArrow) {
            Entity archer = ((EntitySpectralArrow)this.entity).field_70250_c;
            return new SPacketSpawnObject(this.entity, 91, 1 + (archer == null ? this.entity.func_145782_y() : archer.func_145782_y()));
        }
        if (this.entity instanceof EntityTippedArrow) {
            Entity archer = ((EntityArrow)this.entity).field_70250_c;
            return new SPacketSpawnObject(this.entity, 60, 1 + (archer == null ? this.entity.func_145782_y() : archer.func_145782_y()));
        }
        if (this.entity instanceof EntitySnowball) {
            return new SPacketSpawnObject(this.entity, 61);
        }
        if (this.entity instanceof EntityLlamaSpit) {
            return new SPacketSpawnObject(this.entity, 68);
        }
        if (this.entity instanceof EntityPotion) {
            return new SPacketSpawnObject(this.entity, 73);
        }
        if (this.entity instanceof EntityExpBottle) {
            return new SPacketSpawnObject(this.entity, 75);
        }
        if (this.entity instanceof EntityEnderPearl) {
            return new SPacketSpawnObject(this.entity, 65);
        }
        if (this.entity instanceof EntityEnderEye) {
            return new SPacketSpawnObject(this.entity, 72);
        }
        if (this.entity instanceof EntityFireworkRocket) {
            return new SPacketSpawnObject(this.entity, 76);
        }
        if (this.entity instanceof EntityFireball) {
            EntityFireball entityfireball = (EntityFireball)this.entity;
            int i = 63;
            if (this.entity instanceof EntitySmallFireball) {
                i = 64;
            } else if (this.entity instanceof EntityDragonFireball) {
                i = 93;
            } else if (this.entity instanceof EntityWitherSkull) {
                i = 66;
            }
            SPacketSpawnObject spacketspawnobject = entityfireball.field_70235_a != null ? new SPacketSpawnObject(this.entity, i, ((EntityFireball)this.entity).field_70235_a.func_145782_y()) : new SPacketSpawnObject(this.entity, i, 0);
            spacketspawnobject.func_149003_d((int)(entityfireball.field_70232_b * 8000.0));
            spacketspawnobject.func_149000_e((int)(entityfireball.field_70233_c * 8000.0));
            spacketspawnobject.func_149007_f((int)(entityfireball.field_70230_d * 8000.0));
            return spacketspawnobject;
        }
        if (this.entity instanceof EntityShulkerBullet) {
            SPacketSpawnObject spacketspawnobject1 = new SPacketSpawnObject(this.entity, 67, 0);
            spacketspawnobject1.func_149003_d((int)(this.entity.field_70159_w * 8000.0));
            spacketspawnobject1.func_149000_e((int)(this.entity.field_70181_x * 8000.0));
            spacketspawnobject1.func_149007_f((int)(this.entity.field_70179_y * 8000.0));
            return spacketspawnobject1;
        }
        if (this.entity instanceof EntityEgg) {
            return new SPacketSpawnObject(this.entity, 62);
        }
        if (this.entity instanceof EntityEvokerFangs) {
            return new SPacketSpawnObject(this.entity, 79);
        }
        if (this.entity instanceof EntityTNTPrimed) {
            return new SPacketSpawnObject(this.entity, 50);
        }
        if (this.entity instanceof EntityEnderCrystal) {
            return new SPacketSpawnObject(this.entity, 51);
        }
        if (this.entity instanceof EntityFallingBlock) {
            return new SPacketSpawnObject(this.entity, 70, Block.func_176210_f((IBlockState)((EntityFallingBlock)this.entity).func_175131_l()));
        }
        if (this.entity instanceof EntityItemFrame) {
            EntityItemFrame entityitemframe = (EntityItemFrame)this.entity;
            return new SPacketSpawnObject(this.entity, 71, entityitemframe.field_174860_b.func_176736_b(), entityitemframe.func_174857_n());
        }
        if (this.entity instanceof EntityLeashKnot) {
            return new SPacketSpawnObject(this.entity, 77, 0, ((EntityLeashKnot)this.entity).func_174857_n());
        }
        if (this.entity instanceof EntityAreaEffectCloud) {
            return new SPacketSpawnObject(this.entity, 3);
        }
        throw new IllegalArgumentException("Don't know how to send packet for " + this.entity.getClass() + "!");
    }

    public void func_73123_c(EntityPlayerMP playerMP) {
        if (this.field_73134_o.contains(playerMP)) {
            this.field_73134_o.remove(playerMP);
            this.entity.func_184203_c(playerMP);
            playerMP.func_152339_d(this.entity);
        }
    }

    public Entity func_187260_b() {
        return this.entity;
    }

    public void func_187259_a(int maxRangeIn) {
    }

    public void func_187261_c() {
    }
}

