/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.entitytracker;

import com.fantasticsource.dynamicstealth.server.GlobalDefaultsAndData;
import com.fantasticsource.dynamicstealth.server.entitytracker.DSEntityTrackerEntry;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.tools.Tools;
import java.util.Collections;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityArmorStand;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.item.EntityEnderEye;
import net.minecraft.entity.item.EntityEnderPearl;
import net.minecraft.entity.item.EntityExpBottle;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.entity.projectile.EntityFireball;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.entity.projectile.EntityLlamaSpit;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.entity.projectile.EntityShulkerBullet;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.entity.projectile.EntitySnowball;
import net.minecraft.network.Packet;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.registry.EntityRegistry;

public class EntityTrackerEdit
extends EntityTracker {
    public EntityTrackerEdit(WorldServer worldIn) {
        super(worldIn);
        this.field_72792_d = Tools.min((int[])new int[]{worldIn.func_73046_m().func_184103_al().func_72372_a(), EntitySightData.playerMaxSightDistance});
    }

    public void func_72786_a(Entity entityIn) {
        if (EntityRegistry.instance().tryTrackingEntity((EntityTracker)this, entityIn)) {
            return;
        }
        if (entityIn instanceof EntityPlayerMP) {
            this.func_72791_a(entityIn, 512, 2);
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityIn;
            for (EntityTrackerEntry trackerEntry : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
                trackerEntry.func_73117_b(entityplayermp);
            }
        } else if (entityIn instanceof EntityFishHook) {
            this.func_72785_a(entityIn, 64, 5, true);
        } else if (entityIn instanceof EntityArrow) {
            this.func_72785_a(entityIn, 64, 20, false);
        } else if (entityIn instanceof EntitySmallFireball) {
            this.func_72785_a(entityIn, 64, 10, false);
        } else if (entityIn instanceof EntityFireball) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntitySnowball) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityLlamaSpit) {
            this.func_72785_a(entityIn, 64, 10, false);
        } else if (entityIn instanceof EntityEnderPearl) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityEnderEye) {
            this.func_72785_a(entityIn, 64, 4, true);
        } else if (entityIn instanceof EntityEgg) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityPotion) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityExpBottle) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityFireworkRocket) {
            this.func_72785_a(entityIn, 64, 10, true);
        } else if (entityIn instanceof EntityItem) {
            this.func_72785_a(entityIn, 64, 20, true);
        } else if (entityIn instanceof EntityMinecart) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityBoat) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntitySquid) {
            this.func_72785_a(entityIn, 64, 3, true);
        } else if (entityIn instanceof EntityWither) {
            this.func_72785_a(entityIn, 80, 3, false);
        } else if (entityIn instanceof EntityShulkerBullet) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityBat) {
            this.func_72785_a(entityIn, 80, 3, false);
        } else if (entityIn instanceof EntityDragon) {
            this.func_72785_a(entityIn, 160, 3, true);
        } else if (entityIn instanceof IAnimals) {
            this.func_72785_a(entityIn, 80, 3, true);
        } else if (entityIn instanceof EntityTNTPrimed) {
            this.func_72785_a(entityIn, 160, 10, true);
        } else if (entityIn instanceof EntityFallingBlock) {
            this.func_72785_a(entityIn, 160, 20, true);
        } else if (entityIn instanceof EntityHanging) {
            this.func_72785_a(entityIn, 160, Integer.MAX_VALUE, false);
        } else if (entityIn instanceof EntityArmorStand) {
            this.func_72785_a(entityIn, 160, 3, true);
        } else if (entityIn instanceof EntityXPOrb) {
            this.func_72785_a(entityIn, 160, 20, true);
        } else if (entityIn instanceof EntityAreaEffectCloud) {
            this.func_72785_a(entityIn, 160, Integer.MAX_VALUE, true);
        } else if (entityIn instanceof EntityEnderCrystal) {
            this.func_72785_a(entityIn, 256, Integer.MAX_VALUE, false);
        } else if (entityIn instanceof EntityEvokerFangs) {
            this.func_72785_a(entityIn, 160, 2, false);
        }
    }

    public void func_72791_a(Entity entityIn, int trackingRange, int updateFrequency) {
        this.func_72785_a(entityIn, trackingRange, updateFrequency, false);
    }

    public void func_72785_a(Entity entityIn, int trackingRange, int updateFrequency, boolean sendVelocityUpdates) {
        if (this.field_72794_c.func_76037_b(entityIn.func_145782_y())) {
            System.err.println("Entity is already tracked: " + entityIn);
            Tools.printStackTrace();
        } else {
            DSEntityTrackerEntry entityEntry = !GlobalDefaultsAndData.isFullBypass(entityIn) ? new DSEntityTrackerEntry(entityIn, trackingRange, this.field_72792_d, updateFrequency, sendVelocityUpdates) : new EntityTrackerEntry(entityIn, trackingRange, this.field_72792_d, updateFrequency, sendVelocityUpdates);
            this.field_72793_b.add(entityEntry);
            this.field_72794_c.func_76038_a(entityIn.func_145782_y(), (Object)entityEntry);
            entityEntry.func_73125_b(this.field_72795_a.field_73010_i);
        }
    }

    public void func_72790_b(Entity entityIn) {
        EntityTrackerEntry entitytrackerentry;
        if (entityIn instanceof EntityPlayerMP) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)entityIn;
            for (EntityTrackerEntry entitytrackerentry2 : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
                entitytrackerentry2.func_73118_a(entityplayermp);
            }
        }
        if ((entitytrackerentry = (EntityTrackerEntry)this.field_72794_c.func_76049_d(entityIn.func_145782_y())) != null) {
            this.field_72793_b.remove(entitytrackerentry);
            entitytrackerentry.func_73119_a();
        }
    }

    public void func_72788_a() {
        for (EntityTrackerEntry trackerEntry : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
            trackerEntry.func_73122_a(this.field_72795_a.field_73010_i);
            for (EntityPlayer player : this.field_72795_a.field_73010_i) {
                trackerEntry.func_73117_b((EntityPlayerMP)player);
            }
        }
    }

    public void func_180245_a(EntityPlayerMP player) {
    }

    public void func_151247_a(Entity entityIn, Packet<?> packetIn) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entityIn.func_145782_y());
        if (entitytrackerentry != null) {
            entitytrackerentry.func_151259_a(packetIn);
        }
    }

    public Set<? extends EntityPlayer> getTrackingPlayers(Entity entity) {
        EntityTrackerEntry entry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entity.func_145782_y());
        if (entry == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(entry.field_73134_o);
    }

    public void func_151248_b(Entity entityIn, Packet<?> packetIn) {
        EntityTrackerEntry entitytrackerentry = (EntityTrackerEntry)this.field_72794_c.func_76041_a(entityIn.func_145782_y());
        if (entitytrackerentry != null) {
            entitytrackerentry.func_151261_b(packetIn);
        }
    }

    public void func_72787_a(EntityPlayerMP player) {
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
            entitytrackerentry.func_73123_c(player);
        }
    }

    public void func_85172_a(EntityPlayerMP player, Chunk chunkIn) {
        for (EntityTrackerEntry trackerEntry : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
            Entity entity = trackerEntry.func_187260_b();
            if (entity == player || entity.field_70176_ah != chunkIn.field_76635_g || entity.field_70164_aj != chunkIn.field_76647_h) continue;
            trackerEntry.func_73117_b(player);
        }
    }

    public void func_187252_a(int distance) {
        this.field_72792_d = Tools.min((int[])new int[]{(distance - 1) * 16, EntitySightData.playerMaxSightDistance});
        for (EntityTrackerEntry entitytrackerentry : this.field_72793_b.toArray(new EntityTrackerEntry[0])) {
            entitytrackerentry.func_187259_a(this.field_72792_d);
        }
    }
}

