/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.event.attacks;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.AssassinationConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.NormalAttackBlockedConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.NormalAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedAssassinationConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.RangedStealthAttackConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.StealthAttackBlockedConfig;
import com.fantasticsource.dynamicstealth.config.server.interactions.StealthAttackConfig;
import com.fantasticsource.dynamicstealth.server.event.attacks.WeaponEntry;
import com.fantasticsource.mctools.potions.Potions;
import com.fantasticsource.tools.ReflectionTool;
import java.lang.reflect.Method;
import java.util.ArrayList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class AttackData {
    protected static final Method ENTITY_LIVING_BASE_CAN_BLOCK_DAMAGE_SOURCE_METHOD = ReflectionTool.getMethod(EntityLivingBase.class, (String[])new String[]{"func_184583_d", "canBlockDamageSource"});
    public static WeaponEntry normalDefault = new WeaponEntry(null);
    public static WeaponEntry rangedDefault = new WeaponEntry(null);
    public static WeaponEntry stealthDefault = new WeaponEntry(null);
    public static WeaponEntry rangedStealthDefault = new WeaponEntry(null);
    public static WeaponEntry normalBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry rangedBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry stealthBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry rangedStealthBlockedDefault = new WeaponEntry(null);
    public static WeaponEntry assassinationDefault = new WeaponEntry(null);
    public static WeaponEntry rangedAssassinationDefault = new WeaponEntry(null);
    public static ArrayList<WeaponEntry> normalWeaponSpecific;
    public static ArrayList<WeaponEntry> stealthWeaponSpecific;
    public static ArrayList<WeaponEntry> normalBlockedWeaponSpecific;
    public static ArrayList<WeaponEntry> stealthBlockedWeaponSpecific;
    public static ArrayList<WeaponEntry> assassinationWeaponSpecific;

    public static boolean isBlocked(EntityLivingBase victim, DamageSource damageSource) {
        return (Boolean)ReflectionTool.invoke((Method)ENTITY_LIVING_BASE_CAN_BLOCK_DAMAGE_SOURCE_METHOD, (Object)victim, (Object[])new Object[]{damageSource});
    }

    public static void update() {
        NormalAttackConfig normalConfig = DynamicStealthConfig.serverSettings.interactions.attack;
        normalDefault = new WeaponEntry(null);
        AttackData.normalDefault.armorPenetration = normalConfig.armorPenetration;
        AttackData.normalDefault.damageMultiplier = normalConfig.damageMultiplier;
        AttackData.normalDefault.attackerEffects = Potions.parsePotions((String[])normalConfig.attackerEffects);
        AttackData.normalDefault.victimEffects = Potions.parsePotions((String[])normalConfig.victimEffects);
        normalWeaponSpecific = new ArrayList();
        for (String string : normalConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.generateWeaponSpecific(string, 0, false);
            if (entry == null) continue;
            normalWeaponSpecific.add(entry);
        }
        NormalAttackBlockedConfig normalBlockedConfig = DynamicStealthConfig.serverSettings.interactions.attackBlocked;
        normalBlockedDefault = new WeaponEntry(null);
        AttackData.normalBlockedDefault.armorPenetration = normalBlockedConfig.armorPenetration;
        AttackData.normalBlockedDefault.damageMultiplier = normalBlockedConfig.damageMultiplier;
        AttackData.normalBlockedDefault.attackerEffects = Potions.parsePotions((String[])normalBlockedConfig.attackerEffects);
        AttackData.normalBlockedDefault.victimEffects = Potions.parsePotions((String[])normalBlockedConfig.victimEffects);
        normalBlockedWeaponSpecific = new ArrayList();
        for (String string : normalBlockedConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.generateWeaponSpecific(string, 0, true);
            if (entry == null) continue;
            normalBlockedWeaponSpecific.add(entry);
        }
        RangedAttackConfig rangedConfig = DynamicStealthConfig.serverSettings.interactions.rangedAttack;
        AttackData.rangedDefault.armorPenetration = rangedConfig.armorPenetration;
        AttackData.rangedDefault.damageMultiplier = rangedConfig.damageMultiplier;
        AttackData.rangedDefault.attackerEffects = Potions.parsePotions((String[])rangedConfig.attackerEffects);
        AttackData.rangedDefault.victimEffects = Potions.parsePotions((String[])rangedConfig.victimEffects);
        rangedConfig = DynamicStealthConfig.serverSettings.interactions.rangedAttackBlocked;
        AttackData.rangedBlockedDefault.armorPenetration = rangedConfig.armorPenetration;
        AttackData.rangedBlockedDefault.damageMultiplier = rangedConfig.damageMultiplier;
        AttackData.rangedBlockedDefault.attackerEffects = Potions.parsePotions((String[])rangedConfig.attackerEffects);
        AttackData.rangedBlockedDefault.victimEffects = Potions.parsePotions((String[])rangedConfig.victimEffects);
        StealthAttackConfig stealthConfig = DynamicStealthConfig.serverSettings.interactions.stealthAttack;
        AttackData.stealthDefault.armorPenetration = stealthConfig.armorPenetration;
        AttackData.stealthDefault.damageMultiplier = stealthConfig.damageMultiplier;
        AttackData.stealthDefault.attackerEffects = Potions.parsePotions((String[])stealthConfig.attackerEffects);
        AttackData.stealthDefault.victimEffects = Potions.parsePotions((String[])stealthConfig.victimEffects);
        stealthWeaponSpecific = new ArrayList();
        for (String string : stealthConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.generateWeaponSpecific(string, 1, false);
            if (entry == null) continue;
            stealthWeaponSpecific.add(entry);
        }
        StealthAttackBlockedConfig stealthBlockedConfig = DynamicStealthConfig.serverSettings.interactions.stealthAttackBlocked;
        AttackData.stealthBlockedDefault.armorPenetration = stealthBlockedConfig.armorPenetration;
        AttackData.stealthBlockedDefault.damageMultiplier = stealthBlockedConfig.damageMultiplier;
        AttackData.stealthBlockedDefault.attackerEffects = Potions.parsePotions((String[])stealthBlockedConfig.attackerEffects);
        AttackData.stealthBlockedDefault.victimEffects = Potions.parsePotions((String[])stealthBlockedConfig.victimEffects);
        stealthBlockedWeaponSpecific = new ArrayList();
        for (String string : stealthBlockedConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.generateWeaponSpecific(string, 1, true);
            if (entry == null) continue;
            stealthBlockedWeaponSpecific.add(entry);
        }
        RangedStealthAttackConfig rangedStealthConfig = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttack;
        AttackData.rangedStealthDefault.armorPenetration = rangedStealthConfig.armorPenetration;
        AttackData.rangedStealthDefault.damageMultiplier = rangedStealthConfig.damageMultiplier;
        AttackData.rangedStealthDefault.attackerEffects = Potions.parsePotions((String[])rangedStealthConfig.attackerEffects);
        AttackData.rangedStealthDefault.victimEffects = Potions.parsePotions((String[])rangedStealthConfig.victimEffects);
        rangedStealthConfig = DynamicStealthConfig.serverSettings.interactions.rangedStealthAttackBlocked;
        AttackData.rangedStealthBlockedDefault.armorPenetration = rangedStealthConfig.armorPenetration;
        AttackData.rangedStealthBlockedDefault.damageMultiplier = rangedStealthConfig.damageMultiplier;
        AttackData.rangedStealthBlockedDefault.attackerEffects = Potions.parsePotions((String[])rangedStealthConfig.attackerEffects);
        AttackData.rangedStealthBlockedDefault.victimEffects = Potions.parsePotions((String[])rangedStealthConfig.victimEffects);
        AssassinationConfig assassinationConfig = DynamicStealthConfig.serverSettings.interactions.assassination;
        AttackData.assassinationDefault.attackerEffects = Potions.parsePotions((String[])assassinationConfig.attackerEffects);
        assassinationWeaponSpecific = new ArrayList();
        for (String string : assassinationConfig.weaponSpecific) {
            WeaponEntry entry = WeaponEntry.generateWeaponSpecific(string, 2, false);
            if (entry == null) continue;
            assassinationWeaponSpecific.add(entry);
        }
        RangedAssassinationConfig rangedAssassinationConfig = DynamicStealthConfig.serverSettings.interactions.rangedAssassination;
        AttackData.rangedAssassinationDefault.attackerEffects = Potions.parsePotions((String[])rangedAssassinationConfig.attackerEffects);
    }

    protected static WeaponEntry getDefault(int type, boolean isMelee, boolean isBlocked) {
        if (type == 0) {
            if (isMelee) {
                if (isBlocked) {
                    return normalBlockedDefault;
                }
                return normalDefault;
            }
            if (isBlocked) {
                return rangedBlockedDefault;
            }
            return rangedDefault;
        }
        if (type == 1) {
            if (isMelee) {
                if (isBlocked) {
                    return stealthBlockedDefault;
                }
                return stealthDefault;
            }
            if (isBlocked) {
                return rangedStealthBlockedDefault;
            }
            return rangedStealthDefault;
        }
        if (type == 2) {
            if (isMelee) {
                return assassinationDefault;
            }
            return rangedAssassinationDefault;
        }
        return null;
    }

    public static WeaponEntry getWeaponEntry(ItemStack itemStack, int type, boolean isBlocked) {
        if (itemStack == null) {
            return AttackData.getDefault(type, false, isBlocked);
        }
        ArrayList<ArrayList<WeaponEntry>> priorityOrderedLists = new ArrayList<ArrayList<WeaponEntry>>();
        if (type == 2) {
            priorityOrderedLists.add(assassinationWeaponSpecific);
        } else {
            if (type == 1) {
                if (isBlocked) {
                    priorityOrderedLists.add(stealthBlockedWeaponSpecific);
                }
                priorityOrderedLists.add(stealthWeaponSpecific);
            }
            if (isBlocked) {
                priorityOrderedLists.add(normalBlockedWeaponSpecific);
            }
            priorityOrderedLists.add(normalWeaponSpecific);
        }
        for (ArrayList arrayList : priorityOrderedLists) {
            for (WeaponEntry weaponEntry : arrayList) {
                if (!weaponEntry.filter.matches(itemStack)) continue;
                return weaponEntry;
            }
        }
        return AttackData.getDefault(type, true, isBlocked);
    }
}

