/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.event.attacks;

import com.fantasticsource.dynamicstealth.server.event.attacks.AttackDefaults;
import com.fantasticsource.mctools.items.ItemFilter;
import com.fantasticsource.mctools.potions.FantasticPotionEffect;
import com.fantasticsource.mctools.potions.Potions;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class WeaponEntry {
    public static final int TYPE_NORMAL = 0;
    public static final int TYPE_STEALTH = 1;
    public static final int TYPE_ASSASSINATION = 2;
    public ItemFilter filter;
    public boolean consumeItem = false;
    public boolean armorPenetration = false;
    public double damageMultiplier = 1.0;
    public ArrayList<FantasticPotionEffect> attackerEffects = new ArrayList();
    public ArrayList<FantasticPotionEffect> victimEffects = new ArrayList();

    public WeaponEntry(ItemFilter filter) {
        this.filter = filter;
    }

    public static WeaponEntry generateWeaponSpecific(String configEntry, int type, boolean isBlocked) {
        String[] tokens = configEntry.split(Pattern.quote(","));
        if (tokens.length < 2) {
            System.err.println("Not enough arguments for weapon entry: " + configEntry);
            return null;
        }
        if ((type == 0 || type == 1) && tokens.length > 6 || type == 2 && tokens.length > 2) {
            System.err.println("Too many arguments for weapon entry: " + configEntry);
            return null;
        }
        String nameAndNBT = tokens[0].trim();
        boolean suppressMissingItemError = false;
        ArrayList<ArrayList<String>> priorityOrderedLists = new ArrayList<ArrayList<String>>();
        if (type == 2) {
            priorityOrderedLists.add(AttackDefaults.assassinationDefaults);
        } else {
            if (type == 1) {
                if (isBlocked) {
                    priorityOrderedLists.add(AttackDefaults.stealthAttackBlockedDefaults);
                }
                priorityOrderedLists.add(AttackDefaults.stealthAttackDefaults);
            }
            if (isBlocked) {
                priorityOrderedLists.add(AttackDefaults.normalAttackBlockedDefaults);
            }
            priorityOrderedLists.add(AttackDefaults.normalAttackDefaults);
        }
        block0: for (ArrayList arrayList : priorityOrderedLists) {
            for (String entry : arrayList) {
                if (!entry.split(",")[0].trim().equals(nameAndNBT)) continue;
                suppressMissingItemError = true;
                continue block0;
            }
        }
        WeaponEntry result = new WeaponEntry(ItemFilter.getInstance((String)nameAndNBT, (boolean)suppressMissingItemError));
        if (result.filter == null) {
            return null;
        }
        if (type == 0 || type == 1) {
            result.armorPenetration = Boolean.parseBoolean(tokens[1]);
            if (tokens.length > 2) {
                result.damageMultiplier = Double.parseDouble(tokens[2]);
            }
        }
        if (type == 2) {
            result.attackerEffects = Potions.parsePotions((String)tokens[1]);
        } else if (tokens.length > 3) {
            result.attackerEffects = Potions.parsePotions((String)tokens[3]);
            if (tokens.length > 4) {
                result.victimEffects = Potions.parsePotions((String)tokens[4]);
            }
        }
        if (tokens.length > 5) {
            result.consumeItem = Boolean.parseBoolean(tokens[5].trim());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WeaponEntry)) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return obj.equals(this);
        }
        WeaponEntry other = (WeaponEntry)obj;
        if (this.consumeItem != other.consumeItem) {
            return false;
        }
        if (this.armorPenetration != other.armorPenetration) {
            return false;
        }
        if (this.damageMultiplier != other.damageMultiplier) {
            return false;
        }
        if (this.attackerEffects.size() != other.attackerEffects.size()) {
            return false;
        }
        if (this.victimEffects.size() != other.victimEffects.size()) {
            return false;
        }
        ArrayList<FantasticPotionEffect> effects = new ArrayList<FantasticPotionEffect>(this.attackerEffects);
        for (FantasticPotionEffect effect : other.attackerEffects) {
            if (effects.remove(effect)) continue;
            return false;
        }
        effects = new ArrayList<FantasticPotionEffect>(this.victimEffects);
        for (FantasticPotionEffect effect : other.victimEffects) {
            if (effects.remove(effect)) continue;
            return false;
        }
        if (this.filter == null) {
            return other.filter == null;
        }
        return this.filter.equals((Object)other.filter);
    }

    public static boolean resultMatches(double vanillaDamage, WeaponEntry unblocked, WeaponEntry blocked) {
        if (unblocked.consumeItem != blocked.consumeItem) {
            return false;
        }
        if (unblocked.armorPenetration != blocked.armorPenetration) {
            return false;
        }
        if (unblocked.armorPenetration && unblocked.damageMultiplier != blocked.damageMultiplier) {
            return false;
        }
        ArrayList<FantasticPotionEffect> effects = new ArrayList<FantasticPotionEffect>(unblocked.attackerEffects);
        for (FantasticPotionEffect effect : blocked.attackerEffects) {
            if (effects.remove(effect)) continue;
            return false;
        }
        effects = new ArrayList<FantasticPotionEffect>(unblocked.victimEffects);
        for (FantasticPotionEffect effect : blocked.victimEffects) {
            if (effects.remove(effect)) continue;
            return false;
        }
        return true;
    }
}

