/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.senses.sight;

import com.fantasticsource.dynamicstealth.common.potions.Potions;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightDefaults;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.tools.datastructures.Pair;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class EntitySightData {
    public static int playerMaxSightDistance;
    public static HashSet<Entity> potionSoulSightEntities;
    public static LinkedHashMap<Integer, Integer> minimumDimensionLightLevels;
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> naturallyBrightEntities;
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> naturalNightvisionEntities;
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> naturalSoulSightEntities;
    private static LinkedHashMap<Class<? extends Entity>, Pair<Integer, Integer>> entityAngles;
    private static LinkedHashMap<Class<? extends Entity>, Pair<Integer, Integer>> entityDistances;
    private static LinkedHashMap<Class<? extends Entity>, SpecificLighting> entityLighting;

    public static void update() {
        Class c;
        EntityEntry entry;
        String token;
        String[] tokens;
        playerMaxSightDistance = DynamicStealthConfig.serverSettings.senses.sight.f_distances.distanceFar;
        potionSoulSightEntities = new HashSet();
        naturallyBrightEntities = new LinkedHashMap();
        naturalNightvisionEntities = new LinkedHashMap();
        naturalSoulSightEntities = new LinkedHashMap();
        entityAngles = new LinkedHashMap();
        entityDistances = new LinkedHashMap();
        entityLighting = new LinkedHashMap();
        minimumDimensionLightLevels = new LinkedHashMap();
        MCTools.populateEntityMap((String[])DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.naturallyBrightEntities, naturallyBrightEntities);
        MCTools.populateEntityMap((String[])DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.naturalNightvisionEntities, naturalNightvisionEntities);
        MCTools.populateEntityMap((String[])DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.naturalSoulSightEntities, naturalSoulSightEntities);
        for (String string : DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.angle) {
            tokens = string.split(",");
            if (tokens.length != 3) {
                System.err.println("Wrong number of arguments for entity-specific angle override; please check example in tooltip");
                continue;
            }
            token = tokens[0].trim();
            if (token.equals("player")) {
                entityAngles.put(EntityPlayerMP.class, (Pair<Integer, Integer>)new Pair((Object)Integer.parseInt(tokens[1].trim()), (Object)Integer.parseInt(tokens[2].trim())));
                continue;
            }
            entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(token));
            if (entry == null) {
                if (EntitySightDefaults.angleDefaults.contains(string)) continue;
                System.err.println("ResourceLocation for entity \"" + token + "\" not found!");
                continue;
            }
            c = entry.getEntityClass();
            if (EntityLivingBase.class.isAssignableFrom(c)) {
                entityAngles.put(c, (Pair<Integer, Integer>)new Pair((Object)Integer.parseInt(tokens[1].trim()), (Object)Integer.parseInt(tokens[2].trim())));
                continue;
            }
            System.err.println("Entity \"" + string + "\" does not extend EntityLivingBase!");
        }
        for (String string : DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.distance) {
            tokens = string.split(",");
            if (tokens.length != 3) {
                System.err.println("Wrong number of arguments for entity-specific distance override; please check example in tooltip");
                continue;
            }
            token = tokens[0].trim();
            if (token.equals("player")) {
                playerMaxSightDistance = Integer.parseInt(tokens[1].trim());
                entityDistances.put(EntityPlayerMP.class, (Pair<Integer, Integer>)new Pair((Object)playerMaxSightDistance, (Object)Integer.parseInt(tokens[2].trim())));
                continue;
            }
            entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(token));
            if (entry == null) {
                if (EntitySightDefaults.distanceDefaults.contains(string)) continue;
                System.err.println("ResourceLocation for entity \"" + token + "\" not found!");
                continue;
            }
            c = entry.getEntityClass();
            if (EntityLivingBase.class.isAssignableFrom(c)) {
                entityDistances.put(c, (Pair<Integer, Integer>)new Pair((Object)Integer.parseInt(tokens[1].trim()), (Object)Integer.parseInt(tokens[2].trim())));
                continue;
            }
            System.err.println("Entity \"" + string + "\" does not extend EntityLivingBase!");
        }
        for (String string : DynamicStealthConfig.serverSettings.senses.sight.y_entityOverrides.lighting) {
            tokens = string.split(",");
            if (tokens.length != 5) {
                System.err.println("Wrong number of arguments for entity-specific lighting override; please check example in tooltip");
                continue;
            }
            token = tokens[0].trim();
            if (token.equals("player")) {
                entityLighting.put(EntityPlayerMP.class, new SpecificLighting(Integer.parseInt(tokens[1].trim()), Double.parseDouble(tokens[2].trim()), Integer.parseInt(tokens[3].trim()), Double.parseDouble(tokens[4].trim())));
                continue;
            }
            entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(token));
            if (entry == null) {
                System.err.println("ResourceLocation for entity \"" + token + "\" not found!");
                continue;
            }
            c = entry.getEntityClass();
            if (EntityLivingBase.class.isAssignableFrom(c)) {
                entityLighting.put(c, new SpecificLighting(Integer.parseInt(tokens[1].trim()), Double.parseDouble(tokens[2].trim()), Integer.parseInt(tokens[3].trim()), Double.parseDouble(tokens[4].trim())));
                continue;
            }
            System.err.println("Entity \"" + string + "\" does not extend EntityLivingBase!");
        }
        for (String string : DynamicStealthConfig.serverSettings.senses.sight.c_lighting.z_minimumDimensionLightLevels) {
            tokens = string.split(",");
            if (tokens.length != 2) {
                System.err.println("Wrong number of arguments for minimum dimension light level; please check example in tooltip");
                continue;
            }
            int dim = Integer.parseInt(tokens[0].trim());
            int minLight = Integer.parseInt(tokens[1].trim());
            if (minLight < 0 || minLight > 15) {
                System.err.println("Minimum light levels for dimensions must be from 0 to 15, inclusive!");
                continue;
            }
            minimumDimensionLightLevels.put(dim, minLight);
        }
        if (DynamicStealthConfig.serverSettings.senses.sight.e_angles.angleSmall > DynamicStealthConfig.serverSettings.senses.sight.e_angles.angleLarge) {
            throw new IllegalArgumentException("angleLarge must be greater than or equal to angleSmall");
        }
        if (DynamicStealthConfig.serverSettings.senses.sight.f_distances.distanceNear > DynamicStealthConfig.serverSettings.senses.sight.f_distances.distanceFar) {
            throw new IllegalArgumentException("distanceFar must be greater than or equal to distanceNear");
        }
        if (DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightLevelLow > DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightLevelHigh) {
            throw new IllegalArgumentException("lightLevelHigh must be greater than or equal to lightLevelLow");
        }
    }

    public static boolean isBright(Entity target) {
        if (target.func_70027_ad() && DynamicStealthConfig.serverSettings.senses.sight.g_absolutes.seeBurning) {
            return true;
        }
        return MCTools.entityMatchesMap((Entity)target, naturallyBrightEntities);
    }

    public static boolean hasNightvision(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return false;
        }
        return ((EntityLivingBase)searcher).func_70660_b(MobEffects.field_76439_r) != null || MCTools.entityMatchesMap((Entity)searcher, naturalNightvisionEntities);
    }

    public static boolean hasSoulSight(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return false;
        }
        return ((EntityLivingBase)searcher).func_70660_b(Potions.POTION_SOULSIGHT) != null || searcher.getEntityData().func_74767_n("ai_omniscience") || MCTools.entityMatchesMap((Entity)searcher, naturalSoulSightEntities);
    }

    public static int angleLarge(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        Pair<Integer, Integer> pair = entityAngles.get(searcher.getClass());
        return pair == null ? DynamicStealthConfig.serverSettings.senses.sight.e_angles.angleLarge : (Integer)pair.getKey();
    }

    public static int angleSmall(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        Pair<Integer, Integer> pair = entityAngles.get(searcher.getClass());
        return pair == null ? DynamicStealthConfig.serverSettings.senses.sight.e_angles.angleSmall : (Integer)pair.getValue();
    }

    public static int distanceFar(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        Pair<Integer, Integer> pair = entityDistances.get(searcher.getClass());
        return pair == null ? DynamicStealthConfig.serverSettings.senses.sight.f_distances.distanceFar : (Integer)pair.getKey();
    }

    public static int distanceNear(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        Pair<Integer, Integer> pair = entityDistances.get(searcher.getClass());
        return pair == null ? DynamicStealthConfig.serverSettings.senses.sight.f_distances.distanceNear : (Integer)pair.getValue();
    }

    public static int lightLevelHigh(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        SpecificLighting specificLighting = entityLighting.get(searcher.getClass());
        return specificLighting == null ? DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightLevelHigh : specificLighting.levelHigh;
    }

    public static double lightMultHigh(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0.0;
        }
        SpecificLighting specificLighting = entityLighting.get(searcher.getClass());
        return specificLighting == null ? DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightMultHigh : specificLighting.multHigh;
    }

    public static int lightLevelLow(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0;
        }
        SpecificLighting specificLighting = entityLighting.get(searcher.getClass());
        return specificLighting == null ? DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightLevelLow : specificLighting.levelLow;
    }

    public static double lightMultLow(Entity searcher) {
        if (!(searcher instanceof EntityLivingBase)) {
            return 0.0;
        }
        SpecificLighting specificLighting = entityLighting.get(searcher.getClass());
        return specificLighting == null ? DynamicStealthConfig.serverSettings.senses.sight.c_lighting.lightMultLow : specificLighting.multLow;
    }

    public static int minimumDimensionLight(int dim) {
        return minimumDimensionLightLevels.getOrDefault(dim, 0);
    }

    private static class SpecificLighting {
        int levelHigh;
        int levelLow;
        double multHigh;
        double multLow;

        public SpecificLighting(int levelHigh, double multHigh, int levelLow, double multLow) {
            this.levelHigh = levelHigh;
            this.multHigh = multHigh;
            this.levelLow = levelLow;
            this.multLow = multLow;
        }
    }
}

