/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.senses.sight;

import com.fantasticsource.dynamicstealth.common.BlocksAndItems;
import com.fantasticsource.dynamicstealth.common.DSTools;
import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.compat.CompatDissolution;
import com.fantasticsource.dynamicstealth.compat.CompatLevelUp2;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.config.server.senses.sight.SightConfig;
import com.fantasticsource.dynamicstealth.server.Attributes;
import com.fantasticsource.dynamicstealth.server.HUDData;
import com.fantasticsource.dynamicstealth.server.senses.HidingData;
import com.fantasticsource.dynamicstealth.server.senses.sight.EntitySightData;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.mctools.ImprovedRayTracing;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.tools.Tools;
import com.fantasticsource.tools.TrigLookupTable;
import com.fantasticsource.tools.datastructures.ExplicitPriorityQueue;
import com.fantasticsource.tools.datastructures.Pair;
import com.fantasticsource.tools.datastructures.WrappingQueue;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;

public class Sight {
    protected static final double OFFSET_COLLISION_BUFFER_DIRECT = 0.1;
    protected static final double OFFSET_COLLISION_BUFFER_FORWARD = 0.1;
    private static final int SEEN_RECENT_TIMER = 60;
    private static final int GLOBAL_STEALTH_SMOOTHING = 3;
    private static Map<EntityPlayer, Pair<WrappingQueue<Double>, Long>> globalPlayerStealthHistory = new LinkedHashMap<EntityPlayer, Pair<WrappingQueue<Double>, Long>>();
    private static Map<EntityLivingBase, Map<Entity, SeenData>> recentlySeenMap = new LinkedHashMap<EntityLivingBase, Map<Entity, SeenData>>();
    private static Map<Pair<EntityPlayerMP, Boolean>, LinkedHashMap<Entity, Double>> playerSeenThisTickMap = new LinkedHashMap<Pair<EntityPlayerMP, Boolean>, LinkedHashMap<Entity, Double>>();

    public static void update(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            playerSeenThisTickMap.clear();
            recentlySeenMap.entrySet().removeIf(Sight::updateRecentlySeen);
            globalPlayerStealthHistory.entrySet().removeIf(Sight::updateStealthHistory);
        }
    }

    private static boolean updateStealthHistory(Map.Entry<EntityPlayer, Pair<WrappingQueue<Double>, Long>> entry) {
        EntityPlayer player = entry.getKey();
        if (!player.func_70089_S() || !player.field_70170_p.field_73010_i.contains(player)) {
            return true;
        }
        Pair<WrappingQueue<Double>, Long> pair = entry.getValue();
        long tick = ServerTickTimer.currentTick();
        if ((Long)pair.getValue() != tick) {
            ((WrappingQueue)pair.getKey()).add((Object)1.0);
            pair.setValue((Object)tick);
        }
        return false;
    }

    private static boolean updateRecentlySeen(Map.Entry<EntityLivingBase, Map<Entity, SeenData>> entry) {
        EntityLivingBase livingBase = entry.getKey();
        if (!MCTools.entityIsValid((Entity)livingBase)) {
            return true;
        }
        entry.getValue().entrySet().removeIf(e -> !MCTools.entityIsValid((Entity)((Entity)e.getKey())));
        return false;
    }

    public static boolean recentlySeen(EntityLivingBase searcher, Entity target) {
        if (searcher == null || target == null) {
            return false;
        }
        Map<Entity, SeenData> map = recentlySeenMap.get(searcher);
        if (map == null) {
            return false;
        }
        SeenData data = map.get(target);
        if (data == null) {
            return false;
        }
        return data.seen && ServerTickTimer.currentTick() - data.lastSeenTime < 60L;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, true, true, searcher.field_70759_as, searcher.field_70125_A) <= 1.0;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, useCache, saveCache, searcher.field_70759_as, searcher.field_70125_A) <= 1.0;
    }

    public static boolean canSee(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache, double yaw, double pitch) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, useCache, saveCache, yaw, pitch) <= 1.0;
    }

    public static double visualStealthLevel(EntityLivingBase searcher, Entity target, boolean isAggressive) {
        return Sight.visualStealthLevel(searcher, target, isAggressive, true, true, searcher.field_70759_as, searcher.field_70125_A);
    }

    public static double visualStealthLevel(EntityLivingBase searcher, Entity target, boolean isAggressive, boolean useCache, boolean saveCache, double yaw, double pitch) {
        SeenData data;
        if (searcher == null || target == null || !searcher.field_70170_p.func_175667_e(searcher.func_180425_c()) || !target.field_70170_p.func_175667_e(target.func_180425_c())) {
            return 777.0;
        }
        searcher.field_70170_p.field_72984_F.func_76320_a("DStealth: Visual Stealth");
        Map<Entity, SeenData> map = recentlySeenMap.get(searcher);
        long tick = ServerTickTimer.currentTick();
        if (map != null && useCache && (data = map.get(target)) != null && data.lastUpdateTime == tick) {
            searcher.field_70170_p.field_72984_F.func_76319_b();
            return data.lastStealthLevel;
        }
        double offsetLR = 0.0;
        ItemStack stack = searcher.func_184607_cu();
        if (stack.func_77973_b() == BlocksAndItems.itemHandMirror) {
            offsetLR = Tools.min((double[])new double[]{(double)searcher.func_184612_cw() / 20.0, 1.0});
            if (searcher.func_184600_cs() == EnumHand.OFF_HAND == (searcher.func_184591_cq() == EnumHandSide.RIGHT)) {
                offsetLR = -offsetLR;
            }
        }
        double result = Sight.visualStealthLevelInternal(searcher, target, yaw, pitch, offsetLR);
        if (saveCache) {
            if (isAggressive && target instanceof EntityPlayer && HUDData.isGauged((Entity)searcher) && (searcher instanceof EntityPlayer || searcher instanceof EntityLiving && (((EntityLiving)searcher).func_70638_az() == target || !EntityThreatData.isPassive((Entity)searcher) && !EntityThreatData.bypassesThreat((Entity)searcher)))) {
                EntityPlayer player = (EntityPlayer)target;
                Pair pair = globalPlayerStealthHistory.computeIfAbsent(player, k -> new Pair((Object)new WrappingQueue(5), (Object)(tick - 1L)));
                WrappingQueue queue = (WrappingQueue)pair.getKey();
                double clampedResult = Tools.min((double[])new double[]{Tools.max((double[])new double[]{-1.0, result - 1.0}), 1.0});
                if (queue.size() != 0 && (Long)pair.getValue() == tick) {
                    queue.setNewestToOldest(0, (Object)Tools.min((double[])new double[]{clampedResult, (Double)queue.getNewestToOldest(0)}));
                } else {
                    queue.add((Object)clampedResult);
                }
                pair.setValue((Object)tick);
            }
            if (map == null) {
                map = new LinkedHashMap<Entity, SeenData>();
                recentlySeenMap.put(searcher, map);
                map.put(target, new SeenData(result));
            } else {
                SeenData data2 = map.get(target);
                if (data2 == null) {
                    map.put(target, new SeenData(result));
                } else {
                    data2.lastUpdateTime = tick;
                    data2.lastStealthLevel = result;
                    if (result <= 1.0) {
                        data2.seen = true;
                        data2.lastSeenTime = tick;
                    }
                }
            }
        }
        searcher.field_70170_p.field_72984_F.func_76319_b();
        return result;
    }

    public static LinkedHashMap<Entity, Double> seenEntities(EntityPlayerMP player) {
        player.field_70170_p.field_72984_F.func_76320_a("DStealth: Seen Entities");
        LinkedHashMap<Entity, Double> map = playerSeenThisTickMap.get(new Pair((Object)player, (Object)false));
        if (map != null) {
            player.field_70170_p.field_72984_F.func_76319_b();
            return (LinkedHashMap)map.clone();
        }
        map = Sight.seenEntitiesInternal(player);
        playerSeenThisTickMap.put((Pair<EntityPlayerMP, Boolean>)new Pair((Object)player, (Object)false), (LinkedHashMap)map.clone());
        player.field_70170_p.field_72984_F.func_76319_b();
        return map;
    }

    private static LinkedHashMap<Entity, Double> seenEntitiesInternal(EntityPlayerMP player) {
        LinkedHashMap<Entity, Double> result = new LinkedHashMap<Entity, Double>();
        Entity[] loadedEntities = player.field_70170_p.field_72996_f.toArray(new Entity[0]);
        if (DynamicStealthConfig.serverSettings.senses.usePlayerSenses) {
            for (Entity entity : loadedEntities) {
                double stealthLevel;
                if (entity == player || !((stealthLevel = Sight.visualStealthLevel((EntityLivingBase)player, entity, true)) <= 1.0)) continue;
                result.put(entity, stealthLevel);
            }
        } else {
            for (Entity entity : loadedEntities) {
                if (entity == player) continue;
                result.put(entity, -888.0);
            }
        }
        return result;
    }

    private static double visualStealthLevelInternal(EntityLivingBase searcher, Entity target, double yaw, double pitch, double offsetLR) {
        double distanceThreshold;
        IEntity cnpc;
        if (target instanceof EntityItem && ((EntityItem)target).func_92059_d().func_77973_b() instanceof ItemSplashPotion) {
            boolean bl = false;
        }
        if (searcher.field_70170_p != target.field_70170_p || target.field_70128_L || target instanceof FakePlayer || !searcher.func_70089_S()) {
            return 777.0;
        }
        if (target instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)target;
            if (player.func_175149_v()) {
                return 777.0;
            }
            if (player.func_184812_l_() && HidingData.isCreativeInvis(player)) {
                return 777.0;
            }
            if (!(!(searcher instanceof EntityPlayer) || DynamicStealthConfig.serverSettings.senses.pvpStealth && HidingData.isHidingFrom((EntityPlayer)target, searcher.getPersistentID()))) {
                return -777.0;
            }
        }
        if (Compat.customnpcs && (cnpc = NpcAPI.Instance().getIEntity(target)) instanceof ICustomNpc && !cnpc.isAlive() && ((ICustomNpc)cnpc).getStats().getHideDeadBody() && ((EntityLivingBase)cnpc.getMCEntity()).field_70725_aQ == 0) {
            return 777.0;
        }
        if (searcher instanceof EntityPlayerMP && target == ((EntityPlayerMP)searcher).func_175398_C()) {
            return -777.0;
        }
        if (target instanceof EntityDragon || target instanceof EntityWither) {
            return -777.0;
        }
        if (searcher instanceof EntityPlayer && CompatDissolution.isPossessing((EntityPlayer)searcher, target)) {
            return -777.0;
        }
        if (MCTools.isRidingOrRiddenBy((Entity)searcher, (Entity)target)) {
            return -777.0;
        }
        Vec3d eyeVec = searcher.func_174824_e(1.0f);
        if (offsetLR != 0.0) {
            World world = searcher.field_70170_p;
            double testOffsetLR = offsetLR > 0.0 ? offsetLR + 0.1 : offsetLR - 0.1;
            Vec3d testStart = eyeVec.func_72441_c(-0.1 * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad((double)yaw)), 0.0, 0.1 * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad((double)yaw)));
            Vec3d testEnd = testStart.func_178786_a(testOffsetLR * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad((double)yaw)), 0.0, testOffsetLR * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad((double)yaw)));
            RayTraceResult testResult = ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)testStart, (Vec3d)testEnd, (double)testOffsetLR, (boolean)true);
            Vec3d testHitVec = testResult.field_72307_f != null ? testResult.field_72307_f : testEnd;
            Vec3d testDif = testHitVec.func_178788_d(testStart);
            double testDist = testDif.func_72433_c() - 0.1;
            if (testDist > 0.0) {
                Vec3d end = eyeVec.func_178786_a(testOffsetLR * TrigLookupTable.TRIG_TABLE_1024.cos(Tools.degtorad((double)yaw)), 0.0, testOffsetLR * TrigLookupTable.TRIG_TABLE_1024.sin(Tools.degtorad((double)yaw)));
                RayTraceResult result = ImprovedRayTracing.rayTraceBlocks((World)world, (Vec3d)eyeVec, (Vec3d)end, (double)(testDist + 0.1), (boolean)true);
                Vec3d hitVec = result.field_72307_f != null ? result.field_72307_f : end;
                Vec3d dif = hitVec.func_178788_d(eyeVec);
                double dist = dif.func_72433_c() - 0.1;
                if (dist > 0.0) {
                    eyeVec = dif.func_72432_b().func_186678_a(Tools.min((double[])new double[]{testDist, dist})).func_178787_e(eyeVec);
                }
            }
        }
        Vec3d targetVec = target.func_174791_d().func_72441_c(0.0, (double)target.field_70131_O * 0.5, 0.0);
        double distSquared = eyeVec.func_72436_e(targetVec);
        int distanceFar = EntitySightData.distanceFar((Entity)searcher);
        if (EntitySightData.hasSoulSight((Entity)searcher)) {
            if (distSquared > 10000.0) {
                return 777.0;
            }
            return -777.0;
        }
        if (distSquared > Math.pow(distanceFar, 2.0)) {
            return 777.0;
        }
        int angleLarge = EntitySightData.angleLarge((Entity)searcher);
        if (angleLarge == 0) {
            return 777.0;
        }
        int angleSmall = EntitySightData.angleSmall((Entity)searcher);
        if (angleSmall == 180) {
            distanceThreshold = distanceFar;
        } else {
            double angleDif = MCTools.angleDifDeg((Vec3d)eyeVec, (float)((float)yaw), (float)((float)pitch), (Vec3d)targetVec);
            if (angleDif > (double)angleLarge) {
                return 777.0;
            }
            if (angleDif < (double)angleSmall) {
                distanceThreshold = distanceFar;
            } else {
                int distanceNear = EntitySightData.distanceNear((Entity)searcher);
                distanceThreshold = (double)distanceNear + (double)(distanceFar - distanceNear) * ((double)angleLarge - angleDif) / (double)(angleLarge - angleSmall);
            }
        }
        boolean isLivingBase = target instanceof EntityLivingBase;
        EntityLivingBase targetLivingBase = isLivingBase ? (EntityLivingBase)target : null;
        SightConfig sight = DynamicStealthConfig.serverSettings.senses.sight;
        if (sight.g_absolutes.seeGlowing && isLivingBase && targetLivingBase.func_70660_b(MobEffects.field_188423_x) != null) {
            return -777.0;
        }
        double sightAttrib = searcher.func_110148_a((IAttribute)Attributes.SIGHT).func_111126_e();
        if (sightAttrib <= 0.0) {
            return 777.0;
        }
        double visReductionAttrib = !isLivingBase ? Attributes.VISIBILITY_REDUCTION.func_111110_b() : targetLivingBase.func_110148_a((IAttribute)Attributes.VISIBILITY_REDUCTION).func_111126_e();
        double attributeMultipliers = visReductionAttrib <= 0.0 ? 777.0 : sightAttrib / visReductionAttrib;
        double lightFactor = Sight.bestLightingAtLOSHit((Entity)searcher, target, EntitySightData.isBright(target), eyeVec);
        if (lightFactor == -777.0) {
            return 777.0;
        }
        if (EntitySightData.hasNightvision((Entity)searcher)) {
            lightFactor = Math.min(15.0, lightFactor + (double)sight.c_lighting.nightvisionBonus);
        }
        int lightLevelLow = EntitySightData.lightLevelLow((Entity)searcher);
        double lightMultLow = EntitySightData.lightMultLow((Entity)searcher);
        if (lightFactor <= (double)lightLevelLow) {
            lightFactor = lightMultLow;
        } else {
            int lightLevelHigh = EntitySightData.lightLevelHigh((Entity)searcher);
            double lightMultHigh = EntitySightData.lightMultHigh((Entity)searcher);
            lightFactor = lightFactor >= (double)lightLevelHigh ? lightMultHigh : (lightFactor - (double)lightLevelLow) / (double)(lightLevelHigh - lightLevelLow) * (lightMultHigh - lightMultLow) + lightMultLow;
        }
        double blindnessMultiplier = searcher.func_70660_b(MobEffects.field_76440_q) != null ? sight.a_stealthMultipliers.blindnessMultiplier : 1.0;
        double invisibilityMultiplier = isLivingBase && targetLivingBase.func_70660_b(MobEffects.field_76441_p) != null ? sight.a_stealthMultipliers.invisibilityMultiplier : 1.0;
        double crouchingMultiplier = target.func_70093_af() ? sight.a_stealthMultipliers.crouchingMultiplier : 1.0;
        double levelUp2StealthMultiplier = target instanceof EntityPlayer ? CompatLevelUp2.stealthLevelVisMultiplier((EntityPlayer)target) : 1.0;
        double mobHeadMultiplier = 1.0;
        if (isLivingBase) {
            ItemStack helmet = targetLivingBase.func_184582_a(EntityEquipmentSlot.HEAD);
            if (helmet.func_77973_b() == Items.field_151144_bL) {
                int damage = helmet.func_77952_i();
                if (target instanceof EntitySkeleton && damage == 0 || target instanceof EntityWitherSkeleton && damage == 1 || target instanceof EntityZombie && damage == 2 || target instanceof EntityCreeper && damage == 4) {
                    mobHeadMultiplier = sight.a_stealthMultipliers.mobHeadMultiplier;
                }
            } else if (helmet.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150423_aK) && helmet.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150428_aP) && target instanceof EntitySnowman) {
                mobHeadMultiplier = sight.a_stealthMultipliers.mobHeadMultiplier;
            }
        }
        double armorMultiplier = 1.0;
        if (isLivingBase) {
            double unnaturalArmor = 0.0;
            for (EntityEquipmentSlot slot : new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET}) {
                ItemStack stack = targetLivingBase.func_184582_a(slot);
                Item item = stack.func_77973_b();
                if (item instanceof ISpecialArmor) {
                    unnaturalArmor = Compat.conarm && item.getClass().getName().contains("conarm.common.items.armor") ? (unnaturalArmor += Math.abs(((ISpecialArmor)item).getProperties((EntityLivingBase)targetLivingBase, (ItemStack)stack, (DamageSource)new DamageSource((String)"generic"), (double)1.0, (int)Integer.MIN_VALUE).Armor)) : (unnaturalArmor += ((ISpecialArmor)item).getProperties((EntityLivingBase)targetLivingBase, (ItemStack)stack, (DamageSource)new DamageSource((String)"generic"), (double)1.0, (int)Integer.MIN_VALUE).Armor);
                }
                if (!(item instanceof ItemArmor)) continue;
                unnaturalArmor += (double)((ItemArmor)item).field_77879_b;
            }
            armorMultiplier += DynamicStealthConfig.serverSettings.senses.sight.b_visibilityMultipliers.armorMultiplierCumulative * unnaturalArmor;
        }
        double stealthMultiplier = Tools.min((double[])new double[]{mobHeadMultiplier, blindnessMultiplier * invisibilityMultiplier * crouchingMultiplier * levelUp2StealthMultiplier});
        double visibilityMultiplier = armorMultiplier;
        double configMultipliers = Tools.min((double[])new double[]{Tools.max((double[])new double[]{stealthMultiplier * visibilityMultiplier, 0.0}), 1.0});
        return Math.sqrt(distSquared) / (distanceThreshold * lightFactor * configMultipliers * attributeMultipliers);
    }

    private static double bestLightingAtLOSHit(Entity searcher, Entity target, boolean forceMaxLight, Vec3d eyeVec) {
        World world = searcher.field_70170_p;
        if (world != target.field_70170_p) {
            return -777.0;
        }
        ExplicitPriorityQueue queue = new ExplicitPriorityQueue();
        if (forceMaxLight) {
            for (Vec3d vec : DSTools.entityCheckVectors(target)) {
                queue.add((Object)vec, 0.0);
            }
        } else {
            for (Vec3d vec : DSTools.entityCheckVectors(target)) {
                queue.add((Object)vec, (double)(15 - DSTools.lightLevelTotal(world, vec)));
            }
        }
        while (queue.size() > 0) {
            double result = queue.peekPriority();
            Vec3d testVec = (Vec3d)queue.poll();
            if (!ImprovedRayTracing.isUnobstructed((World)searcher.field_70170_p, (Vec3d)eyeVec, (Vec3d)testVec, (boolean)false)) continue;
            return 15.0 - result;
        }
        return -777.0;
    }

    public static double globalPlayerStealthLevel(EntityPlayer player) {
        int size;
        long tick = ServerTickTimer.currentTick();
        Pair<WrappingQueue<Double>, Long> pair = globalPlayerStealthHistory.get(player);
        if (pair == null) {
            WrappingQueue queue = new WrappingQueue(5);
            queue.add((Object)1.0);
            globalPlayerStealthHistory.put(player, (Pair<WrappingQueue<Double>, Long>)new Pair((Object)queue, (Object)tick));
            return 1.0;
        }
        WrappingQueue queue = (WrappingQueue)pair.getKey();
        if ((Long)pair.getValue() != tick) {
            queue.add((Object)1.0);
            pair.setValue((Object)tick);
        }
        if ((size = queue.size()) == 1) {
            return 1.0;
        }
        if (size == 2) {
            return (Double)queue.getOldestToNewest(0);
        }
        if (size < 5) {
            double result = 1.0;
            for (int i = size - 2; i >= 0; --i) {
                result = Tools.min((double[])new double[]{result, (Double)queue.getOldestToNewest(i)});
            }
            return result;
        }
        double first = (Double)queue.getOldestToNewest(0);
        double result = 1.0;
        for (int i = 1; i < size - 1; ++i) {
            if ((result = Tools.min((double[])new double[]{result, (Double)queue.getOldestToNewest(i)})) < first) break;
        }
        return result;
    }

    private static class SeenData {
        boolean seen = false;
        long lastSeenTime;
        long lastUpdateTime = ServerTickTimer.currentTick();
        double lastStealthLevel;

        SeenData(double stealthLevel) {
            this(stealthLevel, false);
        }

        SeenData(double stealthLevel, boolean forceSeen) {
            this.lastStealthLevel = stealthLevel;
            if (forceSeen || stealthLevel <= 1.0) {
                this.seen = true;
                this.lastSeenTime = ServerTickTimer.currentTick();
            }
        }
    }
}

