/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.threat;

import com.fantasticsource.dynamicstealth.compat.Compat;
import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.GlobalDefaultsAndData;
import com.fantasticsource.mctools.MCTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import ladysnake.dissolution.api.corporeality.IPossessable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.ICustomNpc;
import noppes.npcs.api.entity.IEntity;

public class EntityThreatData {
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> threatBypass;
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> isPassive;
    private static LinkedHashMap<Class<? extends Entity>, HashSet<String>> isNonPassive;

    public static void update() {
        threatBypass = new LinkedHashMap();
        isPassive = new LinkedHashMap();
        isNonPassive = new LinkedHashMap();
        MCTools.populateEntityMap((String[])DynamicStealthConfig.serverSettings.threat.y_entityOverrides.threatBypass, threatBypass);
        ArrayList<String> passive = new ArrayList<String>();
        ArrayList<String> nonPassive = new ArrayList<String>();
        for (String string : DynamicStealthConfig.serverSettings.threat.y_entityOverrides.isPassive) {
            String[] tokens = string.split(",");
            if (tokens.length != 2) {
                System.err.println("Wrong number of arguments for entity-specific passivity override; please check example in tooltip");
                continue;
            }
            if (tokens[1].trim().equals("true")) {
                passive.add(tokens[0].trim());
                continue;
            }
            if (tokens[1].trim().equals("false")) {
                nonPassive.add(tokens[0].trim());
                continue;
            }
            System.err.println("Second argument for entity-specific passivity override was not true or false; please check example in tooltip");
        }
        MCTools.populateEntityMap((String[])passive.toArray(new String[0]), isPassive);
        MCTools.populateEntityMap((String[])nonPassive.toArray(new String[0]), isNonPassive);
    }

    public static boolean bypassesThreat(Entity entity) {
        IEntity iEntity;
        if (!(entity instanceof EntityLivingBase)) {
            return true;
        }
        if (DynamicStealthConfig.serverSettings.threat.bypassThreatSystem) {
            return true;
        }
        if (GlobalDefaultsAndData.isFullBypass(entity)) {
            return true;
        }
        if (Compat.dissolution && entity instanceof IPossessable && ((IPossessable)entity).getPossessingEntity() != null) {
            return true;
        }
        if (Compat.customnpcs && (iEntity = NpcAPI.Instance().getIEntity(entity)) instanceof ICustomNpc) {
            ICustomNpc npc = (ICustomNpc)iEntity;
            String faction = npc.getFaction().getName();
            for (String string : DynamicStealthConfig.serverSettings.threat.cnpcThreatConfig.threatBypassFactions) {
                if (!faction.equals(string)) continue;
                return true;
            }
        }
        return MCTools.entityMatchesMap((Entity)entity, threatBypass);
    }

    public static boolean isPassive(Entity entity) {
        if (!(entity instanceof EntityLivingBase)) {
            return false;
        }
        if (EntityThreatData.bypassesThreat(entity)) {
            return false;
        }
        if (MCTools.entityMatchesMap((Entity)entity, isNonPassive)) {
            return false;
        }
        if (MCTools.entityMatchesMap((Entity)entity, isPassive)) {
            return true;
        }
        return MCTools.isPassive((EntityLivingBase)((EntityLivingBase)entity));
    }
}

