/*
 * Decompiled with CFR 0.152.
 */
package com.fantasticsource.dynamicstealth.server.threat;

import com.fantasticsource.dynamicstealth.config.DynamicStealthConfig;
import com.fantasticsource.dynamicstealth.server.Attributes;
import com.fantasticsource.dynamicstealth.server.CombatTracker;
import com.fantasticsource.dynamicstealth.server.ai.AIDynamicStealth;
import com.fantasticsource.dynamicstealth.server.event.ApplyThreatEvent;
import com.fantasticsource.dynamicstealth.server.senses.sight.Sight;
import com.fantasticsource.dynamicstealth.server.threat.EntityThreatData;
import com.fantasticsource.mctools.MCTools;
import com.fantasticsource.mctools.ServerTickTimer;
import com.fantasticsource.tools.Tools;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class Threat {
    private static final int ITERATION_FREQUENCY = 72000;
    private static Map<EntityLivingBase, ThreatData> threatMap = new LinkedHashMap<EntityLivingBase, ThreatData>(200);

    public static void update(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && ServerTickTimer.currentTick() % 72000L == 0L) {
            Threat.removeAllUnused();
        }
    }

    private static void removeAllUnused() {
        threatMap.entrySet().removeIf(Threat::checkRemoveSearcher);
    }

    private static boolean checkRemoveSearcher(Map.Entry<EntityLivingBase, ThreatData> entry) {
        EntityLivingBase searcher = entry.getKey();
        return !searcher.field_70170_p.field_72996_f.contains(searcher) || !searcher.func_70089_S();
    }

    public static void remove(EntityLivingBase searcher) {
        CombatTracker.setNoTargetTime(searcher);
        CombatTracker.setIdleTime(searcher);
        threatMap.remove(searcher);
    }

    @Nonnull
    public static ThreatData get(EntityLivingBase searcher) {
        ThreatData threatData = threatMap.get(searcher);
        if (threatData != null) {
            return threatData.copy();
        }
        return new ThreatData(searcher, null, 0.0f);
    }

    public static EntityLivingBase getTarget(EntityLivingBase searcher) {
        ThreatData threatData = threatMap.get(searcher);
        if (threatData != null) {
            return threatData.target;
        }
        return null;
    }

    public static float getThreat(EntityLivingBase searcher) {
        ThreatData threatData = threatMap.get(searcher);
        if (threatData != null) {
            return threatData.threatPercentage;
        }
        return 0.0f;
    }

    public static void set(EntityLivingBase searcher, EntityLivingBase target, float threatPercentage) {
        if (EntityThreatData.bypassesThreat((Entity)searcher)) {
            return;
        }
        if (threatPercentage <= 0.0f) {
            Threat.remove(searcher);
        } else {
            ThreatData threatData;
            if (threatPercentage > 100.0f) {
                threatPercentage = 100.0f;
            }
            if ((threatData = threatMap.get(searcher)) != null) {
                if (target == null) {
                    CombatTracker.setNoTargetTime(searcher);
                } else if (threatData.target == null) {
                    CombatTracker.setNoTargetTime(searcher, ServerTickTimer.currentTick() - 1L);
                }
                if (threatData.threatPercentage <= 0.0f) {
                    CombatTracker.setIdleTime(searcher, ServerTickTimer.currentTick() - 1L);
                }
                threatData.target = target;
                threatData.threatPercentage = threatPercentage;
            } else {
                if (target == null) {
                    CombatTracker.setNoTargetTime(searcher);
                } else {
                    CombatTracker.setNoTargetTime(searcher, ServerTickTimer.currentTick() - 1L);
                }
                CombatTracker.setIdleTime(searcher, ServerTickTimer.currentTick() - 1L);
                threatMap.put(searcher, new ThreatData(searcher, target, threatPercentage));
            }
        }
    }

    public static void clearTarget(EntityLivingBase searcher) {
        if (EntityThreatData.bypassesThreat((Entity)searcher)) {
            return;
        }
        ThreatData threatData = threatMap.get(searcher);
        if (threatData != null) {
            threatData.target = null;
        }
        CombatTracker.setNoTargetTime(searcher);
    }

    public static void setThreat(EntityLivingBase searcher, float threatPercentage) {
        if (EntityThreatData.bypassesThreat((Entity)searcher)) {
            return;
        }
        if (threatPercentage <= 0.0f) {
            Threat.remove(searcher);
        } else {
            ThreatData threatData;
            if (threatPercentage > 100.0f) {
                threatPercentage = 100.0f;
            }
            if ((threatData = threatMap.get(searcher)) != null) {
                if (threatData.threatPercentage <= 0.0f) {
                    CombatTracker.setIdleTime(searcher, ServerTickTimer.currentTick() - 1L);
                }
                threatData.threatPercentage = threatPercentage;
            } else {
                CombatTracker.setIdleTime(searcher, ServerTickTimer.currentTick() - 1L);
                threatMap.put(searcher, new ThreatData(searcher, null, threatPercentage));
            }
        }
    }

    public static void apply(EntityLivingBase searcher, EntityLivingBase target, double threatPercentage, THREAT_TYPE type) {
        Threat.apply(searcher, target, threatPercentage, type, Sight.canSee(searcher, (Entity)target, true), null);
    }

    public static void apply(EntityLivingBase searcher, EntityLivingBase target, double threatPercentage, THREAT_TYPE type, boolean searcherSeesTarget) {
        Threat.apply(searcher, target, threatPercentage, type, searcherSeesTarget, null);
    }

    public static void apply(EntityLivingBase searcher, EntityLivingBase target, double threatPercentage, THREAT_TYPE type, boolean searcherSeesTarget, DamageSource damageSource) {
        if (EntityThreatData.bypassesThreat((Entity)searcher)) {
            return;
        }
        ApplyThreatEvent event = new ApplyThreatEvent(searcher, target, threatPercentage, type, searcherSeesTarget, damageSource);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        searcher = event.searcher;
        target = event.target;
        threatPercentage = event.threatPercentage;
        type = event.type;
        searcherSeesTarget = event.searcherSeesTarget;
        ThreatData data = Threat.get(searcher);
        EntityLivingBase oldTarget = data.target;
        float oldPercentage = data.threatPercentage;
        switch (type) {
            case GEN_TARGET_SPOTTED: {
                if (!searcherSeesTarget || oldTarget != null && oldTarget != target) break;
                Threat.set(searcher, target, (float)(threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_SPOTTED, (double)1.0)));
                break;
            }
            case GEN_ATTACKED: {
                AIDynamicStealth ai;
                if (searcher instanceof EntityLiving && (ai = AIDynamicStealth.getStealthAI((EntityLiving)searcher)) != null && ai.isFleeing()) {
                    Threat.apply(searcher, target, threatPercentage, THREAT_TYPE.GEN_ATTACKED_DURING_FLEE, searcherSeesTarget, damageSource);
                    return;
                }
                threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_ATTACK, (double)1.0);
                threatPercentage /= (double)searcher.func_110138_aP();
                if (oldPercentage <= 0.0f) {
                    Threat.set(searcher, (EntityLivingBase)(searcherSeesTarget ? target : null), (float)(DynamicStealthConfig.serverSettings.threat.combatStart + (threatPercentage *= DynamicStealthConfig.serverSettings.threat.attackedBySameMultiplier)));
                    break;
                }
                if (searcherSeesTarget && target != oldTarget) {
                    double threatTest = threatPercentage * DynamicStealthConfig.serverSettings.threat.attackedByOtherMultiplier;
                    if (threatTest < (double)oldPercentage) {
                        Threat.setThreat(searcher, (float)((double)oldPercentage - threatTest));
                        break;
                    }
                    Threat.set(searcher, target, (float)(DynamicStealthConfig.serverSettings.threat.combatStart + threatTest));
                    break;
                }
                Threat.setThreat(searcher, (float)(threatPercentage *= DynamicStealthConfig.serverSettings.threat.attackedBySameMultiplier) + oldPercentage);
                break;
            }
            case GEN_ATTACKED_DURING_FLEE: {
                threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_ATTACK, (double)1.0);
                threatPercentage *= DynamicStealthConfig.serverSettings.threat.attackedBySameMultiplier;
                threatPercentage /= (double)searcher.func_110138_aP();
                if (searcherSeesTarget) {
                    Threat.set(searcher, target, (float)threatPercentage + oldPercentage);
                    break;
                }
                Threat.setThreat(searcher, (float)threatPercentage + oldPercentage);
                break;
            }
            case GEN_DAMAGE_DEALT: {
                if (target != oldTarget || !searcherSeesTarget) break;
                threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_DAMAGE_TAKEN, (double)1.0);
                threatPercentage *= DynamicStealthConfig.serverSettings.threat.damageDealtMultiplier;
                Threat.setThreat(searcher, (float)(threatPercentage /= (double)target.func_110138_aP()) + oldPercentage);
                break;
            }
            case GEN_WARNED: {
                if (searcherSeesTarget) {
                    threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_WARNED_AGAINST, (double)1.0);
                }
                threatPercentage = Tools.max((double[])new double[]{threatPercentage, oldPercentage});
                if (searcherSeesTarget && target != null && oldTarget == null) {
                    Threat.set(searcher, target, (float)threatPercentage);
                    break;
                }
                Threat.setThreat(searcher, (float)threatPercentage);
                break;
            }
            case GEN_ALLY_KILLED: {
                if (searcherSeesTarget) {
                    threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATGEN_KILL, (double)1.0);
                }
                if (!searcherSeesTarget || target == oldTarget) {
                    Threat.setThreat(searcher, (float)threatPercentage + oldPercentage);
                    break;
                }
                if (oldTarget == null) {
                    Threat.set(searcher, target, (float)threatPercentage + oldPercentage);
                    break;
                }
                if (threatPercentage >= (double)oldPercentage) {
                    Threat.set(searcher, target, (float)threatPercentage);
                    break;
                }
                Threat.setThreat(searcher, (float)threatPercentage + oldPercentage);
                break;
            }
            case GEN_TARGET_VISIBLE: {
                if (!searcherSeesTarget || oldTarget == null) break;
                Threat.setThreat(searcher, (float)(threatPercentage *= MCTools.getAttribute((EntityLivingBase)oldTarget, (IAttribute)Attributes.THREATGEN_VISIBLE, (double)1.0)) + oldPercentage);
                break;
            }
            case DEG_TARGET_NOT_VISIBLE: {
                if (searcherSeesTarget) break;
                Threat.setThreat(searcher, oldPercentage - (float)(threatPercentage *= MCTools.getAttribute((EntityLivingBase)target, (IAttribute)Attributes.THREATDEG_NOT_VISIBLE, (double)1.0)));
                break;
            }
            case DEG_FLEE: {
                Threat.setThreat(searcher, oldPercentage - (float)(threatPercentage *= MCTools.getAttribute((EntityLivingBase)oldTarget, (IAttribute)Attributes.THREATDEG_FLEE_FROM, (double)1.0)));
                break;
            }
            case DEG_OWNED_CANT_REACH: {
                Threat.setThreat(searcher, oldPercentage - (float)threatPercentage);
            }
        }
    }

    public static class ThreatData {
        public EntityLivingBase searcher;
        public EntityLivingBase target;
        public float threatPercentage;
        public String searcherName;

        private ThreatData(EntityLivingBase searcher, EntityLivingBase target, float threatPercentage) {
            this.searcher = searcher;
            this.target = target;
            this.threatPercentage = threatPercentage;
            this.searcherName = searcher.func_70005_c_();
        }

        public ThreatData copy() {
            return new ThreatData(this.searcher, this.target, this.threatPercentage);
        }

        public boolean equals(ThreatData threatData) {
            return threatData != null && threatData.searcher == this.searcher && threatData.target == this.target && threatData.threatPercentage == this.threatPercentage && threatData.searcherName.equals(this.searcherName);
        }

        public String toString() {
            return this.searcherName + ", " + this.target.func_70005_c_() + ", " + this.threatPercentage;
        }
    }

    public static enum THREAT_TYPE {
        GEN_TARGET_SPOTTED,
        GEN_ATTACKED,
        GEN_ATTACKED_DURING_FLEE,
        GEN_DAMAGE_DEALT,
        GEN_WARNED,
        GEN_ALLY_KILLED,
        GEN_TARGET_VISIBLE,
        DEG_TARGET_NOT_VISIBLE,
        DEG_FLEE,
        DEG_OWNED_CANT_REACH;

    }
}

