﻿/**
 * 创建控件的实例
 * @class 所有控件的基类，提供生命周期管理以及事件功能
 * @constructs
 */
IKE.Control = Class(/** @lends IKE.Control# */{
    /**
     * 表示当前控件是否已经渲染
     * @property
     * @type Boolean
     */
    isRendered: false,
    
    /**
     * 表示当前控件是否已经销毁
     * @property
     * @type Boolean
     */
    isDisposed: false,
    
    /**
     * 将控件渲染在容器内
     * @param {Element} container 渲染当前控件的容器HTML元素
     */
    render: function(container) {
        if (this.isRendered) {
            throw 'already rendered';
        }
        this.rendering(container);
        this.isRendered = true;
        this.rendered(container);
    },
    
    /**
     * 销毁控件，将控件从容器中移除，并释放所有资源
     */
    dispose: function() {
        if (this.isDisposed) {
            throw 'already disposed';
        }
        this.disposing();
        this.isDisposed = true;
        this.disposed();
    },
    
    /**
     * 绑定事件
     * @param {String} name 事件名称
     * @param {Object} [data] 事件的额外数据，执行时通过e.data获取
     * @param {Function} fn 事件的处理函数
     */
    bind: function(name, data, fn) {
        $(this).bind('exui.' + name, data, fn);
    },
    
    /**
     * 注销事件
     * @param {String} name 事件名称
     * @param {String} fn 事件的处理函数
     */
    unbind: function(name, fn) {
        $(this).unbind('exui.' + name, fn);
    },
    
    /**
     * 触发事件
     * @param {String} name 事件名称
     * @param {Object} [data] 事件的额外数据，执行时通过e.data获取
     */
    trigger: function(name, data) {
        $(this).trigger('exui.' + name, data);
    },
    
    /**
     * 触发渲染开始事件
     * @param {Element} container 控件的容器HTML元素
     * @event
     */
    rendering: function(container) {
        this.trigger('rendering', { container: container });
    },
    
    /**
     * 触发渲染结束事件
     * @param {Element} container 控件的容器HTML元素
     * @event
     */
    rendered: function(container) {
        this.trigger('rendered', { container: container });
    },
    
    /**
     * 触发销毁开始事件
     * @event
     */
    disposing: function() {
        this.trigger('disposing');
    },
    
    /**
     * 触发销毁结束事件
     * @event
     */
    disposed: function() {
        this.trigger('disposed');
    }
});