﻿/**
 * 创建一个{@link IKE.CustomForm}对象
 * @class 自定义表单
 * @augments IKE.Control
 * @constructs
 */
IKE.CustomForm = Class(IKE.Control, {
    /**
    * 自定义表单table元素
    * @private
    */
    initRows: 5,
    initCols: 5,
    table: null,
    body: null,
    options: null,
    tableID: null,
    bodyID: null,
    containerID: null,
    startCell: null,
    endCell: null,
    startRowIndex: -1,
    startCellIndex: -1,
    endRowIndex: -1,
    endCellIndex: -1,
    minRowIndex: -1,
    MaxRowIndex: -1,
    minCellIndex: -1,
    MaxCellIndex: -1,
    isClick: false,
    templatePath: "F:\\customDesign\\templates\\",
    savePath: "F:\\customDesign\\saveFiles\\",
    currentCell: null,
    selectedArray: new Array(),
    currentRow: null,
    initialize: function(containerID, options) {
        this.containerID = containerID;
        this.tableID = $("table", "#" + this.containerID).first().attr("id");
        this.bodyID = $("tbody", "#" + this.containerID).first().attr("id");
        this.createTable();
        if (typeof options != "undefined")
            this.setOptions(options);
        else this.setOptions();
        this.initializeControlsAndEvents();
    },
    createTable: function() {
        for (var i = 1; i <= this.initRows; i++) {
            var row = $("<tr/>").attr("id", i).appendTo($("#" + this.bodyID));
            for (var j = 1; j <= this.initCols; j++) {

                if (j == 1 && i == 1) {
                    var cell = $("<td/>").attr("id", i + "/" + j).html("").addClass("disedit").addClass("firstRow").appendTo(row);
                }
                if (j == 1 && i != 1) {
                    var cell = $("<td/>").attr("id", i + "/" + j).html("第" + (i - 1) + "行").addClass("disedit").css({ "width": 50, "backgroundColor": "#F3F5F8" }).appendTo(row);
                }
                if (j != 1 && i == 1) {
                    var cell = $("<td/>").attr("id", i + "/" + j).html("第" + (j - 1) + "列").addClass("disedit").addClass("firstRow").attr("align", "center").appendTo(row);
                }
                if (j != 1 && i != 1) {
                    var cell = $("<td/>").attr("id", i + "/" + j).html(i + "/" + j).appendTo(row);
                }
            }
        }
    },
    setOptions: function(options) {
        this.options = {
            hoverColor: "#FFFDD7",        //移动时背景色   
            activeColor: "#FFFDD7",       //选中时背景色
            normalColor: "transparent",
            defaultBorderColor: "#D8DDE5",
            activeBorderColor: "red",
            activeCls: "movuseover",
            hover: true,                  //是否开启移动行背景色   
            choose: true,                 //是否开启选择   
            multiple: true,              //是否开启多选,开启后按Ctrl可以多选,取消功能需要同时开启
            editable: true,
            title: true,                 //是否提示title   
            cancel: true,                //是否开启取消功能   
            dclick: true,                //是否双击
            onCellClick: false,          //单元格单击  
            onControlClick: false,
            onCancel: function() { },    //取消选择时附加方法，此时取消功能必须开启   
            onMove: function() { },      //鼠标移动事件   
            onDClick: function() { }     //双击
        };
        $.extend(this.options, options || {});

    },
    initializeControlsAndEvents: function() {
        this.OnCellClick = this.options.onCellClick;
        this.OnControlClick = this.options.onControlClick;
        this.OnCancel = this.options.onCancel;
        this.OnMove = this.options.onMove;
        this.table = document.getElementById(this.tableID);
        this.body = document.getElementById(this.bodyID);
        this.AddMouseEvent();
        this.resize();

    },
    selectedIndex: function(elem) {
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (elem == this.selectedArray[i]) {
                return i;
            }
        }
        return -1;
    },
    //获取当前事件对象   
    getCurrentElement: function(e) {
        var elem = e.srcElement || e.target;
        if (elem.tagName.toUpperCase() == "TD") {
            return elem;
        }
        return null;
    },
    getCurrentTd: function() {
        if (this.selectedArray.length > 0)
            return this.selectedArray[0];
        else return false;
    },
    getCurrentControl: function(e) {
        var elem = e.srcElement || e.target;
        if (typeof $(elem).attr("xtype") != "undefined") {
            return elem;
        }
        return null;
    },
    checkIsControl: function(control) {
        var controlArray = ["TEXT", "LABEL"];
        var result = false;
        for (var ele in controlArray) {
            if (ele == control) { result = true; break; }
        }
        return result;
    },
    mouseOver: function(event) {
        try {

            var movedObj = this.getCurrentElement(event);

            if (movedObj == null || movedObj.className == "disedit") { return; };
            if (this.isClick == true && movedObj != null && movedObj.tagName == "TD") {
                $(movedObj).addClass(this.options.activeCls);
                this.selectedArray.splice(1, this.selectedArray.length);
                var index = this.selectedIndex(movedObj);
                if (index < 0) {
                    this.selectedArray.push(movedObj);
                }
                var me = this;
                var minLeft = $(this.startCell).offset().left;
                var maxRight = $(this.startCell).offset().right;
                var minTop = $(this.startCell).offset().top;
                var maxButtom = $(this.startCell).offset().bottom;
                $(this.selectedArray).each(function(index, cell) {
                    minLeft = Math.min($(cell).offset().left, minLeft);
                    minTop = Math.min($(cell).offset().top, minTop);
                    maxRight = Math.max($(cell).offset().right, maxRight);
                    maxButtom = Math.max($(cell).offset().bottom, maxButtom);
                });
                // $("tr td", $(me.table)).removeClass(me.options.activeCls);
                if (!this.checkIsRectangle()) {
                    //alert(me.selectedArray.length);
                    $("tr td", $(me.table)).each(function(index, ele) {

                        var cellIndex = $(ele).attr("cellIndex");
                        var rowIndex = $(ele).parent().attr("rowIndex");
                        var offsetLeft = ($(ele).offset().left + $(ele).offset().right) / 2;
                        var offsetTop = ($(ele).offset().top + $(ele).offset().bottom) / 2;
                        if (offsetLeft >= minLeft && offsetLeft <= maxRight && offsetTop >= minTop && offsetTop <= maxButtom) {
                            $(ele).addClass(me.options.activeCls);
                            var index = me.selectedIndex(me.table.rows[rowIndex].cells[cellIndex]);
                           // alert("index:" + index)
                            if (index < 0) {
                                 me.selectedArray.push(me.table.rows[rowIndex].cells[cellIndex]);
                            }
                        }
                    });
                }
            }

        }
        catch (e) {
            alert(e.message);
        }
    },
    isColspanOrRowspan: function() {

        var flag = false;
        $("tr td", $(this.table)).each(function(index, ele) {
            if ($(ele).attr("colSpan") > 1 || $(ele).attr("rowSpan") > 1)
                flag = true;
            return;
        });
        return flag;
    },
    onMouseDown: function(e) {
        try {
            this.remove();
            this.startCell = null;
            this.endCell = null;
            var movedObj = this.getCurrentElement(e);
            if (movedObj != null && movedObj.tagName == "TD") {
                this.startCell = movedObj
                $(this.startCell).addClass(this.options.activeCls);
                this.selectedArray.push(this.startCell);
                this.isClick = true;
            }

        }
        catch (e) {
            alert(e.message);
        }
    },
    getSelectedCell: function() {
        if (this.selectedArray.length >= 1)
            return this.selectedArray[0];
        return null;
    },
    mouseOut: function(event) {
        this.endCell = this.getCurrentElement(event);
    },
    mouseUp: function(event) {
        this.endCell = this.getCurrentElement(event);
        this.isClick = false;
    },
    addSelected: function(elem) {
        this.selectedArray.push(elem);
    },
    //从集合中移除   
    removeSelected: function(elem) {
        var index = this.selectedIndex(elem);
        this.selectedArray.splice(index, 1);
    },
    mouseClick: function(e) {
        //单击单元格
        if (this.options.onCellClick && $.isFunction(this.options.onCellClick)) {
            var elem = this.getCurrentElement(e);
            if (elem != null) {
                this.options.onCellClick.call(this, e);
            }
        }
    },
    resize: function() {
        $("#" + this.tableID).tableresizer({
            row_border: "2px solid #CCC",
            col_border: "2px solid #CCC"
        });
        this.dragEnd();
    },
    Editable: function(e) {
        var elem = e.srcElement || e.target;
        if (elem.tagName.toUpperCase() == "LABEL") {
            if (!elem.lastChild || elem.lastChild.tagName != "TEXTAREA") {
                var box = document.createElement("textarea");
                box.style.cssText = "background-color:transparent;border:none; font:12px 宋体;margin:-2pt -1pt;width:100%; overflow:hidden";
                box.rows = 1;
                if (elem.align) box.style.textAlign = elem.align;
                box.defaultValue = box.value = "";
                elem.innerHTML = "";
                elem.appendChild(box);
                box.onpropertychange = function() {
                    if (this.value) this.style.posHeight = this.scrollHeight;
                }
                box.onblur = function() {
                    if (this.value == this.defaultValue) {
                        elem.innerText = this.value;

                    }
                    $(elem).css("backgroundColor", "#FFF");
                }
                box.focus();

            }
        }

    },
    addControl: function(control, currentCell) {
        var currentCell = currentCell;
        var divText = $("<span/>").addClass("span-control-container").css({ "marginRight": "5px" });
        var type = $(control).attr("xtype");
        switch (type) {
            case "font":
                {
                    divText.attr({ "xtype": "font", "xTypeName": "文字标签" });
                    var txtInput = $("<label/>").html("添加文字(Label)").addClass("x-form-custom-lblInput")
                                                            .dblclick(function(e) { $(this).css({ "backgroundColor": "#FFFFDD" }); currentTable.Editable(e); })
                                                           .appendTo(divText);
                    break;
                }
            case "text":
                {
                    divText.attr({ "type": "text", "xtype": "text", "xTypeName": "文本框" })
                    var txtInput = $("<input/>").addClass("x-form-custom-txtInput").val("请输入文本")
                                                            .appendTo(divText);
                    break;
                }
            case "textarea":
                {
                    divText.attr({ "xtype": "textarea", "xTypeName": "文本域" });
                    var textArea = $("<textarea cols='5' style='width:200' rows='6'>请输入文本</textarea>")
                                                                           .addClass("x-form-custom-textArea")
                                                                        .appendTo(divText);

                    break;
                }
            case "dropdown":
                {
                    divText.attr({ "xtype": "dropdown", "xTypeName": "下拉框" });
                    var dropdown = $("<div/>").addClass("myui-form-div-dropdown").appendTo(divText);
                    var txtInput = $("<input type='text'/>").width(90).appendTo(dropdown);
                    var hidden = $("<input type='hidden'/>").appendTo(dropdown);
                    var picker = $("<div style='LEFT: 90px'/>").addClass("dropicon").appendTo(dropdown);
                    break;
                }
            case "date":
                {
                    divText.attr({ "xtype": "date", "xTypeName": "日期控件" });
                    var dropdown = $("<div/>").addClass("myui-form-div-datepicker")
                                              .appendTo(divText);
                    var txtInput = $("<input type='text'/>").width(90).appendTo(dropdown);
                    var hidden = $("<input type='hidden'/>").appendTo(dropdown);
                    var picker = $("<div style='LEFT: 90px'/>").addClass("datepickericon").appendTo(dropdown);
                    break;
                }
            case "button":
                {
                    divText.attr({ "xtype": "button", "xTypeName": "按钮" });
                    var txtInput = $("<a class=\"x-btn\"></a>").appendTo(divText);
                    var spanText = $("<span class=\"x-btn-r\"></span>").text("添加text").appendTo(txtInput);
                    break;
                }
            case "radio":
                {
                    divText.attr({ "xtype": "radio", "xTypeName": "单选项" });
                    var txtInput = $("<input/>").attr({ "type": "radio" }).appendTo(divText);
                    var laltext = $("<label/>").html("radio").appendTo(divText);
                    break;
                }
            case "checkbox":
                {
                    divText.attr({ "xtype": "checkbox", "xTypeName": "多选项" });
                    var txtInput = $("<input/>").attr({ "type": "checkbox" }).appendTo(divText);
                    var laltext = $("<label/>").html("checkbox").appendTo(divText);
                    break;
                }
            case "grid":
                {
                    divText.attr({ "xtype": "gird", "xTypeName": "网格列表" });
                    IKE.LoadPage("controlProperty/grid.htm", { timer: new Date().getMilliseconds() }, function(data) {
                        $(data).appendTo(divText);
                    });
                    break;
                }
            default: break;
        }
        if (currentCell != null) {
            $(currentCell).append(divText);

        }
        currentCell = null;
        //单击控件
        var me = this;
        $(divText).dragable({
            accept: $("tr td:not(.disedit)", me.table),
            dragEnd: function(ui, ele) {
                $(ele).append($(ui));
            },
            onclick: function(e, ui) {
                if (!(typeof $(ui).attr("xtype") === undefined) && me.options.onControlClick && $.isFunction(me.options.onControlClick)) {
                    var elem = this;
                    if (elem != null) {
                        me.options.onControlClick.call(this, e, $(this));
                        IKE.stop(e);
                    }
                }
            }
        });
    },
    dragEnd: function() {
        var me = this;
        //拖放事件结束
        $("tr td:not(.disedit)", this.table).droppable({
            accept: "#div-left-menu-content div:not(.line) a",
            hoverClass: "dropHover",
            drop: function(event, ui) {
                var clone = ui.draggable.clone();
                me.addControl(clone, $(this));
                //window.clipboardData.setData("text", $(document.body).html());
            }
        });
    },
    getCellIndex: function(cell) {
        var left = $(cell).offset().left;
        var colIndex = 1;
        var width = 0;
        $("tr:first th", this.table).each(function(index, th) {
            if (left < ($(th).offset().left + $(th).width() / 2)) {
                colIndex = $(th).attr("cellIndex");
                return false;
            }
        });
        return colIndex;
    },
    checkIsRectangle: function() {
        //算法：selectedCellCount=(maxRowId-minRowId+1)*( maxColId-minColId+1) 
        var maxRowNumber = 0;
        var minRowNumber = 1000;
        var maxColNumber = 0;
        var minColNumber = 1000;
        var selectedCellCount = 0;
        var me = this;
        $(this.selectedArray).each(function(index, cell) {
            var colspan = $(cell).attr("colspan");
            var rowspan = $(cell).attr("rowspan");
            selectedCellCount = selectedCellCount + colspan * rowspan;
            var rowIndex = $(cell).parent().attr("rowIndex");
            var colIndex = me.getCellIndex(cell);
            //获取最大，最小行列号
            minRowNumber = Math.min(minRowNumber, rowIndex);
            minColNumber = Math.min(minColNumber, colIndex);
            if (rowspan > 1) rowIndex = rowIndex + rowspan - 1;
            if (colspan > 1) colIndex = colIndex + colspan - 1;
            maxColNumber = Math.max(maxColNumber, colIndex);
            maxRowNumber = Math.max(maxRowNumber, rowIndex);
        });
        //alert(this.selectedArray.length + "," + selectedCellCount + "," + maxRowNumber + "," + minRowNumber + "," + maxColNumber + "," + minColNumber)
        if (selectedCellCount != (maxRowNumber - minRowNumber + 1) * (maxColNumber - minColNumber + 1))
            return false;
        return true;
    },
    AddMouseEvent: function() {
        var me = this;
        if (this.options.hover) {
            //$("tbody tr td", $(this.table)).hover(function() {$(this).css("backgroundColor",me.options.hoverColor) }, function() { $(this).css("backgroundColor", me.options.normalColor); });
        }
        if (this.options.choose) {
            $(this.table).click(function(e) { me.mouseClick(e); IKE.stop(e); });
        }
        if (this.options.editable) {
            //$(this.table).dblclick(function(e){me.Editable(e);});
        }
        $(this.table).mouseover(function(e) { me.mouseOver(e); }).mouseout(function(e) { me.mouseOut(e); })
                     .mousedown(function(e) { me.onMouseDown(e); }).mouseup(function(e) { me.mouseUp(e); })
                     .bind("selectstart", function() { return false }).css("MozUserSelect", "none");
        $(document).click(function(e) {
            me.remove();
        });
        //keep control event
        $(".span-control-container").dragable({
            accept: $("tr td:not(.disedit)", me.table),
            dragEnd: function(ui, ele) {
                $(ele).append($(ui));
            },
            onclick: function(e, ui) {
                if (!(typeof $(ui).attr("xtype") === undefined) && me.options.onControlClick && $.isFunction(me.options.onControlClick)) {
                    var elem = this;
                    if (elem != null) {
                        me.options.onControlClick.call(this, e, $(this));
                        IKE.stop(e);
                    }
                }
            }
        });

    },
    getTableCols: function(table) {
        var tableObject = table;
        if (!tableObject.rows || !tableObject.rows[0] || !tableObject.rows[0].cells) {
            return 0;
        }
        var cells = tableObject.rows[0].cells;
        var cols = 0;
        for (var col = 0; col < cells.length; col++) {
            if (cells[col].colSpan && cells[col].colSpan > 1) {
                cols = cols + cells[col].colSpan;
            }
            else {
                cols = cols + 1;
            }
        }
        return cols;
    },
    addRow: function() {
        var length = this.table.rows.length;
        var row = $("<tr/>").attr("id", (length + 1)).appendTo($(this.body));
        var colNumber = this.getTableCols(this.table);
        for (i = 1; i <= colNumber; i++) {
            //var cell = $("<td/>").attr("id", row.id + "/" + i).html((length + 1) + "/" + i).appendTo(row);
            if (i == 1) {
                var cell = $("<td/>").attr("id", (length + 1) + "/" + i).html("第" + (length) + "行").addClass("disedit").css({ "width": 50, "backgroundColor": "#F3F5F8" }).appendTo(row);
            }
            if (i != 1) {
                var cell = $("<td/>").attr("id", (length + 1) + "/" + i).html((length + 1) + "/" + i).appendTo(row);
            }
        }
        this.resize();
    },
    removeRow: function() {
        var length = this.table.rows.length;
        if (length <= 2) { alert("表格的行数不允许少于1"); }
        else {
            var row = $("#" + length);
            if (row) { $(row).remove(); }
        }
    },
    addColumn: function() {
        var length = this.getTableCols(this.table) + 1;
        for (var i = 0; i < this.table.rows.length; i++) {
            if (i == 0) {
                var cell = $("<th/>").attr("id", (i + 1) + "/" + length).html("第" + (length - 1) + "列").addClass("disedit").addClass("firstRow").attr("align", "center").appendTo($(this.table.rows[i]));
            }
            if (i != 0) {
                var cell = $("<td/>").attr("id", (i + 1) + "/" + length).html((i + 1) + "/" + length).appendTo($(this.table.rows[i]));
            }
        }
        this.resize();
    },
    removeColumn: function() {
        var colNumber = this.getTableCols(this.table);
        if (colNumber <= 2) { alert("表格的列数不允许少于1"); }
        else {
            for (var i = 0; i < this.table.rows.length; i++) {
                var cell = document.getElementById((i + 1) + "/" + (colNumber))
                if (cell) {
                    var parentElement = cell.parentNode;
                    if (parentElement) {
                        parentElement.removeChild(cell);
                    }
                }
            }
        }
    },
    sortSelected: function() {
        if (this.selectedArray.length > 2) {
            this.selectedArray.sort(function(x, y) {
                var x1 = x.id.split("/");
                var y1 = y.id.split("/");
                return (parseInt(x1[0]) - parseInt(y1[0]) || parseInt(x1[1]) - parseInt(y1[1]));
            })
        } else {
            return;
        }
    },
    findCellById: function(cellID) {
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (this.selectedArray[i].id == cellID) {
                return i;
            }
        }
        return -1;
    },
    getMaxRowIndex: function() {
        var MaxRowNum = 0;
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (parseInt(this.selectedArray[i].id.split("/")[0]) > MaxRowNum) {
                MaxRowNum = parseInt(this.selectedArray[i].id.split("/")[0]);
            }
        }
        return MaxRowNum;
    },

    getMaxCellIndex: function() {
        var MaxColNum = 0;
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (parseInt(this.selectedArray[i].id.split("/")[1]) > MaxColNum) {
                MaxColNum = parseInt(this.selectedArray[i].id.split("/")[1]);
            }
        }
        return MaxColNum;
    },

    getMinRowIndex: function() {
        var MinRowNum = 999999;
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (parseInt(this.selectedArray[i].id.split("/")[0]) < MinRowNum) {
                MinRowNum = parseInt(this.selectedArray[i].id.split("/")[0]);
            }
        }
        return MinRowNum;
    },
    getMinCellIndex: function() {
        var MinColNum = 999999;
        for (var i = 0; i < this.selectedArray.length; i++) {
            if (parseInt(this.selectedArray[i].id.split("/")[1]) < MinColNum) {
                MinColNum = parseInt(this.selectedArray[i].id.split("/")[1]);
            }
        }
        return MinColNum;
    },
    removeAllSelected: function() {
        var count = this.selectedArray.length;
        this.selectedArray.splice(0, count);
    },
    clear: function() {
        for (var i = 0; i < this.selectedArray.length; i++) {
            $(this.selectedArray[i]).removeClass(this.options.activeCls);
        }
        this.removeAllSelected();
    },
    reDesign: function(rows, cells, options) {
        this.initRows = rows || 5;
        this.initCols = cells || 4;
        this.createTable();
        if (typeof options != "undefined")
            this.setOptions(options);
        else this.setOptions();
        this.initializeControlsAndEvents();
    },
    remove: function() {
        this.removeAllSelected();
        $("tr td", $(this.table)).removeClass(this.options.activeCls);
    },
    mergeCells: function() {
        if (!this.checkIsRectangle()) {
            this.clear();
            this.removeAllSelected();
            return false;
        }
        var minRow = this.getMinRowIndex();
        var minCol = this.getMinCellIndex();
        var maxRow = this.getMaxRowIndex();
        var maxCol = this.getMaxCellIndex();
        //同行合并   
        if (minRow == maxRow) {
            var distance = parseInt(maxCol) - parseInt(minCol); //得到列差值
            var tmpCell = document.getElementById(minRow + "/" + minCol);
            var cellContent = [];
            tmpCell.colSpan = distance + 1;
            for (var i = 0; i < this.selectedArray.length; i++) {
                if (this.selectedArray[i].id != tmpCell.id) {
                    var parentElement = this.selectedArray[i].parentNode;
                    if (parentElement) {
                        cellContent.push(this.selectedArray[i].innerHTML);
                        parentElement.removeChild(this.selectedArray[i]);
                    }
                }
            }
            $(tmpCell).append(cellContent.join("")); cellContent = null;
        }

        //同列合并   
        if (minCol == maxCol) {
            var distance = parseInt(maxRow) - parseInt(minRow); //得到列差值
            var tmpCell = document.getElementById(minRow + "/" + minCol);
            var cellContent = [];
            tmpCell.rowSpan = distance + 1;
            for (var i = 0; i < this.selectedArray.length; i++) {
                if (this.selectedArray[i].id != tmpCell.id) {
                    var parentElement = this.selectedArray[i].parentNode;
                    if (parentElement) {
                        cellContent.push(this.selectedArray[i].innerHTML);
                        parentElement.removeChild(this.selectedArray[i]);
                    }
                }
            }
            $(tmpCell).append(cellContent.join("")); cellContent = null;
        }
        //多行多列合并   
        if ((minRow != maxRow) && (minCol != maxCol)) {
            var row_distance = parseInt(maxRow) - parseInt(minRow); //得到行差值   
            var col_distance = parseInt(maxCol) - parseInt(minCol); //得到列差值
            var tmpCell = document.getElementById(minRow + "/" + minCol);
            var cellContent = [];
            tmpCell.rowSpan = row_distance + 1; //行合并   
            tmpCell.colSpan = col_distance + 1; //列合并     
            for (var i = 0; i < this.selectedArray.length; i++) {
                if (this.selectedArray[i].id != tmpCell.id) {
                    var parentElement = this.selectedArray[i].parentNode;
                    if (parentElement) {
                        cellContent.push(this.selectedArray[i].innerHTML);
                        parentElement.removeChild(this.selectedArray[i]);
                    }
                }
            }
            $(tmpCell).append(cellContent.join("")); cellContent = null;

        }
        this.clear();
        this.removeAllSelected();
    },
    splitCells: function() {
        if (this.selectedArray.length <= 0) {
            alert("请选择要拆分的单元格！");
        } else {
            for (var i = 0; i < this.selectedArray.length; i++) {
                if ((this.selectedArray[i].colSpan > 1) && (this.selectedArray[i].rowSpan > 1)) {
                    var cellPoint = this.selectedArray[i].id.split("/")
                    var colNum = parseInt(cellPoint[1]);
                    var rowNum = parseInt(cellPoint[0]);
                    for (var m = this.selectedArray[i].colSpan; m > 0; m--) {
                        for (var j = this.selectedArray[i].rowSpan; j > 0; j--) {
                            var cellY = colNum + m - 1;
                            var cellX = rowNum + j - 1;
                            if (document.getElementById(cellX + "/" + cellY)) {
                            } else {
                                var insertCellNum = cellY - 1;
                                for (var d = cellY; d >= 0; d--) {
                                    if (document.getElementById(cellX + "/" + d)) {
                                        insertCellNum = d;
                                        break;
                                    }
                                }
                                var x = document.getElementById(cellX + "").insertCell(insertCellNum);
                                x.id = cellX + "/" + cellY;
                                //x.innerHTML = cellX + "/" + cellY;
                            }
                        }
                    }
                    this.selectedArray[i].rowSpan = 1;
                    this.selectedArray[i].colSpan = 1;
                } else {
                    if (this.selectedArray[i].colSpan > 1) {
                        var cellPoint = this.selectedArray[i].id.split("/")
                        var colNum = parseInt(cellPoint[1]);
                        for (var m = this.selectedArray[i].colSpan; m > 0; m--) {
                            var cellY = colNum + m - 1;
                            if (document.getElementById(cellPoint[0] + "/" + cellY)) {
                            } else {
                                var x = document.getElementById(cellPoint[0] + "").insertCell(cellY - 1);
                                x.id = cellPoint[0] + "/" + cellY;
                                //x.innerHTML = cellPoint[0] + "/" + cellY;
                            }
                        }
                        this.selectedArray[i].colSpan = 1;
                    }
                    if (this.selectedArray[i].rowSpan > 1) {
                        var cellPoint = this.selectedArray[i].id.split("/")
                        var rowNum = parseInt(cellPoint[0]);
                        for (var m = this.selectedArray[i].rowSpan; m > 0; m--) {
                            var cellX = rowNum + m - 1;
                            if (document.getElementById(cellX + "/" + cellPoint[1])) {
                            } else {
                                var x = document.getElementById(cellX + "").insertCell(cellPoint[1] - 1);
                                x.id = cellX + "/" + cellPoint[1];
                                //x.innerHTML = cellX + "/" + cellPoint[1];
                            }
                        }
                        this.selectedArray[i].rowSpan = 1;
                    }
                }
            }
            this.clear();
            this.removeAllSelected();
        }
    },
    previewDesign: function() {
        //        var divResult;
        //        if ($(".divPreviewResult").length == 0) {
        //            divResult = $("<div/>").addClass("divPreviewResult").appendTo($(document.body));
        //        }
        //        else divResult = $(".divPreviewResult").first();
        //        var resultHtml = $(this.table.parentNode.parentNode.innerHTML).appendTo(divResult.empty());
        //        // $("tr th", resultHtml.children("table")).remove();
        //        /// $(".disedit", resultHtml.children("table")).remove();
        //        //initialize control;
        //       // return divResult.html();
        return this.table.parentNode.innerHTML;

    }

});