﻿/**
@class 为IKE框架提供命名空间作用及部分静态辅助方法
*/
var IKE = /** @lends IKE# */{
/**
* 当前IKE框架的版本号
* @property
* @type String
*/
version: '0.8',

/**
* @private
*/
host: '',

/**
* 空方法，可用在继承、重写等环境
* @property
* @type Function
*/
emptyFn: function() {
},

/**
* 返回true的方法
* @property
* @type Function
*/
returnTrue: function() {
    return true
},

/**
* 返回false的方法
* @property
* @type Function
*/
returnFalse: function() {
    return false;
},

/**
* 停止某个事件的传播（父元素无法再接收到该事件）
* @param {Event} event DOM事件对象
*/
stop: function(e) {
    e.stopPropagation();
    e.preventDefault();
},

/**
* 使某个元素内的内容无法选定
* @param {Element} element 目标HTML元素
*/
unselectable: function(element) {
    $(element)
            .attr('unselectable', 'on') //通用
            .addClass('IKE-unselectable') //firefox用
            .bind('selectstart', IKE.returnFalse); //ie用
},

 ajaxError: function(XMLHttpRequest, textStatus, errorThrown) {
        alert("XMLHttp status: " + XMLHttpRequest.responseText + +XMLHttpRequest.status + " " + XMLHttpRequest.statusText + "\errorReason: " + textStatus + "\nExceptionError:" + errorThrown);
    },
    beforeSendCallBack: function(XMLHttpRequest) {
        this;
    },
    ajaxSend: function(type, dataType, url, data, callback) {

        jQuery.ajax({
            type: type,
            url: url,
            dataType: dataType,
            data: data,
            timeout: 50000,
            cache: false,
            beforeSend: this.beforeSendCallBack,
            error: this.ajaxError,
            success: callback
        });
        return false;
    },
    ActionResult: function(url, data, callback) {

        this.ajaxSend("GET", "json", url, data, callback);
    },
    LoadPage: function(url, data, callback) {
        this.ajaxSend("GET", "html", url, data, callback);
    },
    Namespace: function() {
        var o, d;
        $(arguments).each(function(index, v) {
            d = v.toString().split(".");
            o = window[d[0]] = window[d[0]] || {};
            $(d.slice(1)).each(function(index, v2) {
                o = o[v2] = o[v2] || {};
            });
        });
        return o;
    }

};

/**
* @class 键盘按键列表
*/
IKE.KeyCode = {
    /**
    * 回退键
    * @property
    * @static
    * @type int
    */
    Backspace: 8,

    /**
    * Tab键
    * @property
    * @static
    * @type int
    */
    Tab: 9,

    /**
    * Return键
    * @property
    * @static
    * @type int
    */
    Return: 13,

    /**
    * ESC键
    * @property
    * @static
    * @type int
    */
    Esc: 27,

    /**
    * 左方向键
    * @property
    * @static
    * @type int
    */
    Left: 37,

    /**
    * 上方向键
    * @property
    * @static
    * @type int
    */
    Up: 38,

    /**
    * 右方向键
    * @property
    * @static
    * @type int
    */
    Right: 39,

    /**
    * 下方向键
    * @property
    * @static
    * @type int
    */
    Down: 40,

    /**
    * DEL键
    * @property
    * @static
    * @type int
    */
    Delete: 46
};

/**
* @class 常量集合
*/
IKE.Const = {
    /**
    * HTML转义的空格
    * @property
    * @static
    * @type String
    */
    Space: '&nbsp;',

    /**
    * HTML转义的大于(>)符号
    * @property
    * @static
    * @type String
    */
    Gt: '&gt;',

    /**
    * HTML转义的小于(<)符号
    * @property
    * @static
    * @type String
    */
    Lt: '&lt;'
};

/**
* 将包含img元素的div在IE6下替换为AlphaImageLoader
*/
$.fn.alphaDIV = function() {
    return this.each(function() {
        IKE.alphaDIV(this);
    });
};

/**
* 将使用PNG作为背景图片的元素在IE6下替换为AlphaImageLoader
* @for jQuery.fn
*/
$.fn.bgHack = function() {
    return this.each(function() {
        IKE.bgHack(this);
    });
};

/**
* 使某个元素内的内容无法选定
* @for jQuery.fn
*/
$.fn.unselectable = function() {
    return this.each(function() {
        IKE.unselectable(this);
    });
};

/**
* 注册HTML元素的hover事件，使其在鼠标移入时添加特定的CSS类
* @param {String} className 鼠标移入时添加的CSS类
* @for jQuery.fn
*/
$.fn.hoverClass = function(className) {
    return this.each(function() {
        $(this).hover(
            function() { $(this).addClass(className); },
            function() { $(this).removeClass(className); }
        );
    });
};

//删除数组中元素
$.remove = function(array, item) {
    if (!item) {
        return false;
    }
    for (var length = array.length, i = 0; i < length; i++) {
        if (array[i] === item) {
            array.splice(i, 1);
            return true;
        }
    }
    return false;
};

//获取符合条件的第一个，或者null
$.first = function(array, callback) {
    //2表参数的时候，第1个为数组，第2个为回调函数
    if (arguments.length == 2) {
        for (var length = array.length, i = 0; i < length; i++) {
            var item = array[i];
            if (callback.apply(item, [item, i]) === true) {
                return item;
            }
        }
        return null;
    }
    //3个参数的时候，第1个为数组，第2个为成员名称，第3个为成员值
    //$.first(array, fieldName, fieldValue)
    else {
        var fieldName = arguments[1];
        var fieldValue = arguments[2];
        return $.first(array, function() { return this[fieldName] === fieldValue });
    }
};

//判断数组中是否有符合条件的元素
$.contains = function(array, callback) {
    if ($.isFunction(callback)) {
        return $.first.apply(this, arguments) != null;
    }
    //2个参数，第1个为数组，第2个为要判断的元素
    else {
        return callback ? $.inArray(callback, array) >= 0 : false;
    }
};

/**
* 创建一个类
* @param {Class} [baseType] 父类
* @param {Object} extend 重写或扩展的内容
*/
function Class(baseType, extend) {
    var type = function() {
        this.initialize.apply(this, arguments);
    };
    type.prototype = $.extend(false, {}, baseType.prototype || baseType, extend);
    return type;
};