﻿/*
*创建一个{@link IKE.CUSTOMERFORM}对象
*@class 表单自定义
*@augments IKE.Control
*@constructs
*/

IKE.CustomerForm=Class(IKE.Control,{
//自定义表单元素
    title:true,
    setOptions:function(options)
    {
        this.options=
        {
            onClickControl:false    //单击控件单击
        };
        $.extend(this.options,options || {});
    },
    getCurrentControl:function(e)
    {
        var em=e.srcElement || e.target;
        if(typeof($(em).attr("xtype"))!="undefined")
        {
            return em;
        }
        return null;
    },
    addControl:function(control)
    {
        var controlType=$(control).attr("xtype");
        var divText=$("<div/>");
        switch (controlType) {
            case "font":
                {
                    divText.attr({ "xtype": "font", "xTypeName": "文字标签" });
                    var txtInput = $("<label/>").html("添加文字(Label)").addClass("x-form-custom-lblInput")
                                                            .dblclick(function(e) { $(this).css({ "backgroundColor": "#FFFFDD" }); currentTable.Editable(e); })
                                                           .appendTo(divText);
                    break;
                }
            case "text":
                {
                    divText.attr({ "type": "text", "xtype": "text", "xTypeName": "文本框" })
                    var txtInput = $("<input/>").addClass("x-form-custom-txtInput").val("请输入文本")
                                                            .appendTo(divText);
                    break;
                }
            case "textarea":
                {
                    divText.attr({ "xtype": "textarea", "xTypeName": "文本域" });
                    var textArea = $("<textarea cols='5' style='width:200' rows='6'>请输入文本</textarea>")
                                                                           .addClass("x-form-custom-textArea")
                                                                        .appendTo(divText);

                    break;
                }
            case "dropdown":
                {
                    divText.attr({ "xtype": "dropdown", "xTypeName": "下拉框" });
                    var dropdown = $("<div/>").addClass("myui-form-div-dropdown").appendTo(divText);
                    var txtInput = $("<input type='text'/>").width(90).appendTo(dropdown);
                    var hidden = $("<input type='hidden'/>").appendTo(dropdown);
                    var picker = $("<div style='LEFT: 90px'/>").addClass("dropicon").appendTo(dropdown);
                    break;
                }
            case "date":
                {
                    divText.attr({ "xtype": "date", "xTypeName": "日期控件" });
                    var dropdown = $("<div/>").addClass("myui-form-div-datepicker")
                                              .appendTo(divText);
                    var txtInput = $("<input type='text'/>").width(90).appendTo(dropdown);
                    var hidden = $("<input type='hidden'/>").appendTo(dropdown);
                    var picker = $("<div style='LEFT: 90px'/>").addClass("datepickericon").appendTo(dropdown);
                    break;
                }
            case "button":
                {
                    divText.attr({ "xtype": "button", "xTypeName": "按钮" });
                    var txtInput = $("<a class=\"x-btn\"></a>").appendTo(divText);
                    var spanText = $("<span class=\"x-btn-r\"></span>").text("添加text").appendTo(txtInput);
                    break;
                }
            case "radio":
                {
                    divText.attr({ "xtype": "radio", "xTypeName": "单选项" });
                    var txtInput = $("<input/>").attr({ "type": "radio" }).appendTo(divText);
                    var laltext = $("<label/>").html("radio").appendTo(divText);
                    break;
                }
            case "checkbox":
                {
                    divText.attr({ "xtype": "checkbox", "xTypeName": "多选项" });
                    var txtInput = $("<input/>").attr({ "type": "checkbox" }).appendTo(divText);
                    var laltext = $("<label/>").html("checkbox").appendTo(divText);
                    break;
                }
            default: break;
        }
        //单击控件
        //单击控件
        var me = this;
        $(divText).dragable({
            accept: $("tr td:not(.disedit)", me.table),
            dragEnd: function(ui, ele) {
                $(ele).append($(ui));
            },
            onclick: function(e, ui) {
                if (!(typeof $(ui).attr("xtype") === undefined) && me.options.onControlClick && $.isFunction(me.options.onControlClick)) {
                    var elem = this;
                    if (elem != null) {
                        me.options.onControlClick.call(this, e, $(this));
                    }
                }
            }
        });
    },
    //
    dragEnd:function(){
        var me = this;
        //拖放事件结束
        $("tr td:not(.disedit)", this.table).droppable({
            accept: "#div-left-menu-content div:not(.line) a",
            hoverClass: "dropHover",
            drop: function(event, ui) {
                var clone = ui.draggable.clone();
                me.addControl(clone);
                //window.clipboardData.setData("text", $(document.body).html());
            }
        });
    }
});