﻿(function($) {
    $.ike = $.ike || {};
    $.fn.dragable = function(options) {
        return this.each(function() {
            new $.ike.dragable(this, options);
        });
    }
    $.ike.dragable = Class({
        options: null,
        target: null,
        clone: null,
        cloneTemplate: '<div class="ike-drag-clone"></div>',
        isRenderedClone: $(".ike-drag-clone").length > 0,
        isdraging: false,
        accept: false,
        hoverCss: "dropHover",
        initialize: function(target, options) {
            this.target = $(target).css('cursor', 'pointer');
            if (!this.isRenderedClone) { $(document.body).append(this.cloneTemplate); }
            this.options = $.extend({}, $.ike.dragable.defaults, options);
            this.clone = $("div.ike-drag-clone").css({ "left": 0, "top": 0 }).hide();
            this.accept = this.options.accept;
            this.hoverCss = this.options.hoverCss;
            this.initEvents();

        },
        initEvents: function() {
            this.drag();
        },

        drag: function() {
            var me = this;
            $(this.target).mousedown(function(e) {
                me.clone.css({ "left": e.clientX + 5, "top": me.clientY + 5 }).html(me.target.clone()).show();
                me.isdraging = true;
                if (me.options.onclick && $.isFunction(me.options.onclick)) {

                    me.options.onclick.call(this, e, $(this));
                }
                IKE.stop(e);
            });
            $(document).mousemove(function(e) {
                if (!me.isdraging) return false;
                me.clone.css({ "left": e.clientX, "top": e.clientY });
                $(me.accept).each(function(index, ele) {
                    //$(ele).html($(ele).offset().left + "|" + e.clientX + "|" + ($(ele).offset().left + $(ele).width()) + "<br/>" + $(ele).offset().top + "|" + e.clientY + "|" + ($(ele).offset().top + $(ele).height()));
                    if (e.clientX > $(ele).offset().left && e.clientX < ($(ele).offset().left + $(ele).width())
                     && e.clientY > $(ele).offset().top && e.clientY < ($(ele).offset().top + $(ele).height())) {
                        $(ele).addClass(me.hoverCss);
                    }
                    else
                        $(ele).removeClass(me.hoverCss);
                });
               
              
            }).bind("selectstart", function() { return false }).css("MozUserSelect", "none").mouseup(function(e) {
                $(me.accept).each(function(index, ele) {
                    if (e.clientX > $(ele).offset().left && e.clientX < ($(ele).offset().left + $(ele).width())
                     && e.clientY > $(ele).offset().top && e.clientY < ($(ele).offset().top + $(ele).height())) {
                        if (me.options.dragEnd && $.isFunction(me.options.dragEnd) && me.isdraging) {
                            if (me.options.isDelete) {
                                me.options.dragEnd.call(this, me.target, $(ele));
                            }
                            $(ele).removeClass(me.hoverCss);
                            return false;
                        }


                    }
                });
                me.clone.hide();
                me.isdraging = false;


            });
        }

    });
    $.extend($.ike.dragable, {
        defaults: {
            helper: false,
            isDelete: true,
            accept: false,
            hoverCss: "dropHover",
            dragEnd: false,
            onclick: false
        }
    });
})(jQuery)