﻿(function($) {
    $.ike = $.ike || {};
    $.fn.dropable = function(options) {
        return this.each(function() {
        new $.ike.dropable(this, options);
        });
    }
    $.ike.dropable = Class({
        options: null,
        target: null,
        clone: null,
        cloneTemplate: '<div class="ike-drag-clone"></div>',
        isRenderedClone: $(".ike-drag-clone").length > 0,
        isdraging: false,
        startLeft: 0,
        starTop: 0,
        startX: 0,
        startY: 0,
        accept: false,
        hoverCss: "hover",
        initialize: function(target, options) {
            this.target = $(target).css('cursor', 'move');
            if (!this.isRenderedClone) { $(document.body).append(this.cloneTemplate); }
            this.options = $.extend({}, $.ike.dragable.defaults, options);
            //this.clone = $("div.ike-drag-clone").hide();
            this.clone = $(target).clone().hide().addClass(".ike-drag-clone");
            var accept = this.options.accept;
            this.accept = $.isFunction(accept) ? accept : function(d) {
                return d.is(accept);
            };
            this.initEvents();

        },
        initEvents: function() {
            this.drag();
        },
        drag: function() {
            var me = this;
            $(this.target).mousedown(function(e) {
                var offset = $(this).offset();
                me.startLeft = offset.left;
                me.starTop = offset.top;
                me.startX = e.clientX;
                me.startY = e.clientY;
                me.clone.css({ "left": e.clientX + 5, "top": me.clientY + 5 }).show();
                me.isdraging = true;
            })
            $(document).mousemove(function(e) {
                if (!me.isdraging) return;
                var deltaX = e.clientX - me.startX;
                var deltaY = e.clientY - me.startY;
                var left = me.startLeft + deltaX;
                var top = me.startTop + deltaY;
                me.clone.css({ "left": e.clientX + 5, "top": e.clientY + 5 });
                if (me.accept.call(this, me.clone)) {


                };
            }).mouseup(function(event) {
                me.isdraging = false;

            });
        }

    });
    $.extend($.ike.dragable, {
        defaults: {
            helper: false,
            accept: function(d) { return !(typeof $(d).attr("xtype") === undefined) }
        }
    });
})(jQuery)