(function($) {

    //Checkbox
    $.fn.ikecheckbox = function(option, method) {
        var config = $.extend({
            defaultCls: 'zogo-form-checkbox',
            hoverCls: 'zogo-form-checkbox-hover',
            checkedCls: 'zogo-form-checkbox-checked',
            clickEvent: null
        }, option);

        if (method == 'check') {
            return this.each(function() {
                $(this).attr('checked', 'checked');
                $(this).next().addClass(config.checkedCls);
            });
        };

        if (method == 'uncheck') {
            return this.each(function() {
                $(this).removeAttr('checked');
                $(this).next().removeClass(config.checkedCls);
            });
        };

        if (method =='disable') {
            return this.each(function() {
                $(this).attr('disabled', 'disabled');
                $(this).next().css('opacity', .3)
						  .unbind('click')
						  .unbind('mouseover')
						  .unbind('mouseout');
            });
        };

        if (method == 'enable') {
            return this.each(function() {
                var target = $(this);
                var item = target.next();
                target.removeAttr('disabled');
                item.css('opacity', 1)
				.bind('click', { target: target, item: item }, _click)
				.bind('mouseover', { item: item }, _mouseover)
				.bind('mouseout', { item: item }, _mouseout);
            });
        };

        if (method == 'click') {
            return this.each(function() {
                _click({ data: { target: $(this), item: $(this).next()} });
            });
        };

        return this.each(function() {
            var target = $(this);
            var text = $(this).next();
            var item =
			$('<span />').insertAfter(this)
						 .addClass(config.defaultCls)
						 .attr("title", $(this).attr("title"))
						 .html(text.html());

            target.hide();
            text.remove();

            item.bind('click', { target: target, item: item }, _click)
				.bind('mouseover', { item: item }, _mouseover)
				.bind('mouseout', { item: item }, _mouseout);

            if (target.attr('disabled')) { $(this).d_checkbox('disable'); }
            if (target.attr('checked')) { $(this).d_checkbox('check'); }
        });

        function _click(event) {
            var _target = event.data.target;
            var _item = event.data.item;
            _target.attr('checked', !_target.attr('checked'));
            _item.toggleClass(config.checkedCls);
            //提供向外的接口
            if (config.clickEvent && $.isFunction(config.clickEvent)) {
                config.clickEvent.call(this, _target);
            }

        }

        function _mouseover(event) {
            event.data.item.addClass(config.hoverCls);
        }

        function _mouseout(event) {
            event.data.item.removeClass(config.hoverCls);
        }

    }

})(jQuery);
///////////////////////////Radio
(function($) {

$.fn.ikeradio = function(option, method) {

    var config = $.extend({
        defaultCls: 'zogo-form-radio',
        hoverCls: 'zogo-form-radio-hover',
        checkedCls: 'zogo-form-radio-checked',
        clickEvent: null
    }, option);
    if (method == 'disable') {
        return this.each(function() {
            $(this).attr('disabled', 'disabled');
            $(this).next().css('opacity', .3)
						  .unbind('click')
						  .unbind('mouseover')
						  .unbind('mouseout');
        });
    };

    if (method == 'enable') {
        return this.each(function() {
            var target = $(this);
            var item = target.next();
            target.removeAttr('disabled');
            item.css('opacity', 1)
				.bind('click', { target: target, item: item }, _click)
				.bind('mouseover', { item: item }, _mouseover)
				.bind('mouseout', { item: item }, _mouseout);
        });
    };

    if (method == 'click') {
        return this.each(function() {
            _click({ data: { target: $(this), item: $(this).next()} });
        });
    };

    return this.each(function(i) {
        var target = $(this);
        var text = $(this).next();
        var item = $('<span />').insertAfter(this)
									.addClass(config.defaultCls)
									.addClass(target.attr('checked') ? config.checkedCls : '')
									.html(text.html());

        target.hide();
        text.remove();

        item.bind('click', { target: target, item: item }, _click)
				.bind('mouseover', { item: item }, _mouseover)
				.bind('mouseout', { item: item }, _mouseout);

        if (target.attr('disabled')) { $(this).d_checkbox('disable'); }
    });

    function _click(event) {

        var _target = event.data.target;
        var _item = event.data.item;
        _target.attr('checked', !_target.attr('checked'));
        $(":radio[name='" + _target.attr('name') + "']").next().removeClass(config.checkedCls);
        _item.toggleClass(config.checkedCls);
        //提供向外的接口
        
        if (config.clickEvent && $.isFunction(config.clickEvent)) {

            config.clickEvent.call(this, _target);
        }
    }

    function _mouseover(event) {
        event.data.item.addClass(config.hoverCls);
    }

    function _mouseout(event) {
        event.data.item.removeClass(config.hoverCls);
    }

}
})(jQuery);

