﻿(function($) {
    $.ui = $.ui || {};
    $.fn.ikeEditor = function(opts) {
        var ikeEditorInstance = false;
        if (this[0])
            ikeEditorInstance = new $.ui.ikeEditor(opts, this);
        return ikeEditorInstance;
    };
    $.ui.ikeEditor = function(opt, elem) {
        var options = $.extend({
            controls: ['bold', 'italic', 'underline', '|', 'font', 'size', 'color', '|', 'leftalign', 'centeralign', 'rightalign', 'blockjustify'],
            separator: 'tedivider',
            headercss: 'teheader',
            btncss: 'tecontrol',
            width: 500,
            height: 200,
            fontColor: [
            { value: "#000000", text: "黑色" },
            { value: "#333333", text: "浅黑色" },
            { value: "#999999", text: "浅灰色" },
            { value: "#CCCCCC", text: "灰色" },
            { value: "#FFFF00", text: "黄色" },
            { value: "#FF0000", text: "红色" }
            ],
            fontName: [
               { text: "宋体", value: "宋体" },
               { text: "楷体", value: "楷体" },
               { text: "黑体", value: "黑体" },
               { text: "华文彩云", value: "华文彩云" },
               { text: "微软雅黑", value: "微软雅黑" },
               { text: "Arial", value: "Arial" },
               { text: "Tahoma", value: "Tahoma" },
               { text: "Verdana", value: "Verdana" }
            ],
            fontSize: [
		    	{ value: "1", text: "极小" },
				{ value: "2", text: "特小" },
				{ value: "3", text: "小" },
				{ value: "4", text: "中" },
				{ value: "5", text: "大" },
				{ value: "6", text: "特大" },
				{ value: "7", text: "极大" }
			]

        }, opt);
        var c = [], offset = -30;
        c['bold'] = [4, 'Bold', 'a', 'bold'];
        c['italic'] = [5, 'Italic', 'a', 'italic'];
        c['underline'] = [6, 'Underline', 'a', 'underline'];
        c['leftalign'] = [14, 'Left Align', 'a', 'justifyleft'];
        c['centeralign'] = [15, 'Center Align', 'a', 'justifycenter'];
        c['rightalign'] = [16, 'Right Align', 'a', 'justifyright'];
        c['blockjustify'] = [17, 'Block Justify', 'a', 'justifyfull'];
        var iframe = $('<iframe/>').attr("name", "IkeHtmlEditor").attr({ "id": "IkeHtmlEditor", "name": "IkeHtmlEditor", "frameBorder": 0 });
        $(iframe).css({ width: options.width, height: options.height }).appendTo(document.body);
        var frDocument = window.frames["IkeHtmlEditor"].document;
        frDocument.open();
        var m = '<html><head></head><body></body></html>';
        frDocument.write(m);
        frDocument.close();
        frDocument.designMode = "on";
        if (!$.browser.msie)
            frDocument.execCommand("useCSS", false, true);
        var darrenEidtor = {
            getHeader: function() {
                var toolContainer = $("<div/>").addClass("te");
                var toolRowHeader = $("<div/>").addClass("toolbar").css("border-bottom", "solid 1px #a9bfd3").appendTo(toolContainer);
                options.toolbar_table = $("<table/>").appendTo(toolRowHeader);
                options.toolbar_table_row = $("<tr/>").appendTo(options.toolbar_table);
                //距离左边有空
                var paddingTd = $("<td/>").css("width", 2).appendTo(options.toolbar_table_row);
                $(options.controls).each(function(index, ele) {
                    var key = ele;
                    switch (key) {
                        case '|': { var it = $("<td />").append($("<span/>").addClass("spacer")).appendTo(options.toolbar_table_row); break; }
                        case "font":
                            {
                                var it = $("<td/>").css("width", "95").appendTo(options.toolbar_table_row);
                                var fontname = $("<input/>").appendTo(it);
                                $(fontname).dropdown({ dropwidth: 80, items: options.fontName, vinputid: "hiddfontname", selectedchange: function() { darrenEidtor.fontAction($("#hiddfontname").val(), "fontname"); } });
                                break;
                            }
                        case "size":
                            {
                                var it = $("<td/>").css("width", "65").appendTo(options.toolbar_table_row);
                                var fontsize = $("<input/>").appendTo(it);
                                $(fontsize).dropdown({ dropwidth: 50, items: options.fontSize, vinputid: "hiddfontsize", selectedchange: function() { darrenEidtor.fontAction($("#hiddfontsize").val(), "fontsize"); } });
                                break;
                            }
                        case "color":
                            {
                                var it = $("<td/>").css("width", "85").appendTo(options.toolbar_table_row);
                                var fontcolor = $("<input/>").appendTo(it);
                                $(fontcolor).dropdown({ dropwidth: 70, showcolor: true, items: options.fontColor, vinputid: "hiddfontcolor", selectedchange: function() { darrenEidtor.fontAction($("#hiddfontcolor").val(), "foreColor"); return false; } });

                                break;
                            }
                        default:
                            {
                                var it = $("<td/>").appendTo(options.toolbar_table_row);
                                var x = c[ele], func = x[2], ex, pos = x[0] * offset;
                                var div = $("<div/>").addClass(options.btncss).css("backgroundPosition", '0px ' + pos + 'px').attr("title", x[1]).appendTo(it);
                                $(div).hover(function() { $(this).css("backgroundPosition", '34px ' + pos + 'px'); }, function() { $(this).css("backgroundPosition", '0px ' + pos + 'px'); });
                                $(div).click(function() { darrenEidtor.executeCmd(x[3], x[4]); });
                                if ($.browser.msie) { $(div).attr("unselectable", "on") }
                                break;
                            }
                    }
                });
                return toolContainer;
            },
            getIframe: function() {

            },
            fontAction: function(value, cmd) {

                this.executeCmd(cmd, value)
            },
            executeCmd: function(cmd, param) {

                var f = window.frames["IkeHtmlEditor"];
                f.focus();
                if (!param)
                    if ($.browser.msie)
                    f.document.execCommand(cmd)
                else
                    f.document.execCommand(cmd, false, false)
                else
                    f.document.execCommand(cmd, false, param)
                f.focus();
                return false;
            }
        }
        $(elem).each(function() {
            var me = $(this);
            var wrapper = $(me).wrap("<div/>").hide().parent();
            wrapper.append(iframe);
            var editorContainer = darrenEidtor.getHeader().css({ width: options.width }).appendTo(document.body);
            editorContainer.append(wrapper);
            //window.clipboardData.setData("text", wrapper.parent().parent().parent().html());
            //alert(wrapper.parent().parent().parent().html())
        });
    }
})(jQuery);