﻿(function() {
    if (typeof ikeLoader === 'undefined') arguments[0].ikeLoader = this.ikeLoader = {
        scriptQueue: [] //用来加载的队列
    };
    var extend = function(destination, source, override) {
        if (!override) override = true;
        for (var property in source) {
            if (override && !(property in destination)) destination[property] = source[property];
        }
        return destination;
    };
    var createScriptNode = function(url) {
        var script = document.createElement("script");
        script.type = "text/javascript";
        script.charset = "utf-8";
        script.src = url;
        return script;
    };
    var head = function() {
        return document.getElementsByTagName("head")[0]
    } ();

    //递归遍历依赖模块，输出loading队列
    var _queue = function(name) {
        !ikeLoader._regedModules[name]['inQueue'] && ikeLoader.scriptQueue.push(name);
        ikeLoader._regedModules[name]['inQueue'] = true;

        if (ikeLoader._regedModules[name]['require']) {
            var reqL = ikeLoader._regedModules[name]['require'];
            for (var i = 0; i < reqL.length; i++) {
                if (ikeLoader._regedModules[reqL[i]]['inQueue']) return ikeLoader.scriptQueue;
                ikeLoader._regedModules[reqL[i]]['inQueue'] = true;
                ikeLoader.scriptQueue.push(reqL[i]);

                arguments.callee(reqL[i]);
            }
        } else {
            return ikeLoader.scriptQueue;
        }
    };

    // 添加入模块队列
    ikeLoader.add = function(name, options, r) {
        return new ikeLoader.add.prototype.register(name, options, r);
    }

    ikeLoader.add.prototype.register = function(name, options, r) {
        if (!ikeLoader._regedModules) ikeLoader._regedModules = {};
        if (ikeLoader._regedModules[name]) throw new Error('warning: module "' + name + '" is already added!');
        ikeLoader._regedModules[name] = {};

        if (typeof options == 'object') {
            extend(ikeLoader._regedModules[name], options)
        }
        else {
            var arg = arguments;
            ikeLoader._regedModules[name]['url'] = arg[1];
            if (!!arg[2]) ikeLoader._regedModules[name]['require'] = arg[2];
            if (!!arg[3]) {
                for (var i = 3; i < arg.length; i++) {
                    ikeLoader._regedModules[name][arg[i]] = arg[i];
                }
            }
        }

        this.add = function(n, p, r) {
            return ikeLoader.add(n, p, r);
        }

        return this;
    }

    // 加载模块
    ikeLoader.use = function(n, callback) {
        var _q = _queue(n) || this.scriptQueue;
        this.load(_q, callback);
    }
    // 加载模块
    ikeLoader.useArray = function(arr, callback) {
        for (var i = 0; i < arr.length; i++) {
            var _q = _queue(arr(i)) || this.scriptQueue;
            this.load(_q, callback);
        }
    }
    ikeLoader.load = function(arr, callback) {
        var i = 0;
        if (arr.length === 0) {
            !!callback && callback();
            return;
        }
        var curModule = arr.pop();
        __load(curModule, function() {
            ikeLoader.load(arr, callback);
        });

    }
    __load = function(name, cb) {
        if (ikeLoader._regedModules[name]['isLoaded']) return;
        var path = ikeLoader._regedModules[name]['url'];
        var _s = createScriptNode(path);
        head.appendChild(_s);

        _s.onload = _s.onreadystatechange = function() {
            if ((!this.readyState) || this.readyState === "loaded" || this.readyState === "complete") {
                ikeLoader._regedModules[name]['isLoaded'] = true;
                !!cb && cb();
                _s.onload = _s.onreadystatechange = null;
            }
        }
        _s.onerror = function() {
            _s.onload = _s.onerror = undefined;
            throw new Error(_s.src + ' loaded failed!');
            head.removeChild(_s);
        }
    }
})(window);