﻿var GpageSize = 5; //每页计数
var GcurrentPageIndex = 1;
function ShowPageBar(containerId , attr) { 
    var totalCount =( attr["totalCount"]==null ||  attr["totalCount"] == 0) ? 0 :  attr["totalCount"];//parseInt()//总记录条数
    var pageCount = (attr["pageCount"] == null || attr["pageCount"] == 0) ? 20 : attr["pageCount"];//attr["pageCount"];//每页记录数
    var currentPageIndex = attr["currentPageIndex"];//当前页
    var showMode = (attr["showMode"] == null) ? "full" : attr["showMode"];
    //输出设置
    var barID = containerId;
    //var barDiv = $("#"+barID);
    //输出设置 结束
    //添加PageBar层
    $("#" + containerId).html("<div id=\"" + barID + "\"></div>");
    //如果没有记录，返回空记录提示
    if(totalCount==0)
    {
        $("#"+barID).html("");
        return false;
    }
    pageCount = (pageCount == null || pageCount == 0) ? 20 : pageCount;//每页显示记录数
    var totalPage = parseInt((totalCount-1) / pageCount) +1;//总页数
    currentPageIndex = (currentPageIndex == null || currentPageIndex <= 0 || currentPageIndex > totalPage) ? 1 : currentPageIndex;
    var startRecord; 																																							//每页起始记录
    var endRecord;  																																							//每页结束记录
    startRecord = (currentPageIndex - 1) * pageCount + 1;
    endRecord = Math.min(currentPageIndex * pageCount, totalCount);
  
    //开始输出
    //添加工具条
    var toolbar = '<div class="pgToolbar">';
    toolbar += '<div class="pgPanel">';
    if (showMode == 'full') {
        toolbar += '<div style="margin-top:2px;"><select class="pgPerPage">';
        if (pageCount> 0)
            toolbar += '<option value="' + pageCount + '">' + pageCount + '</option>';
        toolbar += '<option value="5">5</option>';
        toolbar += '<option value="10">10</option>';
        toolbar += '<option value="15">15</option>';
        toolbar += '<option value="20">20</option>';
        toolbar += '<option value="25">25</option>';
        toolbar += '<option value="40">40</option>';
        toolbar += '</select>&nbsp;</div>';
        toolbar += '<div class="separator"></div>';
    }
    toolbar += '<div class="pgBtn pgFirst" title="首页"></div>';
    toolbar += '<div class="pgBtn pgPrev" title="上页"></div>';
    if (showMode != 'mini') {
        toolbar += '<div class="separator"></div>';
        toolbar += '<div style="margin-top:2px;">第 <input class="pgCurrentPage" type="text" value="' + currentPageIndex + '" title="页码" /> 页 / 共 <span class="pgTotalPage">' + totalPage + '</span> 页</div>';
        toolbar += '<div class="separator"></div>';
    }
    toolbar += '<div class="pgBtn pgNext" title="下页"></div>';
    toolbar += '<div class="pgBtn pgLast" title="尾页"></div>';
    //刷新
    toolbar += '<div class="separator"></div>';
    toolbar += '<div class="pgBtn pgRefresh" title="刷新"></div>';
   
    if (showMode == 'full') {
        toolbar += '<div class="separator"></div>';
        toolbar += '<div class="pgSearchInfo">检索到&nbsp;' + totalCount + '&nbsp;条记录,显示第&nbsp;<span class="pgStartRecord">' + startRecord + '</span>&nbsp;条&nbsp;-&nbsp;第&nbsp;<span class="pgEndRecord">' + endRecord + '</span>&nbsp;条记录</div>';
    }
    toolbar += '<hr class="cleanFloat" /></div>';
    toolbar += '</div>';
    $(toolbar).appendTo($("#" + barID));
    //事件
    var t = "#" + barID;
    var btnRefresh = $(t + " .pgRefresh"); 													//刷新按钮
    var btnNext = $(t + " .pgNext"); 																//下一页按钮
    var btnPrev = $(t + " .pgPrev"); 																//上一页按钮
    var btnFirst = $(t + " .pgFirst"); 																//首页按钮
    var btnLast = $(t + " .pgLast"); 																//末页按钮
    var btnGo = $(t + " .pgNext," + t + " .pgLast");
    var btnBack = $(t + " .pgPrev," + t + " .pgFirst");
    var btn = $(t + " .pgFirst," + t + " .pgPrev," + t + " .pgNext," + t + " .pgLast");
    var mask;
    var valCurrentPage = $(t + " .pgCurrentPage");
    var valStartRecord = $(t + " .pgStartRecord");
    var valEndRecord = $(t + " .pgEndRecord");
    var valPerPage = $(t + " .pgPerPage");
    var valTotalPage = $(t + " .pgTotalPage");
    $(t + " .pgPerPage").attr("value", pageCount);
    //刷新按钮监听
    btnRefresh.bind("mousedown", pressHandler).bind("mouseup", unpressHandler).bind("mouseout", unpressHandler);
    refresh();
    //按钮监听
    btnNext.click(
		function() {
		    if (currentPageIndex < totalPage) {
		        ShowPage(++currentPageIndex,pageCount);
		     
		    }
		}
	);
	btnPrev.click(
	function() {
	    if (currentPageIndex > 1) {

	        ShowPage(--currentPageIndex, pageCount);
	        
	    }
	}
    );
	btnFirst.click(
		function() {
		    if (currentPageIndex > 1) {

		        currentPageIndex = 1;
		        ShowPage(currentPageIndex,pageCount);

		    }
		}
	);
	btnLast.click(
	function() {
	    if (currentPageIndex < totalPage) {

	        currentPageIndex = totalPage;
	        ShowPage(currentPageIndex,pageCount);
	    }
	}
  );
	btnRefresh.click(
		function() {
		    ShowPage(currentPageIndex,pageCount);
		}
	);
	//页码输入框监听
	valCurrentPage.keydown(
	function() {
	    var targetPage = parseInt($(this).val());
	    if (event.keyCode == 13 && targetPage >= 1 && targetPage <= totalPage) {
	        currentPageIndex = targetPage;
	        ShowPage(currentPageIndex,pageCount);

	    }
	}
 );
	valPerPage.change(
		function() {
		    var newPageCount = parseInt($(this).val());
		    if (newPageCount <= 0 || currentPageIndex > ((totalCount - 1) / newPageCount) + 1) {

		        pageCount = parseInt(newPageCount);
		        currentPageIndex = 1;
		        ShowPage(currentPageIndex, pageCount);
		    }
		    else {
		        pageCount = parseInt(newPageCount);
		        ShowPage(currentPageIndex, pageCount);
		    }

		}
	);
    /**
    * 刷新工具栏状态
    */
    function refresh() {
      
        btn.unbind("mousedown", pressHandler);
        btn.bind("mouseup", unpressHandler);
        btn.bind("mouseout", unpressHandler);
        if (currentPageIndex ==1 && totalPage == 1) {
            enabled();
            btnPrev.addClass("pgPrevDisabled");
            btnFirst.addClass("pgFirstDisabled");
            btnNext.addClass("pgNextDisabled");
            btnLast.addClass("pgLastDisabled");
        }
        else if (currentPageIndex ==totalPage) {
            enabled();
            btnBack.bind("mousedown", pressHandler);
            btnNext.addClass("pgNextDisabled");
            btnLast.addClass("pgLastDisabled");
        } else if (currentPageIndex == 1) {
            enabled();
            btnGo.bind("mousedown", pressHandler);
            btnPrev.addClass("pgPrevDisabled");
            btnFirst.addClass("pgFirstDisabled");
        } else {
            enabled();
            btnBack.bind("mousedown", pressHandler);
            btnGo.bind("mousedown", pressHandler);
            btnNext.addClass("pgNext");
            btnPrev.addClass("pgPrev");
            btnFirst.addClass("pgFirst");
            btnLast.addClass("pgLast");
        }
    }

    /**
    * 移除按钮disabled状态样式
    */
    function enabled() {
        btnNext.removeClass("pgNextDisabled");
        btnPrev.removeClass("pgPrevDisabled");
        btnFirst.removeClass("pgFirstDisabled");
        btnLast.removeClass("pgLastDisabled");
    }

    /**
    * 添加按钮按下状态样式
    **/
    function pressHandler() {
        $(this).addClass("pgPress");
    }

    /**
    ** 移除按钮按下状态样式
    **/
    function unpressHandler() {
        $(this).removeClass("pgPress");
    }
   
}


