(function($) {
    jQuery.fn.timepicker = function(o) {
        var options = $.extend({
            defaultValue:false
        }, o);
        this.each(function() {
            // get the ID and value of the current element
            var i = this.id;
            // the options we need to generate
            var hrs = new Array();
            for (var p = 0; p < 24; p++) { hrs.push(format(p)) }
            var mins = new Array();
            for (var j = 0; j < 60; j++) { mins.push(format(j)) }
            var ap = new Array();
            for (var h = 0; h < 60; h++) { ap.push(format(h)) }
            // default to the current time

            var d = new Date();
            var h = format(d.getHours());
            var m = format(d.getMinutes());
            var p = format(d.getSeconds());
            if (options.defaultValue) {
                h = options.defaultValue.substring(11,19).split(":")[0];
                m = options.defaultValue.substring(11, 19).split(":")[1];
                p = options.defaultValue.substring(11, 19).split(":")[2];
            }

            var v = h + ':' + m + ':' + p;
            $("#" + i).attr("val", v);
            function format(n)//ʽΪλַʾ
            {
                var m = new String();
                var tmp = new String(n);
                if (n < 10 && tmp.length < 2) {
                    m = "0" + n;
                }
                else {
                    m = n;
                }

                return m;

            }
            // build the new DOM objects
            var output = '';
            output += '<select id="h_' + i + '" class="h timepicker">';
            for (var hh = 0; hh < hrs.length; hh++) {

                output += '<option value="' + hrs[hh] + '"';
                if (hrs[hh] == h) output += ' selected';
                output += '>' + hrs[hh] + '</option>';
            }
            output += '</select>';

            output += '<select id="m_' + i + '" class="m timepicker">';
            for (var j = 0; j < mins.length; j++) {
                output += '<option value="' + mins[j] + '"';
                if (mins[j] == m) output += ' selected';
                output += '>' + mins[j] + '</option>';
            }
            output += '</select>';

            output += '<select id="p_' + i + '" class="p timepicker">';
            for (var pp = 0; pp < mins.length; pp++) {
                output += '<option value="' + ap[pp] + '"';
                if (ap[pp] == p) output += ' selected';
                output += '>' + ap[pp] + '</option>';
            }
            output += '</select>';
            // hide original input and append new replacement inputs
            $(this).attr('type', 'hidden').after(output);

        });

        $('select.timepicker').change(function() {
            var i = this.id.substr(2);
            var h = $('#h_' + i).val();
            var m = $('#m_' + i).val();
            var p = $('#p_' + i).val();
            var v = h + ':' + m + ':' + p;
            $("#" + i).attr("val", v);

        });
        return this;
    };
})(jQuery);


