(function($) {
    $.ui = $.ui || {};
    $.fn.toolbar = function(opts) {
        var toolbar = false;
        if (this[0])
            toolbar = new $.ui.toolbar(opts, this[0]);
        return toolbar;
    }
    $.ui.toolbar = function(o, elem) {
        var config = $.extend({
            border: 'bottom',
            items: [],
            filters: [],
            active: 'All',
            filterAlign: 'right'
        }, o);
        //load
        var me = $(elem);
        Load();
        function Load() {
            //工具按钮层
            config.toolbar = $("<div/>").addClass("toolbar").appendTo(me);
            if (config.border != "none") {
                config.toolbar.css("border-" + config.border, "solid 1px #a9bfd3");
            }
            config.toolbar_table = $("<table/>").appendTo(config.toolbar);

            config.toolbar_table_row = $("<tr/>").appendTo(config.toolbar_table);
            //距离左边有空
            var paddingTd = $("<td/>").css("width", 2).appendTo(config.toolbar_table_row);
            //循环子组件
            for (var i = 0; i < config.items.length; i++) {
                addItem(config.items[i]);

            }

            //循环过滤组件
            for (var i = 0; i < config.filters.length; i++) {
                addFilter(config.filters[i]);
            }
            if (config.filterAlign == "left") {

                config.toolbar_table.css("marginLeft", $(".filterTable").width());
            }

        }

        function addItem(t) {
            var toolbarEntity = me;
            switch (t.type) {
                case "separate": var it = $("<td />").append($("<span/>").addClass("spacer")).appendTo(config.toolbar_table_row); break;
                case "space": var it = $("<td/>").css("width", t.width).append($("<span/>").addClass("space")).appendTo(config.toolbar_table_row); break;
                case "button":
                    {
                        var it = $("<td/>");
                        it.appendTo(config.toolbar_table_row);
                        var itemTable = $(document.createElement("TABLE")).attr({ "cellPadding": 0, "cellSpacing": 0 }).append();
                        itemTable.appendTo(it);
                        var b_center = $("<td/>").addClass("b_center");
                        var button = $("<button/>").text(t.text);

                        if (t.id) {
                            button.attr("id", t.id);
                        }

                        if (t.className) {
                            button.addClass(t.className);
                        }

                        if (t.title) {
                            button.attr("title", t.title);
                        }
                        //判断是否包含中文,有的话添加IE补丁
                        if (/^[u4E00-u9FA5]/.test(t.text) == false && $.browser.msie) {
                            if ($.browser.version == "6.0") {
                                button.css("padding-top", "2px");
                            } else {
                                button.css("padding-top", "4px");
                            }
                        }
                        button.appendTo(b_center);

                        var itemTable_tr = $("<tr/>").append($("<td/>").addClass("b_left")).append(b_center).append($("<td/>").addClass("b_right"));

                        itemTable_tr.appendTo(itemTable);
                        //event visiable
                        button.width(button.text().length * button.css("fontSize").substring(0, button.css("fontSize").indexOf("px")) + 16);
                        //是否有权限
                        if (t.useable != "F") {
                            if (t.handler) {
                                itemTable_tr.hover(function() { $(this).addClass("over"); }, function() { $(this).removeClass("over down"); });
                                itemTable_tr.mousedown(function() { $(this).addClass("down"); }).mouseup(function() { $(this).removeClass("down").unbind("mouseup"); });
                                $(button).click(function(e) {
                                    t.handler.call(this, button, e);
                                });
                                //t.handler.call(this,button); 
                            }
                        } else {
                            itemTable_tr.children("TD").each(function() {
                                $(this).css("cursor", "default");
                            });
                            button.attr("disabled", true);
                        }
                        break;
                    }
                case "text":
                    {
                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        var cop = $("<input/>").attr({ "id": t.id, "name": t.id, "type": "text" }).addClass("textfield").appendTo(it);
                        if (t.bodyStyle) {
                            cop.addClass(t.bodyStyle);
                        }
                        if (t.width) {
                            cop.css("width", t.width);
                        }
                        if (t.handler) {
                            cop.bind("click", t.handler);
                        }
                        break;
                    }
                case "checkbox":
                    {

                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        var cop = $("<input/>").attr({ "id": t.id, "name": t.id, "type": "checkbox" }).appendTo(it);
                        if (t.checked) {
                            $(cop).attr("checked", t.checked);
                        }
                        var lable = null;
                        if (t.title != undefined && t.title != null) {
                            label = $("<label/>").attr({ "id": "label_" + t.id }).text(t.title).appendTo(it);
                        } else {
                            label = $("<label/>").attr({ "id": "label_" + t.id }).text(t.text).appendTo(it);
                        }
                        if (t.handler) {
                            $(cop).click(function() {
                                t.handler.call(this, cop);
                            });

                        }
                        break;
                    }
                case "lable":
                    {
                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        var lable = null;
                        if (t.title != undefined && t.title != null) {
                            lable = $("<label/>").addClass("labelfield").text(t.title).appendTo(it);
                        } else {
                            lable = $("<label/>").addClass("labelfield").text(t.text).appendTo(it);
                        }


                        if (t.id) {
                            lable.attr("id", t.id);
                        }
                        if (t.className) {
                            lable.addClass(t.className);
                        }
                        break;
                    }

                case "combo":
                case "date":
                    {
                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        var cop = $("<input/>").attr({ "id": t.id, "name": t.id, "type": "text" });
                        cop.appendTo(it);
                        if (t.handler && $.isFunction(t.handler)) {
                            t.handler.call(this, cop);
                            //alert($(cop).parent().parent().parent().html());
                            $(cop).parent().parent().css("width", ($(cop).width() + 15));
                        }
                        break;
                    }
                case "html":
                    {
                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        it.append(t.html);
                        break;
                    }
                case "select":
                    {
                        var it = $("<td/>").appendTo(config.toolbar_table_row);
                        var cop = $("<input/>").attr({ "id": t.id, "name": t.id, "type": "text" }).appendTo(it);
                        if (t.handler && $.isFunction(t.handler)) {

                            t.handler.call(this, cop);
                            $(cop).parent().parent().css("width", ($(cop).width() + 15));

                        }
                        break;
                    }
                default:
                    {
                        var it = $(document.createElement("TD"));
                        it.appendTo(this.toolbar_table_row);
                        var itemTable = $(document.createElement("TABLE"));
                        itemTable.attr("cellPadding", 0);
                        itemTable.attr("cellSpacing", 0);
                        itemTable.appendTo(it);
                        var itemTable_tr = $(document.createElement("TR"));
                        itemTable_tr.appendTo(itemTable);
                        var itemTable_tr_td = $(document.createElement("TD"));
                        itemTable_tr_td.appendTo(itemTable_tr);
                        if (typeof t.html == "string") {
                            itemTable_tr_td.html(t.html);
                        } else {
                            itemTable_tr_td.append(t.html);
                        }
                        break;
                    }

            }

        }
        function addFilter(filter) {
            var toolbarEntity = me;
            if (!config.filterTable) {
                config.filterTable = $("<table/>").attr({ "cellPadding": 0, "cellSpacing": 0 }).addClass("filterTable").css(config.filterAlign, "2px").appendTo(config.toolbar);
                config.filterLeft = $("<td/>").addClass("b_left");
                config.filterRight = $("<td/>").addClass("b_right");
                config.filterTr = $("<tr/>").addClass("over").addClass("over-f").append(config.filterLeft).append(config.filterRight).appendTo(config.filterTable);
            }
            //查找所有过滤组件按钮
            var t_centers = $(".b_center", config.filterTable);
            //如果有过滤按钮,先添加一个分隔符
            if (t_centers.length > 0) {

                var sp = $("<td/>");
                config.filterRight.before(sp);
                var spacer = $("<span/>").addClass("filter-spacer").appendTo(sp);
            }

            //创建按钮TD
            var buttonTd = $("<td/>").attr("id", filter.id).addClass("b_center");
            //创建按钮
            var button = $("<button/>");
            if (filter.text) {
                button.text(filter.text);
            }
            if (filter.title) {
                button.attr("title", filter.title);
            }
            if (filter.className) {
                button.addClass(filter.className);
            }
            //为按钮绑定点击事件
            button.bind("click", function() {
                //激活BUTTON
                activeFilter($(this).parent().attr("id"));
            });
            if (filter.textClass) {
                button.width(button.text().length * button.css("fontSize").substring(0, button.css("fontSize").indexOf("px")));
            }
            else {
                button.width(button.text().length * button.css("fontSize").substring(0, button.css("fontSize").indexOf("px")) + 16);
            }
            if (filter.handler) {
                button.bind("click", filter.handler);
            }
            //将按钮放到TD中
            button.appendTo(buttonTd);
            //将TD插入到右边框前面
            config.filterRight.before(buttonTd);
            //激活BUTTON
            if (filter.id == config.active) {
                activeFilter(filter.id);
            }
            //更新边框
            updateFilterBorder();
        }
        function activeFilter(tdId) {
            if (tdId && $("#" + tdId).length == 1) {
                $(".border-center-active", config.filterTable).removeClass("border-center-active");
                $("#" + tdId).addClass("border-center-active");
                updateFilterBorder();
            }
        }
        function updateFilterBorder() {
            //改变左右边框的样式表
            if (config.filterLeft.next().hasClass("border-center-active")) {
                config.filterLeft.addClass("border-left-active");
            } else {
                config.filterLeft.removeClass("border-left-active");
            }
            if (config.filterRight.prev().hasClass("border-center-active")) {
                config.filterRight.addClass("border-right-active");
            } else {
                config.filterRight.removeClass("border-right-active");
            }
        }
    }
})(jQuery)
