﻿	(function($) {
	    $.extend({
	        treetable: new function() {
	            this.defaults = {
	                id_col: 0,
	                parent_col: 1,
	                handle_col: 2,
	                order_col: -1,
	                open_img: "../../images/minus.gif",
	                close_img: "../../images/plus.gif"
	            };
	            //jquery的trim处理不了&nbsp;产生的"空格"
	            function trim(str) {
	                return str.replace(/(^[\s\xA0]*)|([\s\xA0]*$)/g, "");
	            }
	            this.construct = function(settings) {
	                var config = $.extend({}, $.treetable.defaults, settings);
	                var $this = $(this);
	                var tr_arr = new Array();
	                var tr_sort = new Array();
	                //构建行对象数组
	                $this.find("tr").each(function() {
	                    var id = $.trim($(this).find("td:eq(" + config.id_col + ")").text());
	                    var parent = $.trim($(this).find("td:eq(" + config.parent_col + ")").text());
	                    tr_arr.push({ 'id': id, 'parent': parent, 'level': 0, 'node': 'leaf', 'expanded': true, 'obj': $(this) });
	                });
	                var len = tr_arr.length;
	                var level = 0;
	                /*
	                检查tr_arr中的每一行的父行是否再tr_sort中，
	                如果有则插入到tr_sort的父行后，从tr_arr中删除
	                直到tr_arr都为null,生成排好序的tr_sort
	                */
	                while (len > 0) {
	                    for (var i = 0; i < tr_arr.length; i++) {
	                        var o = tr_arr[i];
	                        if (o == null) continue;
	                        if (o.parent == 0) {//根行直接压入tr_sort
	                            tr_sort.push(o);
	                            tr_arr[i] = null;
	                            len = len - 1;
	                        } else {
	                            for (var j = 0; j < tr_sort.length; j++) {
	                                if (tr_sort[j].id == o.parent) {
	                                    o.level = tr_sort[j].level + 1; //从父行累计生成层次level
	                                    tr_sort[j].node = 'node';
	                                    tr_sort.splice(j + 1, 0, o); //数组插入
	                                    tr_arr[i] = null;
	                                    len = len - 1;
	                                    break;
	                                }
	                            }
	                        }
	                    }
	                    level = level + 1;
	                } //while
                   
	                //展开事件动作函数
	                var fn_click = function() {
	                    var id = $(this).attr("irowid");
	                    var v = -1;
	                    for (var j = 0; j < tr_sort.length; j++) {
	                        var o = tr_sort[j];
	                        if (o.id == id) {//在tr_sort找到行对象
	                            if (o.node == 'leaf') return;
	                            v = o.level;
	                            var img = o.obj.find("td:eq(" + config.handle_col + ") img")[0];
	                            if (!o.expanded) {//通过图标判断是展开还是收起
	                                img.src = config.open_img;
	                                o.expanded = true;
	                            } else {
	                                img.src = config.close_img;
	                                o.expanded = false;
	                            }
	                            var show = o.expanded;
	                            var f = false; //父行收起标志
	                            var tmp = 0; //父行的层次
	                            for (var i = j + 1; i < tr_sort.length; i++) {//根据level更新后续的子行
	                                o = tr_sort[i];

	                                var img = o.obj.find("td:eq(" + config.handle_col + ") img")[0];
	                                var t = !o.expanded; //判断是否是收起状态
	                                if (o.level > v && show) {//展开操作
	                                    if (!f && !t) {//父行未收起，且当前行是展开状态
	                                        o.obj.show();
	                                    } else if (!f && t) {//父行未收起，且当前行是收起状态
	                                        tmp = o.level;
	                                        f = true;
	                                        o.obj.show();
	                                    } else if (f && o.level <= tmp) {//同级的前一行是收起状态
	                                        if (!t) {
	                                            f = false;
	                                        } else {
	                                            tmp = o.level;
	                                        }
	                                        o.obj.show();
	                                    } else {
	                                        ;
	                                    }

	                                } else if (o.level > v && !show) {//收起操作则隐藏所以子行
	                                    o.obj.hide();
	                                } else if (o.level <= v) {//到达非子行，处理完毕
	                                    break;
	                                }
	                            }

	                            break;
	                        }
	                    }
	                }

	                //重新绘制表格，添加展开动作图标
	                for (var j = tr_sort.length - 1; j > -1; j--) {//prepend插入tbody内需使用反序
	                    var o = tr_sort[j];
	                    var img = $("<img style='vertical-align:middle;' src='" + config.open_img + "'>").attr("irowid", o.id);
	                    img.click(fn_click);
	                    var td = o.obj.find("td:eq(" + config.handle_col + ")").find("div:eq(0)");
	                    td.prepend("&nbsp;");
	                    td.prepend(img);
	                    var s = new Array((o.level + 1) * 3).join("&nbsp;"); //生成缩进空格
	                    td.prepend(s);
	                    $this.prepend(o.obj);

	                } //for


	            } //construct
	        } //treetable

	    });

	    $.fn.extend({
	        treetable: $.treetable.construct
	    });

	})(jQuery);