﻿(function($) {
    $.ui = $.ui || {};
    $.fn.ikeupload = function(options) {
        var uploadFile = false;
        if (this[0])
            uploadFile = new $.ui.ikeupload(options, this[0]);
        return uploadFile;
    }
    $.ui.ikeupload = function(option, ele) {
        var options = $.extend(
         {
             width: 502,
             addBtnText: '添加文件',
             cancelBtnText: '取消',
             deleteBtnText: '<span class="uploadedDelete">&nbsp</span>',
             uploadBtnText: '上传',
             filePath: '/temp/',
             uploadEvent: false,
             downloadEvent: false,
             downAndOpenEvent:false
         }, option);
        ///////////////////////////
        //变量
        this.FileArray = [];
        this.InitFileArray = [];
        this.UploadedFileArray = [];
        ///////////////////////////
        var me = $(ele);
        var target = this;
        var extendID = me.attr("id");
        this.load = function() {
            var separate = "<a class=\"imgbtns\" href=\"javascript:void(0);\"><span class=\"span-sperate\" >&nbsp;</span></a>";
            var addbtn = $("<a/>").attr({ "id": "myuploadaddbtn" + extendID, "title": options.addBtnText })
                                  .addClass("addFile");
            var uploadbtn = $("<a/>").attr({ "id": "myuploaduploadbtn" + extendID, "title": options.uploadBtnText })
                                     .addClass("div-upload-tool-btn")
                                     .click(function() {
                                         //调用外面的方法
                                         if (options.uploadEvent && $.isFunction(options.uploadEvent)) {
                                             var fileArray = target.GetUploadList();
                                             options.uploadEvent.call($(this), fileArray);
                                         }

                                     });

            var toolbar = $("<div/>").addClass("div-upload-toolbar")
                                       .attr("id", "myuploadtoolbar" + extendID)
                                       .append(addbtn).append(separate).append(uploadbtn);
            var uploadingtable = $("<div/>").attr("id", "myuploadingtable" + extendID).hide();
            var uploadedtable = $("<div/>").attr("id", "myuploadedtable" + extendID).hide();
            var container = $("<div/>").addClass("div-upload-container").css("width", options.width)
                                       .attr("id", "myuploadcontainer" + extendID)
                                       .append(toolbar).append(uploadingtable).append(uploadedtable);
            me.append(container);
        }
        this.addFile = function() {
            var myloadFileInstance = $("<input/>").attr({ "type": "file", "name": "myuploadfile" + extendID })
                                              .change(function() { target.Init(); });
            return myloadFileInstance;
        }
        this.GetUploadList = function() {
            var fileArray = [];
            if (this.FileArray.length > 0) {
                $(this.FileArray).each(function(index, ele) {
                    fileArray.push(ele.val());

                });

            }
            return fileArray;
        }
        this.GetUploadedList = function() {
            var getUploadedFileArray = [];
            if (this.UploadedFileArray.length > 0) {
                $(this.UploadedFileArray).each(function(index, ele) {
                    getUploadedFileArray.push(ele);

                });

            }
            return getUploadedFileArray;
        }
        this.Init = function() {
            //整理文件集合
            this.FileArray = [];

            //整理文件空间，把有值的file放入文件集合
            $("input", "#myuploadaddbtn" + extendID).each(function() {
                if ($(this).attr("type") == "file") { $(this).val() && target.FileArray.push($(this)); $(this).val() ? $(this).hide() : $(this).remove(); }
            });
            //添加文件
            $("#myuploadaddbtn" + extendID).append(target.addFile());
            //显示上传列表
            if (this.InitUploadFile()) {
                $("#myuploadingtable" + extendID).html(this.InitUploadFile()).show();
                //显示上传按钮
                $("#myuploaduploadbtn" + extendID).html($("<span class=\"Upload\">" + options.uploadBtnText + "</span>")).attr("disabled", false);
            }
            else {
                $("#myuploadingtable" + extendID).html("").hide();
                //隐藏上传按钮
                $("#myuploaduploadbtn" + extendID).html($("<span class=\"disUpload\">" + options.uploadBtnText + "</span>")).attr("disabled", true);
            }
            //显示已上传的列表
            if (this.InitUploadedFile()) {
                $("#myuploadedtable" + extendID).html(this.InitUploadedFile()).show();
            }
            else {

                $("#myuploadedtable" + extendID).html(this.InitUploadedFile()).html("").hide();
            }



        }
        this.Delete = function(file) {
            var target = $("#myuploadaddbtn" + extendID);
            $("input[type='file']", target).each(function() { if ($(this).val() == file.val()) { $(this).remove(); } });
            this.Init();
        }
        //清空上传列表
        this.Clear = function() {
            var target = $("#myuploadaddbtn" + extendID);
            $("input[type='file']", target).each(function() { $(this).remove(); });
            this.Init();
        }
        this.DeleteUploadedFile = function(file) {

            if (this.UploadedFileArray.length > 0) {
                $(this.UploadedFileArray).each(function(index, ele) {
                    if (ele.colindex1 == file.colindex1) {
                        target.UploadedFileArray.splice(index, 1);


                    }
                });

            }

            this.Init();

        }
        this.InitUploadFile = function() {
            var target = this;
            if (this.FileArray.length > 0) {
                var head = $("<thead/>").append($("<tr/>").append($("<th>").html("待上传文件路径")).append($("<th>").text("删除")));
                var tbody = $("<tbody/>")
                var table = $("<table/>").addClass("div-upload-table").append(head);
                $(this.FileArray).each(function(index, ele) {
                    var a = $("<a/>").addClass("div-row-delete").attr({ "href": "javascript:void(0);" }).html("<span class=\"Delete\">&nbsp;</span>").click(function() { target.Delete(ele); return false; });
                    var tr = $("<tr/>").append($("<td>").html(ele.val()))
                                       .append($("<td>").append(a));
                    tbody.append(tr);
                    table.append(tbody);

                });
                return table;
            }
            else
                return false;

        }
        this.InitUploadedFile = function() {
            if (this.UploadedFileArray.length > 0) {
                var head = $("<thead/>").append($("<tr/>").append($("<th>").html("已上传附件列表")));
                var tbody = $("<tbody/>")
                var table = $("<table/>").addClass("div-upload-table").append(head);
                $(this.UploadedFileArray).each(function(index, ele) {

                    var afile = $("<span/>").attr({"title": ele.colindex2 }).text(ele.colindex2).addClass("uploadedFile");
                    var downFile=$("<a/>").attr({ "href":"javascript:void(0);", "title": "下载" }).text("[下载]").addClass("uploadedFile").click(function() {
                        if (options.downloadEvent && $.isFunction(options.downloadEvent)) {
                            options.downloadEvent.call(this, ele.colindex1, ele.colindex2)
                        }
                    });
                    var openFile=$("<a/>").attr({ "href":"javascript:void(0)", "title": "打开" }).text("[打开]").addClass("uploadedFile").click(function(){
                        if (options.downAndOpenEvent && $.isFunction(options.downAndOpenEvent)) {
                            options.downAndOpenEvent.call(this, ele.colindex1, ele.colindex2)
                        }
                    });
                    var a = $("<a/>").attr({ "href": "javascript:void(0);", "val": ele.colindex0 }).html(options.deleteBtnText).click(function() { target.DeleteUploadedFile(ele); return false; });
                    var tr = $("<tr/>").append($("<td>").append(downFile).append(openFile).append(afile).append(a))
                    tbody.append(tr);
                    table.append(tbody);

                });
                return table;
            }
            else
                return false;

        }
        this.setUploadedFile = function(fileArray, flag) {
            if (fileArray) {
                $(fileArray).each(function(index, ele) {
                    //加载初始化的数据
                    if (flag) {
                        target.InitFileArray.push(ele);
                    }
                    target.UploadedFileArray.push(ele)
                });
            }
            this.Clear();

        }
        this.GetDeleteFile = function() {
            return $.jMinus(this.InitFileArray, this.UploadedFileArray, "colindex0");

        }
        this.GetAddFile = function() {

            return $.jMinus(this.UploadedFileArray, this.InitFileArray, "colindex0", false)
        }
        this.ClearAll = function() {
            target.UploadedFileArray.length = 0;
            this.Clear();
        }
        this.load();
        this.Init();

    }

})(jQuery)