﻿(function($) {

    $.fn.ShowPageBar = function(options) {
        var opt = $.extend({
            style: "technorati",
            totalCount: 0,
            pageCount: 3,
            showPageNumber: 3,
            currentPageIndex: 1,
            onclick: false,
            barMark: "mark",
            noRecordTip: "noRecordTip",
            preWord: " < ",
            nextWord: " > "
        }, options);
        var me = $(this);
        var containerId = me.attr("id");
        var barID = containerId + "_pageBar";
        $("#" + containerId).html("<div id=\"" + barID + "\" class=\"" + opt.style + "\"></div>");
        if (opt.totalCount == 0) {
            $("#" + barID).html(opt.noRecordTip);
            return false;
        }
        var pageCount = (opt.pageCount == null || opt.pageCount == 0) ? 20 : opt.pageCount;
        var totalPage = parseInt((opt.totalCount - 1) / pageCount) + 1; //总页数
        alert(pageCount)
        var url = "www.ike.cn";
        var showPageNumber = (opt.showPageNumber == null || opt.showPageNumber == 0) ? 3 : opt.showPageNumber;
        var currentPageIndex = (opt.currentPageIndex == null || opt.currentPageIndex <= 0 || opt.currentPageIndex > totalPage) ? 1 : opt.currentPageIndex;

        var backPageStyle = (currentPageIndex <= 1) ? "disabled" : "";
        var nextPageStyle = (currentPageIndex >= totalPage) ? "disabled" : "";

        var firstDisplayPageEnd = 0; //从第1页显示到xx页
        var bodyDisplayPageStart = 0; //当前页临近最左页码
        var bodyDisplayPageEnd = 0; //当前页临近最右页码
        var endDisplayPageStart = 0; //从第xx页显示到最后一页

        //设定 bodyDisplayPageStart
        bodyDisplayPageStart = (currentPageIndex - showPageNumber <= 1) ? 1 : currentPageIndex - showPageNumber; // (ViewData.pageIndex - ViewData.showPageNumber <= ViewData.showPageNumber) ? ViewData.showPageNumber + 1 : ViewData.pageIndex - ViewData.showPageNumber;

        //设定 bodyDisplayPageEnd
        bodyDisplayPageEnd = (currentPageIndex + showPageNumber >= totalPage) ? totalPage : currentPageIndex + showPageNumber;


        //设定 firstDisplayPageEnd
        if (bodyDisplayPageStart > 1) {
            if (bodyDisplayPageStart - showPageNumber <= 1)
                firstDisplayPageEnd = bodyDisplayPageStart - 1;
            else
                firstDisplayPageEnd = showPageNumber;
        }
        else {
            firstDisplayPageEnd = 0;
        }

        //设定 endDisplayPageStart
        if (bodyDisplayPageEnd < totalPage) {
            if (bodyDisplayPageEnd + showPageNumber >= totalPage)
                endDisplayPageStart = bodyDisplayPageEnd + 1;
            else
                endDisplayPageStart = totalPage - showPageNumber + 1;
        }
        else {
            endDisplayPageStart = totalPage + 1;
        }

        if (currentPageIndex <= 1)
            $("<span class=\"" + backPageStyle + "\">" + opt.preWord + "</span>").appendTo($("#" + barID));
        else
            $(GetPageLink(currentPageIndex - 1, currentPageIndex, opt.preWord, url, opt.barMark)).appendTo($("#" + barID));


        //first
        for (var i = 1; i <= firstDisplayPageEnd; i++)
            $(GetPageLink(i, currentPageIndex, i,url, opt.barMark)).appendTo($("#" + barID));

        //省略号
        if (firstDisplayPageEnd + 1 < bodyDisplayPageStart)
            $("<span>... </span>").appendTo($("#" + barID));

        //body
        for (var i = bodyDisplayPageStart; i <= bodyDisplayPageEnd; i++)
            $(GetPageLink(i, currentPageIndex, i,url, opt.barMark)).appendTo($("#" + barID));

        //省略号
        if (bodyDisplayPageEnd + 1 < endDisplayPageStart)
            $("<span>... </span>").appendTo($("#" + barID));

        //end
        for (var i = endDisplayPageStart; i <= totalPage; i++)
            $(GetPageLink(i, currentPageIndex, i, url, opt.barMark)).appendTo($("#" + barID));

        // 
        if (currentPageIndex >= totalPage)
            $("<span class=\"" + nextPageStyle + "\">" + opt.nextWord + "</span>").appendTo($("#" + barID));
        else
            $(GetPageLink(currentPageIndex + 1, currentPageIndex, opt.nextWord, url, opt.barMark)).appendTo($("#" + barID));

         function GetPageLink(linkPageIndex, currentPageIndex, text, url,barMark) {

            var pageData = "?page=";
            var  href ="href=\"" + url + pageData + linkPageIndex + "\" ";
            var linkHTML = "";
            if (linkPageIndex == currentPageIndex)
                linkHTML = "<span class=\"current\">" + text + "</span>";
            else
                linkHTML = $("<a/>").text(text).attr("href", href).click(function() {

                    if (opt.onclick && $.isFunction(opt.onclick))
                    { opt.onclick.call(this,linkPageIndex); return false; }

                });
            return linkHTML;
        }


    };
})(jQuery)

