﻿function AudioHelper()
{

}
/*播放方式*/
AudioHelper.PlayMode={
    /*电脑上播放*/
    PC:"Realtek HD Audio output",
    /*话机上播放*/
    Tel:"IKE Audio"
};
/*当前播放模式*/
AudioHelper.CurrentPlayMode=AudioHelper.PlayMode.Tel;
/*是否切换到话机播放模式*/
AudioHelper.ChangedTelPlayMode=function(IsPC){
    window.external.Telphone_PlayMusic(IsPC);
    if(IsPC==true)
    {        
        AudioHelper.CurrentPlayMode=AudioHelper.PlayMode.Tel;
    }
    else
    {
        AudioHelper.CurrentPlayMode=AudioHelper.PlayMode.PC;
    }
};
/*录音文件名*/
AudioHelper.SpeechFileName="";
/*播放*/
AudioHelper.Play=function (ServerSpeechFileName,SpeechFileName,ftpPath)
{
    if(typeof(ftpPath)=="undefined" || ftpPath=="undefined")
    {
        ftpPath="";
    }
    AudioHelper.SpeechFileName=SpeechFileName;
	var IsOK=window.external.Telphone_PlaySpeech(ftpPath,ServerSpeechFileName,'files\\',SpeechFileName);
	if(IsOK==true)
	{
	    /*默认从话机播放*/
        AudioHelper.CurrentPlayMode=AudioHelper.PlayMode.Tel;
	    /*获得ActiveX Control引用*/
	    var IKEAudio= window.document.getElementById("IKEAudio");
	    if(IKEAudio!=null && IKEAudio!=undefined)
	    {
	        /*给ActiveX Control添加事件映射*/
	        /*videoPlugin.attachEvent("OnMouseHover",function(lx, ly){hoverAX(lx,ly,1)});*/

	        /*调用ActiveX Control的方法*/
	        /*默认切换在话机上播放*/
	        if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
	        {
                AudioHelper.ChangedTelPlayMode(false);
            }
            else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
	        {
                AudioHelper.ChangedTelPlayMode(true);
            }
	        IKEAudio.InitPlayer(AudioHelper.CurrentPlayMode);//("Realtek HD Audio output");
	        IKEAudio.PlayMP3('./files/'+SpeechFileName,0,-1);
	        IKEAudio.TitleText="正在缓冲...";
	        IKEAudio.CyclePlayMode=false;
	        IKEAudio.attachEvent("OnAudioSyncStop",AudioHelper.OnAudioSyncStop);
        	
	        IKEAudio.Width=170;
	        IKEAudio.Height=250;
	        /*给ActiveX Control属性赋值*/
	        /*videoPlugin.startTime = “2009-8-26”;*/
        }
    }
};
/*播放*/
/*参数说明：
IKEAudio：播放器对象
SpeechFileName：完整路径
PlayMode：模仿模式：电脑播放还是话机播放
*/
AudioHelper.PlayLocal=function (IKEAudio,SpeechFileName,PlayMode)
{
    AudioHelper.SpeechFileName=SpeechFileName;
    /*默认从话机播放*/
    if(typeof(PlayMode)=="undefined" || PlayMode=="")
    {
        AudioHelper.CurrentPlayMode=AudioHelper.PlayMode.Tel;
    }
    else
    {
        AudioHelper.CurrentPlayMode=PlayMode;
    }
    /*获得ActiveX Control引用*/
    if(IKEAudio!=null && IKEAudio!=undefined)
    {
        IKEAudio.TitleText="正在缓冲...";
        /*给ActiveX Control添加事件映射*/
        /*videoPlugin.attachEvent("OnMouseHover",function(lx, ly){hoverAX(lx,ly,1)});*/

        /*调用ActiveX Control的方法*/
        /*默认切换在话机上播放*/
        if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
        {
            AudioHelper.ChangedTelPlayMode(false);
        }
        else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
        {
            AudioHelper.ChangedTelPlayMode(true);
        }
        IKEAudio.InitPlayer(AudioHelper.CurrentPlayMode);
        IKEAudio.PlayMP3(SpeechFileName,0,-1);
        IKEAudio.CyclePlayMode=false;
        IKEAudio.attachEvent("OnAudioSyncStop",AudioHelper.OnAudioSyncStop);
        IKEAudio.TitleText="";
    	
//        IKEAudio.Width=170;
//        IKEAudio.Height=250;
        /*给ActiveX Control属性赋值*/
        /*videoPlugin.startTime = “2009-8-26”;*/
    }
};
/*停止时执行动作*/
/*参数说明：
isLocalPlay：是否本地播放，如果是，那么就不会删除临时文件
*/
AudioHelper.OnAudioSyncStop=function(isLocalPlay)
{
/*	alert("播放完毕");*/
    try{
        AudioHelper.ChangedTelPlayMode(false);
	    IKEAudio.ChannelFree();
	    if(typeof(isLocalPlay)=="undefined" || isLocalPlay==false)
	    {
	        window.external.FilesDelete('./files/'+AudioHelper.SpeechFileName);    	
	    }
    }
    catch(e){alert(e.message);}
};
/*重播*/
AudioHelper.RePlay=function()
{
	IKEAudio.Replay();
	
	if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
	{
        AudioHelper.ChangedTelPlayMode(false);
    }
    else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
	{
        AudioHelper.ChangedTelPlayMode(true);
    }
};
/*继续播放*/
AudioHelper.Continue=function()
{
	IKEAudio.Continue();
	
	if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
	{
        AudioHelper.ChangedTelPlayMode(false);
    }
    else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
	{
        AudioHelper.ChangedTelPlayMode(true);
    }
};
/*暂停播放*/
AudioHelper.Pause=function()
{
	IKEAudio.Pause();
	
	if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
	{
        AudioHelper.ChangedTelPlayMode(false);
    }
    else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
	{
        AudioHelper.ChangedTelPlayMode(true);
    }
};
/*停止播放*/
AudioHelper.Stop=function()
{
	IKEAudio.Stop();
	
	if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.PC)
	{
        AudioHelper.ChangedTelPlayMode(false);
    }
    else if(AudioHelper.CurrentPlayMode==AudioHelper.PlayMode.Tel)
	{
        AudioHelper.ChangedTelPlayMode(true);
    }
};
/*获取属性集合*/
AudioHelper.Attribe=function()
{
	var s="";
	s="FileName:"+IKEAudio.AudioFileName + "\r\n";
	s=s+"Length:"+IKEAudio.AudioLength + "秒\r\n";
	s=s+"Position:"+IKEAudio.AudioPosition + "秒\r\n";
	s=s+"Volume:"+IKEAudio.AudioVolume + "/100\r\n";
	s=s+"CycleMode:" + IKEAudio.CyclePlayMode + "\r\n";	
	alert(s);
};
/*加载背景样式*/
AudioHelper.LoadBackGround=function()
{
	IKEAudio.LoadPictureFromFille("D:\\1.BMP");
}

